/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.query.plan.cascades.AggregateIndexExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.GroupByExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.ArithmeticValue;
import com.apple.foundationdb.record.query.plan.cascades.values.BuiltInFunctionCatalog;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.NumericAggregationValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class BitmapAggregateIndexExpansionVisitor
extends AggregateIndexExpansionVisitor {
    public BitmapAggregateIndexExpansionVisitor(@Nonnull Index index, @Nonnull Collection<RecordType> recordTypes) {
        super(index, recordTypes);
        Verify.verify("bitmap_value".equals(index.getType()));
    }

    @Override
    @Nonnull
    protected NonnullPair<Quantifier, List<Placeholder>> constructGroupBy(@Nonnull Quantifier selectWhereQun, @Nonnull GraphExpansion baseExpansion) {
        Map<Value, Value> result;
        if (this.groupingKeyExpression.getGroupedCount() != 1) {
            throw new UnsupportedOperationException("bitmap aggregate index is expected to contain exactly one grouped expression, however it contains " + this.groupingKeyExpression.getGroupedCount() + " aggregations");
        }
        Value groupedValue = baseExpansion.getResultColumns().get(this.groupingKeyExpression.getGroupingCount()).getValue();
        if (groupedValue instanceof FieldValue) {
            AliasMap aliasMap = AliasMap.identitiesFor(Sets.union(selectWhereQun.getCorrelatedTo(), groupedValue.getCorrelatedTo()));
            result = selectWhereQun.getRangesOver().get().getResultValue().pullUp(List.of(groupedValue), EvaluationContext.empty(), aliasMap, ImmutableSet.of(), selectWhereQun.getAlias());
            if (!result.containsKey(groupedValue)) {
                throw new RecordCoreException("could not pull grouped value " + String.valueOf(groupedValue), new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, groupedValue});
            }
        } else {
            throw new UnsupportedOperationException("unable to plan group by with non-field value " + String.valueOf(groupedValue));
        }
        Value argument = result.get(groupedValue);
        BuiltInFunction<? extends Typed> bitmapConstructAggFunc = BuiltInFunctionCatalog.getFunctionSingleton(NumericAggregationValue.BitmapConstructAggFn.class).orElseThrow();
        BuiltInFunction<? extends Typed> bitmapBitPositionFunc = BuiltInFunctionCatalog.getFunctionSingleton(ArithmeticValue.BitmapBitPositionFn.class).orElseThrow();
        String sizeArgument = this.index.getOption("bitmapValueEntrySize");
        int entrySize = sizeArgument != null ? Integer.parseInt(sizeArgument) : 10000;
        LiteralValue<Integer> entrySizeValue = LiteralValue.ofScalar(entrySize);
        Value aggregateValue = (Value)bitmapConstructAggFunc.encapsulate(ImmutableList.of(bitmapBitPositionFunc.encapsulate(ImmutableList.of(argument, entrySizeValue))));
        ImmutableList groupingValues = baseExpansion.getResultColumns().subList(0, this.groupingKeyExpression.getGroupingCount()).stream().map(Column::getValue).collect(ImmutableList.toImmutableList());
        BuiltInFunction<? extends Typed> bitmapBitPosition = BuiltInFunctionCatalog.getFunctionSingleton(ArithmeticValue.BitmapBucketOffsetFn.class).orElseThrow();
        Value implicitGroupingValue = (Value)bitmapBitPosition.encapsulate(ImmutableList.of(argument, entrySizeValue));
        Placeholder placeHolder = Placeholder.newInstanceWithoutRanges(implicitGroupingValue, BitmapAggregateIndexExpansionVisitor.newParameterAlias());
        Value selectQunValue = selectWhereQun.getRangesOver().get().getResultValue();
        AliasMap aliasMap = AliasMap.identitiesFor(Sets.union(selectQunValue.getCorrelatedTo(), groupingValues.stream().flatMap(v -> v.getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet())));
        Map<Value, Value> pulledUpGroupingValuesMap = selectQunValue.pullUp(groupingValues, EvaluationContext.empty(), aliasMap, ImmutableSet.of(), selectWhereQun.getAlias());
        ImmutableList explicitPulledUpGroupingValues = groupingValues.stream().map(groupingValue -> {
            if (!pulledUpGroupingValuesMap.containsKey(groupingValue)) {
                throw new RecordCoreException("could not pull grouping value " + String.valueOf(groupingValue), new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, groupingValue});
            }
            return (Value)pulledUpGroupingValuesMap.get(groupingValue);
        }).collect(ImmutableList.toImmutableList());
        ImmutableCollection pulledUpGroupingValues = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)explicitPulledUpGroupingValues)).add(implicitGroupingValue)).build();
        RecordConstructorValue groupingColsValue = RecordConstructorValue.ofUnnamed(pulledUpGroupingValues);
        return NonnullPair.of(Quantifier.forEach(Reference.initialOf((RelationalExpression)new GroupByExpression(groupingColsValue, RecordConstructorValue.ofUnnamed(ImmutableList.of(aggregateValue)), GroupByExpression::nestedResults, selectWhereQun))), ImmutableList.of(placeHolder));
    }
}

