/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.IndexMatchCandidateRegistry;
import com.apple.foundationdb.record.query.IndexQueryabilityFilter;
import com.apple.foundationdb.record.query.ParameterRelationshipGraph;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.QueryPlanInfo;
import com.apple.foundationdb.record.query.plan.QueryPlanInfoKeys;
import com.apple.foundationdb.record.query.plan.QueryPlanResult;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.RecordQueryPlanComplexityException;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.CascadesCostModel;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.MatchPartition;
import com.apple.foundationdb.record.query.plan.cascades.MetaDataPlanContext;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PlanContext;
import com.apple.foundationdb.record.query.plan.cascades.PlannerConstraint;
import com.apple.foundationdb.record.query.plan.cascades.PlannerPhase;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.PlannerStage;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.UnableToPlanException;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.debug.RestartException;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlanVisitor;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class CascadesPlanner
implements QueryPlanner {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(CascadesPlanner.class);
    @Nonnull
    private RecordQueryPlannerConfiguration configuration = RecordQueryPlannerConfiguration.builder().build();
    @Nonnull
    private final RecordMetaData metaData;
    @Nonnull
    private final RecordStoreState recordStoreState;
    @Nonnull
    private final IndexMatchCandidateRegistry matchCandidateRegistry;
    @Nonnull
    private Reference currentRoot;
    @Nonnull
    private PlanContext planContext;
    @Nonnull
    private EvaluationContext evaluationContext;
    @Nonnull
    private Traversal traversal;
    @Nonnull
    private Deque<Task> taskStack;
    private int taskCount;
    private int maxQueueSize;

    public CascadesPlanner(@Nonnull RecordMetaData metaData, @Nonnull RecordStoreState recordStoreState, @Nonnull IndexMatchCandidateRegistry matchCandidateRegistry) {
        this.metaData = metaData;
        this.recordStoreState = recordStoreState;
        this.matchCandidateRegistry = matchCandidateRegistry;
        this.currentRoot = Reference.empty();
        this.planContext = PlanContext.emptyContext();
        this.evaluationContext = EvaluationContext.empty();
        this.traversal = Traversal.withRoot(this.currentRoot);
        this.taskStack = new ArrayDeque<Task>();
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        return this.metaData;
    }

    @Override
    @Nonnull
    public RecordStoreState getRecordStoreState() {
        return this.recordStoreState;
    }

    @Override
    public void setIndexScanPreference(@Nonnull QueryPlanner.IndexScanPreference indexScanPreference) {
        this.configuration = this.configuration.asBuilder().setIndexScanPreference(indexScanPreference).build();
    }

    public void setMaxTaskQueueSize(int maxTaskQueueSize) {
        this.configuration = this.configuration.asBuilder().setMaxTaskQueueSize(maxTaskQueueSize).build();
    }

    public void setMaxTotalTaskCount(int maxTotalTaskCount) {
        this.configuration = this.configuration.asBuilder().setMaxTotalTaskCount(maxTotalTaskCount).build();
    }

    public void setMaxNumMatchesPerRuleCall(int maxNumYieldsPerRuleCall) {
        this.configuration = this.configuration.asBuilder().setMaxNumMatchesPerRuleCall(maxNumYieldsPerRuleCall).build();
    }

    @Override
    @Nonnull
    public RecordQueryPlannerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(@Nonnull RecordQueryPlannerConfiguration configuration) {
        this.configuration = configuration;
    }

    private boolean isTaskQueueSizeExceeded(RecordQueryPlannerConfiguration configuration, int queueSize) {
        return configuration.getMaxTaskQueueSize() > 0 && queueSize > configuration.getMaxTaskQueueSize();
    }

    private boolean isTaskTotalCountExceeded(RecordQueryPlannerConfiguration configuration, int taskCount) {
        return configuration.getMaxTotalTaskCount() > 0 && taskCount > configuration.getMaxTotalTaskCount();
    }

    private boolean isMaxNumMatchesPerRuleCallExceeded(RecordQueryPlannerConfiguration configuration, int numMatches) {
        return configuration.getMaxNumMatchesPerRuleCall() > 0 && numMatches > configuration.getMaxNumMatchesPerRuleCall();
    }

    @Override
    @Nonnull
    @HeuristicPlanner
    public QueryPlanResult planQuery(@Nonnull RecordQuery query, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
        RecordQueryPlan plan = this.plan(query, parameterRelationshipGraph);
        QueryPlanConstraint constraints = QueryPlanConstraint.collectConstraints(plan);
        QueryPlanInfo info = QueryPlanInfo.newBuilder().put(QueryPlanInfoKeys.TOTAL_TASK_COUNT, this.taskCount).put(QueryPlanInfoKeys.MAX_TASK_QUEUE_SIZE, this.maxQueueSize).put(QueryPlanInfoKeys.CONSTRAINTS, constraints).put(QueryPlanInfoKeys.STATS_MAPS, Debugger.getDebuggerMaybe().flatMap(Debugger::getStatsMaps).orElse(null)).build();
        return new QueryPlanResult(plan, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @HeuristicPlanner
    public RecordQueryPlan plan(@Nonnull RecordQuery query, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
        try {
            this.planPartial(() -> Reference.initialOf(RelationalExpression.fromRecordQuery(this.metaData, query)), rootReference -> MetaDataPlanContext.forRecordQuery(this.configuration, this.metaData, this.recordStoreState, this.matchCandidateRegistry, query), EvaluationContext.empty());
            RecordQueryPlan recordQueryPlan = this.resultOrFail();
            return recordQueryPlan;
        }
        finally {
            Debugger.withDebugger(Debugger::onDone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public QueryPlanResult planGraph(@Nonnull Supplier<Reference> referenceSupplier, @Nonnull Optional<Collection<String>> allowedIndexesOptional, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter, @Nonnull EvaluationContext evaluationContext) {
        try {
            this.planPartial(referenceSupplier, rootReference -> MetaDataPlanContext.forRootReference(this.configuration, this.metaData, this.recordStoreState, this.matchCandidateRegistry, rootReference, allowedIndexesOptional, indexQueryabilityFilter), evaluationContext);
            RecordQueryPlan plan = this.resultOrFail();
            QueryPlanConstraint constraints = QueryPlanConstraint.collectConstraints(plan);
            QueryPlanResult queryPlanResult = new QueryPlanResult(plan, QueryPlanInfo.newBuilder().put(QueryPlanInfoKeys.CONSTRAINTS, constraints).put(QueryPlanInfoKeys.STATS_MAPS, Debugger.getDebuggerMaybe().flatMap(Debugger::getStatsMaps).orElse(null)).build());
            return queryPlanResult;
        }
        finally {
            Debugger.withDebugger(Debugger::onDone);
        }
    }

    private RecordQueryPlan resultOrFail() {
        Set<RelationalExpression> finalExpressions = this.currentRoot.getFinalExpressions();
        Verify.verify(finalExpressions.size() <= 1, "more than one variant present", new Object[0]);
        if (finalExpressions.isEmpty()) {
            throw new UnableToPlanException("Cascades planner could not plan query", new Object[0]);
        }
        RelationalExpression singleRoot = Iterables.getOnlyElement(finalExpressions);
        Verify.verify(singleRoot instanceof RecordQueryPlan, "single remaining variant must be a plan", new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug(KeyValueLogMessage.of("GML explain of plan", "explain", PlannerGraphVisitor.explain(singleRoot)));
            logger.debug(KeyValueLogMessage.of("string explain of plan", "explain", ExplainPlanVisitor.toStringForDebugging((RecordQueryPlan)singleRoot)));
        }
        return (RecordQueryPlan)singleRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void planPartial(@Nonnull Supplier<Reference> referenceSupplier, @Nonnull Function<Reference, PlanContext> contextCreatorFunction, @Nonnull EvaluationContext evaluationContext) {
        this.currentRoot = referenceSupplier.get();
        this.planContext = contextCreatorFunction.apply(this.currentRoot);
        this.evaluationContext = evaluationContext;
        RelationalExpression expression = this.currentRoot.get();
        Debugger.withDebugger(debugger -> debugger.onQuery(expression.toString(), this.planContext));
        this.traversal = Traversal.withRoot(this.currentRoot);
        this.taskStack = new ArrayDeque<Task>();
        this.taskCount = 0;
        this.maxQueueSize = 0;
        this.pushInitialTasks();
        while (!this.taskStack.isEmpty()) {
            try {
                if (this.isTaskTotalCountExceeded(this.configuration, this.taskCount)) {
                    throw new RecordQueryPlanComplexityException("Maximum number of tasks was exceeded").addLogInfo(new Object[]{LogMessageKeys.MAX_TASK_COUNT, this.configuration.getMaxTotalTaskCount()}).addLogInfo(new Object[]{LogMessageKeys.TASK_COUNT, this.taskCount});
                }
                ++this.taskCount;
                Debugger.withDebugger(debugger -> debugger.onEvent(new Debugger.ExecutingTaskEvent(this.currentRoot, this.taskStack, Debugger.Location.BEGIN, Objects.requireNonNull(this.taskStack.peek()))));
                Task nextTask = this.taskStack.pop();
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace(KeyValueLogMessage.of("executing task", "nextTask", nextTask.toString()));
                    }
                    Debugger.withDebugger(debugger -> debugger.onEvent(nextTask.toTaskEvent(Debugger.Location.BEGIN)));
                    try {
                        nextTask.execute();
                        Debugger.sanityCheck(() -> {
                            if (nextTask instanceof InitiatePlannerPhase) {
                                this.traversal.verifyIntegrity();
                            }
                        });
                    }
                    finally {
                        Debugger.withDebugger(debugger -> debugger.onEvent(nextTask.toTaskEvent(Debugger.Location.END)));
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace(KeyValueLogMessage.of("planner state", "taskStackSize", this.taskStack.size()));
                    }
                    this.maxQueueSize = Math.max(this.maxQueueSize, this.taskStack.size());
                    if (!this.isTaskQueueSizeExceeded(this.configuration, this.taskStack.size())) continue;
                    throw new RecordQueryPlanComplexityException("Maximum task queue size was exceeded").addLogInfo(new Object[]{LogMessageKeys.MAX_TASK_QUEUE_SIZE, this.configuration.getMaxTaskQueueSize()}).addLogInfo(new Object[]{LogMessageKeys.TASK_QUEUE_SIZE, this.taskStack.size()});
                }
                finally {
                    Debugger.withDebugger(debugger -> debugger.onEvent(new Debugger.ExecutingTaskEvent(this.currentRoot, this.taskStack, Debugger.Location.END, nextTask)));
                }
            }
            catch (RestartException restartException) {
                if (logger.isTraceEnabled()) {
                    logger.trace(KeyValueLogMessage.of("debugger requests restart of planning", "taskStackSize", this.taskStack.size()));
                }
                this.taskStack.clear();
                this.currentRoot = referenceSupplier.get();
                this.planContext = contextCreatorFunction.apply(this.currentRoot);
                this.pushInitialTasks();
            }
        }
        Debugger.sanityCheck(() -> this.traversal.verifyIntegrity());
    }

    private void pushInitialTasks() {
        this.taskStack.push(new InitiatePlannerPhase(PlannerPhase.REWRITING));
    }

    private void exploreExpressionAndOptimizeInputs(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference group, @Nonnull RelationalExpression expression, boolean forceExploration) {
        this.taskStack.push(new OptimizeInputs(plannerPhase, group, expression));
        this.exploreExpression(plannerPhase, group, expression, forceExploration);
    }

    private void exploreExpression(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference group, @Nonnull RelationalExpression expression, boolean forceExploration) {
        Verify.verify(group.containsExactly(expression));
        if (forceExploration) {
            this.taskStack.push(new ExploreExpression(plannerPhase, group, expression));
        } else {
            this.taskStack.push(new ReExploreExpression(plannerPhase, group, expression));
        }
    }

    public static interface Task {
        @Nonnull
        public PlannerPhase getPlannerPhase();

        public void execute();

        public Debugger.Event toTaskEvent(Debugger.Location var1);
    }

    private class InitiatePlannerPhase
    implements Task {
        @Nonnull
        private final PlannerPhase plannerPhase;

        public InitiatePlannerPhase(PlannerPhase plannerPhase) {
            this.plannerPhase = plannerPhase;
        }

        @Override
        @Nonnull
        public PlannerPhase getPlannerPhase() {
            return this.plannerPhase;
        }

        @Override
        public void execute() {
            if (this.plannerPhase.hasNextPhase()) {
                CascadesPlanner.this.taskStack.push(new InitiatePlannerPhase(this.plannerPhase.getNextPhase()));
            }
            CascadesPlanner.this.taskStack.push(new OptimizeGroup(this.plannerPhase, CascadesPlanner.this.currentRoot));
            CascadesPlanner.this.taskStack.push(new ExploreGroup(this.plannerPhase, CascadesPlanner.this.currentRoot));
        }

        @Override
        @Nonnull
        public Debugger.Event toTaskEvent(Debugger.Location location) {
            return new Debugger.InitiatePlannerPhaseEvent(this.plannerPhase, CascadesPlanner.this.currentRoot, CascadesPlanner.this.taskStack, location);
        }

        public String toString() {
            return "InitiatePlannerPhase(" + this.plannerPhase.name() + ")";
        }
    }

    private class OptimizeInputs
    implements Task {
        @Nonnull
        private final PlannerPhase plannerPhase;
        @Nonnull
        private final Reference group;
        @Nonnull
        private final RelationalExpression expression;

        public OptimizeInputs(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference group, RelationalExpression expression) {
            this.plannerPhase = plannerPhase;
            this.group = group;
            this.expression = expression;
        }

        @Override
        @Nonnull
        public PlannerPhase getPlannerPhase() {
            return this.plannerPhase;
        }

        @Override
        public void execute() {
            if (!this.group.containsExactly(this.expression)) {
                return;
            }
            for (Quantifier quantifier : this.expression.getQuantifiers()) {
                Reference rangesOver = quantifier.getRangesOver();
                CascadesPlanner.this.taskStack.push(new OptimizeGroup(this.plannerPhase, rangesOver));
            }
        }

        @Override
        public Debugger.Event toTaskEvent(Debugger.Location location) {
            return new Debugger.OptimizeInputsEvent(this.plannerPhase, CascadesPlanner.this.currentRoot, CascadesPlanner.this.taskStack, location, this.group, this.expression);
        }

        public String toString() {
            return "OptimizeInputs(" + String.valueOf(this.group) + ")";
        }
    }

    private class ExploreExpression
    extends AbstractExploreExpression {
        public ExploreExpression(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference group, RelationalExpression expression) {
            super(plannerPhase, group, expression);
        }

        @Override
        protected boolean shouldPushRule(@Nonnull CascadesRule<?> rule) {
            return true;
        }
    }

    private class ReExploreExpression
    extends AbstractExploreExpression {
        public ReExploreExpression(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference group, RelationalExpression expression) {
            super(plannerPhase, group, expression);
        }

        @Override
        protected boolean shouldPushRule(@Nonnull CascadesRule<?> rule) {
            Set<PlannerConstraint<?>> requirementDependencies = rule.getConstraintDependencies();
            Reference group = this.getGroup();
            if (!group.isExploring() && logger.isWarnEnabled()) {
                logger.warn(KeyValueLogMessage.of("transformation task run on a group that is not being explored", new Object[0]));
            }
            return group.isFullyExploring() || !group.isExploredForAttributes(requirementDependencies);
        }
    }

    private class AdjustMatch
    extends ExploreTask {
        @Nonnull
        final PartialMatch partialMatch;

        public AdjustMatch(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference group, @Nonnull RelationalExpression expression, PartialMatch partialMatch) {
            super(plannerPhase, group, expression);
            this.partialMatch = partialMatch;
        }

        @Override
        public void execute() {
            CascadesRuleSet ruleSet = this.getPlannerPhase().getRuleSet();
            ruleSet.getPartialMatchRules(rule -> CascadesPlanner.this.configuration.isRuleEnabled((PlannerRule<?, ?>)rule)).forEach(rule -> CascadesPlanner.this.taskStack.push(new TransformPartialMatch(this.getPlannerPhase(), this.getGroup(), this.getExpression(), this.partialMatch, (CascadesRule<? extends PartialMatch>)rule)));
        }

        @Override
        public Debugger.Event toTaskEvent(Debugger.Location location) {
            return new Debugger.AdjustMatchEvent(this.getPlannerPhase(), CascadesPlanner.this.currentRoot, CascadesPlanner.this.taskStack, location, this.getGroup(), this.getExpression());
        }

        public String toString() {
            return "AdjustMatch(" + String.valueOf(this.getGroup()) + "; " + String.valueOf(this.getExpression()) + ")";
        }
    }

    private class TransformPartialMatch
    extends AbstractTransform {
        @Nonnull
        private final PartialMatch partialMatch;

        public TransformPartialMatch(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference group, @Nonnull RelationalExpression expression, @Nonnull PartialMatch partialMatch, CascadesRule<? extends PartialMatch> rule) {
            super(plannerPhase, group, expression, rule);
            this.partialMatch = partialMatch;
        }

        @Override
        @Nonnull
        protected Object getBindable() {
            return this.partialMatch;
        }
    }

    private class TransformMatchPartition
    extends AbstractTransform {
        @Nonnull
        private final Supplier<MatchPartition> matchPartitionSupplier;

        public TransformMatchPartition(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference group, @Nonnull RelationalExpression expression, CascadesRule<? extends MatchPartition> rule) {
            super(plannerPhase, group, expression, rule);
            this.matchPartitionSupplier = Suppliers.memoize(() -> MatchPartition.of(group, expression));
        }

        @Override
        @Nonnull
        protected Object getBindable() {
            return this.matchPartitionSupplier.get();
        }
    }

    private class TransformExpression
    extends AbstractTransform {
        public TransformExpression(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference group, @Nonnull RelationalExpression expression, CascadesRule<? extends RelationalExpression> rule) {
            super(plannerPhase, group, expression, rule);
        }

        @Override
        @Nonnull
        protected Object getBindable() {
            return this.getExpression();
        }

        @Override
        protected boolean shouldExecute() {
            return super.shouldExecute() && this.getGroup().containsExactly(this.getExpression());
        }

        @Override
        @Nonnull
        protected PlannerBindings getInitialBindings() {
            return PlannerBindings.newBuilder().putAll(super.getInitialBindings()).build();
        }
    }

    private abstract class AbstractTransform
    implements Task {
        @Nonnull
        private final PlannerPhase plannerPhase;
        @Nonnull
        private final Reference group;
        @Nonnull
        private final RelationalExpression expression;
        @Nonnull
        private final CascadesRule<?> rule;

        protected AbstractTransform(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference group, @Nonnull RelationalExpression expression, CascadesRule<?> rule) {
            this.plannerPhase = plannerPhase;
            this.group = group;
            this.expression = expression;
            this.rule = rule;
        }

        @Override
        @Nonnull
        public PlannerPhase getPlannerPhase() {
            return this.plannerPhase;
        }

        @Nonnull
        public Reference getGroup() {
            return this.group;
        }

        @Nonnull
        public RelationalExpression getExpression() {
            return this.expression;
        }

        @Nonnull
        public CascadesRule<?> getRule() {
            return this.rule;
        }

        @Nonnull
        protected abstract Object getBindable();

        @Nonnull
        protected PlannerBindings getInitialBindings() {
            return new PlannerBindings.Builder().put(ReferenceMatchers.getTopReferenceMatcher(), CascadesPlanner.this.currentRoot).put(ReferenceMatchers.getCurrentReferenceMatcher(), this.group).build();
        }

        protected boolean shouldExecute() {
            return true;
        }

        @Override
        public void execute() {
            if (!this.shouldExecute()) {
                return;
            }
            PlannerBindings initialBindings = this.getInitialBindings();
            AtomicInteger numMatches = new AtomicInteger(0);
            this.rule.getMatcher().bindMatches(CascadesPlanner.this.getConfiguration(), initialBindings, this.getBindable()).map(bindings -> new CascadesRuleCall(this.plannerPhase, CascadesPlanner.this.planContext, this.rule, this.group, CascadesPlanner.this.traversal, CascadesPlanner.this.taskStack, (PlannerBindings)bindings, CascadesPlanner.this.evaluationContext)).forEach(ruleCall -> {
                int ruleMatchesCount = numMatches.incrementAndGet();
                if (CascadesPlanner.this.isMaxNumMatchesPerRuleCallExceeded(CascadesPlanner.this.configuration, ruleMatchesCount)) {
                    throw new RecordQueryPlanComplexityException("Maximum number of matches per rule call has been exceeded").addLogInfo(new Object[]{LogMessageKeys.RULE, ruleCall}).addLogInfo(new Object[]{LogMessageKeys.RULE_MATCHES_COUNT, ruleMatchesCount}).addLogInfo(new Object[]{LogMessageKeys.MAX_RULE_MATCHES_COUNT, CascadesPlanner.this.configuration.getMaxNumMatchesPerRuleCall()});
                }
                Debugger.withDebugger(debugger -> debugger.onEvent(this.toTaskEvent(Debugger.Location.MATCH_PRE)));
                Debugger.withDebugger(debugger -> debugger.onEvent(new Debugger.TransformRuleCallEvent(this.plannerPhase, CascadesPlanner.this.currentRoot, CascadesPlanner.this.taskStack, Debugger.Location.BEGIN, this.group, this.getBindable(), this.rule, (CascadesRuleCall)ruleCall)));
                try {
                    this.executeRuleCall((CascadesRuleCall)ruleCall);
                }
                finally {
                    Debugger.withDebugger(debugger -> debugger.onEvent(new Debugger.TransformRuleCallEvent(this.plannerPhase, CascadesPlanner.this.currentRoot, CascadesPlanner.this.taskStack, Debugger.Location.END, this.group, this.getBindable(), this.rule, (CascadesRuleCall)ruleCall)));
                }
            });
        }

        protected void executeRuleCall(@Nonnull CascadesRuleCall ruleCall) {
            ruleCall.run();
            ruleCall.pruneUnusedNewReferences();
            for (PartialMatch newPartialMatch : ruleCall.getNewPartialMatches()) {
                Debugger.withDebugger(debugger -> debugger.onEvent(new Debugger.TransformRuleCallEvent(this.plannerPhase, CascadesPlanner.this.currentRoot, CascadesPlanner.this.taskStack, Debugger.Location.YIELD, this.group, this.getBindable(), this.rule, ruleCall)));
                CascadesPlanner.this.taskStack.push(new AdjustMatch(this.getPlannerPhase(), this.getGroup(), this.getExpression(), newPartialMatch));
            }
            for (RelationalExpression newExpression : ruleCall.getNewFinalExpressions()) {
                Debugger.withDebugger(debugger -> debugger.onEvent(new Debugger.TransformRuleCallEvent(this.plannerPhase, CascadesPlanner.this.currentRoot, CascadesPlanner.this.taskStack, Debugger.Location.YIELD, this.group, this.getBindable(), this.rule, ruleCall)));
                CascadesPlanner.this.exploreExpressionAndOptimizeInputs(this.plannerPhase, this.getGroup(), newExpression, true);
            }
            for (RelationalExpression newExpression : ruleCall.getNewExploratoryExpressions()) {
                Debugger.withDebugger(debugger -> debugger.onEvent(new Debugger.TransformRuleCallEvent(this.plannerPhase, CascadesPlanner.this.currentRoot, CascadesPlanner.this.taskStack, Debugger.Location.YIELD, this.group, this.getBindable(), this.rule, ruleCall)));
                CascadesPlanner.this.exploreExpression(this.plannerPhase, this.group, newExpression, true);
            }
            Set<Reference> referencesWithPushedRequirements = ruleCall.getReferencesWithPushedConstraints();
            if (!referencesWithPushedRequirements.isEmpty()) {
                if (!(this.rule instanceof PlannerRule.PreOrderRule)) {
                    CascadesPlanner.this.taskStack.push(this);
                }
                for (Reference reference : referencesWithPushedRequirements) {
                    if (reference.hasNeverBeenExplored()) continue;
                    CascadesPlanner.this.taskStack.push(new ExploreGroup(this.plannerPhase, reference));
                }
            }
        }

        @Override
        public Debugger.Event toTaskEvent(Debugger.Location location) {
            return new Debugger.TransformEvent(this.plannerPhase, CascadesPlanner.this.currentRoot, CascadesPlanner.this.taskStack, location, this.getGroup(), this.getBindable(), this.getRule());
        }

        public String toString() {
            return "Transform(" + this.rule.getClass().getSimpleName() + ")";
        }
    }

    private abstract class AbstractExploreExpression
    extends ExploreTask {
        public AbstractExploreExpression(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference group, RelationalExpression expression) {
            super(plannerPhase, group, expression);
        }

        @Override
        public void execute() {
            CascadesRuleSet ruleSet = this.getPlannerPhase().getRuleSet();
            ruleSet.getMatchPartitionRules(rule -> CascadesPlanner.this.configuration.isRuleEnabled((PlannerRule<?, ?>)rule)).filter(this::shouldPushRule).forEach(this::pushTransformMatchPartition);
            ruleSet.getRules(this.getExpression(), rule -> CascadesPlanner.this.configuration.isRuleEnabled((PlannerRule<?, ?>)rule)).filter(rule -> !(rule instanceof PlannerRule.PreOrderRule) && this.shouldPushRule((CascadesRule<?>)rule)).forEach(this::pushTransformTask);
            this.getExpression().getQuantifiers().stream().map(Quantifier::getRangesOver).forEach(this::pushExploreGroup);
            ruleSet.getRules(this.getExpression(), rule -> CascadesPlanner.this.configuration.isRuleEnabled((PlannerRule<?, ?>)rule)).filter(rule -> rule instanceof PlannerRule.PreOrderRule && this.shouldPushRule((CascadesRule<?>)rule)).forEach(this::pushTransformTask);
        }

        protected abstract boolean shouldPushRule(@Nonnull CascadesRule<?> var1);

        private void pushTransformTask(@Nonnull CascadesRule<? extends RelationalExpression> rule) {
            CascadesPlanner.this.taskStack.push(new TransformExpression(this.getPlannerPhase(), this.getGroup(), this.getExpression(), rule));
        }

        private void pushTransformMatchPartition(CascadesRule<? extends MatchPartition> rule) {
            CascadesPlanner.this.taskStack.push(new TransformMatchPartition(this.getPlannerPhase(), this.getGroup(), this.getExpression(), rule));
        }

        private void pushExploreGroup(Reference rangesOver) {
            CascadesPlanner.this.taskStack.push(new ExploreGroup(this.getPlannerPhase(), rangesOver));
        }

        @Override
        public Debugger.Event toTaskEvent(Debugger.Location location) {
            return new Debugger.ExploreExpressionEvent(this.getPlannerPhase(), CascadesPlanner.this.currentRoot, CascadesPlanner.this.taskStack, location, this.getGroup(), this.getExpression());
        }

        public String toString() {
            return "ExploreExpression(" + String.valueOf(this.getGroup()) + ")";
        }
    }

    private static abstract class ExploreTask
    implements Task {
        @Nonnull
        private final PlannerPhase plannerPhase;
        @Nonnull
        private final Reference group;
        @Nonnull
        private final RelationalExpression expression;

        public ExploreTask(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference group, @Nonnull RelationalExpression expression) {
            this.plannerPhase = plannerPhase;
            this.group = group;
            this.expression = expression;
        }

        @Override
        @Nonnull
        public PlannerPhase getPlannerPhase() {
            return this.plannerPhase;
        }

        @Nonnull
        public Reference getGroup() {
            return this.group;
        }

        @Nonnull
        public RelationalExpression getExpression() {
            return this.expression;
        }
    }

    private class ExploreGroup
    implements Task {
        @Nonnull
        private final PlannerPhase plannerPhase;
        @Nonnull
        private final Reference group;

        public ExploreGroup(@Nonnull PlannerPhase plannerPhase, Reference ref) {
            this.plannerPhase = plannerPhase;
            this.group = ref;
        }

        @Override
        @Nonnull
        public PlannerPhase getPlannerPhase() {
            return this.plannerPhase;
        }

        @Override
        public void execute() {
            PlannerStage groupPlannerStage;
            PlannerStage targetPlannerStage = this.plannerPhase.getTargetPlannerStage();
            if (targetPlannerStage != (groupPlannerStage = this.group.getPlannerStage())) {
                if (targetPlannerStage.precedes(groupPlannerStage)) {
                    return;
                }
                for (RelationalExpression exploratoryExpression : this.group.getExploratoryExpressions()) {
                    CascadesPlanner.this.traversal.removeExpression(this.group, exploratoryExpression);
                }
                this.group.advancePlannerStage(targetPlannerStage);
            }
            if (this.group.needsExploration()) {
                CascadesPlanner.this.taskStack.push(this);
                for (RelationalExpression expression : this.group.getFinalExpressions()) {
                    CascadesPlanner.this.exploreExpressionAndOptimizeInputs(this.plannerPhase, this.group, expression, false);
                }
                for (RelationalExpression expression : this.group.getExploratoryExpressions()) {
                    CascadesPlanner.this.exploreExpression(this.plannerPhase, this.group, expression, false);
                }
                this.group.startExploration();
            } else {
                this.group.commitExploration();
            }
        }

        @Override
        public Debugger.Event toTaskEvent(Debugger.Location location) {
            return new Debugger.ExploreGroupEvent(this.plannerPhase, CascadesPlanner.this.currentRoot, CascadesPlanner.this.taskStack, location, this.group);
        }

        public String toString() {
            return "ExploreGroup(" + String.valueOf(this.group) + ")";
        }
    }

    private class OptimizeGroup
    implements Task {
        @Nonnull
        final PlannerPhase plannerPhase;
        @Nonnull
        private final Reference group;

        public OptimizeGroup(@Nonnull PlannerPhase plannerPhase, Reference group) {
            this.plannerPhase = plannerPhase;
            this.group = group;
        }

        @Override
        @Nonnull
        public PlannerPhase getPlannerPhase() {
            return this.plannerPhase;
        }

        @Override
        public void execute() {
            RelationalExpression bestFinalExpression = null;
            CascadesCostModel costModel = this.plannerPhase.createCostModel(CascadesPlanner.this.configuration);
            for (RelationalExpression finalExpression : this.group.getFinalExpressions()) {
                if (bestFinalExpression == null || costModel.compare(finalExpression, bestFinalExpression) < 0) {
                    if (bestFinalExpression != null) {
                        CascadesPlanner.this.traversal.removeExpression(this.group, bestFinalExpression);
                    }
                    bestFinalExpression = finalExpression;
                    continue;
                }
                CascadesPlanner.this.traversal.removeExpression(this.group, finalExpression);
            }
            if (bestFinalExpression == null) {
                this.group.clearFinalExpressions();
            } else {
                this.group.pruneWith(bestFinalExpression);
            }
        }

        @Override
        public Debugger.Event toTaskEvent(Debugger.Location location) {
            return new Debugger.OptimizeGroupEvent(this.plannerPhase, CascadesPlanner.this.currentRoot, CascadesPlanner.this.taskStack, location, this.group);
        }

        public String toString() {
            return "OptimizeGroup(" + String.valueOf(this.group) + ")";
        }
    }
}

