/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlannerConstraint;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class CascadesRule<T>
implements PlannerRule<CascadesRuleCall, T> {
    @Nonnull
    private final BindingMatcher<T> matcher;
    @Nonnull
    private final Set<PlannerConstraint<?>> requirementDependencies;

    public CascadesRule(@Nonnull BindingMatcher<T> matcher) {
        this.matcher = matcher;
        this.requirementDependencies = ImmutableSet.of();
    }

    public CascadesRule(@Nonnull BindingMatcher<T> matcher, Collection<PlannerConstraint<?>> requirementDependencies) {
        this.matcher = matcher;
        this.requirementDependencies = ImmutableSet.copyOf(requirementDependencies);
    }

    @Override
    @Nonnull
    public Optional<Class<?>> getRootOperator() {
        return Optional.of(this.matcher.getRootClass());
    }

    @Nonnull
    public Set<PlannerConstraint<?>> getConstraintDependencies() {
        return this.requirementDependencies;
    }

    @Override
    public abstract void onMatch(@Nonnull CascadesRuleCall var1);

    @Override
    @Nonnull
    public BindingMatcher<T> getMatcher() {
        return this.matcher;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

