/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CascadesPlanner;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ConstraintsMap;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PlanContext;
import com.apple.foundationdb.record.query.plan.cascades.PlannerConstraint;
import com.apple.foundationdb.record.query.plan.cascades.PlannerPhase;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.Yields;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class CascadesRuleCall
implements ExplorationCascadesRuleCall,
ImplementationCascadesRuleCall,
Memoizer,
Yields {
    @Nonnull
    private final PlannerPhase plannerPhase;
    @Nonnull
    private final CascadesRule<?> rule;
    @Nonnull
    private final Reference root;
    @Nonnull
    private final Traversal traversal;
    @Nonnull
    private final Deque<CascadesPlanner.Task> taskStack;
    @Nonnull
    private final PlannerBindings bindings;
    @Nonnull
    private final PlanContext context;
    @Nonnull
    private final LinkedIdentitySet<RelationalExpression> newExploratoryExpressions;
    @Nonnull
    private final LinkedIdentitySet<RelationalExpression> newFinalExpressions;
    @Nonnull
    private final LinkedIdentitySet<PartialMatch> newPartialMatches;
    @Nonnull
    private final LinkedIdentitySet<Reference> newReferences;
    @Nonnull
    private final Set<Reference> referencesWithPushedConstraints;
    @Nonnull
    private final EvaluationContext evaluationContext;

    public CascadesRuleCall(@Nonnull PlannerPhase plannerPhase, @Nonnull PlanContext context, @Nonnull CascadesRule<?> rule, @Nonnull Reference root, @Nonnull Traversal traversal, @Nonnull Deque<CascadesPlanner.Task> taskStack, @Nonnull PlannerBindings bindings, @Nonnull EvaluationContext evaluationContext) {
        this.plannerPhase = plannerPhase;
        this.context = context;
        this.rule = rule;
        this.root = root;
        this.traversal = traversal;
        this.taskStack = taskStack;
        this.bindings = bindings;
        this.newExploratoryExpressions = new LinkedIdentitySet();
        this.newFinalExpressions = new LinkedIdentitySet();
        this.newPartialMatches = new LinkedIdentitySet();
        this.newReferences = new LinkedIdentitySet();
        this.referencesWithPushedConstraints = Sets.newLinkedHashSet();
        this.evaluationContext = evaluationContext;
    }

    public void run() {
        this.rule.onMatch(this);
    }

    @Override
    @Nonnull
    public PlannerPhase getPlannerPhase() {
        return this.plannerPhase;
    }

    @Override
    @Nonnull
    public Reference getRoot() {
        return this.root;
    }

    @Override
    @Nonnull
    public Quantifiers.AliasResolver newAliasResolver() {
        return new Quantifiers.AliasResolver(this.traversal);
    }

    @Override
    @Nonnull
    public PlanContext getContext() {
        return this.context;
    }

    @Override
    @Nonnull
    public PlannerBindings getBindings() {
        return this.bindings;
    }

    @Override
    @Nonnull
    public <T> Optional<T> getPlannerConstraintMaybe(@Nonnull PlannerConstraint<T> plannerConstraint) {
        if (this.rule.getConstraintDependencies().contains(plannerConstraint)) {
            return this.root.getConstraintsMap().getConstraintOptional(plannerConstraint);
        }
        throw new RecordCoreArgumentException("rule is not dependent on requested planner requirement", new Object[0]);
    }

    @Override
    public <T> void pushConstraint(@Nonnull Reference reference, @Nonnull PlannerConstraint<T> plannerConstraint, @Nonnull T constraintValue) {
        Verify.verify(this.root != reference);
        ConstraintsMap requirementsMap = reference.getConstraintsMap();
        if (requirementsMap.pushProperty(plannerConstraint, constraintValue).isPresent()) {
            this.referencesWithPushedConstraints.add(reference);
        }
    }

    @Override
    public void emitEvent(@Nonnull Debugger.Location location) {
        Verify.verify(location != Debugger.Location.BEGIN && location != Debugger.Location.END);
        Debugger.withDebugger(debugger -> debugger.onEvent(new Debugger.TransformRuleCallEvent(this.plannerPhase, this.root, this.taskStack, location, this.root, this.bindings.get(this.rule.getMatcher()), this.rule, this)));
    }

    @Override
    public void yieldExploratoryExpression(@Nonnull RelationalExpression expression) {
        this.yieldExpression(expression, false);
    }

    @Override
    public void yieldPlan(@Nonnull RecordQueryPlan plan) {
        Verify.verify(this.getPlannerPhase() == PlannerPhase.PLANNING);
        this.yieldFinalExpression(plan);
    }

    @Override
    public void yieldFinalExpression(@Nonnull RelationalExpression expression) {
        this.yieldExpression(expression, true);
    }

    @Override
    public void yieldUnknownExpression(@Nonnull RelationalExpression expression) {
        Verify.verify(this.getPlannerPhase() == PlannerPhase.PLANNING);
        if (expression instanceof RecordQueryPlan) {
            this.yieldPlan((RecordQueryPlan)expression);
        } else {
            this.yieldExploratoryExpression(expression);
        }
    }

    private void yieldExpression(@Nonnull RelationalExpression expression, boolean isFinal) {
        this.verifyChildrenMemoized(expression);
        if (isFinal) {
            if (this.root.insertFinalExpression(expression)) {
                this.newFinalExpressions.add(expression);
                this.traversal.addExpression(this.root, expression);
            }
        } else if (this.root.insertExploratoryExpression(expression)) {
            this.newExploratoryExpressions.add(expression);
            this.traversal.addExpression(this.root, expression);
        }
    }

    private void verifyChildrenMemoized(@Nonnull RelationalExpression expression) {
        for (Quantifier quantifier : expression.getQuantifiers()) {
            Reference rangesOver = quantifier.getRangesOver();
            Verify.verify(this.traversal.getRefs().contains(rangesOver));
        }
    }

    @Override
    public void yieldPartialMatch(@Nonnull AliasMap boundAliasMap, @Nonnull MatchCandidate matchCandidate, @Nonnull RelationalExpression queryExpression, @Nonnull Reference candidateRef, @Nonnull MatchInfo matchInfo) {
        PartialMatch newPartialMatch = new PartialMatch(boundAliasMap, matchCandidate, this.root, queryExpression, candidateRef, matchInfo);
        this.root.addPartialMatchForCandidate(matchCandidate, newPartialMatch);
        this.newPartialMatches.add(newPartialMatch);
    }

    @Nonnull
    public Collection<RelationalExpression> getNewExploratoryExpressions() {
        return Collections.unmodifiableCollection(this.newExploratoryExpressions);
    }

    @Nonnull
    public Collection<RelationalExpression> getNewFinalExpressions() {
        return Collections.unmodifiableCollection(this.newFinalExpressions);
    }

    @Nonnull
    public Set<PartialMatch> getNewPartialMatches() {
        return this.newPartialMatches;
    }

    @Nonnull
    public Set<Reference> getReferencesWithPushedConstraints() {
        return this.referencesWithPushedConstraints;
    }

    @Override
    @Nonnull
    public EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    @Nonnull
    private Reference addNewReference(@Nonnull Reference newRef) {
        for (RelationalExpression expression : newRef.getAllMemberExpressions()) {
            Debugger.withDebugger(debugger -> debugger.onEvent(Debugger.InsertIntoMemoEvent.newExp(expression)));
            this.traversal.addExpression(newRef, expression);
        }
        this.newReferences.add(newRef);
        return newRef;
    }

    public void pruneUnusedNewReferences() {
        this.traversal.pruneUnreferencedRefs(this.newReferences);
        this.newReferences.clear();
    }

    @Override
    @Nonnull
    public Reference memoizeExpressions(@Nonnull Collection<? extends RelationalExpression> exploratoryExpressions, @Nonnull Collection<? extends RelationalExpression> finalExpressions) {
        return this.memoizeExpressionsExactly(exploratoryExpressions, finalExpressions, (exploratoryExpressionsSet, finalExpressionsSet) -> Reference.of(this.getPlannerPhase().getTargetPlannerStage(), exploratoryExpressionsSet, finalExpressionsSet));
    }

    @Override
    @Nonnull
    public Reference memoizeExploratoryExpression(@Nonnull RelationalExpression expression) {
        return this.memoizeExploratoryExpressions(ImmutableSet.of(expression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Reference memoizeExploratoryExpressions(@Nonnull Collection<? extends RelationalExpression> expressions) {
        Preconditions.checkArgument(!expressions.isEmpty(), "Cannot create reference over empty expression collection");
        if (expressions.stream().allMatch(expression -> expression.getQuantifiers().isEmpty())) {
            return this.memoizeLeafExpressions(expressions);
        }
        Debugger.withDebugger(debugger -> debugger.onEvent(Debugger.InsertIntoMemoEvent.begin()));
        try {
            Preconditions.checkArgument(expressions.stream().noneMatch(expression -> expression instanceof RecordQueryPlan));
            Set<CorrelationIdentifier> requiredCorrelations = this.correlatedTo(expressions);
            RelationalExpression expression2 = Iterables.getFirst(expressions, null);
            Verify.verify(expression2 != null, "should not get null from first element of non-empty expressions collection", new Object[0]);
            ImmutableList referencePathsList = expression2.getQuantifiers().stream().map(Quantifier::getRangesOver).map(this.traversal::getParentRefPaths).collect(ImmutableList.toImmutableList());
            LinkedIdentityMap expressionToReferenceMap = new LinkedIdentityMap();
            referencePathsList.stream().flatMap(Collection::stream).filter(referencePath -> this.isEligibleForReuse(requiredCorrelations, (Traversal.ReferencePath)referencePath)).forEach(referencePath -> {
                RelationalExpression referencingExpression = referencePath.getExpression();
                if (expressionToReferenceMap.containsKey(referencingExpression)) {
                    if (expressionToReferenceMap.get(referencingExpression) != referencePath.getReference()) {
                        throw new RecordCoreException("expression used in multiple references", new Object[0]);
                    }
                } else {
                    expressionToReferenceMap.put(referencePath.getExpression(), referencePath.getReference());
                }
            });
            List referencingExpressions = referencePathsList.stream().map(referencePaths -> referencePaths.stream().filter(referencePath -> this.isEligibleForReuse(requiredCorrelations, (Traversal.ReferencePath)referencePath)).map(Traversal.ReferencePath::getExpression).collect(LinkedIdentitySet.toLinkedIdentitySet())).collect(ImmutableList.toImmutableList());
            Iterator referencingExpressionsIterator = referencingExpressions.iterator();
            LinkedIdentitySet commonReferencingExpressions = new LinkedIdentitySet((Collection)referencingExpressionsIterator.next());
            while (referencingExpressionsIterator.hasNext()) {
                commonReferencingExpressions.retainAll((Collection)referencingExpressionsIterator.next());
            }
            List existingRefs = commonReferencingExpressions.stream().map(expressionToReferenceMap::get).filter(ref -> ref.containsAllInMemo(expressions, AliasMap.emptyMap(), false)).collect(ImmutableList.toImmutableList());
            if (!existingRefs.isEmpty()) {
                Reference existingReference = (Reference)existingRefs.get(0);
                expressions.forEach(expr -> Debugger.withDebugger(debugger -> debugger.onEvent(Debugger.InsertIntoMemoEvent.reusedExpWithReferences(expr, existingRefs))));
                Verify.verify(existingReference != this.root);
                Reference reference = existingReference;
                return reference;
            }
            Reference reference = this.addNewReference(Reference.ofExploratoryExpressions(this.plannerPhase.getTargetPlannerStage(), expressions));
            return reference;
        }
        finally {
            Debugger.withDebugger(debugger -> debugger.onEvent(Debugger.InsertIntoMemoEvent.end()));
        }
    }

    private boolean isEligibleForReuse(@Nonnull Set<CorrelationIdentifier> requiredCorrelations, @Nonnull Traversal.ReferencePath path) {
        return path.getReference().getPlannerStage() == this.plannerPhase.getTargetPlannerStage() && path.getReference().getCorrelatedTo().equals(requiredCorrelations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Reference memoizeLeafExpressions(@Nonnull Collection<? extends RelationalExpression> expressions) {
        Debugger.withDebugger(debugger -> debugger.onEvent(Debugger.InsertIntoMemoEvent.begin()));
        try {
            Preconditions.checkArgument(expressions.stream().allMatch(expression -> !(expression instanceof RecordQueryPlan) && expression.getQuantifiers().isEmpty()));
            Set<CorrelationIdentifier> requiredCorrelations = this.correlatedTo(expressions);
            Set<Reference> leafRefs = this.traversal.getLeafReferences();
            for (Reference leafRef : leafRefs) {
                if (leafRef.getPlannerStage() != this.plannerPhase.getTargetPlannerStage() || !requiredCorrelations.equals(leafRef.getCorrelatedTo())) continue;
                if (!leafRef.containsAllInMemo(expressions, AliasMap.emptyMap(), false)) continue;
                for (RelationalExpression relationalExpression : expressions) {
                    Debugger.withDebugger(debugger -> debugger.onEvent(Debugger.InsertIntoMemoEvent.reusedExp(expression2)));
                }
                Reference reference = leafRef;
                return reference;
            }
            Reference reference = this.addNewReference(Reference.ofExploratoryExpressions(this.plannerPhase.getTargetPlannerStage(), expressions));
            return reference;
        }
        finally {
            Debugger.withDebugger(debugger -> debugger.onEvent(Debugger.InsertIntoMemoEvent.end()));
        }
    }

    @Nonnull
    private Set<CorrelationIdentifier> correlatedTo(@Nonnull Collection<? extends RelationalExpression> expressions) {
        if (expressions.isEmpty()) {
            return ImmutableSet.of();
        }
        if (expressions.size() == 1) {
            return Iterables.getOnlyElement(expressions).getCorrelatedTo();
        }
        return expressions.stream().map(Correlated::getCorrelatedTo).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public Reference memoizeFinalExpressionsFromOther(@Nonnull Reference reference, @Nonnull Collection<? extends RelationalExpression> expressions) {
        return this.memoizeExpressionsExactly(ImmutableList.of(), expressions, (ignored, finalExpressions) -> reference.newReferenceFromFinalMembers((Collection<? extends RelationalExpression>)finalExpressions));
    }

    @Override
    @Nonnull
    public Reference memoizeFinalExpression(@Nonnull RelationalExpression expression) {
        return this.memoizeFinalExpressions(ImmutableList.of(expression));
    }

    @Override
    @Nonnull
    public Reference memoizeFinalExpressions(@Nonnull Collection<RelationalExpression> expressions) {
        return this.memoizeExpressionsExactly(ImmutableList.of(), expressions, (ignored, finalExpressions) -> Reference.ofFinalExpressions(this.getPlannerPhase().getTargetPlannerStage(), finalExpressions));
    }

    @Override
    @Nonnull
    public Reference memoizeUnknownExpression(@Nonnull RelationalExpression expression) {
        Verify.verify(this.getPlannerPhase() == PlannerPhase.PLANNING);
        if (expression instanceof RecordQueryPlan) {
            return this.memoizePlan((RecordQueryPlan)expression);
        }
        return this.memoizeExploratoryExpression(expression);
    }

    @Override
    @Nonnull
    public Reference memoizeMemberPlansFromOther(@Nonnull Reference reference, @Nonnull Collection<? extends RecordQueryPlan> plans) {
        Verify.verify(this.getPlannerPhase() == PlannerPhase.PLANNING);
        return this.memoizeExpressionsExactly(ImmutableList.of(), plans, (ignored, finalExpressions) -> reference.newReferenceFromFinalMembers((Collection<? extends RelationalExpression>)finalExpressions));
    }

    @Override
    @Nonnull
    public Reference memoizePlan(@Nonnull RecordQueryPlan plan) {
        Verify.verify(this.getPlannerPhase() == PlannerPhase.PLANNING);
        return this.memoizeFinalExpression(plan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Reference memoizeExpressionsExactly(@Nonnull Collection<? extends RelationalExpression> exploratoryExpressions, @Nonnull Collection<? extends RelationalExpression> finalExpressions, @Nonnull BiFunction<Set<? extends RelationalExpression>, Set<? extends RelationalExpression>, Reference> referenceCreator) {
        Iterable<? extends RelationalExpression> allExpressions = Iterables.concat(exploratoryExpressions, finalExpressions);
        Debugger.withDebugger(debugger -> allExpressions.forEach(expression -> debugger.onEvent(Debugger.InsertIntoMemoEvent.begin())));
        try {
            LinkedIdentitySet<? extends RelationalExpression> exploratoryExpressionSet = new LinkedIdentitySet<RelationalExpression>(exploratoryExpressions);
            LinkedIdentitySet<? extends RelationalExpression> finalExpressionSet = new LinkedIdentitySet<RelationalExpression>(finalExpressions);
            Reference reference = this.addNewReference(referenceCreator.apply(exploratoryExpressionSet, finalExpressionSet));
            return reference;
        }
        finally {
            Debugger.withDebugger(debugger -> allExpressions.forEach(expression -> debugger.onEvent(Debugger.InsertIntoMemoEvent.end())));
        }
    }

    @Override
    @Nonnull
    public Memoizer.ReferenceBuilder memoizeExploratoryExpressionBuilder(final @Nonnull RelationalExpression expression) {
        return new Memoizer.ReferenceBuilder(){

            @Override
            @Nonnull
            public Reference reference() {
                return CascadesRuleCall.this.memoizeExploratoryExpression(expression);
            }

            @Override
            @Nonnull
            public Set<? extends RelationalExpression> members() {
                return LinkedIdentitySet.of(new RelationalExpression[]{expression});
            }
        };
    }

    @Override
    @Nonnull
    public Memoizer.ReferenceBuilder memoizeFinalExpressionsBuilder(@Nonnull Collection<? extends RelationalExpression> expressions) {
        return this.memoizeFinalExpressionsBuilder(expressions, e -> Reference.ofFinalExpressions(this.getPlannerPhase().getTargetPlannerStage(), e));
    }

    @Nonnull
    private Memoizer.ReferenceBuilder memoizeFinalExpressionsBuilder(final @Nonnull Collection<? extends RelationalExpression> expressions, final @Nonnull Function<Set<? extends RelationalExpression>, Reference> refAction) {
        final LinkedIdentitySet<? extends RelationalExpression> finalExpressionsSet = new LinkedIdentitySet<RelationalExpression>(expressions);
        return new Memoizer.ReferenceBuilder(){

            @Override
            @Nonnull
            public Reference reference() {
                return CascadesRuleCall.this.memoizeExpressionsExactly(ImmutableList.of(), expressions, (ignored, finalExpressions) -> (Reference)refAction.apply(finalExpressions));
            }

            @Override
            @Nonnull
            public Set<? extends RelationalExpression> members() {
                return finalExpressionsSet;
            }
        };
    }

    @Override
    @Nonnull
    public Memoizer.ReferenceOfPlansBuilder memoizeMemberPlansBuilder(@Nonnull Reference reference, @Nonnull Collection<? extends RecordQueryPlan> plans) {
        return this.memoizePlansBuilder(plans, reference::newReferenceFromFinalMembers);
    }

    @Override
    @Nonnull
    public Memoizer.ReferenceOfPlansBuilder memoizePlansBuilder(@Nonnull Collection<? extends RecordQueryPlan> plans) {
        return this.memoizePlansBuilder(plans, expressions -> Reference.ofFinalExpressions(this.getPlannerPhase().getTargetPlannerStage(), expressions));
    }

    @Nonnull
    private Memoizer.ReferenceOfPlansBuilder memoizePlansBuilder(final @Nonnull Collection<? extends RecordQueryPlan> plans, final @Nonnull Function<Set<? extends RelationalExpression>, Reference> refAction) {
        Verify.verify(this.getPlannerPhase() == PlannerPhase.PLANNING);
        final LinkedIdentitySet<? extends RecordQueryPlan> plansSet = new LinkedIdentitySet<RecordQueryPlan>(plans);
        return new Memoizer.ReferenceOfPlansBuilder(){

            @Override
            @Nonnull
            public Reference reference() {
                return CascadesRuleCall.this.memoizeExpressionsExactly(ImmutableList.of(), plans, (ignored, finalExpressions) -> (Reference)refAction.apply(finalExpressions));
            }

            @Override
            @Nonnull
            public Set<? extends RecordQueryPlan> members() {
                return plansSet;
            }
        };
    }
}

