/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.google.common.base.Functions;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class CatalogedFunction {
    @Nonnull
    protected final String functionName;
    @Nonnull
    protected final List<Type> parameterTypes;
    @Nonnull
    protected final BiMap<String, Integer> parameterNamesMap;
    @Nonnull
    protected final List<Optional<? extends Typed>> parameterDefaults;
    @Nullable
    private final Type variadicSuffixType;

    protected CatalogedFunction(@Nonnull String functionName, @Nonnull List<Type> parameterTypes, @Nullable Type variadicSuffixType) {
        this.functionName = functionName;
        this.parameterTypes = ImmutableList.copyOf(parameterTypes);
        this.parameterDefaults = ImmutableList.of();
        this.parameterNamesMap = ImmutableBiMap.of();
        this.variadicSuffixType = variadicSuffixType;
    }

    protected CatalogedFunction(@Nonnull String functionName, @Nonnull List<String> parameterNames, @Nonnull List<Type> parameterTypes, @Nonnull List<Optional<? extends Typed>> parameterDefaults) {
        Verify.verify(parameterNames.size() == parameterTypes.size());
        this.functionName = functionName;
        this.parameterTypes = ImmutableList.copyOf(parameterTypes);
        this.parameterNamesMap = IntStream.range(0, parameterNames.size()).boxed().collect(ImmutableBiMap.toImmutableBiMap(parameterNames::get, Functions.identity()));
        this.parameterDefaults = ImmutableList.copyOf(parameterDefaults);
        this.variadicSuffixType = null;
    }

    @Nonnull
    public String getFunctionName() {
        return this.functionName;
    }

    @Nonnull
    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean hasNamedParameters() {
        return !this.parameterNamesMap.isEmpty();
    }

    @Nonnull
    public String getParameterName(int index) {
        return (String)this.parameterNamesMap.inverse().get(index);
    }

    @Nonnull
    public Collection<String> getParameterNames() {
        return this.parameterNamesMap.keySet();
    }

    @Nullable
    public Type getVariadicSuffixType() {
        return this.variadicSuffixType;
    }

    public boolean hasVariadicSuffix() {
        return this.variadicSuffixType != null;
    }

    @Nonnull
    public Type computeParameterType(int index) {
        Verify.verify(index >= 0, "unexpected negative parameter index", new Object[0]);
        if (index < this.parameterTypes.size()) {
            return this.parameterTypes.get(index);
        }
        if (this.hasVariadicSuffix()) {
            return this.variadicSuffixType;
        }
        throw new IllegalArgumentException("cannot resolve declared parameter at index " + index);
    }

    @Nonnull
    public Type computeParameterType(@Nonnull String parameterName) {
        return this.computeParameterType(this.getParamIndex(parameterName));
    }

    @Nonnull
    public List<Type> getParameterTypes(int numberOfArguments) {
        Verify.verify(numberOfArguments > 0, "unexpected number of arguments", new Object[0]);
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (int i = 0; i < numberOfArguments; ++i) {
            resultBuilder.add(this.computeParameterType(i));
        }
        return resultBuilder.build();
    }

    public int getParamIndex(@Nonnull String parameter) {
        return (Integer)this.parameterNamesMap.get(parameter);
    }

    public Optional<? extends Typed> getDefaultValue(@Nonnull String paramName) {
        return this.parameterDefaults.get(this.getParamIndex(paramName));
    }

    public Optional<? extends Typed> getDefaultValue(int paramIndex) {
        return this.parameterDefaults.get(paramIndex);
    }

    public boolean hasDefaultValue(@Nonnull String paramName) {
        return this.getDefaultValue(paramName).isPresent();
    }

    public boolean hasDefaultValue(int paramIndex) {
        return this.getDefaultValue(paramIndex).isPresent();
    }

    @Nonnull
    public Optional<? extends CatalogedFunction> validateCall(@Nonnull Map<String, ? extends Typed> namedArgumentsTypeMap) {
        Set parameterNames;
        if (this.parameterNamesMap.isEmpty()) {
            return Optional.empty();
        }
        Set<String> argumentNames = namedArgumentsTypeMap.keySet();
        Sets.SetView<String> unknownArgs = Sets.difference(argumentNames, parameterNames = this.parameterNamesMap.keySet());
        if (!unknownArgs.isEmpty()) {
            return Optional.empty();
        }
        Sets.SetView<String> missingParams = Sets.difference(parameterNames, argumentNames);
        for (String missingParam : missingParams) {
            if (this.hasDefaultValue(missingParam)) continue;
            return Optional.empty();
        }
        return Optional.of(this);
    }

    @Nonnull
    public String toString() {
        Object variadicSuffixString = "";
        if (this.variadicSuffixType != null) {
            variadicSuffixString = String.valueOf(this.variadicSuffixType) + "...";
            if (!this.parameterTypes.isEmpty()) {
                variadicSuffixString = ", " + (String)variadicSuffixString;
            }
        }
        Set parameterNames = this.parameterNamesMap.keySet();
        if (!this.parameterNamesMap.isEmpty()) {
            return this.functionName + "(" + Streams.zip(parameterNames.stream(), this.parameterTypes.stream(), (name, type) -> name + " -> " + String.valueOf(type)).collect(Collectors.joining(",")) + (String)variadicSuffixString + ")";
        }
        return this.functionName + "(" + this.parameterTypes.stream().map(Object::toString).collect(Collectors.joining(",")) + (String)variadicSuffixString + ")";
    }

    @Nonnull
    public abstract Typed encapsulate(@Nonnull List<? extends Typed> var1);

    @Nonnull
    public abstract Typed encapsulate(@Nonnull Map<String, ? extends Typed> var1);
}

