/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PRecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class Column<V extends Value>
implements PlanHashable,
PlanSerializable {
    @Nonnull
    private final Type.Record.Field field;
    @Nonnull
    private final V value;

    public Column(@Nonnull Type.Record.Field field, @Nonnull V value) {
        this.field = field;
        this.value = value;
    }

    @Nonnull
    public Type.Record.Field getField() {
        return this.field;
    }

    @Nonnull
    public V getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column column = (Column)o;
        return this.getField().equals(column.getField()) && this.getValue().equals(column.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getField(), this.getValue());
    }

    public static <V extends Value> Column<V> unnamedOf(@Nonnull V value) {
        return new Column<V>(Type.Record.Field.unnamedOf(value.getResultType()), value);
    }

    public static <V extends Value> Column<V> of(@Nonnull Optional<String> fieldNameOptional, @Nonnull V value) {
        return new Column<V>(Type.Record.Field.of(value.getResultType(), fieldNameOptional), value);
    }

    public static <V extends Value> Column<V> of(@Nonnull Type.Record.Field field, @Nonnull V value) {
        return new Column<V>(field, value);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
        Optional<String> fieldNameOptional = this.getField().getFieldNameOptional();
        if (fieldNameOptional.isPresent() && !Type.Record.Field.isAutoGenerated(fieldNameOptional.get())) {
            return PlanHashable.objectsPlanHash(hashMode, this.getField().getFieldIndexOptional(), fieldNameOptional.get(), this.getValue());
        }
        return PlanHashable.objectsPlanHash(hashMode, this.getField().getFieldIndexOptional(), this.getValue());
    }

    @Override
    @Nonnull
    public PRecordConstructorValue.PColumn toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PRecordConstructorValue.PColumn.newBuilder().setField(this.field.toProto(serializationContext)).setValue(this.value.toValueProto(serializationContext)).build();
    }

    @Nonnull
    public static Column<? extends Value> fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordConstructorValue.PColumn columnProto) {
        return new Column<Value>(Type.Record.Field.fromProto(serializationContext, Objects.requireNonNull(columnProto.getField())), Value.fromValueProto(serializationContext, Objects.requireNonNull(columnProto.getValue())));
    }
}

