/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(value=API.Status.EXPERIMENTAL)
public class ComparisonRange
implements PlanHashable,
Correlated<ComparisonRange> {
    public static final ComparisonRange EMPTY = new ComparisonRange();
    @Nullable
    private final Comparisons.Comparison equalityComparison;
    @Nullable
    private final List<Comparisons.Comparison> inequalityComparisons;

    private ComparisonRange() {
        this.equalityComparison = null;
        this.inequalityComparisons = null;
    }

    private ComparisonRange(@Nonnull Comparisons.Comparison equalityComparison) {
        this.equalityComparison = equalityComparison;
        this.inequalityComparisons = null;
    }

    private ComparisonRange(@Nonnull Iterable<Comparisons.Comparison> inequalityComparisons) {
        this.equalityComparison = null;
        this.inequalityComparisons = Lists.newArrayList(inequalityComparisons);
    }

    public boolean isEmpty() {
        return this.equalityComparison == null && this.inequalityComparisons == null;
    }

    public boolean isEquality() {
        return this.equalityComparison != null && this.inequalityComparisons == null;
    }

    public boolean isInequality() {
        return this.equalityComparison == null && this.inequalityComparisons != null;
    }

    @Nonnull
    public Type getRangeType() {
        if (this.isEmpty()) {
            return Type.EMPTY;
        }
        if (this.isEquality()) {
            return Type.EQUALITY;
        }
        return Type.INEQUALITY;
    }

    @Nonnull
    public Comparisons.Comparison getEqualityComparison() {
        if (this.equalityComparison == null) {
            throw new RecordCoreException("tried to get non-existent equality comparison from ComparisonRange", new Object[0]);
        }
        return this.equalityComparison;
    }

    @Nonnull
    public List<Comparisons.Comparison> getInequalityComparisons() {
        if (this.inequalityComparisons == null) {
            throw new RecordCoreException("tried to get non-existent inequality comparisons from ComparisonRange", new Object[0]);
        }
        return this.inequalityComparisons;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.equalityComparison != null) {
            builder.addAll(this.equalityComparison.getCorrelatedTo());
        }
        if (this.inequalityComparisons != null) {
            for (Comparisons.Comparison inequalityComparison : this.inequalityComparisons) {
                builder.addAll(inequalityComparison.getCorrelatedTo());
            }
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public ComparisonRange rebase(@Nonnull AliasMap aliasMap) {
        return this.translateCorrelations(TranslationMap.rebaseWithAliasMap(aliasMap), false);
    }

    @Nonnull
    public ComparisonRange translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        Collection<Comparisons.Comparison> rebasedInequalityComparisons;
        Comparisons.Comparison translatedEqualityComparison;
        Comparisons.Comparison comparison = translatedEqualityComparison = this.equalityComparison == null ? null : this.equalityComparison.translateCorrelations(translationMap, shouldSimplifyValues);
        if (this.inequalityComparisons != null) {
            boolean allRemainedSame = true;
            ImmutableList.Builder translatedInequalityComparisonsBuilder = ImmutableList.builder();
            for (Comparisons.Comparison inequalityComparison : this.inequalityComparisons) {
                Comparisons.Comparison translatedInequalityComparison = inequalityComparison.translateCorrelations(translationMap, shouldSimplifyValues);
                translatedInequalityComparisonsBuilder.add(translatedInequalityComparison);
                if (inequalityComparison == translatedInequalityComparison) continue;
                allRemainedSame = false;
            }
            rebasedInequalityComparisons = allRemainedSame ? this.inequalityComparisons : translatedInequalityComparisonsBuilder.build();
        } else {
            rebasedInequalityComparisons = null;
        }
        if (translatedEqualityComparison == this.equalityComparison && rebasedInequalityComparisons == this.inequalityComparisons) {
            return this;
        }
        if (this.isEquality()) {
            Objects.requireNonNull(translatedEqualityComparison);
            return new ComparisonRange(translatedEqualityComparison);
        }
        if (this.isInequality()) {
            Objects.requireNonNull(rebasedInequalityComparisons);
            return new ComparisonRange(rebasedInequalityComparisons);
        }
        throw new IllegalStateException("this should never be reached");
    }

    @Override
    public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ComparisonRange that = (ComparisonRange)other;
        Verify.verify(this.isEquality() ^ this.isInequality());
        Verify.verify(that.isEquality() ^ that.isInequality());
        if (this.isEquality()) {
            return Correlated.semanticEquals(this.equalityComparison, that.equalityComparison, aliasMap);
        }
        if (this.isInequality()) {
            if (!that.isInequality()) {
                return false;
            }
            Objects.requireNonNull(this.inequalityComparisons);
            Objects.requireNonNull(that.inequalityComparisons);
            if (this.inequalityComparisons.size() != that.inequalityComparisons.size()) {
                return false;
            }
            for (Comparisons.Comparison inequalityComparison : this.inequalityComparisons) {
                boolean found = false;
                for (Comparisons.Comparison thatInequalityComparison : that.inequalityComparisons) {
                    if (!inequalityComparison.semanticEquals((Object)thatInequalityComparison, aliasMap)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        throw new IllegalStateException("this should never be reached");
    }

    @Override
    public int semanticHashCode() {
        if (this.isEquality()) {
            Objects.requireNonNull(this.equalityComparison);
            return this.equalityComparison.semanticHashCode();
        }
        if (this.isInequality()) {
            Objects.requireNonNull(this.inequalityComparisons);
            return this.inequalityComparisons.stream().map(Comparisons.Comparison::semanticHashCode).collect(ImmutableList.toImmutableList()).hashCode();
        }
        throw new IllegalStateException("this should never be reached");
    }

    @SpotBugsSuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (this.isEquality()) {
            return this.equalityComparison.eval(store, context, value);
        }
        if (this.isInequality()) {
            for (Comparisons.Comparison inequalityComparison : this.inequalityComparisons) {
                Boolean comparisonResult = inequalityComparison.eval(store, context, value);
                if (comparisonResult == null) {
                    return null;
                }
                if (comparisonResult.booleanValue()) continue;
                return false;
            }
            return true;
        }
        throw new RecordCoreException("unknown kind of comparison range", new Object[0]);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, this.equalityComparison, this.inequalityComparisons);
    }

    @Nonnull
    public ScanComparisons toScanComparisons() {
        if (this.isEmpty()) {
            return ScanComparisons.EMPTY;
        }
        if (this.isEquality()) {
            return new ScanComparisons(Lists.newArrayList(this.getEqualityComparison()), Collections.emptySet());
        }
        return new ScanComparisons(Collections.emptyList(), Sets.newHashSet(this.getInequalityComparisons()));
    }

    @Nonnull
    public MergeResult merge(@Nonnull Comparisons.Comparison comparison) {
        ScanComparisons.ComparisonType comparisonType = ScanComparisons.getComparisonType(comparison);
        if (comparisonType == ScanComparisons.ComparisonType.NONE) {
            return MergeResult.of(this, comparison);
        }
        if (this.isEmpty()) {
            return MergeResult.of(ComparisonRange.from(comparison));
        }
        if (this.isEquality()) {
            switch (comparisonType) {
                case INEQUALITY: {
                    return MergeResult.of(this, comparison);
                }
                case EQUALITY: {
                    if (this.getEqualityComparison().equals(comparison)) {
                        return MergeResult.of(this);
                    }
                    return MergeResult.of(this, comparison);
                }
            }
        } else if (this.isInequality()) {
            Objects.requireNonNull(this.inequalityComparisons);
            switch (comparisonType) {
                case INEQUALITY: {
                    if (this.inequalityComparisons.contains(comparison)) {
                        return MergeResult.of(this);
                    }
                    return MergeResult.of(new ComparisonRange(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.inequalityComparisons)).add(comparison)).build()));
                }
                case EQUALITY: {
                    return MergeResult.of(ComparisonRange.from(comparison), this.inequalityComparisons);
                }
            }
        }
        return MergeResult.of(this, comparison);
    }

    @Nonnull
    public MergeResult merge(@Nonnull ComparisonRange comparisonRange) {
        ImmutableList.Builder residualPredicatesBuilder = ImmutableList.builder();
        if (comparisonRange.isEmpty()) {
            return MergeResult.of(this);
        }
        if (this.isEmpty()) {
            return MergeResult.of(comparisonRange);
        }
        if (this.isEquality()) {
            return this.merge(comparisonRange.getEqualityComparison());
        }
        Verify.verify(this.isInequality());
        List<Comparisons.Comparison> comparisons = Objects.requireNonNull(comparisonRange.getInequalityComparisons());
        ComparisonRange resultRange = this;
        for (Comparisons.Comparison comparison : comparisons) {
            MergeResult mergeResult = resultRange.merge(comparison);
            resultRange = mergeResult.getComparisonRange();
            residualPredicatesBuilder.addAll(mergeResult.getResidualComparisons());
        }
        return MergeResult.of(resultRange, (List<Comparisons.Comparison>)((Object)residualPredicatesBuilder.build()));
    }

    public String toString() {
        if (this.isEquality()) {
            return this.getEqualityComparison().toString();
        }
        if (this.isInequality()) {
            Objects.requireNonNull(this.inequalityComparisons);
            return this.inequalityComparisons.stream().map(Object::toString).collect(Collectors.joining(" && ", "[", "]"));
        }
        return "[]";
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object o) {
        return this.semanticEquals(o, AliasMap.emptyMap());
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Nonnull
    public static ComparisonRange from(@Nonnull Comparisons.Comparison comparison) {
        ComparisonRange result = ComparisonRange.tryFrom(comparison);
        if (result == null) {
            throw new RecordCoreException("unexpected comparison type", new Object[0]);
        }
        return result;
    }

    @Nullable
    public static ComparisonRange tryFrom(@Nonnull Comparisons.Comparison comparison) {
        switch (ScanComparisons.getComparisonType(comparison)) {
            case EQUALITY: {
                return new ComparisonRange(comparison);
            }
            case INEQUALITY: {
                return ComparisonRange.fromInequalities(Collections.singletonList(comparison));
            }
        }
        return null;
    }

    @Nonnull
    public static ComparisonRange fromInequalities(@Nonnull Iterable<Comparisons.Comparison> comparisons) {
        Verify.verify(Streams.stream(comparisons).allMatch(comparison -> ScanComparisons.getComparisonType(comparison) == ScanComparisons.ComparisonType.INEQUALITY));
        return new ComparisonRange(comparisons);
    }

    public static enum Type {
        EMPTY,
        EQUALITY,
        INEQUALITY;

    }

    public static class MergeResult {
        @Nonnull
        private final ComparisonRange comparisonRange;
        @Nonnull
        private final List<Comparisons.Comparison> residualComparisons;

        private MergeResult(@Nonnull ComparisonRange comparisonRange, @Nonnull List<Comparisons.Comparison> residualComparison) {
            this.comparisonRange = comparisonRange;
            this.residualComparisons = ImmutableList.copyOf(residualComparison);
        }

        @Nonnull
        public ComparisonRange getComparisonRange() {
            return this.comparisonRange;
        }

        public @NonNull List<Comparisons.Comparison> getResidualComparisons() {
            return this.residualComparisons;
        }

        public static MergeResult of(@Nonnull ComparisonRange comparisonRange) {
            return MergeResult.of(comparisonRange, ImmutableList.of());
        }

        public static MergeResult of(@Nonnull ComparisonRange comparisonRange, @Nonnull Comparisons.Comparison residualComparison) {
            return new MergeResult(comparisonRange, ImmutableList.of(residualComparison));
        }

        public static MergeResult of(@Nonnull ComparisonRange comparisonRange, @NonNull List<Comparisons.Comparison> residualComparisons) {
            return new MergeResult(comparisonRange, residualComparisons);
        }
    }
}

