/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComparisonRanges
implements PlanHashable,
Correlated<ComparisonRanges> {
    @Nonnull
    private final List<ComparisonRange> ranges;
    private int sealedSize;

    public ComparisonRanges() {
        this.ranges = Lists.newArrayList();
    }

    public ComparisonRanges(@Nonnull List<ComparisonRange> ranges) {
        this.ranges = Lists.newArrayList(ranges);
        this.sealedSize = 0;
    }

    public void clear() {
        this.ranges.clear();
        this.sealedSize = 0;
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public void commitAndAdvance() {
        this.sealedSize = this.ranges.size();
    }

    public int uncommittedComparisonRangesSize() {
        return this.ranges.size() - this.sealedSize;
    }

    @Nonnull
    public List<ComparisonRange> getUncommittedComparisonRanges() {
        return this.ranges.subList(this.sealedSize, this.ranges.size());
    }

    public void addEqualityComparison(@Nonnull Comparisons.Comparison comparison) {
        Verify.verify(this.sealedSize == this.ranges.size());
        ComparisonRange newComparisonRange = ComparisonRange.from(comparison);
        Verify.verify(newComparisonRange.isEquality());
        this.ranges.add(newComparisonRange);
    }

    public void addInequalityComparison(@Nonnull Comparisons.Comparison comparison) {
        ComparisonRange newComparisonRange = ComparisonRange.from(comparison);
        Verify.verify(newComparisonRange.isInequality());
        if (this.sealedSize < this.ranges.size()) {
            ComparisonRange currentComparisonRange = this.ranges.get(this.sealedSize);
            Verify.verify(!currentComparisonRange.isEquality());
            ComparisonRange.MergeResult mergeResult = Objects.requireNonNull(currentComparisonRange).merge(newComparisonRange);
            Verify.verify(mergeResult.getResidualComparisons().isEmpty());
            this.ranges.set(this.sealedSize, mergeResult.getComparisonRange());
        } else {
            this.ranges.add(newComparisonRange);
        }
    }

    public void addEmptyRanges(int n) {
        for (int i = 0; i < n; ++i) {
            this.ranges.add(ComparisonRange.EMPTY);
        }
    }

    public void addAll(@Nonnull ComparisonRanges comparisonRanges) {
        Preconditions.checkArgument(this.isUncommitedComparisonRangesEqualities());
        this.ranges.addAll(comparisonRanges.ranges);
    }

    public boolean isEqualities() {
        return this.isEqualities(this.ranges);
    }

    private boolean isEqualities(@Nonnull List<ComparisonRange> ranges) {
        return ranges.stream().allMatch(ComparisonRange::isEquality);
    }

    public boolean isUncommitedComparisonRangesEqualities() {
        return this.isEqualities(this.getUncommittedComparisonRanges());
    }

    public int getEqualitiesSize() {
        int i;
        for (i = 0; i < this.ranges.size(); ++i) {
            ComparisonRange range = this.ranges.get(i);
            if (range.isEquality()) continue;
            return i;
        }
        return i;
    }

    boolean isPrefixRanges() {
        for (int i = 0; i < this.ranges.size(); ++i) {
            ComparisonRange comparisonRange = this.ranges.get(i);
            if (comparisonRange.isEquality()) continue;
            if (!comparisonRange.isInequality()) {
                return false;
            }
            return i + 1 == this.ranges.size();
        }
        return true;
    }

    @Nonnull
    public ComparisonRanges toPrefixRanges() {
        int last;
        for (last = 0; last < this.ranges.size(); ++last) {
            ComparisonRange comparisonRange = this.ranges.get(last);
            if (comparisonRange.isEquality()) continue;
            if (!comparisonRange.isInequality()) break;
            ++last;
            break;
        }
        return new ComparisonRanges(this.ranges.subList(0, last));
    }

    @Nonnull
    public ScanComparisons toScanComparisons() {
        ComparisonRanges prefixRanges = this.toPrefixRanges();
        ArrayList<Comparisons.Comparison> equalityComparisons = Lists.newArrayList();
        HashSet<Comparisons.Comparison> inequalityComparisons = Sets.newHashSet();
        for (ComparisonRange range : prefixRanges.ranges) {
            if (range.isEquality()) {
                equalityComparisons.add(range.getEqualityComparison());
                continue;
            }
            inequalityComparisons.addAll(range.getInequalityComparisons());
        }
        return new ScanComparisons(equalityComparisons, inequalityComparisons);
    }

    @Nullable
    public List<QueryComponent> compensateForScanComparisons(@Nonnull List<KeyExpression> normalizedKeyExpressions) {
        ComparisonRanges prefixRanges = this.toPrefixRanges();
        ArrayList<QueryComponent> compensations = Lists.newArrayList();
        for (int i = prefixRanges.size(); i < this.size(); ++i) {
            ComparisonRange comparisonRange = this.ranges.get(i);
            if (comparisonRange.isEmpty()) continue;
            KeyExpression expression = normalizedKeyExpressions.get(i);
            if (comparisonRange.isEquality()) {
                Comparisons.Comparison comparison = comparisonRange.getEqualityComparison();
                QueryComponent component = ComparisonRanges.toQueryComponentWithComparison(expression, comparison);
                if (component == null) {
                    return null;
                }
                compensations.add(component);
                continue;
            }
            Verify.verify(comparisonRange.isInequality());
            for (Comparisons.Comparison comparison : comparisonRange.getInequalityComparisons()) {
                QueryComponent component = ComparisonRanges.toQueryComponentWithComparison(expression, comparison);
                if (component == null) {
                    return null;
                }
                compensations.add(component);
            }
        }
        return compensations;
    }

    @Nullable
    private static QueryComponent toQueryComponentWithComparison(@Nonnull KeyExpression expression, @Nonnull Comparisons.Comparison comparison) {
        if (expression instanceof FieldKeyExpression) {
            if (((FieldKeyExpression)expression).getFanType() != KeyExpression.FanType.None) {
                return null;
            }
            return new FieldWithComparison(((FieldKeyExpression)expression).getFieldName(), comparison);
        }
        if (expression instanceof NestingKeyExpression) {
            NestingKeyExpression nestingKeyExpression = (NestingKeyExpression)expression;
            QueryComponent nestedQueryComponent = ComparisonRanges.toQueryComponentWithComparison(nestingKeyExpression.getChild(), comparison);
            if (nestedQueryComponent == null) {
                return null;
            }
            return new NestedField(nestingKeyExpression.getParent().getFieldName(), nestedQueryComponent);
        }
        return null;
    }

    public int size() {
        return this.ranges.size();
    }

    public int totalSize() {
        return this.ranges.stream().mapToInt(range -> {
            switch (range.getRangeType()) {
                case EMPTY: {
                    return 0;
                }
                case EQUALITY: {
                    return 1;
                }
                case INEQUALITY: {
                    return Objects.requireNonNull(range.getInequalityComparisons()).size();
                }
            }
            throw new RecordCoreException("unsupported range type", new Object[0]);
        }).sum();
    }

    @Nonnull
    public List<ComparisonRange> getRanges() {
        return this.ranges;
    }

    @Nonnull
    public List<ComparisonRange> subRanges(int startInclusive, int endExclusive) {
        return this.ranges.subList(startInclusive, endExclusive);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        return this.ranges.stream().flatMap(range -> range.getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public ComparisonRanges rebase(@Nonnull AliasMap aliasMap) {
        return this.translateCorrelations(TranslationMap.rebaseWithAliasMap(aliasMap), false);
    }

    @Nonnull
    public ComparisonRanges translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        ImmutableList.Builder rebasedRangesBuilder = ImmutableList.builder();
        boolean isSame = true;
        for (ComparisonRange range : this.ranges) {
            ComparisonRange rebasedRange = range.translateCorrelations(translationMap, shouldSimplifyValues);
            if (rebasedRange != range) {
                isSame = false;
            }
            rebasedRangesBuilder.add(rebasedRange);
        }
        if (isSame) {
            return this;
        }
        return new ComparisonRanges((List<ComparisonRange>)((Object)rebasedRangesBuilder.build()));
    }

    @Override
    public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ComparisonRanges otherComparisonRanges = (ComparisonRanges)other;
        if (this.size() != otherComparisonRanges.size()) {
            return false;
        }
        for (int i = 0; i < this.ranges.size(); ++i) {
            ComparisonRange otherRange;
            ComparisonRange range = this.ranges.get(i);
            if (range.semanticEquals(otherRange = otherComparisonRanges.ranges.get(i), aliasMap)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int semanticHashCode() {
        int hashCode = 0;
        for (ComparisonRange range : this.ranges) {
            hashCode = 31 * hashCode + range.semanticHashCode();
        }
        return hashCode;
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object o) {
        return this.semanticEquals(o, AliasMap.emptyMap());
    }

    public int hashCode() {
        return this.ranges.hashCode();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectPlanHash(mode, this.ranges);
    }

    public String toString() {
        return "{" + this.ranges.stream().map(ComparisonRange::toString).collect(Collectors.joining("; ")) + "}";
    }

    @Nonnull
    public static ComparisonRanges from(@Nullable ScanComparisons scanComparisons) {
        if (scanComparisons == null) {
            return new ComparisonRanges();
        }
        ImmutableList.Builder rangesBuilder = ImmutableList.builder();
        for (Comparisons.Comparison comparison : scanComparisons.getEqualityComparisons()) {
            rangesBuilder.add(ComparisonRange.from(comparison));
        }
        if (!scanComparisons.isEquality()) {
            rangesBuilder.add(ComparisonRange.fromInequalities(scanComparisons.getInequalityComparisons()));
        }
        return new ComparisonRanges((List<ComparisonRange>)((Object)rangesBuilder.build()));
    }

    @Nullable
    public static ComparisonRanges tryFrom(@Nullable Comparisons.Comparison comparison) {
        if (comparison == null) {
            return null;
        }
        ComparisonRange comparisonRange = ComparisonRange.tryFrom(comparison);
        if (comparisonRange == null) {
            return null;
        }
        return new ComparisonRanges(Lists.newArrayList(comparisonRange));
    }
}

