/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.GroupByMappings;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.MaxMatchMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Compensation {
    public static final Compensation NO_COMPENSATION = new Compensation(){

        @Override
        public boolean isNeeded() {
            return false;
        }

        @Override
        public boolean isFinalNeeded() {
            return false;
        }

        @Override
        public boolean isNeededForFiltering() {
            return false;
        }

        @Override
        @Nonnull
        public Compensation intersect(@Nonnull Compensation otherCompensation) {
            return this;
        }

        @Override
        @Nonnull
        public RelationalExpression apply(@Nonnull Memoizer memoizer, @Nonnull RelationalExpression relationalExpression, @Nonnull Function<CorrelationIdentifier, TranslationMap> matchedToRealizedTranslationMapFunction) {
            throw new RecordCoreException("this method should not be called", new Object[0]);
        }

        @Override
        @Nonnull
        public RelationalExpression applyFinal(@Nonnull Memoizer memoizer, @Nonnull RelationalExpression relationalExpression, @Nonnull Function<CorrelationIdentifier, TranslationMap> matchedToRealizedTranslationMapFunction) {
            throw new RecordCoreException("this method should not be called", new Object[0]);
        }

        public String toString() {
            return "no-compensation";
        }
    };
    public static final Compensation IMPOSSIBLE_COMPENSATION = new Compensation(){

        @Override
        public boolean isImpossible() {
            return true;
        }

        @Override
        @Nonnull
        public Compensation intersect(@Nonnull Compensation otherCompensation) {
            return otherCompensation;
        }

        @Override
        @Nonnull
        public RelationalExpression apply(@Nonnull Memoizer memoizer, @Nonnull RelationalExpression relationalExpression, @Nonnull Function<CorrelationIdentifier, TranslationMap> matchedToRealizedTranslationMapFunction) {
            throw new RecordCoreException("this method should not be called", new Object[0]);
        }

        @Override
        @Nonnull
        public RelationalExpression applyFinal(@Nonnull Memoizer memoizer, @Nonnull RelationalExpression relationalExpression, @Nonnull Function<CorrelationIdentifier, TranslationMap> matchedToRealizedTranslationMapFunction) {
            throw new RecordCoreException("this method should not be called", new Object[0]);
        }
    };

    @Nonnull
    default public RelationalExpression applyAllNeededCompensations(@Nonnull Memoizer memoizer, @Nonnull RelationalExpression relationalExpression, @Nonnull Function<CorrelationIdentifier, TranslationMap> matchedToRealizedTranslationMapFunction) {
        if (this.isNeededForFiltering()) {
            relationalExpression = this.apply(memoizer, relationalExpression, matchedToRealizedTranslationMapFunction);
        }
        if (this.isFinalNeeded()) {
            relationalExpression = this.applyFinal(memoizer, relationalExpression, matchedToRealizedTranslationMapFunction);
        }
        return relationalExpression;
    }

    @Nonnull
    public RelationalExpression apply(@Nonnull Memoizer var1, @Nonnull RelationalExpression var2, @Nonnull Function<CorrelationIdentifier, TranslationMap> var3);

    @Nonnull
    public RelationalExpression applyFinal(@Nonnull Memoizer var1, @Nonnull RelationalExpression var2, @Nonnull Function<CorrelationIdentifier, TranslationMap> var3);

    default public boolean isNeeded() {
        return true;
    }

    default public boolean isNeededForFiltering() {
        return true;
    }

    default public boolean isFinalNeeded() {
        return true;
    }

    default public boolean isImpossible() {
        return false;
    }

    default public boolean canBeDeferred() {
        return true;
    }

    @Nonnull
    default public Compensation union(final @Nonnull Compensation otherCompensation) {
        if (!this.isNeeded() && !otherCompensation.isNeeded()) {
            return Compensation.noCompensation();
        }
        if (!this.isNeeded()) {
            return otherCompensation;
        }
        if (!otherCompensation.isNeeded()) {
            return this;
        }
        return new Compensation(){

            @Override
            @Nonnull
            public RelationalExpression apply(@Nonnull Memoizer memoizer, @Nonnull RelationalExpression relationalExpression, @Nonnull Function<CorrelationIdentifier, TranslationMap> matchedToRealizedTranslationMapFunction) {
                return Compensation.this.apply(memoizer, otherCompensation.apply(memoizer, relationalExpression, matchedToRealizedTranslationMapFunction), matchedToRealizedTranslationMapFunction);
            }

            @Override
            @Nonnull
            public RelationalExpression applyFinal(@Nonnull Memoizer memoizer, @Nonnull RelationalExpression relationalExpression, @Nonnull Function<CorrelationIdentifier, TranslationMap> matchedToRealizedTranslationMapFunction) {
                return Compensation.this.applyFinal(memoizer, otherCompensation.applyFinal(memoizer, relationalExpression, matchedToRealizedTranslationMapFunction), matchedToRealizedTranslationMapFunction);
            }
        };
    }

    @Nonnull
    default public Compensation intersect(final @Nonnull Compensation otherCompensation) {
        if (!this.isNeeded() || !otherCompensation.isNeeded()) {
            return Compensation.noCompensation();
        }
        return new Compensation(){

            @Override
            @Nonnull
            public RelationalExpression apply(@Nonnull Memoizer memoizer, @Nonnull RelationalExpression relationalExpression, @Nonnull Function<CorrelationIdentifier, TranslationMap> matchedToRealizedTranslationMapFunction) {
                return Compensation.this.apply(memoizer, otherCompensation.apply(memoizer, relationalExpression, matchedToRealizedTranslationMapFunction), matchedToRealizedTranslationMapFunction);
            }

            @Override
            @Nonnull
            public RelationalExpression applyFinal(@Nonnull Memoizer memoizer, @Nonnull RelationalExpression relationalExpression, @Nonnull Function<CorrelationIdentifier, TranslationMap> matchedToRealizedTranslationMapFunction) {
                return Compensation.this.applyFinal(memoizer, otherCompensation.applyFinal(memoizer, relationalExpression, matchedToRealizedTranslationMapFunction), matchedToRealizedTranslationMapFunction);
            }
        };
    }

    @Nonnull
    public static Compensation noCompensation() {
        return NO_COMPENSATION;
    }

    @Nonnull
    public static Compensation impossibleCompensation() {
        return IMPOSSIBLE_COMPENSATION;
    }

    @Nonnull
    default public ForMatch derived(boolean isImpossible, @Nonnull LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction> predicateCompensationMap, @Nonnull Collection<? extends Quantifier> matchedQuantifiers, @Nonnull Set<? extends Quantifier> unmatchedQuantifiers, @Nonnull Set<CorrelationIdentifier> compensatedAliases, @Nonnull PredicateMultiMap.ResultCompensationFunction resultCompensationFunction, @Nonnull GroupByMappings groupByMappings) {
        Verify.verify(isImpossible || !unmatchedQuantifiers.isEmpty() || !predicateCompensationMap.isEmpty() || resultCompensationFunction.isNeeded() || this.isNeededForFiltering());
        return new ForMatch(isImpossible, this, predicateCompensationMap, matchedQuantifiers, unmatchedQuantifiers, compensatedAliases, resultCompensationFunction, groupByMappings);
    }

    @Nonnull
    public static Optional<CompensatedResult> computeResultCompensation(@Nonnull PartialMatch partialMatch, @Nullable PullUp rootOfMatchPullUp) {
        GroupByMappings groupByMappings;
        PredicateMultiMap.ResultCompensationFunction resultCompensationFunction;
        MatchInfo matchInfo = partialMatch.getMatchInfo();
        boolean isCompensationImpossible = false;
        if (rootOfMatchPullUp == null) {
            resultCompensationFunction = PredicateMultiMap.ResultCompensationFunction.noCompensationNeeded();
            groupByMappings = GroupByMappings.empty();
        } else {
            MaxMatchMap maxMatchMap = matchInfo.getMaxMatchMap();
            Optional<Value> pulledUpTranslatedResultValueOptional = rootOfMatchPullUp.pullUpValueMaybe(maxMatchMap.getQueryValue());
            if (pulledUpTranslatedResultValueOptional.isEmpty()) {
                return Optional.empty();
            }
            Value pulledUpTranslatedResultValue = pulledUpTranslatedResultValueOptional.get();
            resultCompensationFunction = QuantifiedObjectValue.isSimpleQuantifiedObjectValueOver(pulledUpTranslatedResultValue, rootOfMatchPullUp.getCandidateAlias()) ? PredicateMultiMap.ResultCompensationFunction.noCompensationNeeded() : PredicateMultiMap.ResultCompensationFunction.ofValue(pulledUpTranslatedResultValue);
            isCompensationImpossible = resultCompensationFunction.isImpossible();
            groupByMappings = MatchInfo.RegularMatchInfo.pullUpAggregateCandidateMappings(partialMatch, rootOfMatchPullUp);
        }
        return Optional.of(new CompensatedResult(isCompensationImpossible, resultCompensationFunction, groupByMappings));
    }

    public static class ForMatch
    implements WithSelectCompensation {
        final boolean isImpossible;
        @Nonnull
        private final Compensation childCompensation;
        @Nonnull
        final Map<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction> predicateCompensationMap;
        @Nonnull
        private final Set<Quantifier> matchedQuantifiers;
        @Nonnull
        private final Set<Quantifier> unmatchedQuantifiers;
        @Nonnull
        private final Set<CorrelationIdentifier> compensatedAliases;
        @Nonnull
        private final PredicateMultiMap.ResultCompensationFunction resultCompensationFunction;
        @Nonnull
        private final GroupByMappings groupByMappings;
        @Nonnull
        private final Supplier<Set<Quantifier>> unmatchedForEachQuantifiersSupplier;

        private ForMatch(boolean isImpossible, @Nonnull Compensation childCompensation, @Nonnull Map<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction> predicateCompensationMap, @Nonnull Collection<? extends Quantifier> matchedQuantifiers, @Nonnull Collection<? extends Quantifier> unmatchedQuantifiers, @Nonnull Set<CorrelationIdentifier> compensatedAliases, @Nonnull PredicateMultiMap.ResultCompensationFunction resultCompensationFunction, @Nonnull GroupByMappings groupByMappings) {
            this.isImpossible = isImpossible;
            this.childCompensation = childCompensation;
            this.predicateCompensationMap = new LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction>();
            this.predicateCompensationMap.putAll(predicateCompensationMap);
            this.matchedQuantifiers = new LinkedIdentitySet<Quantifier>();
            this.matchedQuantifiers.addAll(matchedQuantifiers);
            this.unmatchedQuantifiers = new LinkedIdentitySet<Quantifier>();
            this.unmatchedQuantifiers.addAll(unmatchedQuantifiers);
            this.compensatedAliases = ImmutableSet.copyOf(compensatedAliases);
            this.resultCompensationFunction = resultCompensationFunction;
            this.groupByMappings = groupByMappings;
            this.unmatchedForEachQuantifiersSupplier = Suppliers.memoize(this::computeUnmatchedForEachQuantifiers);
        }

        @Override
        public boolean isImpossible() {
            return this.isImpossible;
        }

        @Override
        @Nonnull
        public Compensation getChildCompensation() {
            return this.childCompensation;
        }

        @Override
        @Nonnull
        public Set<Quantifier> getMatchedQuantifiers() {
            return this.matchedQuantifiers;
        }

        @Override
        @Nonnull
        public Set<Quantifier> getUnmatchedQuantifiers() {
            return this.unmatchedQuantifiers;
        }

        @Override
        @Nonnull
        public Set<CorrelationIdentifier> getCompensatedAliases() {
            return this.compensatedAliases;
        }

        @Override
        @Nonnull
        public Set<Quantifier> getUnmatchedForEachQuantifiers() {
            return this.unmatchedForEachQuantifiersSupplier.get();
        }

        @Nonnull
        public Set<Quantifier> computeUnmatchedForEachQuantifiers() {
            return this.unmatchedQuantifiers.stream().filter(quantifier -> quantifier instanceof Quantifier.ForEach).collect(LinkedIdentitySet.toLinkedIdentitySet());
        }

        @Override
        @Nonnull
        public Map<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction> getPredicateCompensationMap() {
            return this.predicateCompensationMap;
        }

        @Override
        @Nonnull
        public PredicateMultiMap.ResultCompensationFunction getResultCompensationFunction() {
            return this.resultCompensationFunction;
        }

        @Override
        @Nonnull
        public GroupByMappings getGroupByMappings() {
            return this.groupByMappings;
        }

        @Override
        @Nonnull
        public RelationalExpression apply(@Nonnull Memoizer memoizer, @Nonnull RelationalExpression relationalExpression, @Nonnull Function<CorrelationIdentifier, TranslationMap> matchedToRealizedTranslationMapFunction) {
            Verify.verify(!this.isImpossible());
            if (this.childCompensation.isNeededForFiltering()) {
                relationalExpression = this.childCompensation.apply(memoizer, relationalExpression, matchedToRealizedTranslationMapFunction);
            }
            CorrelationIdentifier matchedForEachAlias = this.getMatchedForEachAlias();
            TranslationMap matchedToRealizedTranslationMap = matchedToRealizedTranslationMapFunction.apply(matchedForEachAlias);
            LinkedIdentitySet compensatedPredicates = new LinkedIdentitySet();
            Collection<PredicateMultiMap.PredicateCompensationFunction> injectCompensationFunctions = this.predicateCompensationMap.values();
            for (PredicateMultiMap.PredicateCompensationFunction predicateCompensationFunction : injectCompensationFunctions) {
                compensatedPredicates.addAll(predicateCompensationFunction.applyCompensationForPredicate(matchedToRealizedTranslationMap));
            }
            ImmutableSet compensatedPredicatesCorrelatedTo = compensatedPredicates.stream().flatMap(predicate -> predicate.getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet());
            ImmutableSet.Builder toBePulledUpQuantifiersBuilder = ImmutableSet.builder();
            for (Quantifier matchedQuantifier : this.matchedQuantifiers) {
                if (!(matchedQuantifier instanceof Quantifier.Existential) || !compensatedPredicatesCorrelatedTo.contains(matchedQuantifier.getAlias())) continue;
                toBePulledUpQuantifiersBuilder.add(matchedQuantifier);
            }
            for (Quantifier unmatchedQuantifier : this.unmatchedQuantifiers) {
                if (unmatchedQuantifier instanceof Quantifier.ForEach) {
                    toBePulledUpQuantifiersBuilder.add(unmatchedQuantifier);
                    continue;
                }
                Verify.verify(unmatchedQuantifier instanceof Quantifier.Existential);
                if (!compensatedPredicatesCorrelatedTo.contains(unmatchedQuantifier.getAlias())) continue;
                toBePulledUpQuantifiersBuilder.add(unmatchedQuantifier);
            }
            ImmutableCollection toBePulledUpQuantifiers = toBePulledUpQuantifiersBuilder.build();
            if (compensatedPredicates.isEmpty() && toBePulledUpQuantifiers.isEmpty()) {
                return relationalExpression;
            }
            Quantifier.ForEach newBaseQuantifier = Quantifier.forEach(memoizer.memoizeUnknownExpression(relationalExpression), matchedForEachAlias);
            if (toBePulledUpQuantifiers.isEmpty()) {
                return new LogicalFilterExpression(compensatedPredicates, newBaseQuantifier);
            }
            GraphExpansion.Builder completeExpansionBuilder = GraphExpansion.builder();
            completeExpansionBuilder.addAllQuantifiers(toBePulledUpQuantifiersBuilder.build());
            completeExpansionBuilder.addQuantifier(newBaseQuantifier);
            completeExpansionBuilder.addAllPredicates(compensatedPredicates);
            return completeExpansionBuilder.build().buildSimpleSelectOverQuantifier(newBaseQuantifier);
        }

        @Nonnull
        private CorrelationIdentifier getMatchedForEachAlias() {
            Map<CorrelationIdentifier, Quantifier> matchedQuantifierMap = Quantifiers.aliasToQuantifierMap(this.matchedQuantifiers);
            Set<CorrelationIdentifier> matchedAliases = matchedQuantifierMap.keySet();
            Verify.verify(this.compensatedAliases.equals(matchedAliases));
            ImmutableSet matchedForEachQuantifierAliases = matchedAliases.stream().filter(alias -> matchedQuantifierMap.get(alias) instanceof Quantifier.ForEach).collect(ImmutableSet.toImmutableSet());
            return (CorrelationIdentifier)Iterables.getOnlyElement(matchedForEachQuantifierAliases);
        }

        @Override
        @Nonnull
        public RelationalExpression applyFinal(@Nonnull Memoizer memoizer, @Nonnull RelationalExpression relationalExpression, @Nonnull Function<CorrelationIdentifier, TranslationMap> matchedToRealizedTranslationMapFunction) {
            Verify.verify(!this.isImpossible());
            Verify.verify(this.resultCompensationFunction.isNeeded());
            CorrelationIdentifier matchedForEachAlias = this.getMatchedForEachAlias();
            Value resultValue = this.resultCompensationFunction.applyCompensationForResult(matchedToRealizedTranslationMapFunction.apply(matchedForEachAlias));
            Quantifier.ForEach newBaseQuantifier = Quantifier.forEach(memoizer.memoizeUnknownExpression(relationalExpression), matchedForEachAlias);
            return GraphExpansion.builder().addQuantifier(newBaseQuantifier).build().buildSelectWithResultValue(resultValue);
        }

        @Nonnull
        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.isNeeded()) {
                result.append("needed; ");
            } else {
                result.append("not needed; ");
            }
            if (this.isImpossible()) {
                result.append("impossible");
            } else {
                result.append("possible");
            }
            return result.toString();
        }
    }

    public static class CompensatedResult {
        private final boolean isCompensationImpossible;
        @Nonnull
        private final PredicateMultiMap.ResultCompensationFunction resultCompensationFunction;
        @Nonnull
        private final GroupByMappings groupByMappings;

        public CompensatedResult(boolean isCompensationImpossible, @Nonnull PredicateMultiMap.ResultCompensationFunction resultCompensationFunction, @Nonnull GroupByMappings groupByMappings) {
            this.isCompensationImpossible = isCompensationImpossible;
            this.resultCompensationFunction = resultCompensationFunction;
            this.groupByMappings = groupByMappings;
        }

        public boolean isCompensationImpossible() {
            return this.isCompensationImpossible;
        }

        @Nonnull
        public PredicateMultiMap.ResultCompensationFunction getResultCompensationFunction() {
            return this.resultCompensationFunction;
        }

        @Nonnull
        public GroupByMappings getGroupByMappings() {
            return this.groupByMappings;
        }
    }

    public static interface WithSelectCompensation
    extends Compensation {
        @Override
        default public boolean isNeeded() {
            return this.getChildCompensation().isNeeded() || !this.getUnmatchedForEachQuantifiers().isEmpty() || !this.getPredicateCompensationMap().isEmpty() || this.getResultCompensationFunction().isNeeded();
        }

        @Override
        default public boolean isNeededForFiltering() {
            return this.getChildCompensation().isNeededForFiltering() || !this.getUnmatchedForEachQuantifiers().isEmpty() || !this.getPredicateCompensationMap().isEmpty();
        }

        @Override
        default public boolean isFinalNeeded() {
            return this.getResultCompensationFunction().isNeeded();
        }

        @Nonnull
        public Compensation getChildCompensation();

        @Nonnull
        public Set<Quantifier> getMatchedQuantifiers();

        @Nonnull
        public Set<Quantifier> getUnmatchedQuantifiers();

        @Nonnull
        public Set<CorrelationIdentifier> getCompensatedAliases();

        @Nonnull
        public Set<Quantifier> getUnmatchedForEachQuantifiers();

        @Nonnull
        public Map<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction> getPredicateCompensationMap();

        @Nonnull
        public PredicateMultiMap.ResultCompensationFunction getResultCompensationFunction();

        @Nonnull
        public GroupByMappings getGroupByMappings();

        @Override
        @Nonnull
        default public Compensation union(@Nonnull Compensation otherCompensation) {
            PredicateMultiMap.ResultCompensationFunction newResultResultCompensationFunction;
            if (!(otherCompensation instanceof WithSelectCompensation)) {
                return otherCompensation.union(this);
            }
            WithSelectCompensation otherWithSelectCompensation = (WithSelectCompensation)otherCompensation;
            Sets.SetView<Quantifier> unionedMatchedQuantifiers = Sets.union(this.getMatchedQuantifiers(), otherWithSelectCompensation.getMatchedQuantifiers());
            int numberForEachInUnion = unionedMatchedQuantifiers.stream().filter(quantifier -> quantifier instanceof Quantifier.ForEach).collect(ImmutableList.toImmutableList()).size();
            if (numberForEachInUnion > 1) {
                return Compensation.impossibleCompensation();
            }
            if (!this.getUnmatchedForEachQuantifiers().isEmpty() || !otherWithSelectCompensation.getUnmatchedForEachQuantifiers().isEmpty()) {
                return Compensation.impossibleCompensation();
            }
            Compensation unionedChildCompensation = this.getChildCompensation().union(otherWithSelectCompensation.getChildCompensation());
            if (unionedChildCompensation.isImpossible() || !unionedChildCompensation.canBeDeferred()) {
                return Compensation.impossibleCompensation();
            }
            PredicateMultiMap.ResultCompensationFunction resultCompensationFunction = this.getResultCompensationFunction();
            PredicateMultiMap.ResultCompensationFunction otherResultCompensationFunction = otherWithSelectCompensation.getResultCompensationFunction();
            if (!resultCompensationFunction.isNeeded() && !otherResultCompensationFunction.isNeeded()) {
                newResultResultCompensationFunction = PredicateMultiMap.ResultCompensationFunction.noCompensationNeeded();
            } else {
                Verify.verify(resultCompensationFunction.isNeeded());
                Verify.verify(otherResultCompensationFunction.isNeeded());
                newResultResultCompensationFunction = resultCompensationFunction;
            }
            Map<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction> otherCompensationMap = otherWithSelectCompensation.getPredicateCompensationMap();
            LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction> combinedPredicateMap = new LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction>();
            combinedPredicateMap.putAll(this.getPredicateCompensationMap());
            for (Map.Entry<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction> otherEntry : otherCompensationMap.entrySet()) {
                if (combinedPredicateMap.containsKey(otherEntry.getKey())) {
                    throw new RecordCoreException("predicate is mapped more than once", new Object[0]);
                }
                combinedPredicateMap.put(otherEntry.getKey(), otherEntry.getValue());
            }
            if (!unionedChildCompensation.isNeededForFiltering() && !newResultResultCompensationFunction.isNeeded() && combinedPredicateMap.isEmpty()) {
                return Compensation.noCompensation();
            }
            if (!newResultResultCompensationFunction.isNeeded() && combinedPredicateMap.isEmpty()) {
                return unionedChildCompensation;
            }
            return unionedChildCompensation.derived(false, combinedPredicateMap, unionedMatchedQuantifiers, ImmutableSet.of(), Sets.union(this.getCompensatedAliases(), otherWithSelectCompensation.getCompensatedAliases()), newResultResultCompensationFunction, GroupByMappings.empty());
        }

        @Override
        @Nonnull
        default public Compensation intersect(@Nonnull Compensation otherCompensation) {
            PredicateMultiMap.ResultCompensationFunction newResultResultCompensationFunction;
            if (!(otherCompensation instanceof WithSelectCompensation)) {
                return otherCompensation.intersect(this);
            }
            WithSelectCompensation otherWithSelectCompensation = (WithSelectCompensation)otherCompensation;
            Compensation childCompensation = this.getChildCompensation();
            Verify.verify(!(childCompensation instanceof WithSelectCompensation) || ((WithSelectCompensation)childCompensation).getUnmatchedForEachQuantifiers().isEmpty());
            Compensation intersectedChildCompensation = childCompensation.intersect(otherWithSelectCompensation.getChildCompensation());
            if (intersectedChildCompensation.isImpossible() || !intersectedChildCompensation.canBeDeferred()) {
                return Compensation.impossibleCompensation();
            }
            ImmutableBiMap.Builder newMatchedGroupingsMapBuilder = ImmutableBiMap.builder();
            BiMap<Value, Value> matchedGroupingsMap = this.getGroupByMappings().getMatchedGroupingsMap();
            newMatchedGroupingsMapBuilder.putAll(matchedGroupingsMap);
            for (Map.Entry entry : otherWithSelectCompensation.getGroupByMappings().getMatchedGroupingsMap().entrySet()) {
                if (matchedGroupingsMap.containsKey(entry.getKey())) continue;
                newMatchedGroupingsMapBuilder.put(entry);
            }
            ImmutableBiMap.Builder newMatchedAggregatesMapBuilder = ImmutableBiMap.builder();
            BiMap<Value, Value> matchedAggregatesMap = this.getGroupByMappings().getMatchedAggregatesMap();
            newMatchedAggregatesMapBuilder.putAll(matchedAggregatesMap);
            for (Map.Entry entry : otherWithSelectCompensation.getGroupByMappings().getMatchedAggregatesMap().entrySet()) {
                if (matchedAggregatesMap.containsKey(entry.getKey())) continue;
                newMatchedAggregatesMapBuilder.put(entry);
            }
            ImmutableMap newMatchedAggregatesMap = newMatchedAggregatesMapBuilder.build();
            ImmutableBiMap.Builder newUnmatchedAggregatesMapBuilder = ImmutableBiMap.builder();
            BiMap<CorrelationIdentifier, Value> unmatchedAggregateMap = this.getGroupByMappings().getUnmatchedAggregatesMap();
            for (Map.Entry entry : unmatchedAggregateMap.entrySet()) {
                if (newMatchedAggregatesMap.containsKey(entry.getValue())) continue;
                newUnmatchedAggregatesMapBuilder.put(entry);
            }
            for (Map.Entry entry : otherWithSelectCompensation.getGroupByMappings().getUnmatchedAggregatesMap().entrySet()) {
                if (newMatchedAggregatesMap.containsKey(entry.getValue()) || unmatchedAggregateMap.inverse().containsKey(entry.getValue())) continue;
                newUnmatchedAggregatesMapBuilder.put(entry);
            }
            GroupByMappings newGroupByMappings = GroupByMappings.of((BiMap<Value, Value>)((Object)newMatchedGroupingsMapBuilder.build()), (BiMap<Value, Value>)((Object)newMatchedAggregatesMap), (BiMap<CorrelationIdentifier, Value>)((Object)newUnmatchedAggregatesMapBuilder.build()));
            boolean isImpossible = false;
            PredicateMultiMap.ResultCompensationFunction resultCompensationFunction = this.getResultCompensationFunction();
            PredicateMultiMap.ResultCompensationFunction otherResultCompensationFunction = otherWithSelectCompensation.getResultCompensationFunction();
            if (!resultCompensationFunction.isNeeded() && !otherResultCompensationFunction.isNeeded()) {
                newResultResultCompensationFunction = PredicateMultiMap.ResultCompensationFunction.noCompensationNeeded();
            } else {
                Verify.verify(resultCompensationFunction.isNeeded());
                Verify.verify(otherResultCompensationFunction.isNeeded());
                newResultResultCompensationFunction = resultCompensationFunction.amend(unmatchedAggregateMap, newMatchedAggregatesMap);
                isImpossible |= newResultResultCompensationFunction.isImpossible();
            }
            Map<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction> otherCompensationMap = otherWithSelectCompensation.getPredicateCompensationMap();
            LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction> combinedPredicateMap = new LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction>();
            for (Map.Entry<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction> entry : this.getPredicateCompensationMap().entrySet()) {
                PredicateMultiMap.PredicateCompensationFunction otherPredicateCompensationFunction = otherCompensationMap.get(entry.getKey());
                if (otherPredicateCompensationFunction == null) continue;
                PredicateMultiMap.PredicateCompensationFunction newPredicateCompensationFunction = entry.getValue().amend(unmatchedAggregateMap, newMatchedAggregatesMap);
                combinedPredicateMap.put(entry.getKey(), newPredicateCompensationFunction);
                isImpossible |= newPredicateCompensationFunction.isImpossible();
            }
            if (!intersectedChildCompensation.isNeededForFiltering() && !newResultResultCompensationFunction.isNeeded() && combinedPredicateMap.isEmpty()) {
                return Compensation.noCompensation();
            }
            if (!newResultResultCompensationFunction.isNeeded() && combinedPredicateMap.isEmpty()) {
                return intersectedChildCompensation;
            }
            Sets.SetView<Quantifier> intersectedMatchedQuantifiers = Sets.union(this.getMatchedQuantifiers(), otherWithSelectCompensation.getMatchedQuantifiers());
            Sets.SetView<Quantifier> intersectedUnmatchedQuantifiers = Sets.intersection(this.getUnmatchedQuantifiers(), otherWithSelectCompensation.getUnmatchedQuantifiers());
            Sets.SetView<Quantifier> unmatchedQuantifiers = Sets.intersection(this.getUnmatchedQuantifiers(), otherWithSelectCompensation.getUnmatchedQuantifiers());
            ImmutableList unmatchedQuantifierAliases = unmatchedQuantifiers.stream().map(Quantifier::getAlias).collect(ImmutableList.toImmutableList());
            if (!isImpossible) {
                isImpossible = combinedPredicateMap.keySet().stream().flatMap(queryPredicate -> queryPredicate.getCorrelatedTo().stream()).anyMatch(unmatchedQuantifierAliases::contains);
            }
            return intersectedChildCompensation.derived(isImpossible, combinedPredicateMap, intersectedMatchedQuantifiers, intersectedUnmatchedQuantifiers, this.getCompensatedAliases(), newResultResultCompensationFunction, newGroupByMappings);
        }
    }
}

