/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.DefaultConstrained;
import com.google.common.base.Verify;
import javax.annotation.Nonnull;

public interface Constrained<T> {
    @Nonnull
    public T get();

    @Nonnull
    default public T getUnconstrained() {
        Verify.verify(!this.getConstraint().isConstrained());
        return this.get();
    }

    @Nonnull
    public QueryPlanConstraint getConstraint();

    @Nonnull
    public Constrained<T> composeWithConstraint(@Nonnull QueryPlanConstraint var1);

    @Nonnull
    public static <T> Constrained<T> unconstrained(@Nonnull T object) {
        return DefaultConstrained.of(object);
    }

    @Nonnull
    public static <T> Constrained<T> ofConstrainedObject(@Nonnull T object, @Nonnull QueryPlanConstraint queryPlanConstraint) {
        return DefaultConstrained.ofConstrainedObject(object, queryPlanConstraint);
    }
}

