/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.Constrained;
import com.google.common.base.Verify;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ConstrainedBoolean
implements Constrained<Boolean> {
    private static final ConstrainedBoolean FALSE = new ConstrainedBoolean(false, QueryPlanConstraint.noConstraint());
    private static final ConstrainedBoolean ALWAYS_TRUE = new ConstrainedBoolean(true, QueryPlanConstraint.noConstraint());
    private final boolean isTrue;
    @Nonnull
    private final QueryPlanConstraint queryPlanConstraint;

    private ConstrainedBoolean(boolean isTrue, @Nonnull QueryPlanConstraint queryPlanConstraint) {
        Verify.verify(isTrue || !queryPlanConstraint.isConstrained());
        this.isTrue = isTrue;
        this.queryPlanConstraint = queryPlanConstraint;
    }

    public boolean isTrue() {
        return this.isTrue;
    }

    public boolean isFalse() {
        return !this.isTrue();
    }

    @Override
    @Nonnull
    public Boolean get() {
        return this.isTrue();
    }

    @Override
    @Nonnull
    public QueryPlanConstraint getConstraint() {
        return this.queryPlanConstraint;
    }

    @Nonnull
    public ConstrainedBoolean composeWithOther(@Nonnull ConstrainedBoolean other) {
        if (other.isFalse()) {
            return ConstrainedBoolean.falseValue();
        }
        return this.composeWithConstraint(other.getConstraint());
    }

    @Nonnull
    public ConstrainedBoolean composeWithConstraint(@Nonnull QueryPlanConstraint constraint) {
        if (!this.isTrue()) {
            return ConstrainedBoolean.falseValue();
        }
        return ConstrainedBoolean.trueWithConstraint(Objects.requireNonNull(this.queryPlanConstraint).compose(constraint));
    }

    @Nonnull
    public ConstrainedBoolean filter(@Nonnull Predicate<? super QueryPlanConstraint> predicate) {
        if (this.isFalse() || !predicate.test(this.getConstraint())) {
            return ConstrainedBoolean.falseValue();
        }
        return this;
    }

    @Nonnull
    public <U> Optional<U> mapToOptional(@Nonnull Function<? super QueryPlanConstraint, ? extends U> mapper) {
        if (this.isFalse()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.getConstraint()));
    }

    @Nonnull
    public ConstrainedBoolean compose(@Nonnull Function<? super QueryPlanConstraint, ? extends ConstrainedBoolean> composeFunction) {
        if (this.isFalse()) {
            return ConstrainedBoolean.falseValue();
        }
        ConstrainedBoolean result = composeFunction.apply(this.getConstraint());
        if (result.isFalse()) {
            return ConstrainedBoolean.falseValue();
        }
        return this.composeWithOther(result);
    }

    @Nonnull
    public static ConstrainedBoolean falseValue() {
        return FALSE;
    }

    @Nonnull
    public static ConstrainedBoolean alwaysTrue() {
        return ALWAYS_TRUE;
    }

    @Nonnull
    public static ConstrainedBoolean ofBoolean(boolean isTrue) {
        return isTrue ? ConstrainedBoolean.alwaysTrue() : ConstrainedBoolean.falseValue();
    }

    @Nonnull
    public static ConstrainedBoolean trueWithConstraint(@Nonnull QueryPlanConstraint constraint) {
        return new ConstrainedBoolean(true, constraint);
    }
}

