/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.PlannerConstraint;
import com.google.common.base.Verify;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class ConstraintsMap {
    private long currentTick = 0L;
    private long watermarkGoalTick = -1L;
    private long watermarkCommittedTick = -1L;
    private final Map<PlannerConstraint<?>, ConstraintEntry> attributeToConstraintMap = Maps.newLinkedHashMap();

    public long getCurrentTick() {
        return this.currentTick;
    }

    public long getWatermarkGoalTick() {
        return this.watermarkGoalTick;
    }

    public long getWatermarkCommittedTick() {
        return this.watermarkCommittedTick;
    }

    public <T> boolean containsAttribute(@Nonnull PlannerConstraint<T> attribute) {
        return this.attributeToConstraintMap.containsKey(attribute);
    }

    @Nonnull
    public <T> Optional<T> getConstraintOptional(@Nonnull PlannerConstraint<T> attribute) {
        if (this.containsAttribute(attribute)) {
            return Optional.of(attribute.narrowConstraint(this.attributeToConstraintMap.get(attribute).property));
        }
        return Optional.empty();
    }

    @Nonnull
    public <T, X extends Throwable> T getPropertyOrThrow(@Nonnull PlannerConstraint<T> attribute, @Nonnull Supplier<? extends X> exceptionSupplier) throws X {
        if (this.containsAttribute(attribute)) {
            return attribute.narrowConstraint(this.attributeToConstraintMap.get(attribute).property);
        }
        throw (Throwable)exceptionSupplier.get();
    }

    @Nonnull
    public <T> T getPropertyOrElse(@Nonnull PlannerConstraint<T> attribute, @Nonnull T defaultConstraint) {
        if (this.containsAttribute(attribute)) {
            return attribute.narrowConstraint(this.attributeToConstraintMap.get(attribute).property);
        }
        return defaultConstraint;
    }

    public <T> Optional<T> pushProperty(@Nonnull PlannerConstraint<T> attribute, @Nonnull T constraint) {
        if (this.containsAttribute(attribute)) {
            ConstraintEntry constraintEntry = this.attributeToConstraintMap.get(attribute);
            return attribute.combine(attribute.narrowConstraint(constraintEntry.property), constraint).map(combinedProperty -> {
                this.bumpTick();
                constraintEntry.property = combinedProperty;
                constraintEntry.lastUpdatedTick = this.currentTick;
                return combinedProperty;
            });
        }
        this.bumpTick();
        this.attributeToConstraintMap.put(attribute, new ConstraintEntry(constraint));
        return Optional.of(constraint);
    }

    public boolean isExplored() {
        Verify.verify(this.watermarkGoalTick <= this.currentTick);
        return this.watermarkGoalTick == this.currentTick;
    }

    public boolean isExploring() {
        return this.watermarkGoalTick > this.watermarkCommittedTick;
    }

    public boolean hasNeverBeenExplored() {
        return this.watermarkCommittedTick < 0L;
    }

    public boolean isFullyExploring() {
        return this.hasNeverBeenExplored() && this.isExploring();
    }

    public boolean isExploredForAttributes(@Nonnull Set<PlannerConstraint<?>> attributes) {
        if (this.hasNeverBeenExplored()) {
            return false;
        }
        for (PlannerConstraint<?> interestingKey : attributes) {
            if (!this.containsAttribute(interestingKey)) continue;
            ConstraintEntry constraintEntry = this.attributeToConstraintMap.get(interestingKey);
            if (constraintEntry.lastUpdatedTick <= this.watermarkCommittedTick) continue;
            return false;
        }
        return true;
    }

    public void startExploration() {
        this.watermarkGoalTick = this.currentTick;
    }

    public void commitExploration() {
        this.watermarkCommittedTick = this.watermarkGoalTick;
    }

    public void setExplored() {
        this.watermarkGoalTick = this.currentTick;
        this.watermarkCommittedTick = this.currentTick;
    }

    public void advancePlannerStage() {
        Iterator<Map.Entry<PlannerConstraint<?>, ConstraintEntry>> iterator = this.attributeToConstraintMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PlannerConstraint<?>, ConstraintEntry> entry = iterator.next();
            ConstraintEntry constraintEntry = entry.getValue();
            if (constraintEntry.lastUpdatedTick >= this.watermarkCommittedTick) continue;
            iterator.remove();
        }
        this.watermarkGoalTick = -1L;
        this.watermarkCommittedTick = -1L;
    }

    @CanIgnoreReturnValue
    private long bumpTick() {
        return ++this.currentTick;
    }

    public void inheritFromOther(@Nonnull ConstraintsMap otherConstraintsMap) {
        this.currentTick = otherConstraintsMap.currentTick;
        this.watermarkGoalTick = otherConstraintsMap.watermarkGoalTick;
        this.watermarkCommittedTick = otherConstraintsMap.watermarkCommittedTick;
        this.attributeToConstraintMap.clear();
        this.attributeToConstraintMap.putAll(otherConstraintsMap.attributeToConstraintMap);
    }

    private class ConstraintEntry {
        private long lastUpdatedTick;
        @Nonnull
        private Object property;

        public ConstraintEntry(Object property) {
            this.lastUpdatedTick = ConstraintsMap.this.currentTick;
            this.property = property;
        }
    }
}

