/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.google.common.base.Equivalence;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public interface Correlated<S extends Correlated<S>> {
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo();

    default public boolean isCorrelatedTo(@Nonnull CorrelationIdentifier alias) {
        return this.getCorrelatedTo().contains(alias);
    }

    @Nonnull
    public S rebase(@Nonnull AliasMap var1);

    public boolean semanticEquals(@Nullable Object var1, @Nonnull AliasMap var2);

    public static <S extends Correlated<S>> boolean semanticEquals(@Nullable Correlated<S> one, @Nullable Correlated<S> other, @Nonnull AliasMap aliasMap) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null) {
            return false;
        }
        return one.semanticEquals(other, aliasMap);
    }

    public int semanticHashCode();

    public static class BoundEquivalence<S extends Correlated<S>>
    extends Equivalence<S> {
        @Nonnull
        private final AliasMap aliasMap;

        public BoundEquivalence(@Nonnull AliasMap aliasMap) {
            this.aliasMap = aliasMap;
        }

        @Override
        protected boolean doEquivalent(S a, @Nonnull S b) {
            return a.semanticEquals(b, this.aliasMap);
        }

        @Override
        protected int doHash(S correlated) {
            return correlated.semanticHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BoundEquivalence)) {
                return false;
            }
            BoundEquivalence that = (BoundEquivalence)o;
            return Objects.equals(this.aliasMap, that.aliasMap);
        }

        public int hashCode() {
            return Objects.hash(this.aliasMap);
        }

        public String toString() {
            return "\u224c[" + String.valueOf(this.aliasMap) + "]";
        }
    }
}

