/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.util.ProtoUtils;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class CorrelationIdentifier {
    @Nonnull
    private final String id;

    @Nonnull
    public static CorrelationIdentifier of(@Nonnull String id) {
        return new CorrelationIdentifier(id);
    }

    @Nonnull
    public static CorrelationIdentifier uniqueId() {
        return CorrelationIdentifier.uniqueId(CorrelationIdentifier.class);
    }

    @Nonnull
    public static CorrelationIdentifier uniqueId(@Nonnull Class<?> clazz) {
        return CorrelationIdentifier.uniqueId(clazz, clazz.getSimpleName().substring(0, 1).toLowerCase(Locale.ROOT));
    }

    @Nonnull
    public static CorrelationIdentifier uniqueId(@Nonnull Class<?> clazz, @Nonnull String prefix) {
        CorrelationIdentifier id = Debugger.getIndexOptional(clazz).map(i -> CorrelationIdentifier.of(prefix + i)).orElseGet(() -> new CorrelationIdentifier(ProtoUtils.uniqueName(prefix)));
        Debugger.updateIndex(clazz, i -> i + 1);
        return id;
    }

    @Nonnull
    public static CorrelationIdentifier uniqueSingletonID(@Nonnull UUID singleton, @Nonnull String prefix) {
        return Debugger.getOrRegisterSingleton(singleton).map(index -> new CorrelationIdentifier(prefix + index)).orElseGet(() -> new CorrelationIdentifier(singleton.toString()));
    }

    private CorrelationIdentifier(@Nonnull String id) {
        this.id = id;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorrelationIdentifier that = (CorrelationIdentifier)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id;
    }

    public static Map<CorrelationIdentifier, CorrelationIdentifier> identityMappingMap(final @Nonnull Set<CorrelationIdentifier> aliases) {
        return new Map<CorrelationIdentifier, CorrelationIdentifier>(){

            @Override
            public int size() {
                return aliases.size();
            }

            @Override
            public boolean isEmpty() {
                return aliases.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return aliases.contains(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return aliases.contains(value);
            }

            @Override
            @Nullable
            public CorrelationIdentifier get(Object key) {
                if (this.containsKey(key)) {
                    return (CorrelationIdentifier)key;
                }
                return null;
            }

            @Override
            public CorrelationIdentifier put(CorrelationIdentifier key, CorrelationIdentifier value) {
                throw new UnsupportedOperationException("mutation is not allowed");
            }

            @Override
            public CorrelationIdentifier remove(Object key) {
                throw new UnsupportedOperationException("mutation is not allowed");
            }

            @Override
            public void putAll(@Nonnull Map<? extends CorrelationIdentifier, ? extends CorrelationIdentifier> m4) {
                throw new UnsupportedOperationException("mutation is not allowed");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("mutation is not allowed");
            }

            @Override
            @Nonnull
            public Set<CorrelationIdentifier> keySet() {
                return aliases;
            }

            @Override
            @Nonnull
            public Collection<CorrelationIdentifier> values() {
                return aliases;
            }

            @Override
            @Nonnull
            public Set<Map.Entry<CorrelationIdentifier, CorrelationIdentifier>> entrySet() {
                return aliases.stream().map(element -> new AbstractMap.SimpleImmutableEntry<CorrelationIdentifier, CorrelationIdentifier>((CorrelationIdentifier)element, (CorrelationIdentifier)element)).collect(ImmutableSet.toImmutableSet());
            }
        };
    }
}

