/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.Constrained;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DefaultConstrained<T>
implements Constrained<T> {
    @Nonnull
    private final T object;
    @Nonnull
    private final QueryPlanConstraint queryPlanConstraint;

    private DefaultConstrained(@Nonnull T object, @Nonnull QueryPlanConstraint queryPlanConstraint) {
        this.object = object;
        this.queryPlanConstraint = queryPlanConstraint;
    }

    @Override
    @Nonnull
    public T get() {
        return this.object;
    }

    @Override
    @Nonnull
    public QueryPlanConstraint getConstraint() {
        return this.queryPlanConstraint;
    }

    @Override
    @Nonnull
    public DefaultConstrained<T> composeWithConstraint(@Nonnull QueryPlanConstraint constraint) {
        return new DefaultConstrained<T>(this.get(), Objects.requireNonNull(this.queryPlanConstraint).compose(constraint));
    }

    @Nonnull
    public static <T> Constrained<T> of(@Nonnull T object) {
        return new DefaultConstrained<T>(object, QueryPlanConstraint.noConstraint());
    }

    @Nonnull
    static <T> Constrained<T> ofConstrainedObject(@Nonnull T object, @Nonnull QueryPlanConstraint queryPlanConstraint) {
        return new DefaultConstrained<T>(object, queryPlanConstraint);
    }
}

