/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ExpressionPartition<E extends RelationalExpression> {
    @Nonnull
    private final Map<ExpressionProperty<?>, ?> partitionPropertiesMap;
    @Nonnull
    private final Map<E, Map<ExpressionProperty<?>, ?>> nonPartitioningPropertiesMap;

    public ExpressionPartition(@Nonnull Map<ExpressionProperty<?>, ?> partitionPropertiesMap, @Nonnull Map<E, Map<ExpressionProperty<?>, ?>> nonPartitioningPropertiesMap) {
        this.partitionPropertiesMap = partitionPropertiesMap;
        this.nonPartitioningPropertiesMap = nonPartitioningPropertiesMap;
    }

    @Nonnull
    public Map<ExpressionProperty<?>, ?> getPartitionPropertiesMap() {
        return this.partitionPropertiesMap;
    }

    @Nonnull
    public Map<E, Map<ExpressionProperty<?>, ?>> getNonPartitioningPropertiesMap() {
        return this.nonPartitioningPropertiesMap;
    }

    @Nonnull
    public <A> A getPartitionPropertyValue(@Nonnull ExpressionProperty<A> expressionProperty) {
        return expressionProperty.narrowAttribute(Objects.requireNonNull(this.partitionPropertiesMap.get(expressionProperty)));
    }

    @Nonnull
    public <A> A getNonPartitioningPropertyValue(@Nonnull E expression, @Nonnull ExpressionProperty<A> expressionProperty) {
        Map<ExpressionProperty<?>, ?> propertyMapForExpression = this.nonPartitioningPropertiesMap.get(expression);
        return expressionProperty.narrowAttribute(Objects.requireNonNull(propertyMapForExpression.get(expressionProperty)));
    }

    @Nonnull
    public Set<E> getExpressions() {
        return this.nonPartitioningPropertiesMap.keySet();
    }

    @Nonnull
    public ExpressionPartition<E> filter(@Nonnull Predicate<E> expressionPredicate) {
        return this.with(this.partitionPropertiesMap, this.filterGroupedPropertyMap(expressionPredicate));
    }

    @Nonnull
    protected Map<E, Map<ExpressionProperty<?>, ?>> filterGroupedPropertyMap(@Nonnull Predicate<E> expressionPredicate) {
        return Maps.filterKeys(this.nonPartitioningPropertiesMap, expressionPredicate::test);
    }

    @Nonnull
    protected ExpressionPartition<E> with(@Nonnull Map<ExpressionProperty<?>, ?> groupingPropertyMap, @Nonnull Map<E, Map<ExpressionProperty<?>, ?>> groupedPropertyMap) {
        return new ExpressionPartition<E>(groupingPropertyMap, groupedPropertyMap);
    }
}

