/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.ExpressionPartition;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionPropertiesMap;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ExpressionPartitions {
    private ExpressionPartitions() {
    }

    @Nonnull
    public static <E extends RelationalExpression> List<ExpressionPartition<E>> rollUpTo(@Nonnull Collection<ExpressionPartition<E>> expressionPartitions, @Nonnull ExpressionProperty<?> property) {
        return ExpressionPartitions.rollUpTo(expressionPartitions, ImmutableSet.of(property), ExpressionPartition::new);
    }

    @Nonnull
    protected static <E extends RelationalExpression, P extends ExpressionPartition<E>> List<P> rollUpTo(@Nonnull Collection<P> expressionPartitions, @Nonnull ExpressionProperty<?> property, @Nonnull PartitionCreator<E, P> partitionCreator) {
        return ExpressionPartitions.rollUpTo(expressionPartitions, ImmutableSet.of(property), partitionCreator);
    }

    @Nonnull
    public static <E extends RelationalExpression> List<ExpressionPartition<E>> rollUpTo(@Nonnull Collection<ExpressionPartition<E>> expressionPartitions, @Nonnull Set<ExpressionProperty<?>> rollupProperties) {
        return ExpressionPartitions.rollUpTo(expressionPartitions, rollupProperties, ExpressionPartition::new);
    }

    @Nonnull
    static <E extends RelationalExpression, P extends ExpressionPartition<E>> List<P> rollUpTo(@Nonnull Collection<P> partitions, @Nonnull Set<ExpressionProperty<?>> rollupProperties, @Nonnull PartitionCreator<E, P> partitionCreator) {
        LinkedHashMap<Map, Map> rolledUpMap = new LinkedHashMap<Map, Map>();
        for (ExpressionPartition partition : partitions) {
            Map<ExpressionProperty<?>, ?> groupingPropertyMap = partition.getPartitionPropertiesMap();
            Map filteredPropertiesMap = groupingPropertyMap.entrySet().stream().filter(attributeEntry -> rollupProperties.contains(attributeEntry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            rolledUpMap.compute(filteredPropertiesMap, (key, oldValue) -> {
                if (oldValue == null) {
                    return new LinkedIdentityMap(partition.getNonPartitioningPropertiesMap());
                }
                oldValue.putAll(partition.getNonPartitioningPropertiesMap());
                return oldValue;
            });
        }
        ImmutableList.Builder resultsBuilder = ImmutableList.builder();
        for (Map.Entry entry : rolledUpMap.entrySet()) {
            resultsBuilder.add(partitionCreator.create((Map)entry.getKey(), (Map)entry.getValue()));
        }
        return resultsBuilder.build();
    }

    @Nonnull
    protected static <E extends RelationalExpression> List<ExpressionPartition<E>> toPartitions(@Nonnull ExpressionPropertiesMap<E> propertiesMap) {
        return ExpressionPartitions.toPartitions(propertiesMap, ExpressionPartition::new);
    }

    @Nonnull
    protected static <E extends RelationalExpression, P extends ExpressionPartition<E>> List<P> toPartitions(@Nonnull ExpressionPropertiesMap<E> propertiesMap, @Nonnull PartitionCreator<E, P> partitionCreator) {
        return ExpressionPartitions.toPartitions(propertiesMap.getPartitioningPropertiesExpressionsMap(), propertiesMap.computeNonPartitioningPropertiesMap(), partitionCreator);
    }

    @Nonnull
    private static <E extends RelationalExpression, P extends ExpressionPartition<E>> List<P> toPartitions(@Nonnull Map<Map<ExpressionProperty<?>, ?>, ? extends Set<E>> partitioningPropertiesMap, @Nonnull Map<E, Map<ExpressionProperty<?>, ?>> nonPartitioningPropertiesMap, @Nonnull PartitionCreator<E, P> partitionCreator) {
        return partitioningPropertiesMap.entrySet().stream().map(entry -> {
            Map partitioningPropertyMap = (Map)entry.getKey();
            Set expressions = (Set)entry.getValue();
            LinkedIdentityMap nonPartitioningPropertyMap = new LinkedIdentityMap();
            for (RelationalExpression expression : expressions) {
                Map propertiesMapForExpression = (Map)nonPartitioningPropertiesMap.get(expression);
                nonPartitioningPropertyMap.put(expression, ImmutableMap.copyOf(propertiesMapForExpression));
            }
            return partitionCreator.create(ImmutableMap.copyOf(partitioningPropertyMap), nonPartitioningPropertyMap);
        }).collect(ImmutableList.toImmutableList());
    }

    @FunctionalInterface
    protected static interface PartitionCreator<E extends RelationalExpression, P extends ExpressionPartition<E>> {
        public P create(@Nonnull Map<ExpressionProperty<?>, ?> var1, @Nonnull Map<E, Map<ExpressionProperty<?>, ?>> var2);
    }
}

