/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.properties.ExpressionCountProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.PredicateComplexityProperty;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExpressionPropertiesMap<E extends RelationalExpression> {
    @Nonnull
    private final Class<E> expressionClass;
    private final Set<ExpressionProperty<?>> trackedPartitioningProperties;
    private final Set<ExpressionProperty<?>> trackedNonPartitioningProperties;
    @Nonnull
    private final Deque<E> toBeInsertedExpressions;
    @Nonnull
    private final Map<E, Map<ExpressionProperty<?>, ?>> propertiesMap;
    @Nonnull
    private final SetMultimap<Map<ExpressionProperty<?>, ?>, E> partitioningPropertiesExpressionsMap;

    public ExpressionPropertiesMap(@Nonnull Class<E> expressionClass, @Nonnull Set<ExpressionProperty<?>> trackedPartitioningProperties, @Nonnull Set<ExpressionProperty<?>> trackedNonPartitioningProperties, @Nonnull Collection<? extends RelationalExpression> expressions) {
        this.expressionClass = expressionClass;
        this.trackedPartitioningProperties = ImmutableSet.copyOf(trackedPartitioningProperties);
        this.trackedNonPartitioningProperties = ImmutableSet.copyOf(trackedNonPartitioningProperties);
        this.toBeInsertedExpressions = new ArrayDeque();
        this.propertiesMap = new LinkedIdentityMap();
        this.partitioningPropertiesExpressionsMap = Multimaps.newSetMultimap(Maps.newLinkedHashMap(), LinkedIdentitySet::new);
        expressions.forEach(this::add);
    }

    @Nonnull
    private E narrow(@Nonnull RelationalExpression expression) {
        Verify.verify(this.expressionClass.isInstance(expression), "unable to cast property value to its declared type", new Object[0]);
        return (E)((RelationalExpression)this.expressionClass.cast(expression));
    }

    protected void update() {
        while (!this.toBeInsertedExpressions.isEmpty()) {
            RelationalExpression expression = (RelationalExpression)this.toBeInsertedExpressions.pop();
            ImmutableMap.Builder<ExpressionProperty<?>, ?> groupingPropertyMapBuilder = ImmutableMap.builder();
            for (ExpressionProperty<?> expressionProperty : this.trackedPartitioningProperties) {
                groupingPropertyMapBuilder.put(expressionProperty, this.computePropertyValue(expressionProperty, expression));
            }
            ImmutableMap groupingPropertyMap = groupingPropertyMapBuilder.build();
            ImmutableMap.Builder<ExpressionProperty<?>, ?> groupedPropertyMapBuilder = ImmutableMap.builder();
            for (ExpressionProperty<?> expressionProperty : this.trackedNonPartitioningProperties) {
                groupedPropertyMapBuilder.put(expressionProperty, this.computePropertyValue(expressionProperty, expression));
            }
            ImmutableMap groupedPropertyMap = groupedPropertyMapBuilder.build();
            this.add(expression, groupingPropertyMap, groupedPropertyMap);
        }
    }

    @Nonnull
    public Map<E, Map<ExpressionProperty<?>, ?>> getPropertiesMap() {
        return this.propertiesMap;
    }

    @Nonnull
    public Map<E, Map<ExpressionProperty<?>, ?>> computeNonPartitioningPropertiesMap() {
        return Maps.transformValues(this.propertiesMap, propertyMap -> Maps.filterKeys(propertyMap, this.trackedNonPartitioningProperties::contains));
    }

    @Nullable
    public Map<ExpressionProperty<?>, ?> getProperties(@Nonnull RelationalExpression expression) {
        this.update();
        return this.getCurrentProperties(expression);
    }

    @Nullable
    public Map<ExpressionProperty<?>, ?> getCurrentProperties(@Nonnull RelationalExpression expression) {
        return this.propertiesMap.get(this.narrow(expression));
    }

    public void add(@Nonnull RelationalExpression expression) {
        this.toBeInsertedExpressions.add(this.narrow(expression));
    }

    public void add(@Nonnull RelationalExpression expression, @Nonnull Map<ExpressionProperty<?>, ?> propertyMap) {
        ImmutableMap.Builder<ExpressionProperty<?>, ?> partitioningPropertyMapBuilder = ImmutableMap.builder();
        for (ExpressionProperty<?> expressionProperty : this.trackedPartitioningProperties) {
            Object propertyValue = propertyMap.get(expressionProperty);
            Verify.verify(propertyValue != null);
            partitioningPropertyMapBuilder.put(expressionProperty, propertyMap.get(expressionProperty));
        }
        ImmutableMap partitioningPropertyMap = partitioningPropertyMapBuilder.build();
        E typedExpression = this.narrow(expression);
        Verify.verify(!this.propertiesMap.containsKey(typedExpression));
        this.propertiesMap.put(typedExpression, propertyMap);
        this.partitioningPropertiesExpressionsMap.put(partitioningPropertyMap, typedExpression);
    }

    public void add(@Nonnull RelationalExpression expression, @Nonnull Map<ExpressionProperty<?>, ?> partitioningPropertyMap, @Nonnull Map<ExpressionProperty<?>, ?> nonPartitioningPropertyMap) {
        E typedExpression = this.narrow(expression);
        Verify.verify(!this.propertiesMap.containsKey(typedExpression));
        ImmutableMap combinedPropertyMap = ImmutableMap.builder().putAll(partitioningPropertyMap).putAll(nonPartitioningPropertyMap).build();
        this.propertiesMap.put(typedExpression, combinedPropertyMap);
        this.partitioningPropertiesExpressionsMap.put(partitioningPropertyMap, typedExpression);
    }

    @Nonnull
    private <P> P computePropertyValue(@Nonnull ExpressionProperty<P> expressionProperty, @Nonnull RelationalExpression expression) {
        RelationalExpressionVisitor<P> propertyVisitor = expressionProperty.createVisitor();
        return propertyVisitor.visit(expression);
    }

    public void clear() {
        this.toBeInsertedExpressions.clear();
        this.propertiesMap.clear();
        this.partitioningPropertiesExpressionsMap.clear();
    }

    @Nonnull
    public <P> Map<E, P> propertyValueForExpressions(@Nonnull ExpressionProperty<P> expressionProperty) {
        this.update();
        LinkedIdentityMap<RelationalExpression, P> resultMap = new LinkedIdentityMap<RelationalExpression, P>();
        for (Map.Entry<E, Map<ExpressionProperty<?>, ?>> entry : this.propertiesMap.entrySet()) {
            resultMap.put((RelationalExpression)entry.getKey(), expressionProperty.narrowAttribute(entry.getValue().get(expressionProperty)));
        }
        return resultMap;
    }

    @Nonnull
    public Map<Map<ExpressionProperty<?>, ?>, Set<E>> getPartitioningPropertiesExpressionsMap() {
        this.update();
        return Multimaps.asMap(this.partitioningPropertiesExpressionsMap);
    }

    @Nonnull
    public Map<Map<ExpressionProperty<?>, ?>, Set<RecordQueryPlan>> getGroupingPropertiesPlansMap() {
        throw new UnsupportedOperationException("method should not be called");
    }

    @Nonnull
    public <P> Map<RecordQueryPlan, P> propertyValueForPlans(@Nonnull ExpressionProperty<P> expressionProperty) {
        throw new UnsupportedOperationException("method cannot provide plans");
    }

    @Nonnull
    public static ExpressionPropertiesMap<RelationalExpression> defaultForRewritePhase() {
        return new ExpressionPropertiesMap<RelationalExpression>(RelationalExpression.class, ImmutableSet.of(), ImmutableSet.of(ExpressionCountProperty.selectCount(), ExpressionCountProperty.tableFunctionCount(), PredicateComplexityProperty.predicateComplexity()), ImmutableList.of());
    }
}

