/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class FindExpressionVisitor
implements SimpleExpressionVisitor<Map<Class<? extends RelationalExpression>, Set<RelationalExpression>>> {
    private final Set<Class<? extends RelationalExpression>> expressionClasses;

    public FindExpressionVisitor(@Nonnull Set<Class<? extends RelationalExpression>> expressionClasses) {
        this.expressionClasses = ImmutableSet.copyOf(expressionClasses);
    }

    @Override
    @Nonnull
    public Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> evaluateAtExpression(@Nonnull RelationalExpression expression, @Nonnull List<Map<Class<? extends RelationalExpression>, Set<RelationalExpression>>> childResults) {
        HashMap<Class, Set> currentMap = Maps.newHashMap();
        for (Class<? extends RelationalExpression> expressionClass : this.expressionClasses) {
            currentMap.compute(expressionClass, (clazz, oldSet) -> {
                if (expressionClass.isInstance(expression)) {
                    if (oldSet == null) {
                        return LinkedIdentitySet.of(new RelationalExpression[]{expression});
                    }
                    oldSet.add(expression);
                    return oldSet;
                }
                return oldSet == null ? LinkedIdentitySet.of(new RelationalExpression[0]) : oldSet;
            });
        }
        return this.mergeMaps(Iterables.concat(childResults, ImmutableList.of(currentMap)));
    }

    @Override
    @Nonnull
    public Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> evaluateAtRef(@Nonnull Reference ref, @Nonnull List<Map<Class<? extends RelationalExpression>, Set<RelationalExpression>>> memberResults) {
        Verify.verify(memberResults.size() == 1);
        return Iterables.getOnlyElement(memberResults);
    }

    @Nonnull
    private Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> mergeMaps(@Nonnull Iterable<Map<Class<? extends RelationalExpression>, Set<RelationalExpression>>> childResults) {
        ImmutableMap.Builder resultMap = ImmutableMap.builder();
        for (Class<? extends RelationalExpression> expressionClass : this.expressionClasses) {
            LinkedIdentitySet accumulated = new LinkedIdentitySet();
            for (Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> childResult : childResults) {
                Set<RelationalExpression> childResultForClass = childResult.get(expressionClass);
                if (childResultForClass == null) continue;
                accumulated.addAll(childResultForClass);
            }
            resultMap.put(expressionClass, LinkedIdentitySet.copyOf(accumulated));
        }
        return resultMap.build();
    }

    @Nonnull
    public static Set<? extends RelationalExpression> findExpressions(@Nonnull Class<? extends RelationalExpression> expressionClass, @Nonnull RelationalExpression expression) {
        return FindExpressionVisitor.findExpressions(ImmutableSet.of(expressionClass), expression);
    }

    @Nonnull
    public static Set<? extends RelationalExpression> findExpressions(@Nonnull Set<Class<? extends RelationalExpression>> expressionClasses, @Nonnull RelationalExpression expression) {
        Map expressionClassToExpressionsMap = (Map)new FindExpressionVisitor(expressionClasses).visit(expression);
        if (expressionClassToExpressionsMap == null) {
            return LinkedIdentitySet.of(new RelationalExpression[0]);
        }
        LinkedIdentitySet accumulated = new LinkedIdentitySet();
        for (Set value : expressionClassToExpressionsMap.values()) {
            accumulated.addAll(value);
        }
        return accumulated;
    }

    @Nonnull
    @SafeVarargs
    public static Set<? extends RelationalExpression> slice(@Nonnull Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> inMap, Class<? extends RelationalExpression> ... expressionClasses) {
        LinkedIdentitySet accumulated = new LinkedIdentitySet();
        for (Class<? extends RelationalExpression> expressionClass : expressionClasses) {
            Set<RelationalExpression> childResultForClass = inMap.get(expressionClass);
            if (childResultForClass == null) continue;
            accumulated.addAll(childResultForClass);
        }
        return accumulated;
    }

    public static int countExpressions(@Nonnull Class<? extends RelationalExpression> expressionClass, @Nonnull RelationalExpression expression) {
        return FindExpressionVisitor.countExpressions(ImmutableSet.of(expressionClass), expression);
    }

    public static int countExpressions(@Nonnull Set<Class<? extends RelationalExpression>> expressionClasses, @Nonnull RelationalExpression expression) {
        return FindExpressionVisitor.findExpressions(expressionClasses, expression).size();
    }

    @Nonnull
    public static Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> evaluate(@Nonnull Set<Class<? extends RelationalExpression>> expressionClasses, @Nonnull RelationalExpression expression) {
        Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> nullableResult = expression.acceptVisitor(new FindExpressionVisitor(expressionClasses));
        return nullableResult == null ? ImmutableMap.of() : nullableResult;
    }
}

