/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ExistsPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class GraphExpansion {
    @Nonnull
    private final ImmutableList<Column<? extends Value>> resultColumns;
    @Nonnull
    private final ImmutableList<QueryPredicate> predicates;
    @Nonnull
    private final ImmutableList<Quantifier> quantifiers;
    @Nonnull
    private final ImmutableList<Placeholder> placeholders;

    private GraphExpansion(@Nonnull List<Column<? extends Value>> resultColumns, @Nonnull List<QueryPredicate> predicates, @Nonnull List<Quantifier> quantifiers, @Nonnull List<Placeholder> placeholders) {
        this.resultColumns = ImmutableList.copyOf(resultColumns);
        this.predicates = ImmutableList.copyOf(predicates);
        this.quantifiers = ImmutableList.copyOf(quantifiers);
        this.placeholders = ImmutableList.copyOf(placeholders);
    }

    @Nonnull
    public List<Column<? extends Value>> getResultColumns() {
        return this.resultColumns;
    }

    @Nonnull
    public List<QueryPredicate> getPredicates() {
        return this.predicates;
    }

    @Nonnull
    public List<Quantifier> getQuantifiers() {
        return this.quantifiers;
    }

    @Nonnull
    public List<Placeholder> getPlaceholders() {
        return this.placeholders;
    }

    @Nonnull
    public List<CorrelationIdentifier> getPlaceholderAliases() {
        return this.placeholders.stream().map(Placeholder::getParameterAlias).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public QueryPredicate asAndPredicate() {
        return AndPredicate.and(this.getPredicates());
    }

    @Nonnull
    public GraphExpansion withPredicate(@Nonnull QueryPredicate predicate) {
        return new GraphExpansion(this.resultColumns, ImmutableList.of(predicate), this.quantifiers, this.placeholders);
    }

    @Nonnull
    public GraphExpansion withBase(@Nonnull Quantifier.ForEach quantifier) {
        return GraphExpansion.ofOthers(GraphExpansion.ofQuantifier(quantifier), this);
    }

    public boolean isTrivialSelect() {
        return this.quantifiers.size() == 1 && this.predicates.isEmpty() && this.resultColumns.isEmpty();
    }

    @Nonnull
    public Builder toBuilder() {
        Builder builder = GraphExpansion.builder();
        builder.addAllResultColumns(this.resultColumns);
        builder.addAllPredicates(this.predicates);
        builder.addAllQuantifiers(this.quantifiers);
        builder.addAllPlaceholders(this.placeholders);
        return builder;
    }

    @Nonnull
    public Sealed distinctSeal() {
        return this.seal(true);
    }

    @Nonnull
    public Sealed seal() {
        return this.seal(false);
    }

    @Nonnull
    public Sealed seal(boolean isDistinctColumns) {
        GraphExpansion graphExpansion;
        HashSet<String> seenFieldNames = Sets.newHashSet();
        ImmutableSet.Builder duplicateFieldNamesBuilder = ImmutableSet.builder();
        HashSet seenResultValues = isDistinctColumns ? Sets.newHashSet() : null;
        ImmutableList.Builder distinctResultColumnsBuilder = isDistinctColumns ? ImmutableList.builder() : null;
        for (Column column : this.resultColumns) {
            String fieldName;
            boolean isDuplicateValue;
            Optional<String> fieldNameOptional = column.getField().getFieldNameOptional();
            if (seenResultValues != null) {
                boolean bl = isDuplicateValue = !seenResultValues.add(column.getValue());
                if (!isDuplicateValue) {
                    distinctResultColumnsBuilder.add(column);
                }
            } else {
                isDuplicateValue = false;
            }
            if (!fieldNameOptional.isPresent() || isDuplicateValue || seenFieldNames.add(fieldName = fieldNameOptional.get())) continue;
            duplicateFieldNamesBuilder.add(fieldName);
        }
        ImmutableCollection duplicateFieldNames = duplicateFieldNamesBuilder.build();
        ImmutableList<Column<? extends Value>> immutableList2 = distinctResultColumnsBuilder != null ? distinctResultColumnsBuilder.build() : this.resultColumns;
        immutableList2 = immutableList2.stream().map(arg_0 -> GraphExpansion.lambda$seal$0((ImmutableSet)duplicateFieldNames, arg_0)).collect(ImmutableList.toImmutableList());
        if (!this.placeholders.isEmpty()) {
            ImmutableSet<QueryPredicate> localPredicates = ImmutableSet.copyOf(this.getPredicates());
            ImmutableList localValues = localPredicates.stream().flatMap(predicate -> predicate.narrowMaybe(PredicateWithValueAndRanges.class).stream()).map(PredicateWithValueAndRanges::getValue).collect(ImmutableList.toImmutableList());
            ImmutableList uniquePlaceholders = ImmutableList.copyOf(this.placeholders.stream().collect(Collectors.toMap(Placeholder::getParameterAlias, v -> v, (left, right) -> left.withExtraRanges(right.getRanges()), LinkedHashMap::new)).values());
            ArrayList resultPlaceHolders = Lists.newArrayList(uniquePlaceholders);
            List localPlaceHolderPairs = IntStream.range(0, uniquePlaceholders.size()).mapToObj(i -> NonnullPair.of((Placeholder)uniquePlaceholders.get(i), i)).filter(placeholderWithIndex -> localValues.contains(((Placeholder)placeholderWithIndex.getKey()).getValue())).collect(Collectors.toList());
            ImmutableList.Builder resultPredicates = new ImmutableList.Builder();
            for (QueryPredicate queryPredicate : this.getPredicates()) {
                if (queryPredicate instanceof Placeholder) {
                    Placeholder localPlaceHolder = (Placeholder)queryPredicate;
                    AliasMap identities = AliasMap.emptyMap();
                    Iterator iterator = localPlaceHolderPairs.iterator();
                    int foundAtOrdinal = -1;
                    while (iterator.hasNext()) {
                        NonnullPair currentPlaceholderPair = (NonnullPair)iterator.next();
                        Placeholder currentPlaceholder = (Placeholder)currentPlaceholderPair.getLeft();
                        if (!localPlaceHolder.getValue().semanticEquals((Object)currentPlaceholder.getValue(), identities)) continue;
                        if (foundAtOrdinal < 0) {
                            foundAtOrdinal = (Integer)currentPlaceholderPair.getRight();
                            resultPredicates.add(currentPlaceholder);
                            resultPlaceHolders.set(foundAtOrdinal, currentPlaceholder);
                        } else {
                            resultPlaceHolders.set((Integer)currentPlaceholderPair.getRight(), (Placeholder)resultPlaceHolders.get(foundAtOrdinal));
                        }
                        iterator.remove();
                    }
                    continue;
                }
                resultPredicates.add(queryPredicate);
            }
            graphExpansion = new GraphExpansion(immutableList2, (List<QueryPredicate>)((Object)resultPredicates.build()), this.quantifiers, ImmutableList.copyOf(resultPlaceHolders));
        } else {
            graphExpansion = new GraphExpansion(immutableList2, this.predicates, this.quantifiers, ImmutableList.of());
        }
        return graphExpansion.new Sealed();
    }

    @Nonnull
    public SelectExpression buildSelect() {
        return this.seal().buildSelect();
    }

    @Nonnull
    public SelectExpression buildSimpleSelectOverQuantifier(@Nonnull Quantifier.ForEach overQuantifier) {
        return this.seal().buildSimpleSelectOverQuantifier(overQuantifier);
    }

    @Nonnull
    public SelectExpression buildSelectWithResultValue(@Nonnull Value resultValue) {
        return this.seal().buildSelectWithResultValue(resultValue);
    }

    @Nonnull
    public static GraphExpansion empty() {
        return GraphExpansion.builder().build();
    }

    @Nonnull
    public static GraphExpansion ofQuantifier(@Nonnull Quantifier quantifier) {
        return GraphExpansion.builder().addQuantifier(quantifier).build();
    }

    @Nonnull
    public static GraphExpansion ofPredicate(@Nonnull QueryPredicate predicate) {
        return GraphExpansion.builder().addPredicate(predicate).build();
    }

    @Nonnull
    public static GraphExpansion ofResultColumn(@Nonnull Column<? extends Value> resultColumn) {
        return GraphExpansion.builder().addResultColumn(resultColumn).build();
    }

    @Nonnull
    public static GraphExpansion ofResultColumnAndPlaceholder(@Nonnull Column<? extends Value> resultColumn, @Nonnull Placeholder placeholder) {
        return GraphExpansion.builder().addResultColumn(resultColumn).addPredicate(placeholder).addPlaceholder(placeholder).build();
    }

    @Nonnull
    public static GraphExpansion ofExists(@Nonnull Quantifier.Existential existentialQuantifier) {
        ExistsPredicate existsPredicate = new ExistsPredicate(existentialQuantifier.getAlias());
        return GraphExpansion.of(ImmutableList.of(), ImmutableList.of(existsPredicate), ImmutableList.of(existentialQuantifier), ImmutableList.of());
    }

    @Nonnull
    public static GraphExpansion ofPlaceholder(@Nonnull Placeholder placeholder) {
        return GraphExpansion.builder().addPredicate(placeholder).addPlaceholder(placeholder).build();
    }

    @Nonnull
    public static GraphExpansion of(@Nonnull List<Column<? extends Value>> resultColumns, @Nonnull List<QueryPredicate> predicates, @Nonnull List<Quantifier> quantifiers, @Nonnull List<Placeholder> placeholders) {
        return new GraphExpansion(resultColumns, predicates, quantifiers, placeholders);
    }

    @Nonnull
    public static GraphExpansion ofOthers(@Nonnull GraphExpansion graphExpansion, GraphExpansion ... otherExpansions) {
        ImmutableList.Builder graphExpansionsBuilder = ImmutableList.builder();
        graphExpansionsBuilder.add(graphExpansion);
        graphExpansionsBuilder.addAll(Arrays.asList(otherExpansions));
        return GraphExpansion.ofOthers((List<GraphExpansion>)((Object)graphExpansionsBuilder.build()));
    }

    @Nonnull
    public static GraphExpansion ofOthers(@Nonnull List<GraphExpansion> graphExpansions) {
        ImmutableList.Builder resultColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
        ImmutableList.Builder quantifiersBuilder = ImmutableList.builder();
        ImmutableList.Builder placeholdersBuilder = ImmutableList.builder();
        for (GraphExpansion expandedPredicate : graphExpansions) {
            resultColumnsBuilder.addAll(expandedPredicate.getResultColumns());
            predicatesBuilder.addAll(expandedPredicate.getPredicates());
            quantifiersBuilder.addAll(expandedPredicate.getQuantifiers());
            placeholdersBuilder.addAll(expandedPredicate.getPlaceholders());
        }
        return new GraphExpansion((List<Column<? extends Value>>)((Object)resultColumnsBuilder.build()), (List<QueryPredicate>)((Object)predicatesBuilder.build()), (List<Quantifier>)((Object)quantifiersBuilder.build()), (List<Placeholder>)((Object)placeholdersBuilder.build()));
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static /* synthetic */ Column lambda$seal$0(ImmutableSet duplicateFieldNames, Column resultColumn) {
        Optional<String> fieldNameOptional = resultColumn.getField().getFieldNameOptional();
        if (fieldNameOptional.isEmpty()) {
            return resultColumn;
        }
        String fieldName = fieldNameOptional.get();
        if (!duplicateFieldNames.contains(fieldName)) {
            return resultColumn;
        }
        return Column.unnamedOf(resultColumn.getValue());
    }

    public static class Builder {
        @Nonnull
        private ImmutableList.Builder<Column<? extends Value>> resultColumns = new ImmutableList.Builder();
        @Nonnull
        private ImmutableList.Builder<QueryPredicate> predicates = new ImmutableList.Builder();
        @Nonnull
        private ImmutableList.Builder<Quantifier> quantifiers = new ImmutableList.Builder();
        @Nonnull
        private ImmutableList.Builder<Placeholder> placeholders = new ImmutableList.Builder();

        private Builder() {
        }

        @Nonnull
        public Builder addResultValue(@Nonnull Value resultValue) {
            this.addResultColumn(Column.unnamedOf(resultValue));
            return this;
        }

        @Nonnull
        public Builder addAllResultValues(@Nonnull Iterable<? extends Value> addResultValues) {
            addResultValues.forEach(this::addResultValue);
            return this;
        }

        @Nonnull
        public Builder addResultColumn(@Nonnull Column<? extends Value> resultColumn) {
            this.resultColumns.add((Object)resultColumn);
            return this;
        }

        @Nonnull
        public Builder addAllResultColumns(@Nonnull Iterable<? extends Column<? extends Value>> addResultColumns) {
            addResultColumns.forEach(this::addResultColumn);
            return this;
        }

        @Nonnull
        public Builder removeAllResultColumns() {
            this.resultColumns = new ImmutableList.Builder();
            return this;
        }

        @Nonnull
        public Builder addPredicate(@Nonnull QueryPredicate predicate) {
            this.predicates.add((Object)predicate);
            return this;
        }

        @Nonnull
        public Builder addAllPredicates(@Nonnull Iterable<? extends QueryPredicate> addPredicates) {
            this.predicates.addAll(addPredicates);
            return this;
        }

        @Nonnull
        public Builder removeAllPredicates() {
            this.predicates = new ImmutableList.Builder();
            return this;
        }

        @Nonnull
        public Builder addQuantifier(@Nonnull Quantifier quantifier) {
            this.quantifiers.add((Object)quantifier);
            return this;
        }

        @Nonnull
        public Builder addAllQuantifiers(@Nonnull Iterable<? extends Quantifier> addQuantifiers) {
            addQuantifiers.forEach(this::addQuantifier);
            return this;
        }

        @Nonnull
        public Builder removeAllQuantifiers() {
            this.quantifiers = new ImmutableList.Builder();
            return this;
        }

        @Nonnull
        public Builder pullUpQuantifier(@Nonnull Quantifier quantifier) {
            this.quantifiers.add((Object)quantifier);
            this.resultColumns.addAll(quantifier.getFlowedColumns());
            return this;
        }

        @Nonnull
        public Builder pullUpAllQuantifiers(@Nonnull Iterable<? extends Quantifier> addQuantifiers) {
            addQuantifiers.forEach(this::pullUpQuantifier);
            return this;
        }

        @Nonnull
        public Builder addPlaceholder(@Nonnull Placeholder placeholder) {
            this.placeholders.add((Object)placeholder);
            return this;
        }

        @Nonnull
        public Builder addAllPlaceholders(@Nonnull Iterable<? extends Placeholder> addPlaceholders) {
            this.placeholders.addAll(addPlaceholders);
            return this;
        }

        @Nonnull
        public Builder removeAllPlaceholders() {
            this.placeholders = new ImmutableList.Builder();
            return this;
        }

        @Nonnull
        public GraphExpansion build() {
            return new GraphExpansion((List<Column<? extends Value>>)((Object)this.resultColumns.build()), (List<QueryPredicate>)((Object)this.predicates.build()), (List<Quantifier>)((Object)this.quantifiers.build()), (List<Placeholder>)((Object)this.placeholders.build()));
        }
    }

    public class Sealed {
        @Nonnull
        public SelectExpression buildSelect() {
            return new SelectExpression(RecordConstructorValue.ofColumns(GraphExpansion.this.resultColumns), GraphExpansion.this.quantifiers, this.getPredicates());
        }

        @Nonnull
        public SelectExpression buildSimpleSelectOverQuantifier(@Nonnull Quantifier.ForEach overQuantifier) {
            return this.buildSelectWithResultValue(overQuantifier.getFlowedObjectValue());
        }

        @Nonnull
        public SelectExpression buildSelectWithResultValue(@Nonnull Value resultValue) {
            Verify.verify(GraphExpansion.this.resultColumns.isEmpty());
            return new SelectExpression(resultValue, GraphExpansion.this.quantifiers, this.getPredicates());
        }

        @Nonnull
        public List<Column<? extends Value>> getResultColumns() {
            return GraphExpansion.this.resultColumns;
        }

        @Nonnull
        public List<Value> getResultValues() {
            return GraphExpansion.this.resultColumns.stream().map(Column::getValue).collect(ImmutableList.toImmutableList());
        }

        @Nonnull
        public List<QueryPredicate> getPredicates() {
            return GraphExpansion.this.predicates;
        }

        @Nonnull
        public List<Quantifier> getQuantifiers() {
            return GraphExpansion.this.quantifiers;
        }

        @Nonnull
        public List<Placeholder> getPlaceholders() {
            return GraphExpansion.this.placeholders;
        }

        @Nonnull
        public QueryPredicate asAndPredicate() {
            return GraphExpansion.this.asAndPredicate();
        }

        @Nonnull
        public Builder builderWithInheritedPlaceholders() {
            return GraphExpansion.builder().addAllPlaceholders(GraphExpansion.this.placeholders);
        }
    }
}

