/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import javax.annotation.Nonnull;

public class GroupByMappings {
    @Nonnull
    private final BiMap<Value, Value> matchedGroupingsMap;
    @Nonnull
    private final BiMap<Value, Value> matchedAggregatesMap;
    @Nonnull
    private final BiMap<CorrelationIdentifier, Value> unmatchedAggregatesMap;

    private GroupByMappings(@Nonnull BiMap<Value, Value> matchedGroupingsMap, @Nonnull BiMap<Value, Value> matchedAggregatesMap, @Nonnull BiMap<CorrelationIdentifier, Value> unmatchedAggregatesMap) {
        this.matchedGroupingsMap = matchedGroupingsMap;
        this.matchedAggregatesMap = matchedAggregatesMap;
        this.unmatchedAggregatesMap = unmatchedAggregatesMap;
    }

    @Nonnull
    public BiMap<Value, Value> getMatchedGroupingsMap() {
        return this.matchedGroupingsMap;
    }

    @Nonnull
    public BiMap<Value, Value> getMatchedAggregatesMap() {
        return this.matchedAggregatesMap;
    }

    @Nonnull
    public BiMap<CorrelationIdentifier, Value> getUnmatchedAggregatesMap() {
        return this.unmatchedAggregatesMap;
    }

    public static GroupByMappings empty() {
        return GroupByMappings.of(ImmutableBiMap.of(), ImmutableBiMap.of(), ImmutableBiMap.of());
    }

    @Nonnull
    public static GroupByMappings of(@Nonnull BiMap<Value, Value> matchedGroupingsMap, @Nonnull BiMap<Value, Value> matchedAggregateMap, @Nonnull BiMap<CorrelationIdentifier, Value> unmatchedAggregatesMap) {
        return new GroupByMappings(ImmutableBiMap.copyOf(matchedGroupingsMap), ImmutableBiMap.copyOf(matchedAggregateMap), ImmutableBiMap.copyOf(unmatchedAggregatesMap));
    }
}

