/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.google.common.base.Equivalence;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SpotBugsSuppressWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
public class IdentityBiMap<K, V>
implements BiMap<Equivalence.Wrapper<K>, Equivalence.Wrapper<V>> {
    private static final Equivalence<Object> identity = Equivalence.identity();
    private final BiMap<Equivalence.Wrapper<K>, Equivalence.Wrapper<V>> delegate;
    private final Supplier<IdentityBiMap<V, K>> inverseProvider = Suppliers.memoize(() -> IdentityBiMap.create(this.getDelegate().inverse()));

    private IdentityBiMap(BiMap<Equivalence.Wrapper<K>, Equivalence.Wrapper<V>> delegate) {
        this.delegate = delegate;
    }

    protected BiMap<Equivalence.Wrapper<K>, Equivalence.Wrapper<V>> getDelegate() {
        return this.delegate;
    }

    @Override
    @Nullable
    @CanIgnoreReturnValue
    public Equivalence.Wrapper<V> put(@Nullable Equivalence.Wrapper<K> key, @Nullable Equivalence.Wrapper<V> value) {
        return this.getDelegate().put(key, value);
    }

    @Nullable
    @CanIgnoreReturnValue
    public V putUnwrapped(@Nullable K key, @Nullable V value) {
        return IdentityBiMap.unwrap(this.getDelegate().put(IdentityBiMap.wrap(key), IdentityBiMap.wrap(value)));
    }

    @Override
    @Nullable
    @CanIgnoreReturnValue
    @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public Equivalence.Wrapper<V> forcePut(@Nullable Equivalence.Wrapper<K> key, @Nullable Equivalence.Wrapper<V> value) {
        return this.getDelegate().forcePut(key, value);
    }

    @Nullable
    @CanIgnoreReturnValue
    public V forcePutUnwrapped(@Nullable K key, @Nullable V value) {
        return IdentityBiMap.unwrap(this.getDelegate().forcePut(IdentityBiMap.wrap(key), IdentityBiMap.wrap(value)));
    }

    @Override
    public void putAll(@Nonnull Map<? extends Equivalence.Wrapper<K>, ? extends Equivalence.Wrapper<V>> map) {
        this.getDelegate().putAll(map);
    }

    @Override
    @Nonnull
    public Set<Equivalence.Wrapper<V>> values() {
        return this.getDelegate().values();
    }

    @Override
    @Nonnull
    public IdentityBiMap<V, K> inverse() {
        return this.inverseProvider.get();
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.getDelegate().containsKey(key);
    }

    public boolean containsKeyUnwrapped(@Nullable Object key) {
        return this.getDelegate().containsKey(IdentityBiMap.wrap(key));
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.getDelegate().containsValue(value);
    }

    @Override
    @Nullable
    public Equivalence.Wrapper<V> get(@Nullable Object key) {
        return (Equivalence.Wrapper)this.getDelegate().get(key);
    }

    @Nullable
    public V getUnwrapped(@Nullable Object key) {
        return (V)IdentityBiMap.unwrap((Equivalence.Wrapper)this.getDelegate().get(IdentityBiMap.wrap(key)));
    }

    @Override
    @Nullable
    public Equivalence.Wrapper<V> remove(Object key) {
        return (Equivalence.Wrapper)this.getDelegate().remove(key);
    }

    @Override
    public void clear() {
        this.getDelegate().clear();
    }

    @Override
    @Nonnull
    public Set<Equivalence.Wrapper<K>> keySet() {
        return this.getDelegate().keySet();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<Equivalence.Wrapper<K>, Equivalence.Wrapper<V>>> entrySet() {
        return this.getDelegate().entrySet();
    }

    @Override
    @SpotBugsSuppressWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public boolean equals(@Nullable Object o) {
        return this.getDelegate().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    @Nullable
    public Equivalence.Wrapper<V> getOrDefault(@Nullable Object key, @Nullable Equivalence.Wrapper<V> defaultValue) {
        return this.getDelegate().getOrDefault(key, defaultValue);
    }

    @Nullable
    public V getOrDefaultUnwrapped(@Nullable Object key, @Nullable V defaultValue) {
        Equivalence.Wrapper<Object> wrappedKey = IdentityBiMap.wrap(key);
        Object wrappedValue = this.get(wrappedKey);
        return (V)(wrappedValue == null ? defaultValue : ((Equivalence.Wrapper)wrappedValue).get());
    }

    @Override
    public void forEach(@Nonnull BiConsumer<? super Equivalence.Wrapper<K>, ? super Equivalence.Wrapper<V>> action) {
        this.getDelegate().forEach(action);
    }

    public void forEachUnwrapped(@Nonnull BiConsumer<? super K, ? super V> action) {
        this.getDelegate().forEach((? super K wrappedKey, ? super V wrappedValue) -> action.accept((Object)IdentityBiMap.unwrap(wrappedKey), (Object)IdentityBiMap.unwrap(wrappedValue)));
    }

    @Override
    public void replaceAll(@Nonnull BiFunction<? super Equivalence.Wrapper<K>, ? super Equivalence.Wrapper<V>, ? extends Equivalence.Wrapper<V>> function) {
        this.getDelegate().replaceAll(function);
    }

    @Override
    @Nullable
    public Equivalence.Wrapper<V> putIfAbsent(@Nullable Equivalence.Wrapper<K> key, Equivalence.Wrapper<V> value) {
        return this.getDelegate().putIfAbsent(key, value);
    }

    @Nullable
    public Equivalence.Wrapper<V> putIfAbsentUnwrapped(@Nullable K key, V value) {
        return this.getDelegate().putIfAbsent(IdentityBiMap.wrap(key), IdentityBiMap.wrap(value));
    }

    @Override
    public boolean replace(@Nullable Equivalence.Wrapper<K> key, @Nullable Equivalence.Wrapper<V> oldValue, @Nullable Equivalence.Wrapper<V> newValue) {
        return this.getDelegate().replace(key, oldValue, newValue);
    }

    @Override
    @Nullable
    public Equivalence.Wrapper<V> replace(@Nullable Equivalence.Wrapper<K> key, Equivalence.Wrapper<V> value) {
        return this.getDelegate().replace(key, value);
    }

    @Override
    @Nullable
    public Equivalence.Wrapper<V> computeIfAbsent(@Nullable Equivalence.Wrapper<K> key, @Nonnull Function<? super Equivalence.Wrapper<K>, ? extends Equivalence.Wrapper<V>> mappingFunction) {
        return this.getDelegate().computeIfAbsent(key, mappingFunction);
    }

    @Override
    @Nullable
    public Equivalence.Wrapper<V> computeIfPresent(@Nullable Equivalence.Wrapper<K> key, @Nonnull BiFunction<? super Equivalence.Wrapper<K>, ? super Equivalence.Wrapper<V>, ? extends Equivalence.Wrapper<V>> remappingFunction) {
        return this.getDelegate().computeIfPresent(key, remappingFunction);
    }

    @Override
    @Nullable
    public Equivalence.Wrapper<V> compute(@Nullable Equivalence.Wrapper<K> key, @Nonnull BiFunction<? super Equivalence.Wrapper<K>, ? super Equivalence.Wrapper<V>, ? extends Equivalence.Wrapper<V>> remappingFunction) {
        return this.getDelegate().compute(key, remappingFunction);
    }

    @Override
    @Nullable
    public Equivalence.Wrapper<V> merge(@Nullable Equivalence.Wrapper<K> key, @Nonnull Equivalence.Wrapper<V> value, @Nonnull BiFunction<? super Equivalence.Wrapper<V>, ? super Equivalence.Wrapper<V>, ? extends Equivalence.Wrapper<V>> remappingFunction) {
        return this.getDelegate().merge(key, value, remappingFunction);
    }

    @Nonnull
    public IdentityBiMap<K, V> toImmutable() {
        return new IdentityBiMap<K, V>(ImmutableBiMap.copyOf(this.delegate));
    }

    @Nonnull
    public static <K, V> IdentityBiMap<K, V> create() {
        return IdentityBiMap.create(HashBiMap.create());
    }

    @Nonnull
    public static <K, V> IdentityBiMap<K, V> create(BiMap<Equivalence.Wrapper<K>, Equivalence.Wrapper<V>> delegate) {
        return new IdentityBiMap<K, V>(delegate);
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public static <T> Equivalence.Wrapper<T> wrap(@Nullable T reference) {
        return identity.wrap(reference);
    }

    @Nullable
    public static <T> T unwrap(@Nullable Equivalence.Wrapper<T> wrapper) {
        return wrapper == null ? null : (T)wrapper.get();
    }

    public static <T, K, V> Collector<T, ?, IdentityBiMap<K, V>> toImmutableIdentityBiMap(final @Nonnull Function<? super T, ? extends K> keyMapper, final @Nonnull Function<? super T, ? extends V> valueMapper, final @Nonnull BinaryOperator<V> mergeFunction) {
        return new Collector<T, IdentityBiMap<K, V>, IdentityBiMap<K, V>>(){

            @Override
            public Supplier<IdentityBiMap<K, V>> supplier() {
                return IdentityBiMap::create;
            }

            @Override
            public BiConsumer<IdentityBiMap<K, V>, T> accumulator() {
                return (map, t2) -> {
                    Object key = keyMapper.apply(t2);
                    Object value = valueMapper.apply(t2);
                    map.merge(IdentityBiMap.wrap(key), IdentityBiMap.wrap(value), (wrappedValue1, wrappedValue2) -> IdentityBiMap.wrap(mergeFunction.apply(IdentityBiMap.unwrap(wrappedValue1), IdentityBiMap.unwrap(wrappedValue2))));
                };
            }

            @Override
            public BinaryOperator<IdentityBiMap<K, V>> combiner() {
                return (map1, map2) -> {
                    map2.forEach((wrappedKey, wrappedValue) -> map1.merge(wrappedKey, wrappedValue, (wrappedValue1, wrappedValue2) -> IdentityBiMap.wrap(mergeFunction.apply(IdentityBiMap.unwrap(wrappedValue1), IdentityBiMap.unwrap(wrappedValue2)))));
                    return map1;
                };
            }

            @Override
            public Function<IdentityBiMap<K, V>, IdentityBiMap<K, V>> finisher() {
                return IdentityBiMap::toImmutable;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return ImmutableSet.of(Collector.Characteristics.UNORDERED);
            }
        };
    }
}

