/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public final class IndexExpansionInfo {
    @Nonnull
    private final RecordMetaData metaData;
    @Nonnull
    private final Index index;
    private final boolean reverse;
    @Nullable
    private final KeyExpression commonPrimaryKeyForTypes;
    @Nonnull
    private final Collection<RecordType> indexedRecordTypes;
    @Nonnull
    private final Set<String> indexedRecordTypeNames;

    private IndexExpansionInfo(@Nonnull RecordMetaData metaData, @Nonnull Index index, boolean reverse, @Nonnull Collection<RecordType> indexedRecordTypes, @Nonnull Set<String> indexedRecordTypeNames, @Nullable KeyExpression commonPrimaryKeyForTypes) {
        this.metaData = metaData;
        this.index = index;
        this.reverse = reverse;
        this.indexedRecordTypes = indexedRecordTypes;
        this.indexedRecordTypeNames = indexedRecordTypeNames;
        this.commonPrimaryKeyForTypes = commonPrimaryKeyForTypes;
    }

    @Nonnull
    public RecordMetaData getMetaData() {
        return this.metaData;
    }

    @Nonnull
    public Index getIndex() {
        return this.index;
    }

    @Nonnull
    public String getIndexName() {
        return this.index.getName();
    }

    public boolean isReverse() {
        return this.reverse;
    }

    @Nonnull
    public Collection<RecordType> getIndexedRecordTypes() {
        return this.indexedRecordTypes;
    }

    @Nonnull
    public Set<String> getIndexedRecordTypeNames() {
        return this.indexedRecordTypeNames;
    }

    @Nullable
    public KeyExpression getCommonPrimaryKeyForTypes() {
        return this.commonPrimaryKeyForTypes;
    }

    @Nonnull
    public Set<String> getAvailableRecordTypeNames() {
        return this.metaData.getRecordTypes().keySet();
    }

    @Nonnull
    public static IndexExpansionInfo createInfo(@Nonnull RecordMetaData metaData, @Nonnull Index index, boolean reverse) {
        Collection<RecordType> indexedRecordTypes = Collections.unmodifiableCollection(metaData.recordTypesForIndex(index));
        Set indexedRecordTypeNames = indexedRecordTypes.stream().map(RecordType::getName).collect(ImmutableSet.toImmutableSet());
        KeyExpression commonPrimaryKeyForTypes = RecordMetaData.commonPrimaryKey(indexedRecordTypes);
        return new IndexExpansionInfo(metaData, index, reverse, indexedRecordTypes, indexedRecordTypeNames, commonPrimaryKeyForTypes);
    }
}

