/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.RangeConstraints;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Optional;
import javax.annotation.Nonnull;

public class IndexPredicateExpansion {
    @Nonnull
    public static Optional<Multimap<Value, RangeConstraints>> dnfPredicateToRanges(@Nonnull QueryPredicate predicate) {
        ImmutableMultimap.Builder<Value, RangeConstraints> result = ImmutableMultimap.builder();
        if (!(predicate instanceof OrPredicate)) {
            if (!IndexPredicateExpansion.conjunctionToRange(predicate, result, predicate)) {
                return Optional.empty();
            }
        } else {
            Iterable groups = predicate.getChildren();
            for (QueryPredicate group : groups) {
                if (IndexPredicateExpansion.conjunctionToRange(predicate, result, group)) continue;
                return Optional.empty();
            }
        }
        return Optional.of(result.build());
    }

    private static boolean conjunctionToRange(@Nonnull QueryPredicate predicate, ImmutableMultimap.Builder<Value, RangeConstraints> result, QueryPredicate group) {
        if (group instanceof AndPredicate) {
            Iterable terms = ((AndPredicate)group).getChildren();
            Optional<Object> key = Optional.empty();
            RangeConstraints.Builder rangeBuilder = RangeConstraints.newBuilder();
            for (QueryPredicate term : terms) {
                if (!(term instanceof ValuePredicate)) {
                    return false;
                }
                ValuePredicate valuePredicate = (ValuePredicate)term;
                if (key.isEmpty()) {
                    key = Optional.of(valuePredicate.getValue());
                } else if (!((Value)key.get()).semanticEquals((Object)valuePredicate.getValue(), AliasMap.emptyMap())) {
                    return false;
                }
                if (rangeBuilder.addComparisonMaybe(valuePredicate.getComparison())) continue;
                return false;
            }
            Optional<RangeConstraints> range = rangeBuilder.build();
            if (key.isEmpty() || range.isEmpty()) {
                return false;
            }
            result.put((Value)key.get(), range.get());
        } else {
            if (!(group instanceof ValuePredicate)) {
                return false;
            }
            ValuePredicate valuePredicate = (ValuePredicate)group;
            Value key = valuePredicate.getValue();
            RangeConstraints.Builder rangeBuilder = RangeConstraints.newBuilder();
            if (!rangeBuilder.addComparisonMaybe(valuePredicate.getComparison())) {
                return false;
            }
            Optional<RangeConstraints> range = rangeBuilder.build();
            if (range.isEmpty()) {
                throw new RecordCoreException("invalid predicate", new Object[0]).addLogInfo("predicate", (Object)predicate);
            }
            result.put(key, range.get());
        }
        return true;
    }
}

