/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class IterableHelpers {
    private IterableHelpers() {
    }

    public static <T, R> Iterable<R> flatMap(@Nonnull Iterable<T> source, @Nonnull Function<? super T, ? extends Iterable<R>> mapper) {
        return () -> StreamSupport.stream(source.spliterator(), false).flatMap(t2 -> {
            Iterable mappedIterable = (Iterable)mapper.apply(t2);
            return StreamSupport.stream(mappedIterable.spliterator(), false);
        }).iterator();
    }

    public static <T, R> Iterable<R> map(@Nonnull Iterable<T> source, @Nonnull Function<? super T, R> mapper) {
        return () -> StreamSupport.stream(source.spliterator(), false).map(mapper).iterator();
    }

    public static <T> Iterable<T> orElseOf(@Nonnull Iterable<T> source, @Nonnull T value) {
        return IterableHelpers.orElse(source, ImmutableList.of(value));
    }

    public static <T> Iterable<T> orElse(final @Nonnull Iterable<T> source, final @Nonnull Iterable<T> otherIterable) {
        return () -> new AbstractIterator<T>(){
            private Iterator<T> nestedIterator;
            private boolean isEmpty;
            private boolean hasSwitched;
            {
                this.nestedIterator = source.iterator();
                this.isEmpty = true;
                this.hasSwitched = false;
            }

            @Override
            protected T computeNext() {
                if (this.nestedIterator.hasNext()) {
                    this.isEmpty = false;
                    return this.nestedIterator.next();
                }
                if (this.isEmpty && !this.hasSwitched) {
                    this.nestedIterator = otherIterable.iterator();
                    this.hasSwitched = true;
                    return this.computeNext();
                }
                return this.endOfData();
            }
        };
    }
}

