/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithValue;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.metadata.expressions.ListKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.NullableArrayTypeUtils;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.values.EmptyValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class KeyExpressionExpansionVisitor
implements KeyExpressionVisitor<VisitorState, GraphExpansion> {
    private final Deque<VisitorState> states = new ArrayDeque<VisitorState>();

    @Override
    public VisitorState getCurrentState() {
        return this.states.peek();
    }

    public KeyExpressionExpansionVisitor push(VisitorState newState) {
        this.states.push(newState);
        return this;
    }

    public VisitorState pop() {
        return this.states.pop();
    }

    public <T> T pop(T t2) {
        this.pop();
        return t2;
    }

    @Override
    @Nonnull
    public final GraphExpansion visitExpression(@Nonnull KeyExpression keyExpression) {
        throw new UnsupportedOperationException("visitor method for this key expression is not implemented");
    }

    @Override
    @Nonnull
    public GraphExpansion visitExpression(@Nonnull EmptyKeyExpression emptyKeyExpression) {
        return GraphExpansion.ofResultColumn(Column.unnamedOf(EmptyValue.empty()));
    }

    @Override
    @Nonnull
    public GraphExpansion visitExpression(@Nonnull FieldKeyExpression fieldKeyExpression) {
        String fieldName = fieldKeyExpression.getFieldName();
        KeyExpression.FanType fanType = fieldKeyExpression.getFanType();
        VisitorState state = this.getCurrentState();
        List<String> fieldNamePrefix = state.getFieldNamePrefix();
        Quantifier.ForEach baseQuantifier = state.getBaseQuantifier();
        ImmutableCollection fieldNames = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fieldNamePrefix)).add(fieldName)).build();
        switch (fanType) {
            case FanOut: {
                Quantifier.ForEach childBase = fieldKeyExpression.explodeField(baseQuantifier, fieldNamePrefix);
                Value value = state.registerValue(childBase.getFlowedObjectValue());
                Column<Value> column = Column.unnamedOf(value);
                GraphExpansion childExpansion = state.isKey() && !state.isInternalExpansion() ? GraphExpansion.ofResultColumnAndPlaceholder(column, value.asPlaceholder(KeyExpressionExpansionVisitor.newParameterAlias())) : GraphExpansion.ofResultColumn(column);
                SelectExpression selectExpression = childExpansion.withBase(childBase).buildSelect();
                Quantifier.ForEach childQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)selectExpression));
                GraphExpansion.Sealed sealedChildExpansion = childExpansion.seal();
                return sealedChildExpansion.builderWithInheritedPlaceholders().pullUpQuantifier(childQuantifier).build();
            }
            case None: {
                Value value = state.registerValue(FieldValue.ofFieldNames(baseQuantifier.getFlowedObjectValue(), (List<String>)((Object)fieldNames)));
                if (state.isSelectStar()) {
                    if (state.isKey() && !state.isInternalExpansion()) {
                        return GraphExpansion.ofPlaceholder(value.asPlaceholder(KeyExpressionExpansionVisitor.newParameterAlias()));
                    }
                    return GraphExpansion.empty();
                }
                Column<Value> column = Column.unnamedOf(value);
                if (state.isKey() && !state.isInternalExpansion()) {
                    return GraphExpansion.ofResultColumnAndPlaceholder(column, value.asPlaceholder(KeyExpressionExpansionVisitor.newParameterAlias()));
                }
                return GraphExpansion.ofResultColumn(column);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GraphExpansion visitExpression(@Nonnull KeyExpressionWithValue keyExpressionWithValue) {
        VisitorState state = this.getCurrentState();
        Quantifier.ForEach baseQuantifier = state.getBaseQuantifier();
        Value value = state.registerValue(keyExpressionWithValue.toValue(baseQuantifier.getAlias(), baseQuantifier.getFlowedObjectType()));
        if (state.isKey() && !state.isInternalExpansion()) {
            return GraphExpansion.ofResultColumnAndPlaceholder(Column.unnamedOf(value), value.asPlaceholder(KeyExpressionExpansionVisitor.newParameterAlias()));
        }
        return GraphExpansion.ofResultColumn(Column.unnamedOf(value));
    }

    @Override
    @Nonnull
    public GraphExpansion visitExpression(@Nonnull FunctionKeyExpression functionKeyExpression) {
        VisitorState state = this.getCurrentState();
        KeyExpression arguments = functionKeyExpression.getArguments();
        GraphExpansion graphExpansion = this.pop(arguments.expand(this.push(state.forFunctionalExpansion())));
        List<Column<? extends Value>> resultColumns = graphExpansion.getResultColumns();
        Verify.verify(resultColumns.size() == arguments.getColumnSize());
        ImmutableList argumentValues = resultColumns.stream().map(Column::getValue).collect(ImmutableList.toImmutableList());
        GraphExpansion.Builder graphExpansionBuilder = GraphExpansion.builder().addAllQuantifiers(graphExpansion.getQuantifiers()).addAllPredicates(graphExpansion.getPredicates());
        Value value = state.registerValue(functionKeyExpression.toValue(argumentValues));
        if (state.isKey() && !state.isInternalExpansion()) {
            Placeholder placeholder = value.asPlaceholder(KeyExpressionExpansionVisitor.newParameterAlias());
            graphExpansionBuilder.addResultColumn(Column.unnamedOf(value)).addPredicate(placeholder).addPlaceholder(placeholder);
        } else {
            graphExpansionBuilder.addResultColumn(Column.unnamedOf(value));
        }
        return graphExpansionBuilder.build();
    }

    @Override
    @Nonnull
    public GraphExpansion visitExpression(@Nonnull KeyWithValueExpression keyWithValueExpression) {
        throw new RecordCoreException("expression should have been handled at top level", new Object[0]);
    }

    @Override
    @Nonnull
    public GraphExpansion visitExpression(@Nonnull NestingKeyExpression nestingKeyExpression) {
        VisitorState state = this.getCurrentState();
        List<String> fieldNamePrefix = state.getFieldNamePrefix();
        Quantifier.ForEach baseQuantifier = state.getBaseQuantifier();
        FieldKeyExpression parent = nestingKeyExpression.getParent();
        KeyExpression child = nestingKeyExpression.getChild();
        switch (parent.getFanType()) {
            case None: {
                ImmutableCollection newPrefix = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fieldNamePrefix)).add(parent.getFieldName())).build();
                if (NullableArrayTypeUtils.isArrayWrapper(nestingKeyExpression)) {
                    RecordKeyExpressionProto.KeyExpression childProto = nestingKeyExpression.getChild().toKeyExpression();
                    if (childProto.hasNesting()) {
                        RecordKeyExpressionProto.Nesting.Builder newNestingBuilder = RecordKeyExpressionProto.Nesting.newBuilder().setParent(parent.toProto().toBuilder().setFanType(RecordKeyExpressionProto.Field.FanType.FAN_OUT)).setChild(childProto.getNesting().getChild());
                        return this.visitExpression(new NestingKeyExpression(newNestingBuilder.build()));
                    }
                    return this.visitExpression(new FieldKeyExpression(parent.toProto().toBuilder().setFanType(RecordKeyExpressionProto.Field.FanType.FAN_OUT).build()));
                }
                return this.pop(child.expand(this.push(state.withFieldNamePrefix((List<String>)((Object)newPrefix)))));
            }
            case FanOut: {
                Quantifier.ForEach childBaseQuantifier = parent.explodeField(baseQuantifier, fieldNamePrefix);
                GraphExpansion childExpansion = this.pop(child.expand(this.push(state.withBaseQuantifier(childBaseQuantifier).withFieldNamePrefix(ImmutableList.of()))));
                if (state.isSelectStar()) {
                    GraphExpansion baseExpansion = GraphExpansion.builder().pullUpQuantifier(childBaseQuantifier).build();
                    GraphExpansion baseAndChildExpansion = GraphExpansion.ofOthers(baseExpansion, childExpansion);
                    GraphExpansion.Sealed sealedBaseAndChildExpansion = baseAndChildExpansion.seal();
                    SelectExpression selectExpression = sealedBaseAndChildExpansion.buildSelect();
                    Quantifier.ForEach childQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)selectExpression));
                    return sealedBaseAndChildExpansion.builderWithInheritedPlaceholders().pullUpQuantifier(childQuantifier).build();
                }
                GraphExpansion.Builder baseAndChildExpansionBuilder = GraphExpansion.builder().addAllPredicates(childExpansion.getPredicates()).addAllPlaceholders(childExpansion.getPlaceholders());
                baseAndChildExpansionBuilder.pullUpQuantifier(childBaseQuantifier);
                childExpansion.getQuantifiers().forEach(baseAndChildExpansionBuilder::pullUpQuantifier);
                GraphExpansion baseAndChildExpansion = baseAndChildExpansionBuilder.build();
                GraphExpansion.Sealed sealedBaseAndChildExpansion = baseAndChildExpansion.seal();
                SelectExpression selectExpression = sealedBaseAndChildExpansion.buildSelect();
                Quantifier.ForEach childQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)selectExpression));
                Value childResultValue = selectExpression.getResultValue();
                ImmutableList<Column<? extends Value>> pulledUpExpansionColumns = KeyExpressionExpansionVisitor.pullUpResultColumns(childExpansion, childResultValue, childQuantifier);
                ImmutableList<Placeholder> pulledUpPlaceholders = KeyExpressionExpansionVisitor.pullUpPlaceholders(childExpansion, childResultValue, childQuantifier);
                return GraphExpansion.builder().addQuantifier(childQuantifier).addAllPredicates(pulledUpPlaceholders).addAllPlaceholders(pulledUpPlaceholders).addAllResultColumns(pulledUpExpansionColumns).build();
            }
        }
        throw new RecordCoreException("unsupported fan type", new Object[0]);
    }

    @Nonnull
    private static ImmutableList<Placeholder> pullUpPlaceholders(@Nonnull GraphExpansion childExpansion, @Nonnull Value childResultValue, @Nonnull Quantifier childQuantifier) {
        LinkedIdentityMap childExpansionPlaceholderValuesMap = childExpansion.getPlaceholders().stream().collect(Collectors.toMap(PredicateWithValueAndRanges::getValue, Placeholder::getParameterAlias, (l, r) -> {
            if (l.equals(r)) {
                return l;
            }
            throw new RecordCoreException("ambiguous values in placeholder map", new Object[0]);
        }, LinkedIdentityMap::new));
        Set childExpansionPlaceholderValues = childExpansionPlaceholderValuesMap.keySet();
        Map<Value, Value> pulledUpPlaceholderValuesMap = childResultValue.pullUp(childExpansionPlaceholderValues, EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), childQuantifier.getAlias());
        return childExpansionPlaceholderValues.stream().map(value -> {
            if (!pulledUpPlaceholderValuesMap.containsKey(value)) {
                throw new RecordCoreException("could not pull expansion value " + String.valueOf(value), new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, value});
            }
            Value pulledUpValue = (Value)pulledUpPlaceholderValuesMap.get(value);
            CorrelationIdentifier parameterAlias = Objects.requireNonNull((CorrelationIdentifier)childExpansionPlaceholderValuesMap.get(value));
            return Placeholder.newInstanceWithoutRanges(pulledUpValue, parameterAlias);
        }).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private static ImmutableList<Column<? extends Value>> pullUpResultColumns(@Nonnull GraphExpansion childExpansion, @Nonnull Value childResultValue, @Nonnull Quantifier childQuantifier) {
        ImmutableList childExpansionValues = childExpansion.getResultColumns().stream().map(Column::getValue).collect(ImmutableList.toImmutableList());
        Map<Value, Value> pulledUpValuesMap = childResultValue.pullUp(childExpansionValues, EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), childQuantifier.getAlias());
        return childExpansionValues.stream().map(value -> {
            if (!pulledUpValuesMap.containsKey(value)) {
                throw new RecordCoreException("could not pull expansion value " + String.valueOf(value), new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, value});
            }
            return (Value)pulledUpValuesMap.get(value);
        }).map(Column::unnamedOf).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nonnull
    public GraphExpansion visitExpression(@Nonnull ThenKeyExpression thenKeyExpression) {
        ImmutableList.Builder expandedPredicatesBuilder = ImmutableList.builder();
        VisitorState state = this.getCurrentState();
        int currentOrdinal = state.getCurrentOrdinal();
        for (KeyExpression child : thenKeyExpression.getChildren()) {
            GraphExpansion graphExpansion = this.pop(child.expand(this.push(state.withCurrentOrdinal(currentOrdinal))));
            currentOrdinal += child.getColumnSize();
            expandedPredicatesBuilder.add(graphExpansion);
        }
        return GraphExpansion.ofOthers((List<GraphExpansion>)((Object)expandedPredicatesBuilder.build()));
    }

    @Override
    @Nonnull
    public GraphExpansion visitExpression(@Nonnull ListKeyExpression listKeyExpression) {
        throw new UnsupportedOperationException("visitor method for this key expression is not implemented");
    }

    protected static CorrelationIdentifier newParameterAlias() {
        return CorrelationIdentifier.uniqueId(PredicateWithValueAndRanges.class);
    }

    public static class VisitorState
    implements KeyExpressionVisitor.State {
        @Nonnull
        private final Quantifier.ForEach baseQuantifier;
        @Nonnull
        private final List<String> fieldNamePrefix;
        private final int splitPointForValues;
        private final int currentOrdinal;
        @Nonnull
        private final List<Value> keyValues;
        @Nonnull
        private final List<Value> valueValues;
        private final boolean isInternalExpansion;
        private final boolean isSelectStar;

        private VisitorState(@Nonnull List<Value> keyOrdinalMap, @Nonnull List<Value> valueValues, @Nonnull Quantifier.ForEach baseQuantifier, @Nonnull List<String> fieldNamePrefix, int splitPointForValues, int currentOrdinal, boolean isInternalExpansion, boolean isSelectStar) {
            this.keyValues = keyOrdinalMap;
            this.valueValues = valueValues;
            this.baseQuantifier = baseQuantifier;
            this.fieldNamePrefix = fieldNamePrefix;
            this.splitPointForValues = splitPointForValues;
            this.currentOrdinal = currentOrdinal;
            this.isInternalExpansion = isInternalExpansion;
            this.isSelectStar = isSelectStar;
        }

        @Nonnull
        public List<Value> getKeyValues() {
            return this.keyValues;
        }

        @Nonnull
        public List<Value> getValueValues() {
            return this.valueValues;
        }

        @Nonnull
        public Quantifier.ForEach getBaseQuantifier() {
            return this.baseQuantifier;
        }

        @Nonnull
        public List<String> getFieldNamePrefix() {
            return this.fieldNamePrefix;
        }

        public int getSplitPointForValues() {
            return this.splitPointForValues;
        }

        public int getCurrentOrdinal() {
            return this.currentOrdinal;
        }

        public boolean isInternalExpansion() {
            return this.isInternalExpansion;
        }

        public boolean isSelectStar() {
            return this.isSelectStar;
        }

        public boolean isKey() {
            return this.splitPointForValues < 0 || this.getCurrentOrdinal() < this.splitPointForValues;
        }

        @Nonnull
        public Value registerValue(@Nonnull Value value) {
            if (!this.isInternalExpansion()) {
                if (this.isKey()) {
                    this.keyValues.add(value);
                } else {
                    this.valueValues.add(value);
                }
            }
            return value;
        }

        public VisitorState withBaseQuantifier(@Nonnull Quantifier.ForEach baseQuantifier) {
            return new VisitorState(this.keyValues, this.valueValues, baseQuantifier, this.fieldNamePrefix, this.splitPointForValues, this.currentOrdinal, this.isInternalExpansion, this.isSelectStar);
        }

        public VisitorState withFieldNamePrefix(@Nonnull List<String> fieldNamePrefix) {
            return new VisitorState(this.keyValues, this.valueValues, this.baseQuantifier, fieldNamePrefix, this.splitPointForValues, this.currentOrdinal, this.isInternalExpansion, this.isSelectStar);
        }

        public VisitorState withSplitPointForValues(int splitPointForValues) {
            return new VisitorState(this.keyValues, this.valueValues, this.baseQuantifier, this.fieldNamePrefix, splitPointForValues, this.currentOrdinal, this.isInternalExpansion, this.isSelectStar);
        }

        public VisitorState withCurrentOrdinal(int currentOrdinal) {
            return new VisitorState(this.keyValues, this.valueValues, this.baseQuantifier, this.fieldNamePrefix, this.splitPointForValues, currentOrdinal, this.isInternalExpansion, this.isSelectStar);
        }

        public VisitorState withIsInternalExpansion(boolean isInternalExpansion) {
            return new VisitorState(this.keyValues, this.valueValues, this.baseQuantifier, this.fieldNamePrefix, this.splitPointForValues, this.currentOrdinal, isInternalExpansion, this.isSelectStar);
        }

        public VisitorState forFunctionalExpansion() {
            return new VisitorState(this.keyValues, this.valueValues, this.baseQuantifier, this.fieldNamePrefix, this.splitPointForValues, this.currentOrdinal, true, false);
        }

        public static VisitorState forQueries(@Nonnull List<Value> valueValues, @Nonnull Quantifier.ForEach baseQuantifier, @Nonnull List<String> fieldNamePrefix) {
            return new VisitorState(Lists.newArrayList(), valueValues, baseQuantifier, fieldNamePrefix, 0, 0, false, false);
        }

        public static VisitorState of(@Nonnull List<Value> keyValues, @Nonnull List<Value> valueValues, @Nonnull Quantifier.ForEach baseQuantifier, @Nonnull List<String> fieldNamePrefix, int splitPointForValues, int currentOrdinal, boolean isInternalExpansion, boolean isSelectStar) {
            return new VisitorState(keyValues, valueValues, baseQuantifier, fieldNamePrefix, splitPointForValues, currentOrdinal, isInternalExpansion, isSelectStar);
        }
    }
}

