/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.google.common.base.Equivalence;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class LinkedIdentityMap<K, V>
extends AbstractMap<K, V> {
    @Nonnull
    private static final Equivalence<Object> identity = Equivalence.identity();
    @Nonnull
    private final Map<Equivalence.Wrapper<K>, V> map = Maps.newLinkedHashMap();
    @Nonnull
    private final Supplier<Set<Map.Entry<K, V>>> entrySetSupplier = Suppliers.memoize(this::computeEntrySet);

    public LinkedIdentityMap() {
        this(ImmutableMap.of());
    }

    public LinkedIdentityMap(@Nonnull Map<K, V> sourceMap) {
        this.putAll(sourceMap);
    }

    @Nonnull
    private Set<Map.Entry<K, V>> computeEntrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<Equivalence.Wrapper<K>, V>> iterator;
                    {
                        this.iterator = LinkedIdentityMap.this.map.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    @Nonnull
                    public Map.Entry<K, V> next() {
                        Map.Entry next = this.iterator.next();
                        return new AbstractMap.SimpleEntry(next.getKey().get(), next.getValue());
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return LinkedIdentityMap.this.map.size();
            }

            @Override
            public boolean isEmpty() {
                return LinkedIdentityMap.this.map.isEmpty();
            }

            @Override
            public void clear() {
                LinkedIdentityMap.this.map.clear();
            }

            @Override
            public boolean contains(Object k) {
                return LinkedIdentityMap.this.map.containsKey(identity.wrap(k));
            }
        };
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(identity.wrap(key));
    }

    @Override
    public V get(Object key) {
        return this.map.get(identity.wrap(key));
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(identity.wrap(key), value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySetSupplier.get();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.map.replaceAll((wrappedK, v) -> function.apply((Object)wrappedK.get(), (Object)v));
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(identity.wrap(key));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LinkedIdentityMap)) {
            return false;
        }
        return this.map.equals(((LinkedIdentityMap)o).map);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

