/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.annotation.Nonnull;

public class LinkedIdentitySet<T>
extends AbstractSet<T> {
    @Nonnull
    private static final Equivalence<Object> identity = Equivalence.identity();
    @Nonnull
    private final Set<Equivalence.Wrapper<T>> members = Sets.newLinkedHashSet();

    public LinkedIdentitySet() {
    }

    public LinkedIdentitySet(@Nonnull Collection<? extends T> collection) {
        collection.forEach(element -> this.members.add(identity.wrap(element)));
    }

    @Override
    public boolean add(@Nonnull T expression) {
        return this.members.add(identity.wrap(expression));
    }

    public void addAll(@Nonnull LinkedIdentitySet<T> otherSet) {
        this.members.addAll(otherSet.members);
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        return this.members.contains(identity.wrap(o));
    }

    @Override
    public boolean remove(@Nonnull Object expression) {
        return this.members.remove(identity.wrap(expression));
    }

    @Override
    public void clear() {
        this.members.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    @Override
    public int size() {
        return this.members.size();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            @Nonnull
            private final Iterator<Equivalence.Wrapper<T>> innerIterator;
            {
                this.innerIterator = LinkedIdentitySet.this.members.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.innerIterator.hasNext();
            }

            @Override
            public T next() {
                return this.innerIterator.next().get();
            }

            @Override
            public void remove() {
                this.innerIterator.remove();
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LinkedIdentitySet)) {
            return false;
        }
        return this.members.equals(((LinkedIdentitySet)o).members);
    }

    @Override
    public int hashCode() {
        return this.members.hashCode();
    }

    public static <T> Collector<T, ?, Set<T>> toLinkedIdentitySet() {
        return new SetCollector(Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH)));
    }

    public static <T> LinkedIdentitySet<T> of(T ... args) {
        LinkedIdentitySet<T> newSet = new LinkedIdentitySet<T>();
        Collections.addAll(newSet, args);
        return newSet;
    }

    public static <T> LinkedIdentitySet<T> copyOf(@Nonnull Iterable<T> iterable) {
        if (iterable instanceof LinkedIdentitySet) {
            return (LinkedIdentitySet)iterable;
        }
        LinkedIdentitySet<T> newSet = new LinkedIdentitySet<T>();
        iterable.forEach(newSet::add);
        return newSet;
    }

    private static class SetCollector<T>
    implements Collector<T, LinkedIdentitySet<T>, Set<T>> {
        private final Set<Collector.Characteristics> characteristics;

        private SetCollector(@Nonnull Set<Collector.Characteristics> characteristics) {
            this.characteristics = characteristics;
        }

        @Override
        public BiConsumer<LinkedIdentitySet<T>, T> accumulator() {
            return LinkedIdentitySet::add;
        }

        @Override
        public Supplier<LinkedIdentitySet<T>> supplier() {
            return LinkedIdentitySet::new;
        }

        @Override
        public BinaryOperator<LinkedIdentitySet<T>> combiner() {
            return (left, right) -> {
                if (left.size() < right.size()) {
                    right.addAll(left);
                    return right;
                }
                left.addAll(right);
                return left;
            };
        }

        @Override
        public Function<LinkedIdentitySet<T>, Set<T>> finisher() {
            return s2 -> s2;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

