/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.planprotos.PMacroFunctionValue;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.SemanticException;
import com.apple.foundationdb.record.query.plan.cascades.UserDefinedFunction;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class MacroFunction
extends UserDefinedFunction {
    @Nonnull
    private final Value bodyValue;
    @Nonnull
    private final List<CorrelationIdentifier> parameterIdentifiers;

    public MacroFunction(@Nonnull String functionName, @Nonnull List<QuantifiedObjectValue> parameters, @Nonnull Value bodyValue) {
        super(functionName, parameters.stream().map(QuantifiedObjectValue::getResultType).collect(Collectors.toUnmodifiableList()));
        this.parameterIdentifiers = parameters.stream().map(QuantifiedObjectValue::getAlias).collect(Collectors.toList());
        this.bodyValue = bodyValue;
    }

    @Override
    @Nonnull
    public Value encapsulate(@Nonnull List<? extends Typed> arguments) {
        SemanticException.check(arguments.size() == this.parameterTypes.size(), SemanticException.ErrorCode.FUNCTION_UNDEFINED_FOR_GIVEN_ARGUMENT_TYPES, "argument length doesn't match with function definition");
        RegularTranslationMap.Builder translationMapBuilder = TranslationMap.regularBuilder();
        for (int i = 0; i < arguments.size(); ++i) {
            int finalI = i;
            SemanticException.check(arguments.get(finalI).getResultType().equals(this.parameterTypes.get(i)), SemanticException.ErrorCode.FUNCTION_UNDEFINED_FOR_GIVEN_ARGUMENT_TYPES, "argument type doesn't match with function definition");
            translationMapBuilder.when(this.parameterIdentifiers.get(finalI)).then((sourceAlias, leafValue) -> (Value)arguments.get(finalI));
        }
        return this.bodyValue.translateCorrelations(translationMapBuilder.build());
    }

    @Override
    @Nonnull
    public RecordMetaDataProto.PUserDefinedFunction toProto(@Nonnull PlanSerializationContext serializationContext) {
        PMacroFunctionValue.Builder builder = PMacroFunctionValue.newBuilder();
        for (int i = 0; i < this.parameterTypes.size(); ++i) {
            builder.addArguments(QuantifiedObjectValue.of(this.parameterIdentifiers.get(i), (Type)this.parameterTypes.get(i)).toValueProto(serializationContext));
        }
        return RecordMetaDataProto.PUserDefinedFunction.newBuilder().setMacroFunction(builder.setFunctionName(this.functionName).setBody(this.bodyValue.toValueProto(serializationContext))).build();
    }

    @Override
    @Nonnull
    public Typed encapsulate(@Nonnull Map<String, ? extends Typed> namedArguments) {
        throw new RecordCoreException("macro functions do not support named argument calling conventions", new Object[0]);
    }

    @Nonnull
    public static MacroFunction fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PMacroFunctionValue functionValue) {
        return new MacroFunction(functionValue.getFunctionName(), functionValue.getArgumentsList().stream().map(pvalue -> (QuantifiedObjectValue)Value.fromValueProto(serializationContext, pvalue)).collect(Collectors.toList()), Value.fromValueProto(serializationContext, functionValue.getBody()));
    }

    public static class Deserializer
    implements PlanDeserializer<PMacroFunctionValue, MacroFunction> {
        @Override
        @Nonnull
        public Class<PMacroFunctionValue> getProtoMessageClass() {
            return PMacroFunctionValue.class;
        }

        @Override
        @Nonnull
        public MacroFunction fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PMacroFunctionValue macroFunctionValue) {
            return MacroFunction.fromProto(serializationContext, macroFunctionValue);
        }
    }
}

