/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PlanContext;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.ScalarTranslationVisitor;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ComparisonCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.OrderingValueComputationRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface MatchCandidate {
    @Nonnull
    public String getName();

    @Nonnull
    public Traversal getTraversal();

    @Nonnull
    public List<CorrelationIdentifier> getSargableAliases();

    @Nonnull
    public List<CorrelationIdentifier> getOrderingAliases();

    @Nonnull
    public KeyExpression getFullKeyExpression();

    public boolean createsDuplicates();

    default public Map<CorrelationIdentifier, ComparisonRange> computeBoundParameterPrefixMap(@Nonnull MatchInfo matchInfo) {
        HashMap<CorrelationIdentifier, ComparisonRange> prefixMap = Maps.newHashMap();
        Map<CorrelationIdentifier, ComparisonRange> parameterBindingMap = matchInfo.getRegularMatchInfo().getParameterBindingMap();
        List<CorrelationIdentifier> parameters = this.getSargableAliases();
        block4: for (CorrelationIdentifier parameter : parameters) {
            Objects.requireNonNull(parameter);
            ComparisonRange comparisonRange = parameterBindingMap.get(parameter);
            if (comparisonRange == null) {
                return ImmutableMap.copyOf(prefixMap);
            }
            if (prefixMap.containsKey(parameter)) {
                Verify.verify(((ComparisonRange)prefixMap.get(parameter)).equals(comparisonRange));
                continue;
            }
            switch (comparisonRange.getRangeType()) {
                case EQUALITY: {
                    prefixMap.put(parameter, comparisonRange);
                    continue block4;
                }
                case INEQUALITY: {
                    prefixMap.put(parameter, comparisonRange);
                    return ImmutableMap.copyOf(prefixMap);
                }
            }
            return ImmutableMap.copyOf(prefixMap);
        }
        return ImmutableMap.copyOf(prefixMap);
    }

    @Nonnull
    public List<OrderingPart.MatchedOrderingPart> computeMatchedOrderingParts(@Nonnull MatchInfo var1, @Nonnull List<CorrelationIdentifier> var2, boolean var3);

    @Nonnull
    public Ordering computeOrderingFromScanComparisons(@Nonnull ScanComparisons var1, boolean var2, boolean var3);

    @Nullable
    default public PullUp.UnificationPullUp prepareForUnification(@Nonnull PartialMatch partialMatch, @Nonnull CorrelationIdentifier topAlias, @Nonnull CorrelationIdentifier topCandidateAlias) {
        return null;
    }

    default public RecordQueryPlan toEquivalentPlan(@Nonnull PartialMatch partialMatch, @Nonnull PlanContext planContext, @Nonnull Memoizer memoizer, boolean reverseScanOrder) {
        MatchInfo matchInfo = partialMatch.getMatchInfo();
        Map<CorrelationIdentifier, ComparisonRange> prefixMap = this.computeBoundParameterPrefixMap(matchInfo);
        ImmutableList.Builder comparisonRangesForScanBuilder = ImmutableList.builder();
        for (CorrelationIdentifier parameterAlias : this.getSargableAliases()) {
            if (!prefixMap.containsKey(parameterAlias)) break;
            comparisonRangesForScanBuilder.add(prefixMap.get(parameterAlias));
        }
        return this.toEquivalentPlan(partialMatch, planContext, memoizer, (List<ComparisonRange>)((Object)comparisonRangesForScanBuilder.build()), reverseScanOrder);
    }

    @Nonnull
    public RecordQueryPlan toEquivalentPlan(@Nonnull PartialMatch var1, @Nonnull PlanContext var2, @Nonnull Memoizer var3, @Nonnull List<ComparisonRange> var4, boolean var5);

    @Nonnull
    default public SetMultimap<Reference, RelationalExpression> findReferencingExpressions(@Nonnull ImmutableList<? extends Reference> references) {
        Traversal traversal = this.getTraversal();
        SetMultimap<Reference, RelationalExpression> refToExpressionMap = Multimaps.newSetMultimap(new LinkedIdentityMap(), LinkedIdentitySet::new);
        for (Reference reference : references) {
            Set<PartialMatch> partialMatchesForCandidate = reference.getPartialMatchesForCandidate(this);
            for (PartialMatch partialMatch : partialMatchesForCandidate) {
                for (Traversal.ReferencePath parentReferencePath : traversal.getParentRefPaths(partialMatch.getCandidateRef())) {
                    refToExpressionMap.put(parentReferencePath.getReference(), parentReferencePath.getExpression());
                }
            }
        }
        return refToExpressionMap;
    }

    @Nonnull
    public List<RecordType> getQueriedRecordTypes();

    public int getColumnSize();

    public boolean isUnique();

    @Nonnull
    default public Set<String> getQueriedRecordTypeNames() {
        return this.getQueriedRecordTypes().stream().map(RecordType::getName).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public static Optional<List<Value>> computePrimaryKeyValuesMaybe(@Nullable KeyExpression primaryKey, @Nonnull Type flowedType) {
        if (primaryKey == null) {
            return Optional.empty();
        }
        return Optional.of(ScalarTranslationVisitor.translateKeyExpression(primaryKey, flowedType));
    }

    @Nonnull
    public static Optional<NonnullPair<Value, Comparisons.Comparison>> simplifyComparisonMaybe(@Nonnull Value value, @Nonnull Comparisons.Comparison comparison) {
        OrderingPart.ProvidedOrderingPart providedOrderingPart = value.deriveOrderingPart(EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), OrderingPart.ProvidedOrderingPart::new, OrderingValueComputationRuleSet.usingProvidedOrderingParts());
        Value simplifiedValue = providedOrderingPart.getValue();
        if (simplifiedValue == value) {
            return Optional.of(NonnullPair.of(value, comparison));
        }
        Optional<NonnullPair<ComparisonCompensation, QueryPlanConstraint>> compensationPairOptional = simplifiedValue.matchAndCompensateComparisonMaybe(value, ValueEquivalence.empty());
        if (compensationPairOptional.isEmpty()) {
            return Optional.empty();
        }
        NonnullPair<ComparisonCompensation, QueryPlanConstraint> compensationPair = compensationPairOptional.get();
        if (!(comparison instanceof Comparisons.ValueComparison)) {
            return Optional.empty();
        }
        Comparisons.ValueComparison valueComparison = (Comparisons.ValueComparison)comparison;
        Value comparedValue = valueComparison.getValue();
        Optional<Value> simplifiedComparedValueOptional = compensationPair.getLeft().unapplyMaybe(comparedValue);
        if (simplifiedComparedValueOptional.isEmpty()) {
            return Optional.empty();
        }
        Comparisons.ValueComparison simplifiedComparison = valueComparison.withValue(simplifiedComparedValueOptional.get());
        return Optional.of(NonnullPair.of(simplifiedValue, simplifiedComparison));
    }
}

