/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.plan.cascades.AccessHint;
import com.apple.foundationdb.record.query.plan.cascades.AccessHints;
import com.apple.foundationdb.record.query.plan.cascades.AggregateIndexExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.ExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.IndexAccessHint;
import com.apple.foundationdb.record.query.plan.cascades.IndexExpansionInfo;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.PrimaryAccessExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.PrimaryAccessHint;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.ValueIndexExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.FullUnorderedScanExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalTypeFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public final class MatchCandidateExpansion {
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(MatchCandidateExpansion.class);

    private MatchCandidateExpansion() {
    }

    @Nonnull
    public static <T> Iterable<T> optionalToIterable(@Nonnull Optional<T> optional) {
        return optional.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    @Nonnull
    public static Iterable<MatchCandidate> expandValueIndexMatchCandidate(@Nonnull RecordMetaData metaData, @Nonnull Index index, boolean isReverse) {
        IndexExpansionInfo info = IndexExpansionInfo.createInfo(metaData, index, isReverse);
        return MatchCandidateExpansion.optionalToIterable(MatchCandidateExpansion.expandValueIndexMatchCandidate(info));
    }

    @Nonnull
    public static Optional<MatchCandidate> expandValueIndexMatchCandidate(@Nonnull IndexExpansionInfo info) {
        return MatchCandidateExpansion.expandIndexMatchCandidate(info, info.getCommonPrimaryKeyForTypes(), new ValueIndexExpansionVisitor(info.getIndex(), info.getIndexedRecordTypes()));
    }

    @Nonnull
    public static Iterable<MatchCandidate> expandAggregateIndexMatchCandidate(@Nonnull RecordMetaData metaData, @Nonnull Index index, boolean isReverse) {
        IndexExpansionInfo info = IndexExpansionInfo.createInfo(metaData, index, isReverse);
        return MatchCandidateExpansion.optionalToIterable(MatchCandidateExpansion.expandAggregateIndexMatchCandidate(info));
    }

    @Nonnull
    public static Optional<MatchCandidate> expandAggregateIndexMatchCandidate(@Nonnull IndexExpansionInfo info) {
        return MatchCandidateExpansion.expandIndexMatchCandidate(info, null, new AggregateIndexExpansionVisitor(info.getIndex(), info.getIndexedRecordTypes()));
    }

    @Nonnull
    public static Optional<MatchCandidate> expandIndexMatchCandidate(@Nonnull IndexExpansionInfo info, @Nullable KeyExpression commonPrimaryKey, @Nonnull ExpansionVisitor<?> expansionVisitor) {
        Reference baseRef = MatchCandidateExpansion.createBaseRef(info, new IndexAccessHint(info.getIndexName()));
        try {
            return Optional.of(expansionVisitor.expand(() -> Quantifier.forEach(baseRef), commonPrimaryKey, info.isReverse()));
        }
        catch (UnsupportedOperationException uOE) {
            if (LOGGER.isDebugEnabled()) {
                String message = KeyValueLogMessage.of("unsupported index", "reason", uOE.getMessage(), "indexName", info.getIndexName());
                LOGGER.debug(message, uOE);
            }
            return Optional.empty();
        }
    }

    @Nonnull
    public static Optional<MatchCandidate> fromPrimaryDefinition(@Nonnull RecordMetaData metaData, @Nonnull Set<String> queriedRecordTypeNames, @Nullable KeyExpression primaryKey, boolean isReverse) {
        if (primaryKey != null) {
            Collection<RecordType> availableRecordTypes = metaData.getRecordTypes().values();
            ImmutableList<RecordType> queriedRecordTypes = availableRecordTypes.stream().filter(recordType -> queriedRecordTypeNames.contains(recordType.getName())).collect(ImmutableList.toImmutableList());
            Reference baseRef = MatchCandidateExpansion.createBaseRef(metaData.getRecordTypes().keySet(), queriedRecordTypeNames, queriedRecordTypes, new PrimaryAccessHint());
            PrimaryAccessExpansionVisitor expansionVisitor = new PrimaryAccessExpansionVisitor(availableRecordTypes, queriedRecordTypes);
            return Optional.of(expansionVisitor.expand(() -> Quantifier.forEach(baseRef), primaryKey, isReverse));
        }
        return Optional.empty();
    }

    @Nonnull
    private static Reference createBaseRef(@Nonnull IndexExpansionInfo info, @Nonnull AccessHint accessHint) {
        return MatchCandidateExpansion.createBaseRef(info.getAvailableRecordTypeNames(), info.getIndexedRecordTypeNames(), info.getIndexedRecordTypes(), accessHint);
    }

    @Nonnull
    private static Reference createBaseRef(@Nonnull Set<String> availableRecordTypeNames, @Nonnull Set<String> queriedRecordTypeNames, @Nonnull Collection<RecordType> queriedRecordTypes, @Nonnull AccessHint accessHint) {
        Quantifier.ForEach quantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)new FullUnorderedScanExpression(availableRecordTypeNames, new Type.AnyRecord(false), new AccessHints(accessHint))));
        return Reference.initialOf((RelationalExpression)new LogicalTypeFilterExpression(queriedRecordTypeNames, quantifier, Type.Record.fromFieldDescriptorsMap(RecordMetaData.getFieldDescriptorMapFromTypes(queriedRecordTypes))));
    }
}

