/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.GroupByMappings;
import com.apple.foundationdb.record.query.plan.cascades.IdentityBiMap;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMap;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.MaxMatchMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.google.common.base.Equivalence;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface MatchInfo {
    @Nonnull
    public List<OrderingPart.MatchedOrderingPart> getMatchedOrderingParts();

    @Nonnull
    public MaxMatchMap getMaxMatchMap();

    public boolean isAdjusted();

    default public boolean isRegular() {
        return !this.isAdjusted();
    }

    @Nonnull
    public RegularMatchInfo getRegularMatchInfo();

    @Nonnull
    public Map<QueryPredicate, PredicateMultiMap.PredicateMapping> collectPulledUpPredicateMappings(@Nonnull RelationalExpression var1, @Nonnull Set<QueryPredicate> var2);

    @Nonnull
    public GroupByMappings getGroupByMappings();

    @Nonnull
    default public AdjustedBuilder adjustedBuilder() {
        return new AdjustedBuilder(this, this.getMatchedOrderingParts(), this.getMaxMatchMap(), this.getGroupByMappings());
    }

    @Nonnull
    default public GroupByMappings adjustGroupByMappings(@Nonnull Quantifier candidateQuantifier) {
        return this.adjustGroupByMappings(candidateQuantifier.getAlias(), candidateQuantifier.getRangesOver().get());
    }

    @Nonnull
    default public GroupByMappings adjustGroupByMappings(@Nonnull CorrelationIdentifier candidateAlias, @Nonnull RelationalExpression candidateLowerExpression) {
        GroupByMappings groupByMappings = this.getGroupByMappings();
        BiMap<Value, Value> matchedGroupingsMap = groupByMappings.getMatchedGroupingsMap();
        ImmutableBiMap<Value, Value> adjustedMatchedGroupingsMap = MatchInfo.adjustMatchedValueMap(candidateAlias, candidateLowerExpression, matchedGroupingsMap);
        BiMap<Value, Value> matchedAggregatesMap = groupByMappings.getMatchedAggregatesMap();
        ImmutableBiMap<Value, Value> adjustedMatchedAggregatesMap = MatchInfo.adjustMatchedValueMap(candidateAlias, candidateLowerExpression, matchedAggregatesMap);
        return GroupByMappings.of(adjustedMatchedGroupingsMap, adjustedMatchedAggregatesMap, groupByMappings.getUnmatchedAggregatesMap());
    }

    @Nonnull
    public static ImmutableBiMap<Value, Value> adjustMatchedValueMap(@Nonnull CorrelationIdentifier candidateAlias, @Nonnull RelationalExpression candidateLowerExpression, @Nonnull Map<Value, Value> matchedValueMap) {
        ImmutableBiMap.Builder adjustedMatchedAggregateMapBuilder = ImmutableBiMap.builder();
        for (Map.Entry<Value, Value> matchedAggregateMapEntry : matchedValueMap.entrySet()) {
            Value queryAggregateValue = matchedAggregateMapEntry.getKey();
            Value candidateAggregateValue = matchedAggregateMapEntry.getValue();
            Value candidateLowerResultValue = candidateLowerExpression.getResultValue();
            Map<Value, Value> candidatePullUpMap = candidateLowerResultValue.pullUp(ImmutableList.of(candidateAggregateValue), EvaluationContext.empty(), AliasMap.emptyMap(), Sets.difference(candidateAggregateValue.getCorrelatedToWithoutChildren(), candidateLowerExpression.getCorrelatedTo()), candidateAlias);
            Value pulledUpCandidateAggregateValue = candidatePullUpMap.get(candidateAggregateValue);
            if (pulledUpCandidateAggregateValue == null) continue;
            adjustedMatchedAggregateMapBuilder.put(queryAggregateValue, pulledUpCandidateAggregateValue);
        }
        return adjustedMatchedAggregateMapBuilder.build();
    }

    public static class AdjustedBuilder {
        @Nonnull
        private final MatchInfo underlying;
        @Nonnull
        private List<OrderingPart.MatchedOrderingPart> matchedOrderingParts;
        @Nonnull
        private MaxMatchMap maxMatchMap;
        @Nonnull
        private GroupByMappings groupByMappings;

        private AdjustedBuilder(@Nonnull MatchInfo underlying, @Nonnull List<OrderingPart.MatchedOrderingPart> matchedOrderingParts, @Nonnull MaxMatchMap maxMatchMap, @Nonnull GroupByMappings groupByMappings) {
            this.underlying = underlying;
            this.matchedOrderingParts = matchedOrderingParts;
            this.maxMatchMap = maxMatchMap;
            this.groupByMappings = groupByMappings;
        }

        @Nonnull
        public List<OrderingPart.MatchedOrderingPart> getMatchedOrderingParts() {
            return this.matchedOrderingParts;
        }

        public AdjustedBuilder setMatchedOrderingParts(@Nonnull List<OrderingPart.MatchedOrderingPart> matchedOrderingParts) {
            this.matchedOrderingParts = matchedOrderingParts;
            return this;
        }

        @Nonnull
        public AdjustedBuilder setGroupByMappings(@Nonnull GroupByMappings groupByMappings) {
            this.groupByMappings = groupByMappings;
            return this;
        }

        @Nonnull
        public MaxMatchMap getMaxMatchMap() {
            return this.maxMatchMap;
        }

        @Nonnull
        public AdjustedBuilder setMaxMatchMap(@Nonnull MaxMatchMap maxMatchMap) {
            this.maxMatchMap = maxMatchMap;
            return this;
        }

        @Nonnull
        public GroupByMappings getGroupByMappings() {
            return this.groupByMappings;
        }

        @Nonnull
        public MatchInfo build() {
            return new AdjustedMatchInfo(this.underlying, this.matchedOrderingParts, this.maxMatchMap, this.groupByMappings);
        }
    }

    public static class AdjustedMatchInfo
    implements MatchInfo {
        @Nonnull
        private final MatchInfo underlying;
        @Nonnull
        private final List<OrderingPart.MatchedOrderingPart> matchedOrderingParts;
        @Nonnull
        private final MaxMatchMap maxMatchMap;
        @Nonnull
        private final GroupByMappings groupByMappings;

        private AdjustedMatchInfo(@Nonnull MatchInfo underlying, @Nonnull List<OrderingPart.MatchedOrderingPart> matchedOrderingParts, @Nonnull MaxMatchMap maxMatchMap, @Nonnull GroupByMappings groupByMappings) {
            this.underlying = underlying;
            this.matchedOrderingParts = matchedOrderingParts;
            this.maxMatchMap = maxMatchMap;
            this.groupByMappings = groupByMappings;
        }

        @Nonnull
        public MatchInfo getUnderlying() {
            return this.underlying;
        }

        @Override
        @Nonnull
        public List<OrderingPart.MatchedOrderingPart> getMatchedOrderingParts() {
            return this.matchedOrderingParts;
        }

        @Override
        @Nonnull
        public MaxMatchMap getMaxMatchMap() {
            return this.maxMatchMap;
        }

        @Override
        @Nonnull
        public GroupByMappings getGroupByMappings() {
            return this.groupByMappings;
        }

        @Override
        public boolean isAdjusted() {
            return true;
        }

        @Override
        @Nonnull
        public RegularMatchInfo getRegularMatchInfo() {
            return this.underlying.getRegularMatchInfo();
        }

        @Override
        @Nonnull
        public Map<QueryPredicate, PredicateMultiMap.PredicateMapping> collectPulledUpPredicateMappings(@Nonnull RelationalExpression candidateExpression, @Nonnull Set<QueryPredicate> interestingPredicates) {
            LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateMapping> resultsMap = new LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateMapping>();
            MatchInfo matchInfo = this.getUnderlying();
            Quantifier nestingQuantifier = Iterables.getOnlyElement(candidateExpression.getQuantifiers());
            RelationalExpression childCandidateExpression = nestingQuantifier.getRangesOver().get();
            Map<QueryPredicate, PredicateMultiMap.PredicateMapping> childPredicateMappings = matchInfo.collectPulledUpPredicateMappings(childCandidateExpression, interestingPredicates);
            RelationalExpressionVisitor<PullUp> nestingVisitor = PullUp.visitor(null, nestingQuantifier.getAlias());
            PullUp pullUp = nestingVisitor.visit(childCandidateExpression);
            for (Map.Entry<QueryPredicate, PredicateMultiMap.PredicateMapping> childPredicateMappingEntry : childPredicateMappings.entrySet()) {
                QueryPredicate originalQueryPredicate = childPredicateMappingEntry.getKey();
                PredicateMultiMap.PredicateMapping childPredicateMapping = childPredicateMappingEntry.getValue();
                Optional<QueryPredicate> pulledUpPredicateOptional = childPredicateMapping.getTranslatedQueryPredicate().replaceValuesMaybe(pullUp::pullUpValueMaybe);
                pulledUpPredicateOptional.ifPresent(queryPredicate -> resultsMap.put(originalQueryPredicate, childPredicateMapping.withTranslatedQueryPredicate((QueryPredicate)queryPredicate)));
            }
            return resultsMap;
        }
    }

    public static class RegularMatchInfo
    implements MatchInfo {
        @Nonnull
        private final Map<CorrelationIdentifier, ComparisonRange> parameterBindingMap;
        @Nonnull
        private final AliasMap bindingAliasMap;
        @Nonnull
        private final IdentityBiMap<Quantifier, PartialMatch> partialMatchMap;
        @Nonnull
        private final Supplier<Map<CorrelationIdentifier, PartialMatch>> aliasToPartialMatchMapSupplier;
        @Nonnull
        private final Supplier<QueryPlanConstraint> constraintsSupplier;
        @Nonnull
        private final PredicateMultiMap predicateMap;
        @Nonnull
        private final List<OrderingPart.MatchedOrderingPart> matchedOrderingParts;
        @Nonnull
        private final MaxMatchMap maxMatchMap;
        @Nonnull
        private final GroupByMappings groupByMappings;
        @Nullable
        private final List<Value> rollUpToGroupingValues;
        @Nonnull
        private final QueryPlanConstraint additionalPlanConstraint;

        private RegularMatchInfo(@Nonnull Map<CorrelationIdentifier, ComparisonRange> parameterBindingMap, @Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap, @Nonnull PredicateMultiMap predicateMap, @Nonnull List<OrderingPart.MatchedOrderingPart> matchedOrderingParts, @Nonnull MaxMatchMap maxMatchMap, @Nonnull GroupByMappings groupByMappings, @Nullable List<Value> rollUpToGroupingValues, @Nonnull QueryPlanConstraint additionalPlanConstraint) {
            this.parameterBindingMap = ImmutableMap.copyOf(parameterBindingMap);
            this.bindingAliasMap = bindingAliasMap;
            this.partialMatchMap = partialMatchMap.toImmutable();
            this.aliasToPartialMatchMapSupplier = Suppliers.memoize(() -> {
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                partialMatchMap.forEachUnwrapped((quantifier, partialMatch) -> mapBuilder.put(quantifier.getAlias(), partialMatch));
                return mapBuilder.build();
            });
            this.constraintsSupplier = Suppliers.memoize(this::computeConstraints);
            this.predicateMap = predicateMap;
            this.matchedOrderingParts = ImmutableList.copyOf(matchedOrderingParts);
            this.maxMatchMap = maxMatchMap;
            this.groupByMappings = groupByMappings;
            this.rollUpToGroupingValues = rollUpToGroupingValues == null ? null : ImmutableList.copyOf(rollUpToGroupingValues);
            this.additionalPlanConstraint = additionalPlanConstraint;
        }

        @Nonnull
        public Map<CorrelationIdentifier, ComparisonRange> getParameterBindingMap() {
            return this.parameterBindingMap;
        }

        @Nonnull
        public AliasMap getBindingAliasMap() {
            return this.bindingAliasMap;
        }

        @Nonnull
        public IdentityBiMap<Quantifier, PartialMatch> getPartialMatchMap() {
            return this.partialMatchMap;
        }

        @Nonnull
        public Optional<PartialMatch> getChildPartialMatchMaybe(@Nonnull Quantifier quantifier) {
            return Optional.ofNullable(this.partialMatchMap.getUnwrapped(quantifier));
        }

        @Nonnull
        public Optional<PartialMatch> getChildPartialMatchMaybe(@Nonnull CorrelationIdentifier alias) {
            return Optional.ofNullable(this.aliasToPartialMatchMapSupplier.get().get(alias));
        }

        @Nonnull
        public PredicateMultiMap getPredicateMap() {
            return this.predicateMap;
        }

        @Nonnull
        public QueryPlanConstraint getConstraint() {
            return this.constraintsSupplier.get();
        }

        @Override
        @Nonnull
        public Map<QueryPredicate, PredicateMultiMap.PredicateMapping> collectPulledUpPredicateMappings(@Nonnull RelationalExpression candidateExpression, @Nonnull Set<QueryPredicate> interestingPredicates) {
            LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateMapping> resultsMap = new LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateMapping>();
            this.predicateMap.entries().stream().filter(entry -> interestingPredicates.contains(entry.getKey())).forEach(entry -> resultsMap.put((QueryPredicate)entry.getKey(), (PredicateMultiMap.PredicateMapping)entry.getValue()));
            for (Map.Entry<Equivalence.Wrapper<Quantifier>, Equivalence.Wrapper<PartialMatch>> childPartialMatchEntry : this.partialMatchMap.entrySet()) {
                Quantifier queryQuantifier = childPartialMatchEntry.getKey().get();
                PartialMatch childPartialMatch = Objects.requireNonNull(childPartialMatchEntry.getValue().get());
                CorrelationIdentifier candidateAlias = Objects.requireNonNull(this.bindingAliasMap.getTarget(queryQuantifier.getAlias()));
                resultsMap.putAll(childPartialMatch.pullUpToParent(candidateAlias, interestingPredicates));
            }
            return resultsMap;
        }

        @Override
        @Nonnull
        public List<OrderingPart.MatchedOrderingPart> getMatchedOrderingParts() {
            return this.matchedOrderingParts;
        }

        @Override
        @Nonnull
        public MaxMatchMap getMaxMatchMap() {
            return this.maxMatchMap;
        }

        @Override
        @Nonnull
        public GroupByMappings getGroupByMappings() {
            return this.groupByMappings;
        }

        @Nullable
        public List<Value> getRollUpToGroupingValues() {
            return this.rollUpToGroupingValues;
        }

        @Nonnull
        public QueryPlanConstraint getAdditionalPlanConstraint() {
            return this.additionalPlanConstraint;
        }

        @Override
        public boolean isAdjusted() {
            return false;
        }

        @Override
        @Nonnull
        public RegularMatchInfo getRegularMatchInfo() {
            return this;
        }

        @Nonnull
        private QueryPlanConstraint computeConstraints() {
            List childConstraints = this.partialMatchMap.values().stream().map(partialMatch -> ((PartialMatch)partialMatch.get()).getRegularMatchInfo().getConstraint()).collect(Collectors.toList());
            List constraints = this.predicateMap.getMap().values().stream().map(PredicateMultiMap.PredicateMapping::getConstraint).collect(Collectors.toUnmodifiableList());
            ImmutableCollection allConstraints = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)constraints)).addAll((Iterable)childConstraints)).add(this.getAdditionalPlanConstraint())).build();
            return QueryPlanConstraint.composeConstraints(allConstraints);
        }

        @Nonnull
        public static Optional<MatchInfo> tryFromMatchMap(@Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap, @Nonnull MaxMatchMap maxMatchMap) {
            return RegularMatchInfo.tryMerge(bindingAliasMap, partialMatchMap, ImmutableMap.of(), PredicateMap.empty(), maxMatchMap, GroupByMappings.empty(), null, maxMatchMap.getQueryPlanConstraint());
        }

        @Nonnull
        public static Optional<MatchInfo> tryMerge(@Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap, @Nonnull Map<CorrelationIdentifier, ComparisonRange> parameterBindingMap, @Nonnull PredicateMultiMap predicateMap, @Nonnull MaxMatchMap maxMatchMap, @Nonnull GroupByMappings additionalGroupByMappings, @Nullable List<Value> rollUpToGroupingValues, @Nonnull QueryPlanConstraint additionalPlanConstraint) {
            List<Value> resolvedRollUpToGroupingValues;
            List<Object> orderingParts;
            ImmutableList.Builder parameterMapsBuilder = ImmutableList.builder();
            Collection<MatchInfo> matchInfos = PartialMatch.matchInfosFromMap(partialMatchMap);
            matchInfos.forEach(matchInfo -> parameterMapsBuilder.add(matchInfo.getRegularMatchInfo().getParameterBindingMap()));
            parameterMapsBuilder.add(parameterBindingMap);
            Set regularQuantifiers = partialMatchMap.keySet().stream().map(Equivalence.Wrapper::get).filter(quantifier -> quantifier instanceof Quantifier.ForEach || quantifier instanceof Quantifier.Physical).collect(Collectors.toCollection(Sets::newIdentityHashSet));
            if (regularQuantifiers.size() == 1) {
                Quantifier regularQuantifier = (Quantifier)Iterables.getOnlyElement(regularQuantifiers);
                PartialMatch partialMatch = Objects.requireNonNull(partialMatchMap.getUnwrapped(regularQuantifier));
                orderingParts = partialMatch.getMatchInfo().getMatchedOrderingParts();
            } else {
                orderingParts = ImmutableList.of();
            }
            Optional<Map<CorrelationIdentifier, ComparisonRange>> mergedParameterBindingsOptional = RegularMatchInfo.tryMergeParameterBindings(parameterMapsBuilder.build());
            GroupByMappings matchedAggregateValueMap = RegularMatchInfo.pullUpAndMergeGroupByMappings(bindingAliasMap, partialMatchMap, additionalGroupByMappings);
            if (rollUpToGroupingValues != null) {
                for (Quantifier regularQuantifier : regularQuantifiers) {
                    PartialMatch partialMatch = Objects.requireNonNull(partialMatchMap.getUnwrapped(regularQuantifier));
                    if (partialMatch.getRegularMatchInfo().getRollUpToGroupingValues() == null) continue;
                    return Optional.empty();
                }
                resolvedRollUpToGroupingValues = rollUpToGroupingValues;
            } else {
                List<Value> onlyRollUpToGroupingValues = null;
                for (Quantifier regularQuantifier : regularQuantifiers) {
                    PartialMatch partialMatch = Objects.requireNonNull(partialMatchMap.getUnwrapped(regularQuantifier));
                    List<Value> currentRollUpToGroupingValues = partialMatch.getRegularMatchInfo().getRollUpToGroupingValues();
                    if (currentRollUpToGroupingValues == null) continue;
                    if (onlyRollUpToGroupingValues == null) {
                        onlyRollUpToGroupingValues = currentRollUpToGroupingValues;
                        continue;
                    }
                    return Optional.empty();
                }
                resolvedRollUpToGroupingValues = onlyRollUpToGroupingValues;
            }
            return mergedParameterBindingsOptional.map(mergedParameterBindings -> new RegularMatchInfo((Map<CorrelationIdentifier, ComparisonRange>)mergedParameterBindings, bindingAliasMap, partialMatchMap, predicateMap, (List<OrderingPart.MatchedOrderingPart>)orderingParts, maxMatchMap, matchedAggregateValueMap, resolvedRollUpToGroupingValues, additionalPlanConstraint));
        }

        public static Optional<Map<CorrelationIdentifier, ComparisonRange>> tryMergeParameterBindings(Collection<Map<CorrelationIdentifier, ComparisonRange>> parameterBindingMaps) {
            HashMap<CorrelationIdentifier, ComparisonRange> resultMap = Maps.newHashMap();
            for (Map<CorrelationIdentifier, ComparisonRange> parameterBindingMap : parameterBindingMaps) {
                for (Map.Entry<CorrelationIdentifier, ComparisonRange> entry : parameterBindingMap.entrySet()) {
                    if (resultMap.containsKey(entry.getKey())) {
                        ComparisonRange.MergeResult mergeResult = ((ComparisonRange)resultMap.get(entry.getKey())).merge(entry.getValue());
                        if (mergeResult.getResidualComparisons().isEmpty()) {
                            resultMap.replace(entry.getKey(), mergeResult.getComparisonRange());
                            continue;
                        }
                        if (((ComparisonRange)resultMap.get(entry.getKey())).equals(entry.getValue())) continue;
                        return Optional.empty();
                    }
                    resultMap.put(entry.getKey(), entry.getValue());
                }
            }
            return Optional.of(resultMap);
        }

        @Nonnull
        private static GroupByMappings pullUpAndMergeGroupByMappings(@Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap, @Nonnull GroupByMappings additionalGroupByMappings) {
            ImmutableBiMap.Builder matchedGroupingsMapBuilder = ImmutableBiMap.builder();
            matchedGroupingsMapBuilder.putAll(additionalGroupByMappings.getMatchedGroupingsMap());
            ImmutableBiMap.Builder matchedAggregateMapBuilder = ImmutableBiMap.builder();
            matchedAggregateMapBuilder.putAll(additionalGroupByMappings.getMatchedAggregatesMap());
            ImmutableBiMap.Builder unatchedAggregateMapBuilder = ImmutableBiMap.builder();
            unatchedAggregateMapBuilder.putAll(additionalGroupByMappings.getUnmatchedAggregatesMap());
            for (Map.Entry<Equivalence.Wrapper<Quantifier>, Equivalence.Wrapper<PartialMatch>> partialMatchMapEntry : partialMatchMap.entrySet()) {
                Equivalence.Wrapper<Quantifier> partialMatchMapEntryKey = partialMatchMapEntry.getKey();
                Quantifier quantifier = partialMatchMapEntryKey.get();
                if (!(quantifier instanceof Quantifier.ForEach)) continue;
                PartialMatch partialMatch = partialMatchMapEntry.getValue().get();
                GroupByMappings pulledUpGroupByMappings = RegularMatchInfo.pullUpGroupByMappings(partialMatch, quantifier.getAlias(), Objects.requireNonNull(bindingAliasMap.getTarget(quantifier.getAlias())));
                matchedGroupingsMapBuilder.putAll(pulledUpGroupByMappings.getMatchedGroupingsMap());
                matchedAggregateMapBuilder.putAll(pulledUpGroupByMappings.getMatchedAggregatesMap());
                unatchedAggregateMapBuilder.putAll(pulledUpGroupByMappings.getUnmatchedAggregatesMap());
            }
            return GroupByMappings.of((BiMap<Value, Value>)((Object)matchedGroupingsMapBuilder.build()), (BiMap<Value, Value>)((Object)matchedAggregateMapBuilder.build()), (BiMap<CorrelationIdentifier, Value>)((Object)unatchedAggregateMapBuilder.build()));
        }

        @Nonnull
        public static GroupByMappings pullUpAggregateCandidateMappings(@Nonnull PartialMatch partialMatch, @Nonnull PullUp pullUp) {
            MatchInfo matchInfo = partialMatch.getMatchInfo();
            GroupByMappings groupByMappings = matchInfo.getGroupByMappings();
            ImmutableBiMap.Builder matchedGroupingsMapBuilder = ImmutableBiMap.builder();
            for (Map.Entry matchedGroupingsMapEntry : groupByMappings.getMatchedGroupingsMap().entrySet()) {
                Value candidateGroupingValue = (Value)matchedGroupingsMapEntry.getValue();
                Optional<Value> pulledUpCandidateGroupingValueOptional = pullUp.pullUpCandidateValueMaybe(candidateGroupingValue);
                pulledUpCandidateGroupingValueOptional.ifPresent(value -> matchedGroupingsMapBuilder.put((Value)matchedGroupingsMapEntry.getKey(), value));
            }
            ImmutableBiMap.Builder matchedAggregatesMapBuilder = ImmutableBiMap.builder();
            for (Map.Entry matchedAggregatesMapEntry : groupByMappings.getMatchedAggregatesMap().entrySet()) {
                Value candidateAggregateValue = (Value)matchedAggregatesMapEntry.getValue();
                Optional<Value> pulledUpCandidateAggregateValueOptional = pullUp.pullUpCandidateValueMaybe(candidateAggregateValue);
                pulledUpCandidateAggregateValueOptional.ifPresent(value -> matchedAggregatesMapBuilder.put((Value)matchedAggregatesMapEntry.getKey(), value));
            }
            return GroupByMappings.of((BiMap<Value, Value>)((Object)matchedGroupingsMapBuilder.build()), (BiMap<Value, Value>)((Object)matchedAggregatesMapBuilder.build()), groupByMappings.getUnmatchedAggregatesMap());
        }

        @Nonnull
        public static GroupByMappings pullUpGroupByMappings(@Nonnull PartialMatch partialMatch, @Nonnull CorrelationIdentifier queryAlias, @Nonnull CorrelationIdentifier candidateAlias) {
            MatchInfo matchInfo = partialMatch.getMatchInfo();
            RelationalExpression queryExpression = partialMatch.getQueryExpression();
            Value resultValue = queryExpression.getResultValue();
            GroupByMappings groupByMappings = matchInfo.getGroupByMappings();
            Sets.SetView<CorrelationIdentifier> constantAliases = Sets.difference(resultValue.getCorrelatedTo(), queryExpression.getCorrelatedTo());
            ImmutableBiMap<Value, Value> matchedGroupingsMap = RegularMatchInfo.pullUpMatchedValueMap(partialMatch, groupByMappings.getMatchedGroupingsMap(), resultValue, queryAlias, candidateAlias, constantAliases);
            ImmutableBiMap<Value, Value> matchedAggregatesMap = RegularMatchInfo.pullUpMatchedValueMap(partialMatch, groupByMappings.getMatchedAggregatesMap(), resultValue, queryAlias, candidateAlias, constantAliases);
            ImmutableBiMap.Builder unmatchedAggregateMapBuilder = ImmutableBiMap.builder();
            for (Map.Entry unmatchedAggregateMapEntry : groupByMappings.getUnmatchedAggregatesMap().entrySet()) {
                Value queryAggregateValue = (Value)unmatchedAggregateMapEntry.getValue();
                Map<Value, Value> pullUpMap = resultValue.pullUp(ImmutableList.of(queryAggregateValue), EvaluationContext.empty(), AliasMap.emptyMap(), Sets.difference(queryAggregateValue.getCorrelatedToWithoutChildren(), queryExpression.getCorrelatedTo()), queryAlias);
                Value pulledUpQueryAggregateValue = pullUpMap.get(queryAggregateValue);
                if (pulledUpQueryAggregateValue == null) {
                    return GroupByMappings.empty();
                }
                unmatchedAggregateMapBuilder.put((CorrelationIdentifier)unmatchedAggregateMapEntry.getKey(), pulledUpQueryAggregateValue);
            }
            return GroupByMappings.of(matchedGroupingsMap, matchedAggregatesMap, (BiMap<CorrelationIdentifier, Value>)((Object)unmatchedAggregateMapBuilder.build()));
        }

        private static ImmutableBiMap<Value, Value> pullUpMatchedValueMap(@Nonnull PartialMatch partialMatch, @Nonnull BiMap<Value, Value> matchedValueMap, @Nonnull Value queryResultValue, @Nonnull CorrelationIdentifier queryAlias, @Nonnull CorrelationIdentifier candidateAlias, @Nonnull Set<CorrelationIdentifier> constantAliases) {
            ImmutableBiMap.Builder matchedAggregatesMapBuilder = ImmutableBiMap.builder();
            for (Map.Entry entry : matchedValueMap.entrySet()) {
                Value queryValue = (Value)entry.getKey();
                Map<Value, Value> pullUpMap = queryResultValue.pullUp(ImmutableList.of(queryValue), EvaluationContext.empty(), AliasMap.emptyMap(), constantAliases, queryAlias);
                Value pulledUpQueryValue = pullUpMap.get(queryValue);
                if (pulledUpQueryValue == null) continue;
                Value candidateAggregateValue = (Value)entry.getValue();
                RelationalExpression candidateLowerExpression = Iterables.getOnlyElement(partialMatch.getCandidateRef().getAllMemberExpressions());
                Value candidateLowerResultValue = candidateLowerExpression.getResultValue();
                Map<Value, Value> candidatePullUpMap = candidateLowerResultValue.pullUp(ImmutableList.of(candidateAggregateValue), EvaluationContext.empty(), AliasMap.emptyMap(), Sets.difference(candidateAggregateValue.getCorrelatedToWithoutChildren(), candidateLowerExpression.getCorrelatedTo()), candidateAlias);
                Value pulledUpCandidateAggregateValue = candidatePullUpMap.get(candidateAggregateValue);
                if (pulledUpCandidateAggregateValue == null) continue;
                matchedAggregatesMapBuilder.put(pulledUpQueryValue, pulledUpCandidateAggregateValue);
            }
            return matchedAggregatesMapBuilder.build();
        }
    }
}

