/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.ExploratoryMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.FinalMemoizer;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.PlannerStage;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Verify;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public interface Memoizer
extends ExploratoryMemoizer,
FinalMemoizer {
    @Nonnull
    public Reference memoizeExpressions(@Nonnull Collection<? extends RelationalExpression> var1, @Nonnull Collection<? extends RelationalExpression> var2);

    @Nonnull
    public static Memoizer noMemoization(final @Nonnull PlannerStage plannerStage) {
        return new Memoizer(){

            @Override
            @Nonnull
            public Reference memoizeExpressions(@Nonnull Collection<? extends RelationalExpression> exploratoryExpressions, @Nonnull Collection<? extends RelationalExpression> finalExpressions) {
                return Reference.of(plannerStage, exploratoryExpressions, finalExpressions);
            }

            @Override
            @Nonnull
            public Reference memoizeExploratoryExpression(@Nonnull RelationalExpression expression) {
                return Reference.ofExploratoryExpression(plannerStage, expression);
            }

            @Override
            @Nonnull
            public Reference memoizeExploratoryExpressions(@Nonnull Collection<? extends RelationalExpression> expressions) {
                return Reference.ofExploratoryExpressions(plannerStage, expressions);
            }

            @Override
            @Nonnull
            public ReferenceBuilder memoizeExploratoryExpressionBuilder(final @Nonnull RelationalExpression expression) {
                return new ReferenceBuilder(){

                    @Override
                    @Nonnull
                    public Reference reference() {
                        return Reference.ofExploratoryExpression(plannerStage, expression);
                    }

                    @Override
                    @Nonnull
                    public Set<? extends RelationalExpression> members() {
                        LinkedIdentitySet<RelationalExpression> newMembersSet = new LinkedIdentitySet<RelationalExpression>();
                        newMembersSet.add(expression);
                        return newMembersSet;
                    }
                };
            }

            @Override
            @Nonnull
            public Reference memoizeFinalExpressionsFromOther(@Nonnull Reference reference, @Nonnull Collection<? extends RelationalExpression> expressions) {
                return Reference.ofFinalExpressions(plannerStage, expressions);
            }

            @Override
            @Nonnull
            public Reference memoizeFinalExpression(@Nonnull RelationalExpression expression) {
                return Reference.ofFinalExpression(plannerStage, expression);
            }

            @Override
            @Nonnull
            public Reference memoizeFinalExpressions(@Nonnull Collection<RelationalExpression> expressions) {
                return Reference.ofFinalExpressions(plannerStage, expressions);
            }

            @Override
            @Nonnull
            public Reference memoizeUnknownExpression(@Nonnull RelationalExpression expression) {
                Verify.verify(plannerStage == PlannerStage.PLANNED);
                if (expression instanceof RecordQueryPlan) {
                    return this.memoizeFinalExpression(expression);
                }
                return this.memoizeExploratoryExpression(expression);
            }

            @Override
            @Nonnull
            public Reference memoizeMemberPlansFromOther(@Nonnull Reference reference, @Nonnull Collection<? extends RecordQueryPlan> plans) {
                return this.memoizeFinalExpressionsFromOther(reference, plans);
            }

            @Override
            @Nonnull
            public Reference memoizePlan(@Nonnull RecordQueryPlan plan) {
                return this.memoizeFinalExpression(plan);
            }

            @Override
            @Nonnull
            public ReferenceBuilder memoizeFinalExpressionsBuilder(final @Nonnull Collection<? extends RelationalExpression> expressions) {
                return new ReferenceBuilder(){

                    @Override
                    @Nonnull
                    public Reference reference() {
                        return Reference.ofFinalExpressions(plannerStage, expressions);
                    }

                    @Override
                    @Nonnull
                    public Set<? extends RelationalExpression> members() {
                        return new LinkedIdentitySet(expressions);
                    }
                };
            }

            @Override
            @Nonnull
            public ReferenceOfPlansBuilder memoizeMemberPlansBuilder(@Nonnull Reference reference, final @Nonnull Collection<? extends RecordQueryPlan> plans) {
                return new ReferenceOfPlansBuilder(){

                    @Override
                    @Nonnull
                    public Set<? extends RecordQueryPlan> members() {
                        return new LinkedIdentitySet(plans);
                    }

                    @Override
                    @Nonnull
                    public Reference reference() {
                        return Reference.ofFinalExpressions(plannerStage, plans);
                    }
                };
            }

            @Override
            @Nonnull
            public ReferenceOfPlansBuilder memoizePlansBuilder(final @Nonnull Collection<? extends RecordQueryPlan> plans) {
                return new ReferenceOfPlansBuilder(){

                    @Override
                    @Nonnull
                    public Set<? extends RecordQueryPlan> members() {
                        return new LinkedIdentitySet(plans);
                    }

                    @Override
                    @Nonnull
                    public Reference reference() {
                        return Reference.ofFinalExpressions(plannerStage, plans);
                    }
                };
            }

            public String toString() {
                return "no-memo";
            }
        };
    }

    public static interface ReferenceOfPlansBuilder
    extends ReferenceBuilder {
        @Nonnull
        public Set<? extends RecordQueryPlan> members();
    }

    public static interface ReferenceBuilder {
        @Nonnull
        public Reference reference();

        @Nonnull
        public Set<? extends RelationalExpression> members();
    }
}

