/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.IndexMatchCandidateRegistry;
import com.apple.foundationdb.record.query.IndexQueryabilityFilter;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidateExpansion;
import com.apple.foundationdb.record.query.plan.cascades.PlanContext;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.properties.RecordTypesProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class MetaDataPlanContext
implements PlanContext {
    @Nonnull
    private final RecordQueryPlannerConfiguration plannerConfiguration;
    @Nonnull
    private final Set<MatchCandidate> matchCandidates;

    private MetaDataPlanContext(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull Set<MatchCandidate> matchCandidates) {
        this.plannerConfiguration = plannerConfiguration;
        this.matchCandidates = ImmutableSet.copyOf(matchCandidates);
    }

    @Override
    @Nonnull
    public RecordQueryPlannerConfiguration getPlannerConfiguration() {
        return this.plannerConfiguration;
    }

    @Nullable
    private static KeyExpression commonPrimaryKey(@Nonnull Iterable<RecordType> recordTypes) {
        KeyExpression common = null;
        boolean first = true;
        for (RecordType recordType : recordTypes) {
            if (first) {
                common = recordType.getPrimaryKey();
                first = false;
                continue;
            }
            if (common.equals(recordType.getPrimaryKey())) continue;
            return null;
        }
        return common;
    }

    @Override
    @Nonnull
    public Set<MatchCandidate> getMatchCandidates() {
        return this.matchCandidates;
    }

    @Nonnull
    private static List<Index> readableOf(@Nonnull RecordStoreState recordStoreState, @Nonnull List<Index> indexes) {
        if (recordStoreState.allIndexesReadable()) {
            return indexes;
        }
        return indexes.stream().filter(recordStoreState::isReadable).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static PlanContext forRecordQuery(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull RecordMetaData metaData, @Nonnull RecordStoreState recordStoreState, @Nonnull IndexMatchCandidateRegistry matchCandidateRegistry, @Nonnull RecordQuery query) {
        ImmutableSet<String> queriedRecordTypeNames;
        KeyExpression commonPrimaryKey;
        Optional queriedRecordTypeNamesOptional = query.getRecordTypes().isEmpty() ? Optional.empty() : Optional.of(query.getRecordTypes());
        Optional allowedIndexesOptional = query.hasAllowedIndexes() ? Optional.of(Objects.requireNonNull(query.getAllowedIndexes())) : Optional.empty();
        IndexQueryabilityFilter indexQueryabilityFilter = query.getIndexQueryabilityFilter();
        boolean isSortReverse = query.isSortReverse();
        ArrayList<Index> indexList = new ArrayList<Index>();
        recordStoreState.beginRead();
        try {
            if (queriedRecordTypeNamesOptional.isEmpty()) {
                commonPrimaryKey = MetaDataPlanContext.commonPrimaryKey(metaData.getRecordTypes().values());
                queriedRecordTypeNames = metaData.getRecordTypes().keySet();
            } else {
                queriedRecordTypeNames = ImmutableSet.copyOf((Collection)queriedRecordTypeNamesOptional.get());
                List<RecordType> queriedRecordTypes = queriedRecordTypeNames.stream().map(metaData::getRecordType).collect(Collectors.toList());
                if (queriedRecordTypes.size() == 1) {
                    RecordType recordType = (RecordType)queriedRecordTypes.get(0);
                    indexList.addAll(MetaDataPlanContext.readableOf(recordStoreState, recordType.getIndexes()));
                    indexList.addAll(MetaDataPlanContext.readableOf(recordStoreState, recordType.getMultiTypeIndexes()));
                    commonPrimaryKey = recordType.getPrimaryKey();
                } else {
                    boolean first = true;
                    for (RecordType recordType : queriedRecordTypes) {
                        if (first) {
                            indexList.addAll(MetaDataPlanContext.readableOf(recordStoreState, recordType.getMultiTypeIndexes()));
                            first = false;
                            continue;
                        }
                        indexList.retainAll(MetaDataPlanContext.readableOf(recordStoreState, recordType.getMultiTypeIndexes()));
                    }
                    commonPrimaryKey = MetaDataPlanContext.commonPrimaryKey(queriedRecordTypes);
                }
            }
            indexList.addAll(MetaDataPlanContext.readableOf(recordStoreState, metaData.getUniversalIndexes()));
        }
        finally {
            recordStoreState.endRead();
        }
        if (allowedIndexesOptional.isPresent()) {
            Collection allowedIndexes = (Collection)allowedIndexesOptional.get();
            indexList.removeIf(index -> !allowedIndexes.contains(index.getName()));
        } else {
            indexList.removeIf(index -> !indexQueryabilityFilter.isQueryable((Index)index));
        }
        ImmutableSet.Builder matchCandidatesBuilder = ImmutableSet.builder();
        for (Index index2 : indexList) {
            matchCandidatesBuilder.addAll(matchCandidateRegistry.createMatchCandidates(metaData, index2, isSortReverse));
        }
        MatchCandidateExpansion.fromPrimaryDefinition(metaData, queriedRecordTypeNames, commonPrimaryKey, isSortReverse).ifPresent(matchCandidatesBuilder::add);
        return new MetaDataPlanContext(plannerConfiguration, (Set<MatchCandidate>)((Object)matchCandidatesBuilder.build()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlanContext forRootReference(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull RecordMetaData metaData, @Nonnull RecordStoreState recordStoreState, @Nonnull IndexMatchCandidateRegistry matchCandidateRegistry, @Nonnull Reference rootReference, @Nonnull Optional<Collection<String>> allowedIndexesOptional, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter) {
        Set<String> queriedRecordTypeNames = RecordTypesProperty.recordTypes().evaluate(rootReference);
        if (queriedRecordTypeNames.isEmpty()) {
            return new MetaDataPlanContext(plannerConfiguration, ImmutableSet.of());
        }
        List queriedRecordTypes = queriedRecordTypeNames.stream().map(metaData::getRecordType).collect(Collectors.toList());
        ArrayList<Index> indexList = Lists.newArrayList();
        recordStoreState.beginRead();
        try {
            for (RecordType recordType : queriedRecordTypes) {
                indexList.addAll(MetaDataPlanContext.readableOf(recordStoreState, recordType.getAllIndexes()));
            }
        }
        finally {
            recordStoreState.endRead();
        }
        if (allowedIndexesOptional.isPresent()) {
            Collection<String> allowedIndexes = allowedIndexesOptional.get();
            indexList.removeIf(index -> !allowedIndexes.contains(index.getName()));
        } else {
            indexList.removeIf(index -> !indexQueryabilityFilter.isQueryable((Index)index));
        }
        ImmutableSet.Builder matchCandidatesBuilder = ImmutableSet.builder();
        for (Index index2 : indexList) {
            matchCandidatesBuilder.addAll(matchCandidateRegistry.createMatchCandidates(metaData, index2, false));
        }
        for (RecordType recordType : queriedRecordTypes) {
            MatchCandidateExpansion.fromPrimaryDefinition(metaData, ImmutableSet.of(recordType.getName()), recordType.getPrimaryKey(), false).ifPresent(matchCandidatesBuilder::add);
        }
        return new MetaDataPlanContext(plannerConfiguration, (Set<MatchCandidate>)((Object)matchCandidatesBuilder.build()));
    }
}

