/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.MessageHelpers;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NullableArrayTypeUtils {
    @Nonnull
    private static final String REPEATED_FIELD_NAME = "values";

    private NullableArrayTypeUtils() {
        throw new IllegalStateException("Utility class");
    }

    @Nonnull
    public static String getRepeatedFieldName() {
        return REPEATED_FIELD_NAME;
    }

    public static boolean describesWrappedArray(@Nonnull Descriptors.Descriptor descriptor) {
        if (descriptor.getFields().size() == 1) {
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.getFields().get(0);
            return fieldDescriptor.isRepeated() && REPEATED_FIELD_NAME.equals(fieldDescriptor.getName());
        }
        return false;
    }

    public static boolean isArrayWrapper(@Nonnull NestingKeyExpression nestingKeyExpression) {
        RecordKeyExpressionProto.KeyExpression child = nestingKeyExpression.getChild().toKeyExpression();
        if (child.hasNesting()) {
            RecordKeyExpressionProto.Field firstChild = child.getNesting().getParent();
            return NullableArrayTypeUtils.isWrappedField(firstChild);
        }
        if (child.hasField()) {
            return NullableArrayTypeUtils.isWrappedField(child.getField());
        }
        return false;
    }

    @Nullable
    public static Object unwrapIfArray(@Nullable Object wrappedValue, @Nonnull Type type) {
        if (wrappedValue != null && type.isArray() && type.isNullable()) {
            return MessageHelpers.getFieldOnMessage((MessageOrBuilder)((Message)wrappedValue), NullableArrayTypeUtils.getRepeatedFieldName());
        }
        return wrappedValue;
    }

    private static boolean isWrappedField(@Nonnull RecordKeyExpressionProto.Field field) {
        return REPEATED_FIELD_NAME.equals(field.getFieldName()) && RecordKeyExpressionProto.Field.FanType.FAN_OUT.equals(field.getFanType());
    }
}

