/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.DefaultValueSimplificationRuleSet;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Ordering {
    @Nonnull
    private static final Ordering EMPTY = new Ordering(ImmutableSetMultimap.of(), PartiallyOrderedSet.empty(), false, (b, o) -> {});
    public static final MergeOperator<Union> UNION = new MergeOperator<Union>(){

        @Override
        @Nonnull
        public Set<Binding> combineBindings(@Nonnull Set<Binding> leftBindings, @Nonnull Set<Binding> rightBindings) {
            return Ordering.combineBindingsForUnion(leftBindings, rightBindings);
        }

        @Override
        @Nonnull
        public Union createOrdering(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull PartiallyOrderedSet<Value> orderingSet, boolean isDistinct) {
            return new Union(bindingMap, orderingSet, isDistinct);
        }
    };
    public static final MergeOperator<Intersection> INTERSECTION = new MergeOperator<Intersection>(){

        @Override
        @Nonnull
        public Set<Binding> combineBindings(@Nonnull Set<Binding> leftBindings, @Nonnull Set<Binding> rightBindings) {
            return Ordering.combineBindingsForIntersection(leftBindings, rightBindings);
        }

        @Override
        @Nonnull
        public Intersection createOrdering(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull PartiallyOrderedSet<Value> orderingSet, boolean isDistinct) {
            return new Intersection(bindingMap, Ordering.normalizeOrderingSet(bindingMap, orderingSet), isDistinct);
        }
    };
    @Nonnull
    private final SetMultimap<Value, Binding> bindingMap;
    @Nonnull
    private final PartiallyOrderedSet<Value> orderingSet;
    private final boolean isDistinct;
    @Nonnull
    private final Supplier<SetMultimap<Value, Binding>> fixedBindingMapSupplier;

    protected Ordering(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull PartiallyOrderedSet<Value> orderingSet, boolean isDistinct, @Nonnull BiConsumer<SetMultimap<Value, Binding>, PartiallyOrderedSet<Value>> sanityCheckConsumer) {
        Debugger.sanityCheck(() -> sanityCheckConsumer.accept(bindingMap, orderingSet));
        this.orderingSet = orderingSet;
        this.bindingMap = ImmutableSetMultimap.copyOf(bindingMap);
        this.isDistinct = isDistinct;
        this.fixedBindingMapSupplier = Suppliers.memoize(this::computeFixedBindingMap);
    }

    @Nonnull
    public SetMultimap<Value, Binding> getBindingMap() {
        return this.bindingMap;
    }

    @Nonnull
    public Set<Value> getEqualityBoundValues() {
        return this.getFixedBindingMap().keySet();
    }

    @Nonnull
    private SetMultimap<Value, Binding> getFixedBindingMap() {
        return this.fixedBindingMapSupplier.get();
    }

    @Nonnull
    private SetMultimap<Value, Binding> computeFixedBindingMap() {
        return ImmutableSetMultimap.copyOf(Multimaps.filterValues(this.getBindingMap(), Binding::isFixed));
    }

    @Nonnull
    public PartiallyOrderedSet<Value> getOrderingSet() {
        return this.orderingSet;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public boolean isEmpty() {
        return this.bindingMap.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Ordering)) {
            return false;
        }
        Ordering ordering = (Ordering)o;
        return this.getBindingMap().equals(ordering.getBindingMap()) && this.getOrderingSet().equals(ordering.getOrderingSet()) && this.isDistinct() == ordering.isDistinct();
    }

    public int hashCode() {
        return Objects.hash(this.getBindingMap(), this.getOrderingSet(), this.isDistinct());
    }

    public String toString() {
        return "[" + (this.isDistinct ? "distinct " : "") + String.valueOf(this.orderingSet) + "; bindings: " + String.valueOf(this.bindingMap) + "]";
    }

    @Nonnull
    public Set<RequestedOrdering> deriveRequestedOrderings(@Nonnull RequestedOrdering requestedOrdering, boolean isExhaustive) {
        if (requestedOrdering.isDistinct() && !this.isDistinct()) {
            return ImmutableSet.of();
        }
        Iterable<List<OrderingPart.RequestedOrderingPart>> satisfyingEnumeratedOrderings = this.enumerateCompatibleRequestedOrderings(requestedOrdering);
        return Streams.stream(satisfyingEnumeratedOrderings).map(keyParts -> RequestedOrdering.ofPrimitiveParts(keyParts, RequestedOrdering.Distinctness.PRESERVE_DISTINCTNESS, isExhaustive)).collect(ImmutableSet.toImmutableSet());
    }

    public boolean satisfies(@Nonnull RequestedOrdering requestedOrdering) {
        return !Iterables.isEmpty(this.enumerateCompatibleRequestedOrderings(requestedOrdering));
    }

    @Nonnull
    public Iterable<List<OrderingPart.RequestedOrderingPart>> enumerateCompatibleRequestedOrderings(@Nonnull RequestedOrdering requestedOrdering) {
        if (requestedOrdering.isDistinct() && !this.isDistinct()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder requestedOrderingValuesBuilder = ImmutableList.builder();
        ImmutableMap.Builder<Value, OrderingPart.RequestedOrderingPart> requestedOrderingValuesMapBuilder = ImmutableMap.builder();
        for (OrderingPart.RequestedOrderingPart requestedOrderingPart : requestedOrdering.getOrderingParts()) {
            if (!this.bindingMap.containsKey(requestedOrderingPart.getValue())) {
                return ImmutableList.of();
            }
            Collection bindings = this.bindingMap.get((Object)requestedOrderingPart.getValue());
            OrderingPart.ProvidedSortOrder sortOrder = Ordering.sortOrder(bindings);
            if (!sortOrder.isCompatibleWithRequestedSortOrder((OrderingPart.RequestedSortOrder)requestedOrderingPart.getSortOrder())) {
                return ImmutableList.of();
            }
            requestedOrderingValuesBuilder.add(requestedOrderingPart.getValue());
            requestedOrderingValuesMapBuilder.put(requestedOrderingPart.getValue(), requestedOrderingPart);
        }
        ImmutableMap requestedOrderingValuesMap = requestedOrderingValuesMapBuilder.build();
        Iterable<List<Value>> satisfyingValuePermutations = TopologicalSort.satisfyingPermutations(this.getOrderingSet(), ImmutableList.copyOf(requestedOrderingValuesMap.keySet()), Function.identity(), permutation -> requestedOrdering.getOrderingParts().size());
        return Iterables.transform(satisfyingValuePermutations, permutation -> permutation.stream().map(value -> {
            Collection bindings = this.bindingMap.get(value);
            if (Ordering.areAllBindingsFixed(bindings)) {
                return new OrderingPart.RequestedOrderingPart((Value)value, OrderingPart.RequestedSortOrder.ANY);
            }
            return new OrderingPart.RequestedOrderingPart((Value)value, Ordering.sortOrder(bindings).toRequestedSortOrder());
        }).collect(ImmutableList.toImmutableList()));
    }

    public boolean satisfiesGroupingValues(@Nonnull Set<Value> requestedGroupingValues) {
        if (requestedGroupingValues.isEmpty()) {
            return true;
        }
        if (this.orderingSet.size() < requestedGroupingValues.size()) {
            return false;
        }
        if (requestedGroupingValues.stream().anyMatch(requestedGroupingValue -> {
            if (!this.bindingMap.containsKey(requestedGroupingValue)) {
                return true;
            }
            Collection bindings = this.bindingMap.get(requestedGroupingValue);
            return Ordering.areAllBindingsFixed(bindings) && Ordering.hasMultipleFixedBindings(bindings);
        })) {
            return false;
        }
        EnumeratingIterable<Value> permutations = TopologicalSort.topologicalOrderPermutations(this.orderingSet);
        for (List list : permutations) {
            boolean containsAll = requestedGroupingValues.containsAll(list.subList(0, requestedGroupingValues.size()));
            if (!containsAll) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Ordering pullUp(@Nonnull Value value, @Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases) {
        ImmutableSetMultimap.Builder pulledUpBindingMapBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry<Value, Collection<Binding>> entry : this.getBindingMap().asMap().entrySet()) {
            Set<Binding> pulledUpBindings = Ordering.translateBindings(entry.getValue(), toBePulledUpValues -> value.pullUp((Iterable<? extends Value>)toBePulledUpValues, evaluationContext, aliasMap, constantAliases, Quantifier.current()));
            pulledUpBindingMapBuilder.putAll((Object)entry.getKey(), pulledUpBindings);
        }
        ImmutableMultimap pulledUpBindingMap = pulledUpBindingMapBuilder.build();
        Map<Value, Value> pulledUpValuesMap = value.pullUp(pulledUpBindingMap.keySet(), evaluationContext, aliasMap, constantAliases, Quantifier.current());
        PartiallyOrderedSet<Value> mappedOrderingSet = this.getOrderingSet().mapAll(pulledUpValuesMap);
        ImmutableSet<Value> mappedValues = mappedOrderingSet.getSet();
        ImmutableSetMultimap.Builder bindingMapBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry<Value, Value> entry : pulledUpValuesMap.entrySet()) {
            if (!mappedValues.contains(entry.getValue())) continue;
            Verify.verify(pulledUpBindingMap.containsKey(entry.getKey()));
            bindingMapBuilder.putAll((Object)entry.getValue(), (Iterable)((ImmutableSetMultimap)pulledUpBindingMap).get(entry.getKey()));
        }
        return Ordering.ofOrderingSet((SetMultimap<Value, Binding>)((Object)bindingMapBuilder.build()), mappedOrderingSet, this.isDistinct());
    }

    @Nonnull
    public Ordering pushDown(@Nonnull Value value, @Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases) {
        ImmutableSetMultimap.Builder pushedBindingMapBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry<Value, Collection<Binding>> entry : this.getBindingMap().asMap().entrySet()) {
            Set<Binding> pushedBindings = Ordering.translateBindings(entry.getValue(), toBePushedValues -> {
                List<Value> pushedDownValues = value.pushDown((Iterable<? extends Value>)toBePushedValues, DefaultValueSimplificationRuleSet.instance(), evaluationContext, aliasMap, constantAliases, Quantifier.current());
                LinkedIdentityMap<Value, Value> resultMap = new LinkedIdentityMap<Value, Value>();
                for (int i = 0; i < toBePushedValues.size(); ++i) {
                    Value toBePushedValue = (Value)toBePushedValues.get(i);
                    Value pushedValue = Objects.requireNonNull(pushedDownValues.get(i));
                    resultMap.put(toBePushedValue, pushedValue);
                }
                return resultMap;
            });
            pushedBindingMapBuilder.putAll((Object)entry.getKey(), pushedBindings);
        }
        ImmutableMultimap pushedBindingMap = pushedBindingMapBuilder.build();
        Set values = pushedBindingMap.keySet();
        List<Value> pushedValues = value.pushDown(values, DefaultValueSimplificationRuleSet.instance(), evaluationContext, aliasMap, constantAliases, Quantifier.current());
        ImmutableMap.Builder<Value, Value> pushedValuesMapBuilder = ImmutableMap.builder();
        Iterator valuesIterator = ((ImmutableSet)values).iterator();
        Iterator<Value> pushedValuesIterator = pushedValues.iterator();
        while (valuesIterator.hasNext() && pushedValuesIterator.hasNext()) {
            pushedValuesMapBuilder.put((Value)valuesIterator.next(), pushedValuesIterator.next());
        }
        Verify.verify(!valuesIterator.hasNext() && !pushedValuesIterator.hasNext());
        ImmutableMap pushedValuesMap = pushedValuesMapBuilder.build();
        PartiallyOrderedSet<Value> mappedOrderingSet = this.getOrderingSet().mapAll(pushedValuesMap);
        ImmutableSet mappedValues = mappedOrderingSet.getSet();
        ImmutableSetMultimap.Builder bindingMapBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry entry : pushedValuesMap.entrySet()) {
            if (!mappedValues.contains(entry.getValue())) continue;
            Verify.verify(pushedBindingMap.containsKey(entry.getKey()));
            bindingMapBuilder.putAll((Object)((Value)entry.getValue()), (Iterable)((ImmutableSetMultimap)pushedBindingMap).get((Value)entry.getKey()));
        }
        return Ordering.ofOrderingSet((SetMultimap<Value, Binding>)((Object)bindingMapBuilder.build()), mappedOrderingSet, this.isDistinct());
    }

    @Nonnull
    public static SetMultimap<Value, Binding> sortedBindingsForValues(@Nonnull Collection<? extends Value> values, @Nonnull OrderingPart.ProvidedSortOrder sortOrder) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Value value : values) {
            builder.put(value, Binding.sorted(sortOrder));
        }
        return builder.build();
    }

    public boolean isSingularNonFixedValue(@Nonnull Value value) {
        Verify.verify(this.bindingMap.containsKey(value));
        Collection bindings = this.bindingMap.get((Object)value);
        if (Ordering.isSingularNonFixedBinding(bindings)) {
            return true;
        }
        Debugger.sanityCheck(() -> Verify.verify(Ordering.areAllBindingsFixed(this.bindingMap.get((Object)value))));
        return false;
    }

    public boolean isSingularFixedValue(@Nonnull Value value) {
        Verify.verify(this.bindingMap.containsKey(value));
        Collection bindings = this.bindingMap.get((Object)value);
        return Ordering.areAllBindingsFixed(bindings) && !Ordering.hasMultipleFixedBindings(bindings);
    }

    @Nonnull
    private static Set<Binding> translateBindings(@Nonnull Collection<Binding> bindings, @Nonnull Function<List<Value>, Map<Value, Value>> translateFunction) {
        ImmutableSet.Builder translatedBindingsBuilder = ImmutableSet.builder();
        if (Ordering.areAllBindingsFixed(bindings)) {
            ImmutableList.Builder toBeTranslatedValues = ImmutableList.builder();
            for (Binding binding : bindings) {
                Comparisons.Comparison comparison = binding.getComparison();
                if (!(comparison instanceof Comparisons.ValueComparison)) continue;
                Comparisons.ValueComparison valueComparison = (Comparisons.ValueComparison)comparison;
                toBeTranslatedValues.add(valueComparison.getValue());
            }
            Map<Value, Value> translationMap = translateFunction.apply((List<Value>)((Object)toBeTranslatedValues.build()));
            for (Binding binding : bindings) {
                Comparisons.Comparison comparison = binding.getComparison();
                if (comparison instanceof Comparisons.ValueComparison) {
                    Comparisons.ValueComparison valueComparison = (Comparisons.ValueComparison)comparison;
                    if (!translationMap.containsKey(valueComparison.getValue())) continue;
                    Comparisons.ValueComparison translatedComparison = new Comparisons.ValueComparison(valueComparison.getType(), translationMap.get(valueComparison.getValue()));
                    translatedBindingsBuilder.add(Binding.fixed(translatedComparison));
                    continue;
                }
                translatedBindingsBuilder.add(binding);
            }
        } else {
            translatedBindingsBuilder.add(Binding.sorted(Ordering.sortOrder(bindings)));
        }
        return translatedBindingsBuilder.build();
    }

    @Nonnull
    private static PartiallyOrderedSet<Value> computeFromOrderingSequence(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull List<? extends Value> orderingValues) {
        ImmutableList filteredOrderingValues = orderingValues.stream().peek(orderingValue -> Verify.verify(bindingMap.containsKey(orderingValue))).filter(orderingValue -> bindingMap.get(orderingValue).stream().noneMatch(Binding::isFixed)).collect(ImmutableList.toImmutableList());
        return PartiallyOrderedSet.builder().addAll(bindingMap.keySet()).addListWithDependencies(filteredOrderingValues).build();
    }

    @Nonnull
    public static ImmutableSetMultimap<Value, Binding> normalizeBindingMap(@Nonnull SetMultimap<Value, Binding> bindingMap) {
        ImmutableSetMultimap.Builder normalizedBindingMapBuilder = ImmutableSetMultimap.builder();
        for (Value value : bindingMap.keySet()) {
            boolean isFixed = Ordering.areAllBindingsFixed(bindingMap.get((Object)value));
            Collection bindings = bindingMap.get((Object)value);
            OrderingPart.ProvidedSortOrder seenSortOrder = null;
            block12: for (Binding binding : bindings) {
                if (seenSortOrder != null) {
                    switch (binding.getSortOrder()) {
                        case ASCENDING: {
                            Verify.verify(!isFixed);
                            Verify.verify(seenSortOrder != OrderingPart.ProvidedSortOrder.DESCENDING);
                            if (seenSortOrder == OrderingPart.ProvidedSortOrder.ASCENDING) continue block12;
                            normalizedBindingMapBuilder.put(value, binding);
                            continue block12;
                        }
                        case DESCENDING: {
                            Verify.verify(!isFixed);
                            Verify.verify(seenSortOrder != OrderingPart.ProvidedSortOrder.ASCENDING);
                            if (seenSortOrder == OrderingPart.ProvidedSortOrder.DESCENDING) continue block12;
                            normalizedBindingMapBuilder.put(value, binding);
                            continue block12;
                        }
                        case FIXED: {
                            if (!isFixed) continue block12;
                            normalizedBindingMapBuilder.put(value, binding);
                            continue block12;
                        }
                    }
                    throw new RecordCoreException("unknown binding", new Object[0]);
                }
                switch (binding.getSortOrder()) {
                    case ASCENDING: {
                        Verify.verify(!isFixed);
                        normalizedBindingMapBuilder.put(value, binding);
                        break;
                    }
                    case DESCENDING: {
                        Verify.verify(!isFixed);
                        normalizedBindingMapBuilder.put(value, binding);
                        break;
                    }
                    case CHOOSE: {
                        Verify.verify(!isFixed);
                        normalizedBindingMapBuilder.put(value, binding);
                        break;
                    }
                    case FIXED: {
                        if (!isFixed) break;
                        normalizedBindingMapBuilder.put(value, binding);
                        break;
                    }
                    default: {
                        throw new RecordCoreException("unknown binding", new Object[0]);
                    }
                }
                seenSortOrder = binding.getSortOrder();
            }
        }
        return normalizedBindingMapBuilder.build();
    }

    @Nonnull
    public static PartiallyOrderedSet<Value> normalizeOrderingSet(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull PartiallyOrderedSet<Value> orderingSet) {
        ImmutableSetMultimap.Builder normalizedDependencyMapBuilder = ImmutableSetMultimap.builder();
        Map dependencyMap = orderingSet.getDependencyMap().asMap();
        for (Map.Entry dependencySetEntry : ((ImmutableMap)dependencyMap).entrySet()) {
            if (Ordering.areAllBindingsFixed(Objects.requireNonNull(bindingMap.get((Object)((Value)dependencySetEntry.getKey()))))) continue;
            ArrayDeque toBeProcessed = new ArrayDeque((Collection)dependencySetEntry.getValue());
            while (!toBeProcessed.isEmpty()) {
                Value dependentValue = (Value)toBeProcessed.removeFirst();
                if (!Ordering.areAllBindingsFixed(Objects.requireNonNull(bindingMap.get((Object)dependentValue)))) {
                    normalizedDependencyMapBuilder.put((Value)dependencySetEntry.getKey(), dependentValue);
                    continue;
                }
                Collection transitivelyDependentValues = (Collection)((ImmutableMap)dependencyMap).get(dependentValue);
                if (transitivelyDependentValues == null) continue;
                toBeProcessed.addAll(transitivelyDependentValues);
            }
        }
        return PartiallyOrderedSet.of(orderingSet.getSet(), normalizedDependencyMapBuilder.build());
    }

    public static boolean areAllBindingsFixed(@Nonnull Collection<Binding> bindings) {
        return bindings.stream().allMatch(Binding::isFixed);
    }

    public static boolean hasMultipleFixedBindings(@Nonnull Collection<Binding> bindings) {
        return bindings.stream().filter(Binding::isFixed).count() > 1L;
    }

    public static Binding fixedBinding(@Nonnull Collection<Binding> bindings) {
        Debugger.sanityCheck(() -> Verify.verify(Ordering.areAllBindingsFixed(bindings) && !Ordering.hasMultipleFixedBindings(bindings)));
        return Iterables.getOnlyElement(bindings);
    }

    public static boolean isSingularBinding(@Nonnull Collection<Binding> bindings) {
        Verify.verify(!bindings.isEmpty());
        return bindings.size() == 1;
    }

    public static boolean isSingularDirectionalBinding(@Nonnull Collection<Binding> bindings) {
        if (Ordering.isSingularBinding(bindings)) {
            return Iterables.getOnlyElement(bindings).getSortOrder().isDirectional();
        }
        return false;
    }

    public static boolean isSingularNonFixedBinding(@Nonnull Collection<Binding> bindings) {
        if (Ordering.isSingularBinding(bindings)) {
            OrderingPart.ProvidedSortOrder sortOrder = Iterables.getOnlyElement(bindings).getSortOrder();
            return sortOrder.isDirectional() || sortOrder == OrderingPart.ProvidedSortOrder.CHOOSE;
        }
        return false;
    }

    public static OrderingPart.ProvidedSortOrder sortOrder(@Nonnull Collection<Binding> bindings) {
        Verify.verify(!bindings.isEmpty());
        if (Ordering.isSingularNonFixedBinding(bindings)) {
            return Iterables.getOnlyElement(bindings).getSortOrder();
        }
        if (Ordering.areAllBindingsFixed(bindings)) {
            return OrderingPart.ProvidedSortOrder.FIXED;
        }
        throw new RecordCoreException("inconsistent ordering state", new Object[0]);
    }

    @Nonnull
    public static <O extends SetOperationsOrdering> O merge(@Nonnull Iterable<Ordering> orderings, @Nonnull MergeOperator<O> mergeOperator, @Nonnull BiPredicate<O, O> isDistinctPredicate) {
        return (O)Streams.stream(orderings).map(mergeOperator::createFromOrdering).reduce((left, right) -> Ordering.merge(left, right, mergeOperator, isDistinctPredicate.test(left, right))).orElseThrow(() -> new IllegalStateException("must have an ordering"));
    }

    @Nonnull
    public static <O extends SetOperationsOrdering> O merge(@Nonnull Ordering left, @Nonnull Ordering right, @Nonnull MergeOperator<O> mergeOperator, boolean isDistinct) {
        PartiallyOrderedSet<Value> leftOrderingSet = left.getOrderingSet();
        PartiallyOrderedSet<Value> rightOrderingSet = right.getOrderingSet();
        ImmutableSetMultimap<Value, Value> leftDependencies = leftOrderingSet.getDependencyMap();
        ImmutableSetMultimap<Value, Value> rightDependencies = rightOrderingSet.getDependencyMap();
        SetMultimap<Value, Binding> leftBindingMap = left.getBindingMap();
        SetMultimap<Value, Binding> rightBindingMap = right.getBindingMap();
        ImmutableSet.Builder elementsBuilder = ImmutableSet.builder();
        ImmutableSetMultimap.Builder dependencyBuilder = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder bindingMapBuilder = ImmutableSetMultimap.builder();
        PartiallyOrderedSet.EligibleSet<Value> leftEligibleSet = leftOrderingSet.eligibleSet();
        PartiallyOrderedSet.EligibleSet<Value> rightEligibleSet = rightOrderingSet.eligibleSet();
        ImmutableCollection lastElements = ImmutableSet.of();
        while (!leftEligibleSet.isEmpty() && !rightEligibleSet.isEmpty()) {
            Set<Binding> combinedBindings;
            Set<Value> leftElements = leftEligibleSet.eligibleElements();
            Set<Value> rightElements = rightEligibleSet.eligibleElements();
            ImmutableSet.Builder intersectedElementsBuilder = ImmutableSet.builder();
            for (Value leftElement : leftElements) {
                for (Value rightElement : rightElements) {
                    Set<Binding> combinedBindings2;
                    if (!leftElement.equals(rightElement) || (combinedBindings2 = mergeOperator.combineBindings((Set<Binding>)leftBindingMap.get((Object)leftElement), (Set<Binding>)rightBindingMap.get((Object)rightElement))).isEmpty()) continue;
                    intersectedElementsBuilder.add(leftElement);
                    elementsBuilder.add(leftElement);
                    bindingMapBuilder.putAll((Object)leftElement, combinedBindings2);
                }
            }
            for (Value leftElement : Sets.difference(leftElements, rightElements)) {
                combinedBindings = mergeOperator.combineBindings((Set<Binding>)leftBindingMap.get((Object)leftElement), ImmutableSet.of());
                if (combinedBindings.isEmpty()) continue;
                elementsBuilder.add(leftElement);
                bindingMapBuilder.putAll((Object)leftElement, combinedBindings);
            }
            for (Value rightElement : Sets.difference(rightElements, leftElements)) {
                combinedBindings = mergeOperator.combineBindings(ImmutableSet.of(), (Set<Binding>)rightBindingMap.get((Object)rightElement));
                if (combinedBindings.isEmpty()) continue;
                elementsBuilder.add(rightElement);
                bindingMapBuilder.putAll((Object)rightElement, combinedBindings);
            }
            ImmutableCollection intersectedElements = intersectedElementsBuilder.build();
            if (intersectedElements.isEmpty()) break;
            for (Value intersectedElement : intersectedElements) {
                for (Value lastElement : lastElements) {
                    if (!leftDependencies.get((Object)intersectedElement).contains(lastElement) && !rightDependencies.get((Object)intersectedElement).contains(lastElement)) continue;
                    dependencyBuilder.put(intersectedElement, lastElement);
                }
            }
            leftEligibleSet = leftEligibleSet.removeEligibleElements((Set<Value>)((Object)intersectedElements));
            rightEligibleSet = rightEligibleSet.removeEligibleElements((Set<Value>)((Object)intersectedElements));
            lastElements = intersectedElements;
        }
        PartiallyOrderedSet<Value> orderingSet = PartiallyOrderedSet.of(elementsBuilder.build(), dependencyBuilder.build());
        return mergeOperator.createOrdering((SetMultimap<Value, Binding>)((Object)bindingMapBuilder.build()), orderingSet, isDistinct);
    }

    @Nonnull
    private static Set<Binding> combineBindingsForUnion(@Nonnull Set<Binding> leftBindings, @Nonnull Set<Binding> rightBindings) {
        if (leftBindings.isEmpty() || rightBindings.isEmpty()) {
            return ImmutableSet.of();
        }
        OrderingPart.ProvidedSortOrder leftSortOrder = Ordering.sortOrder(leftBindings);
        OrderingPart.ProvidedSortOrder rightSortOrder = Ordering.sortOrder(rightBindings);
        if (leftSortOrder.isDirectional() && rightSortOrder.isDirectional()) {
            if (leftSortOrder != rightSortOrder) {
                return ImmutableSet.of();
            }
            return ImmutableSet.of(Binding.sorted(leftSortOrder));
        }
        if (leftSortOrder.isDirectional() && rightSortOrder == OrderingPart.ProvidedSortOrder.FIXED) {
            return ImmutableSet.of(Binding.sorted(leftSortOrder));
        }
        if (leftSortOrder == OrderingPart.ProvidedSortOrder.FIXED && rightSortOrder.isDirectional()) {
            return ImmutableSet.of(Binding.sorted(rightSortOrder));
        }
        Debugger.sanityCheck(() -> {
            Verify.verify(Ordering.areAllBindingsFixed(leftBindings));
            Verify.verify(Ordering.areAllBindingsFixed(rightBindings));
        });
        return ImmutableSet.copyOf(Sets.union(leftBindings, rightBindings));
    }

    @Nonnull
    private static Set<Binding> combineBindingsForIntersection(@Nonnull Set<Binding> leftBindings, @Nonnull Set<Binding> rightBindings) {
        if (leftBindings.isEmpty() && rightBindings.isEmpty()) {
            return ImmutableSet.of();
        }
        if (rightBindings.isEmpty() && Ordering.areAllBindingsFixed(leftBindings)) {
            return leftBindings;
        }
        if (leftBindings.isEmpty() && Ordering.areAllBindingsFixed(rightBindings)) {
            return rightBindings;
        }
        if (leftBindings.isEmpty() || rightBindings.isEmpty()) {
            return ImmutableSet.of();
        }
        OrderingPart.ProvidedSortOrder leftSortOrder = Ordering.sortOrder(leftBindings);
        OrderingPart.ProvidedSortOrder rightSortOrder = Ordering.sortOrder(rightBindings);
        if (leftSortOrder.isDirectional() && rightSortOrder.isDirectional()) {
            if (leftSortOrder != rightSortOrder) {
                return ImmutableSet.of();
            }
            return ImmutableSet.of(Binding.sorted(leftSortOrder));
        }
        if (leftSortOrder.isDirectional() && rightSortOrder == OrderingPart.ProvidedSortOrder.FIXED) {
            return rightBindings;
        }
        if (leftSortOrder == OrderingPart.ProvidedSortOrder.FIXED && rightSortOrder.isDirectional()) {
            return leftBindings;
        }
        Debugger.sanityCheck(() -> {
            Verify.verify(Ordering.areAllBindingsFixed(leftBindings));
            Verify.verify(Ordering.areAllBindingsFixed(rightBindings));
        });
        return ImmutableSet.copyOf(Sets.union(leftBindings, rightBindings));
    }

    @Nonnull
    public static Ordering concatOrderings(@Nonnull Collection<Ordering> orderings) {
        return orderings.stream().reduce(Ordering::concatOrderings).orElseThrow(() -> new RecordCoreException("unable to concatenate orderings", new Object[0]));
    }

    @Nonnull
    public static Ordering concatOrderings(@Nonnull Ordering leftOrdering, @Nonnull Ordering rightOrdering) {
        SetMultimap<Value, Binding> leftBindingMap = leftOrdering.getBindingMap();
        SetMultimap<Value, Binding> rightBindingMap = rightOrdering.getBindingMap();
        PartiallyOrderedSet<Value> leftOrderingSet = leftOrdering.getOrderingSet();
        PartiallyOrderedSet<Value> rightOrderingSet = rightOrdering.getOrderingSet();
        Verify.verify(leftOrdering.isDistinct());
        Debugger.sanityCheck(() -> Verify.verify(Sets.intersection(leftOrderingSet.getSet(), rightOrderingSet.getSet()).isEmpty()));
        ImmutableCollection orderingElements = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(leftOrderingSet.getSet())).addAll(rightOrderingSet.getSet())).build();
        ImmutableMultimap.Builder dependencyMapBuilder = ((ImmutableSetMultimap.Builder)ImmutableSetMultimap.builder().putAll(leftOrderingSet.getDependencyMap())).putAll(rightOrderingSet.getDependencyMap());
        PartiallyOrderedSet<Value> leftDualOrdering = leftOrderingSet.dualOrder();
        Set<Value> leftMaxElements = leftDualOrdering.eligibleSet().eligibleElements();
        Set<Value> rightMinElements = rightOrderingSet.eligibleSet().eligibleElements();
        for (Value leftMaxElement : leftMaxElements) {
            for (Value rightMinElement : rightMinElements) {
                if (Ordering.areAllBindingsFixed(leftBindingMap.get((Object)leftMaxElement)) || Ordering.areAllBindingsFixed(rightBindingMap.get((Object)rightMinElement))) continue;
                ((ImmutableSetMultimap.Builder)dependencyMapBuilder).put(rightMinElement, leftMaxElement);
            }
        }
        PartiallyOrderedSet<Value> concatenatedOrderingSet = PartiallyOrderedSet.of(orderingElements, ((ImmutableSetMultimap.Builder)dependencyMapBuilder).build());
        ImmutableSetMultimap.Builder combinedBindingMapBuilder = ImmutableSetMultimap.builder();
        combinedBindingMapBuilder.putAll(leftBindingMap);
        combinedBindingMapBuilder.putAll(rightBindingMap);
        return Ordering.ofOrderingSet((SetMultimap<Value, Binding>)((Object)combinedBindingMapBuilder.build()), concatenatedOrderingSet, rightOrdering.isDistinct());
    }

    @Nonnull
    public static Ordering empty() {
        return EMPTY;
    }

    @Nonnull
    protected static BiConsumer<SetMultimap<Value, Binding>, PartiallyOrderedSet<Value>> normalizationCheckConsumer() {
        return Ordering::normalizationCheck;
    }

    protected static void normalizationCheck(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull PartiallyOrderedSet<Value> orderingSet) {
        ImmutableSetMultimap<Value, Binding> normalizedBindingMap = Ordering.normalizeBindingMap(bindingMap);
        Verify.verify(bindingMap.equals(normalizedBindingMap));
        PartiallyOrderedSet<Value> normalizedOrderingSet = Ordering.normalizeOrderingSet(bindingMap, orderingSet);
        Verify.verify(orderingSet.equals(normalizedOrderingSet));
    }

    protected static void singularFixedBindingCheck(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull PartiallyOrderedSet<Value> orderingSet) {
        for (Map.Entry<Value, Collection<Binding>> valueBindingsEntry : bindingMap.asMap().entrySet()) {
            Collection<Binding> bindings = valueBindingsEntry.getValue();
            Verify.verify(!Ordering.areAllBindingsFixed(bindings) || !Ordering.hasMultipleFixedBindings(bindings));
        }
    }

    protected static void noChooseBindingCheck(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull PartiallyOrderedSet<Value> orderingSet) {
        for (Map.Entry<Value, Collection<Binding>> valueBindingsEntry : bindingMap.asMap().entrySet()) {
            Collection<Binding> bindings = valueBindingsEntry.getValue();
            if (!Ordering.isSingularBinding(bindings)) continue;
            Verify.verify(Ordering.sortOrder(bindings) != OrderingPart.ProvidedSortOrder.CHOOSE);
        }
    }

    @Nonnull
    public static Ordering ofOrderingSet(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull PartiallyOrderedSet<Value> orderingSet, boolean isDistinct) {
        return new Ordering(bindingMap, orderingSet, isDistinct, Ordering.normalizationCheckConsumer().andThen(Ordering::singularFixedBindingCheck).andThen(Ordering::noChooseBindingCheck));
    }

    @Nonnull
    public static Ordering ofOrderingSequence(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull List<? extends Value> orderingAsList, boolean isDistinct) {
        return Ordering.ofOrderingSet(bindingMap, Ordering.computeFromOrderingSequence(bindingMap, orderingAsList), isDistinct);
    }

    public static class Binding {
        @Nonnull
        private final OrderingPart.ProvidedSortOrder sortOrder;
        @Nullable
        private final Comparisons.Comparison comparison;

        private Binding(@Nonnull OrderingPart.ProvidedSortOrder sortOrder, @Nullable Comparisons.Comparison comparison) {
            this.sortOrder = sortOrder;
            this.comparison = comparison;
        }

        @Nonnull
        public OrderingPart.ProvidedSortOrder getSortOrder() {
            return this.sortOrder;
        }

        public boolean isFixed() {
            return this.sortOrder == OrderingPart.ProvidedSortOrder.FIXED;
        }

        @Nonnull
        public Comparisons.Comparison getComparison() {
            Verify.verify(this.sortOrder == OrderingPart.ProvidedSortOrder.FIXED);
            return Objects.requireNonNull(this.comparison);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Binding)) {
                return false;
            }
            Binding binding = (Binding)o;
            return this.sortOrder == binding.sortOrder && Objects.equals(this.comparison, binding.comparison);
        }

        public int hashCode() {
            return Objects.hash(this.sortOrder, this.comparison);
        }

        public String toString() {
            return this.sortOrder.getArrowIndicator() + (String)(this.comparison == null ? "" : ":" + String.valueOf(this.comparison));
        }

        @Nonnull
        public static Binding ascending() {
            return Binding.sorted(OrderingPart.ProvidedSortOrder.ASCENDING);
        }

        @Nonnull
        public static Binding descending() {
            return Binding.sorted(OrderingPart.ProvidedSortOrder.DESCENDING);
        }

        @Nonnull
        public static Binding choose() {
            return new Binding(OrderingPart.ProvidedSortOrder.CHOOSE, null);
        }

        @Nonnull
        public static Binding sorted(boolean isReverse) {
            return Binding.sorted(OrderingPart.ProvidedSortOrder.fromIsReverse(isReverse));
        }

        @Nonnull
        public static Binding sorted(@Nonnull OrderingPart.ProvidedSortOrder sortOrder) {
            Verify.verify(sortOrder.isDirectional());
            return new Binding(sortOrder, null);
        }

        @Nonnull
        public static Binding fixed(@Nonnull Comparisons.Comparison comparison) {
            return new Binding(OrderingPart.ProvidedSortOrder.FIXED, comparison);
        }
    }

    public static interface MergeOperator<O extends SetOperationsOrdering> {
        @Nonnull
        public Set<Binding> combineBindings(@Nonnull Set<Binding> var1, @Nonnull Set<Binding> var2);

        @Nonnull
        public O createOrdering(@Nonnull SetMultimap<Value, Binding> var1, @Nonnull PartiallyOrderedSet<Value> var2, boolean var3);

        default public O createFromOrdering(@Nonnull Ordering ordering) {
            return this.createOrdering(ordering.getBindingMap(), ordering.getOrderingSet(), ordering.isDistinct());
        }
    }

    public static abstract class SetOperationsOrdering
    extends Ordering {
        public SetOperationsOrdering(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull PartiallyOrderedSet<Value> orderingSet, boolean isDistinct) {
            super(bindingMap, orderingSet, isDistinct, Ordering::normalizationCheck);
        }

        @Nonnull
        public Iterable<List<Value>> enumerateSatisfyingComparisonKeyValues(@Nonnull RequestedOrdering requestedOrdering) {
            if (requestedOrdering.isDistinct() && !this.isDistinct()) {
                return ImmutableList.of();
            }
            SetMultimap<Value, Binding> bindingMap = this.getBindingMap();
            ImmutableList.Builder reducedRequestedOrderingValuesBuilder = ImmutableList.builder();
            for (OrderingPart.RequestedOrderingPart requestedOrderingPart : requestedOrdering.getOrderingParts()) {
                if (!bindingMap.containsKey(requestedOrderingPart.getValue())) {
                    return ImmutableList.of();
                }
                Collection bindings = bindingMap.get((Object)requestedOrderingPart.getValue());
                OrderingPart.ProvidedSortOrder sortOrder = SetOperationsOrdering.sortOrder(bindings);
                if (!sortOrder.isCompatibleWithRequestedSortOrder((OrderingPart.RequestedSortOrder)requestedOrderingPart.getSortOrder())) {
                    return ImmutableList.of();
                }
                if (sortOrder != OrderingPart.ProvidedSortOrder.FIXED) {
                    reducedRequestedOrderingValuesBuilder.add(requestedOrderingPart.getValue());
                    continue;
                }
                if (bindings.size() <= 1 || !this.promoteToDirectional()) continue;
                reducedRequestedOrderingValuesBuilder.add(requestedOrderingPart.getValue());
            }
            ImmutableCollection reducedRequestedOrderingValues = reducedRequestedOrderingValuesBuilder.build();
            PartiallyOrderedSet<Value> filteredOrderingSet = this.getOrderingSet().filterElements(value -> {
                Collection bindings = bindingMap.get(value);
                return this.isSingularNonFixedValue((Value)value) || bindings.size() > 1 && this.promoteToDirectional();
            });
            return TopologicalSort.satisfyingPermutations(filteredOrderingSet, reducedRequestedOrderingValues, Function.identity(), arg_0 -> SetOperationsOrdering.lambda$enumerateSatisfyingComparisonKeyValues$1((ImmutableList)reducedRequestedOrderingValues, arg_0));
        }

        protected abstract boolean promoteToDirectional();

        @Nonnull
        public Ordering applyComparisonKey(@Nonnull List<OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingParts) {
            Map<Value, OrderingPart.ProvidedOrderingPart> comparisonKeyOrderingPartMap = OrderingPart.toOrderingPartMap(comparisonKeyOrderingParts);
            ImmutableList comparisonKeyValues = comparisonKeyOrderingParts.stream().map(OrderingPart::getValue).collect(ImmutableList.toImmutableList());
            PartiallyOrderedSet<Value> orderingSet = this.getOrderingSet();
            PartiallyOrderedSet comparisonKeyOrderingSet = PartiallyOrderedSet.builder().addListWithDependencies(comparisonKeyValues).build();
            Debugger.sanityCheck(() -> Verify.verify(orderingSet.getSet().containsAll(comparisonKeyOrderingSet.getSet())));
            ImmutableSetMultimap.Builder resultBindingMapBuilder = ImmutableSetMultimap.builder();
            for (Map.Entry<Value, Collection<Binding>> entry : this.getBindingMap().asMap().entrySet()) {
                Value value = entry.getKey();
                Collection<Binding> bindings = entry.getValue();
                if (!comparisonKeyOrderingPartMap.containsKey(value)) {
                    if (!SetOperationsOrdering.areAllBindingsFixed(bindings) || SetOperationsOrdering.hasMultipleFixedBindings(bindings)) continue;
                    resultBindingMapBuilder.putAll((Object)value, bindings);
                    continue;
                }
                OrderingPart.ProvidedOrderingPart providedOrderingPart = Objects.requireNonNull(comparisonKeyOrderingPartMap.get(value));
                OrderingPart.ProvidedSortOrder sortOrder = (OrderingPart.ProvidedSortOrder)providedOrderingPart.getSortOrder();
                Verify.verify(sortOrder.isDirectional());
                resultBindingMapBuilder.put(value, Binding.sorted(sortOrder));
            }
            ImmutableMultimap resultBindingMap = resultBindingMapBuilder.build();
            Sets.SetView<Value> resultSet = Sets.intersection(orderingSet.getSet(), resultBindingMap.keySet());
            ImmutableSetMultimap otherDependencyMap = comparisonKeyOrderingSet.getDependencyMap();
            ImmutableMultimap resultDependencyMap = ((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)ImmutableSetMultimap.builder().putAll(orderingSet.getDependencyMap())).putAll((Multimap)otherDependencyMap)).build();
            PartiallyOrderedSet<Value> resultOrderingSet = PartiallyOrderedSet.of(resultSet, resultDependencyMap);
            return Ordering.ofOrderingSet((SetMultimap<Value, Binding>)((Object)resultBindingMap), resultOrderingSet, this.isDistinct());
        }

        @Nonnull
        public List<OrderingPart.ProvidedOrderingPart> directionalOrderingParts(@Nonnull List<Value> comparisonKeyValues, @Nonnull RequestedOrdering requestedOrdering, @Nonnull OrderingPart.ProvidedSortOrder defaultProvidedSortOrder) {
            Map<Value, OrderingPart.RequestedSortOrder> valueRequestedSortOrderMapMap = requestedOrdering.getValueRequestedSortOrderMap();
            return this.directionalOrderingParts(comparisonKeyValues, valueRequestedSortOrderMapMap, defaultProvidedSortOrder);
        }

        @Nonnull
        public List<OrderingPart.ProvidedOrderingPart> directionalOrderingParts(@Nonnull List<Value> comparisonKeyValues, @Nonnull Map<Value, OrderingPart.RequestedSortOrder> valueRequestedSortOrderMap, @Nonnull OrderingPart.ProvidedSortOrder defaultProvidedSortOrder) {
            SetMultimap<Value, Binding> bindingMap = this.getBindingMap();
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            block4: for (Value comparisonKeyValue : comparisonKeyValues) {
                Verify.verify(bindingMap.containsKey(comparisonKeyValue));
                Collection bindings = bindingMap.get((Object)comparisonKeyValue);
                if (SetOperationsOrdering.isSingularDirectionalBinding(bindings)) {
                    resultBuilder.add(new OrderingPart.ProvidedOrderingPart(comparisonKeyValue, SetOperationsOrdering.sortOrder(bindings)));
                    continue;
                }
                Debugger.sanityCheck(() -> SetOperationsOrdering.lambda$directionalOrderingParts$3((Set)bindings));
                if (!valueRequestedSortOrderMap.containsKey(comparisonKeyValue)) {
                    resultBuilder.add(new OrderingPart.ProvidedOrderingPart(comparisonKeyValue, defaultProvidedSortOrder));
                    continue;
                }
                OrderingPart.RequestedSortOrder requestedSortOrder = valueRequestedSortOrderMap.get(comparisonKeyValue);
                switch (requestedSortOrder) {
                    case ASCENDING: 
                    case DESCENDING: 
                    case ASCENDING_NULLS_LAST: 
                    case DESCENDING_NULLS_FIRST: {
                        resultBuilder.add(new OrderingPart.ProvidedOrderingPart(comparisonKeyValue, requestedSortOrder.toProvidedSortOrder()));
                        continue block4;
                    }
                    case ANY: {
                        resultBuilder.add(new OrderingPart.ProvidedOrderingPart(comparisonKeyValue, defaultProvidedSortOrder));
                        continue block4;
                    }
                }
                throw new RecordCoreException("unable to resolve directional order", new Object[0]);
            }
            return resultBuilder.build();
        }

        private static /* synthetic */ void lambda$directionalOrderingParts$3(Set bindings) {
            SetOperationsOrdering.areAllBindingsFixed(bindings);
        }

        private static /* synthetic */ Integer lambda$enumerateSatisfyingComparisonKeyValues$1(ImmutableList reducedRequestedOrderingValues, List permutation) {
            return reducedRequestedOrderingValues.size();
        }
    }

    public static interface InverseOrderPreservingValue
    extends OrderPreservingValue {
        @Override
        @Nonnull
        default public OrderPreservingKind getOrderPreservingKind() {
            return OrderPreservingKind.INVERSE_ORDER_PRESERVING;
        }

        @Nonnull
        default public <T extends InverseOrderPreservingValue> OrderPreservingKind getOrderPreservingKindExclusive() {
            return this.getOrderPreservingKind();
        }
    }

    public static interface DirectOrderPreservingValue
    extends OrderPreservingValue {
        @Override
        @Nonnull
        default public OrderPreservingKind getOrderPreservingKind() {
            return OrderPreservingKind.DIRECT_ORDER_PRESERVING;
        }

        @Nonnull
        default public <T extends DirectOrderPreservingValue> OrderPreservingKind getOrderPreservingKindExclusive() {
            return this.getOrderPreservingKind();
        }
    }

    public static interface OrderPreservingValue
    extends Value {
        @Nonnull
        public OrderPreservingKind getOrderPreservingKind();
    }

    public static enum OrderPreservingKind {
        NOT_ORDER_PRESERVING,
        DIRECT_ORDER_PRESERVING,
        INVERSE_ORDER_PRESERVING;

    }

    public static class Intersection
    extends SetOperationsOrdering {
        public Intersection(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull PartiallyOrderedSet<Value> orderingSet, boolean isDistinct) {
            super(bindingMap, orderingSet, isDistinct);
        }

        @Override
        protected boolean promoteToDirectional() {
            return false;
        }
    }

    public static class Union
    extends SetOperationsOrdering {
        public Union(@Nonnull SetMultimap<Value, Binding> bindingMap, @Nonnull PartiallyOrderedSet<Value> orderingSet, boolean isDistinct) {
            super(bindingMap, orderingSet, isDistinct);
        }

        @Override
        protected boolean promoteToDirectional() {
            return true;
        }
    }
}

