/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.values.ToOrderedBytesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.tuple.TupleOrdering;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OrderingPart<S extends SortOrder> {
    @Nonnull
    private final Value value;
    @Nonnull
    private final S sortOrder;
    private final Supplier<Integer> hashCodeSupplier;

    protected OrderingPart(@Nonnull Value value, @Nonnull S sortOrder) {
        this.value = OrderingPart.checkValue(value);
        this.sortOrder = sortOrder;
        this.hashCodeSupplier = Suppliers.memoize(this::computeHashCode);
    }

    @Nonnull
    public Value getValue() {
        return this.value;
    }

    @Nonnull
    public S getSortOrder() {
        return this.sortOrder;
    }

    @Nonnull
    public S getDirectionalSortOrderOrDefault(@Nonnull S defaultSortOrder) {
        if (this.sortOrder.isDirectional()) {
            return this.sortOrder;
        }
        return defaultSortOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrderingPart)) {
            return false;
        }
        OrderingPart keyPart = (OrderingPart)o;
        return this.getValue().equals(keyPart.getValue()) && this.getSortOrder() == keyPart.getSortOrder();
    }

    public int hashCode() {
        return this.hashCodeSupplier.get();
    }

    public int computeHashCode() {
        return Objects.hash(this.getValue(), this.getSortOrder().name());
    }

    public String toString() {
        return String.valueOf(this.getValue()) + this.getSortOrder().getArrowIndicator();
    }

    @Nonnull
    public static <S extends SortOrder> List<OrderingPart<S>> prefix(@Nonnull List<? extends OrderingPart<S>> keyParts, int endExclusive) {
        return ImmutableList.copyOf(keyParts.subList(0, endExclusive));
    }

    @Nonnull
    private static Value checkValue(@Nonnull Value value) {
        Set<CorrelationIdentifier> correlatedTo = value.getCorrelatedTo();
        Verify.verify(correlatedTo.size() <= 1);
        Verify.verify(correlatedTo.isEmpty() || Iterables.getOnlyElement(correlatedTo).equals(Quantifier.current()));
        return value;
    }

    @Nonnull
    public static <O extends OrderingPart<S>, S extends SortOrder> Map<Value, O> toOrderingPartMap(@Nonnull Iterable<O> orderingParts) {
        ImmutableMap.Builder<Value, OrderingPart> resultMapBuilder = ImmutableMap.builder();
        for (OrderingPart orderingPart : orderingParts) {
            resultMapBuilder.put(orderingPart.getValue(), orderingPart);
        }
        return resultMapBuilder.build();
    }

    @Nonnull
    public static List<Value> toValues(@Nonnull Iterable<? extends OrderingPart<?>> orderingParts) {
        ImmutableList.Builder resultsBuilder = ImmutableList.builder();
        for (OrderingPart<?> orderingPart : orderingParts) {
            resultsBuilder.add(orderingPart.getValue());
        }
        return resultsBuilder.build();
    }

    public static interface SortOrder {
        @Nonnull
        public String name();

        @Nonnull
        public String getArrowIndicator();

        public boolean isDirectional();

        @Nonnull
        public TupleOrdering.Direction getTupleDirection();

        default public boolean isAnyAscending() {
            Verify.verify(this.isDirectional());
            return this.getTupleDirection().isAscending();
        }

        default public boolean isAnyDescending() {
            Verify.verify(this.isDirectional());
            return this.getTupleDirection().isDescending();
        }

        default public boolean isNullsFirst() {
            Verify.verify(this.isDirectional());
            return this.getTupleDirection().isNullsFirst();
        }

        default public boolean isNullsLast() {
            Verify.verify(this.isDirectional());
            return this.getTupleDirection().isNullsLast();
        }

        default public boolean isCounterflowNulls() {
            Verify.verify(this.isDirectional());
            return this.getTupleDirection().isCounterflowNulls();
        }

        @Nonnull
        public static <SO extends SortOrder> EnumMap<TupleOrdering.Direction, SO> computeDirectionToSortOrder(@Nonnull Class<SO> soClass) {
            SortOrder[] values;
            EnumMap<TupleOrdering.Direction, SortOrder> directionToSortOrderMap = new EnumMap<TupleOrdering.Direction, SortOrder>(TupleOrdering.Direction.class);
            for (SortOrder value : values = (SortOrder[])soClass.getEnumConstants()) {
                if (!value.isDirectional()) continue;
                directionToSortOrderMap.put(value.getTupleDirection(), value);
            }
            return directionToSortOrderMap;
        }

        @Nonnull
        public static <FO extends SortOrder, TO extends SortOrder> TO mapToSortOrder(@Nonnull FO fo, @Nonnull EnumMap<TupleOrdering.Direction, TO> directionToSortOrderMap) {
            Verify.verify(fo.isDirectional());
            return (TO)Objects.requireNonNull((SortOrder)directionToSortOrderMap.get((Object)fo.getTupleDirection()));
        }

        @Nonnull
        public static <FO extends SortOrder, TO extends SortOrder> TO mapToReverseSortOrder(@Nonnull FO fo, @Nonnull EnumMap<TupleOrdering.Direction, TO> directionToSortOrderMap) {
            Verify.verify(fo.isDirectional());
            return (TO)Objects.requireNonNull((SortOrder)directionToSortOrderMap.get((Object)fo.getTupleDirection().reverseDirection()));
        }
    }

    @FunctionalInterface
    public static interface OrderingPartCreator<O extends SortOrder, P extends OrderingPart<O>> {
        public P create(@Nonnull Value var1, @Nonnull O var2);
    }

    public static final class MatchedOrderingPart
    extends OrderingPart<MatchedSortOrder> {
        @Nonnull
        private final CorrelationIdentifier parameterId;
        @Nonnull
        private final ComparisonRange comparisonRange;

        private MatchedOrderingPart(@Nonnull CorrelationIdentifier parameterId, @Nonnull Value orderByValue, @Nonnull ComparisonRange comparisonRange, @Nonnull MatchedSortOrder matchedSortOrder) {
            super(orderByValue, matchedSortOrder);
            this.parameterId = parameterId;
            this.comparisonRange = comparisonRange;
        }

        @Nonnull
        public CorrelationIdentifier getParameterId() {
            return this.parameterId;
        }

        @Nonnull
        public ComparisonRange getComparisonRange() {
            return this.comparisonRange;
        }

        @Nonnull
        public ComparisonRange.Type getComparisonRangeType() {
            return this.comparisonRange.getRangeType();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MatchedOrderingPart)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MatchedOrderingPart that = (MatchedOrderingPart)o;
            return Objects.equals(this.parameterId, that.parameterId) && Objects.equals(this.comparisonRange, that.comparisonRange);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.parameterId, this.comparisonRange);
        }

        @Nonnull
        public MatchedOrderingPart demote() {
            Verify.verify(this.getComparisonRange().isEquality());
            return new MatchedOrderingPart(this.getParameterId(), this.getValue(), ComparisonRange.EMPTY, (MatchedSortOrder)this.getSortOrder());
        }

        @Nonnull
        public static MatchedOrderingPart of(@Nonnull CorrelationIdentifier parameterId, @Nonnull Value orderByValue, @Nullable ComparisonRange comparisonRange, @Nonnull MatchedSortOrder matchedSortOrder) {
            return new MatchedOrderingPart(parameterId, orderByValue, comparisonRange == null ? ComparisonRange.EMPTY : comparisonRange, matchedSortOrder);
        }
    }

    public static final class RequestedOrderingPart
    extends OrderingPart<RequestedSortOrder> {
        public RequestedOrderingPart(@Nonnull Value value, RequestedSortOrder sortOrder) {
            super(value, sortOrder);
        }
    }

    public static final class ProvidedOrderingPart
    extends OrderingPart<ProvidedSortOrder> {
        public ProvidedOrderingPart(@Nonnull Value value, ProvidedSortOrder sortOrder) {
            super(value, sortOrder);
        }

        @Nonnull
        public Value comparisonKeyValue(boolean isReverse) {
            TupleOrdering.Direction tupleDirection = this.toTupleDirection(isReverse);
            Value value = this.getValue();
            if (tupleDirection == TupleOrdering.Direction.ASC_NULLS_FIRST) {
                return value;
            }
            return new ToOrderedBytesValue(value, tupleDirection);
        }

        @Nonnull
        private TupleOrdering.Direction toTupleDirection(boolean isReverse) {
            return isReverse ? ((ProvidedSortOrder)this.getSortOrder()).getTupleDirection().reverseDirection() : ((ProvidedSortOrder)this.getSortOrder()).getTupleDirection();
        }

        @Nonnull
        public static List<Value> comparisonKeyValues(@Nonnull Iterable<ProvidedOrderingPart> comparisonKeyOrderingParts, boolean isReverse) {
            return Streams.stream(comparisonKeyOrderingParts).map(providedOrderingPart -> providedOrderingPart.comparisonKeyValue(isReverse)).collect(ImmutableList.toImmutableList());
        }
    }

    public static enum RequestedSortOrder implements SortOrder
    {
        ASCENDING(TupleOrdering.Direction.ASC_NULLS_FIRST),
        DESCENDING(TupleOrdering.Direction.DESC_NULLS_LAST),
        ASCENDING_NULLS_LAST(TupleOrdering.Direction.ASC_NULLS_LAST),
        DESCENDING_NULLS_FIRST(TupleOrdering.Direction.DESC_NULLS_FIRST),
        ANY("\u2195");

        private static final EnumMap<TupleOrdering.Direction, RequestedSortOrder> directionToSortOrderMap;
        @Nullable
        private final TupleOrdering.Direction tupleDirection;
        @Nonnull
        private final String arrowIndicator;

        private RequestedSortOrder(TupleOrdering.Direction tupleDirection) {
            this.tupleDirection = tupleDirection;
            this.arrowIndicator = tupleDirection.getArrowIndicator();
        }

        private RequestedSortOrder(String arrowIndicator) {
            this.tupleDirection = null;
            this.arrowIndicator = arrowIndicator;
        }

        @Override
        @Nonnull
        public String getArrowIndicator() {
            return this.arrowIndicator;
        }

        @Override
        public boolean isDirectional() {
            return this == ASCENDING || this == DESCENDING || this == ASCENDING_NULLS_LAST || this == DESCENDING_NULLS_FIRST;
        }

        @Override
        @Nonnull
        public TupleOrdering.Direction getTupleDirection() {
            Verify.verify(this.isDirectional());
            return Objects.requireNonNull(this.tupleDirection);
        }

        @Nonnull
        public static RequestedSortOrder fromIsReverse(boolean isReverse) {
            return isReverse ? DESCENDING : ASCENDING;
        }

        @Nonnull
        public ProvidedSortOrder toProvidedSortOrder() {
            return SortOrder.mapToSortOrder(this, ProvidedSortOrder.getDirectionToSortOrderMap());
        }

        @Nonnull
        public MatchedSortOrder toMatchedSortOrder() {
            return SortOrder.mapToSortOrder(this, MatchedSortOrder.getDirectionToSortOrderMap());
        }

        @Nonnull
        static EnumMap<TupleOrdering.Direction, RequestedSortOrder> getDirectionToSortOrderMap() {
            return directionToSortOrderMap;
        }

        @Nonnull
        public static RequestedSortOrder fromDirection(@Nonnull TupleOrdering.Direction direction) {
            return Objects.requireNonNull(directionToSortOrderMap.get((Object)direction));
        }

        static {
            directionToSortOrderMap = SortOrder.computeDirectionToSortOrder(RequestedSortOrder.class);
        }
    }

    public static enum MatchedSortOrder implements SortOrder
    {
        ASCENDING(TupleOrdering.Direction.ASC_NULLS_FIRST),
        DESCENDING(TupleOrdering.Direction.DESC_NULLS_LAST),
        ASCENDING_NULLS_LAST(TupleOrdering.Direction.ASC_NULLS_LAST),
        DESCENDING_NULLS_FIRST(TupleOrdering.Direction.DESC_NULLS_FIRST);

        private static final EnumMap<TupleOrdering.Direction, MatchedSortOrder> directionToSortOrderMap;
        @Nonnull
        private final TupleOrdering.Direction tupleDirection;

        private MatchedSortOrder(TupleOrdering.Direction tupleDirection) {
            this.tupleDirection = tupleDirection;
        }

        @Override
        @Nonnull
        public String getArrowIndicator() {
            return this.tupleDirection.getArrowIndicator();
        }

        @Override
        public boolean isDirectional() {
            return true;
        }

        @Override
        @Nonnull
        public TupleOrdering.Direction getTupleDirection() {
            return this.tupleDirection;
        }

        @Nonnull
        public ProvidedSortOrder toProvidedSortOrder() {
            return this.toProvidedSortOrder(false);
        }

        @Nonnull
        public ProvidedSortOrder toProvidedSortOrder(boolean isReverse) {
            if (isReverse) {
                return SortOrder.mapToReverseSortOrder(this, ProvidedSortOrder.getDirectionToSortOrderMap());
            }
            return SortOrder.mapToSortOrder(this, ProvidedSortOrder.getDirectionToSortOrderMap());
        }

        @Nonnull
        public RequestedSortOrder toRequestedSortOrder() {
            return SortOrder.mapToSortOrder(this, RequestedSortOrder.getDirectionToSortOrderMap());
        }

        @Nonnull
        static EnumMap<TupleOrdering.Direction, MatchedSortOrder> getDirectionToSortOrderMap() {
            return directionToSortOrderMap;
        }

        @Nonnull
        public static MatchedSortOrder fromDirection(@Nonnull TupleOrdering.Direction direction) {
            return Objects.requireNonNull(directionToSortOrderMap.get((Object)direction));
        }

        static {
            directionToSortOrderMap = SortOrder.computeDirectionToSortOrder(MatchedSortOrder.class);
        }
    }

    public static enum ProvidedSortOrder implements SortOrder
    {
        ASCENDING(TupleOrdering.Direction.ASC_NULLS_FIRST),
        DESCENDING(TupleOrdering.Direction.DESC_NULLS_LAST),
        ASCENDING_NULLS_LAST(TupleOrdering.Direction.ASC_NULLS_LAST),
        DESCENDING_NULLS_FIRST(TupleOrdering.Direction.DESC_NULLS_FIRST),
        FIXED("="),
        CHOOSE("?");

        private static final EnumMap<TupleOrdering.Direction, ProvidedSortOrder> directionToSortOrderMap;
        @Nullable
        private final TupleOrdering.Direction tupleDirection;
        @Nonnull
        private final String arrowIndicator;

        private ProvidedSortOrder(TupleOrdering.Direction tupleDirection) {
            this.tupleDirection = tupleDirection;
            this.arrowIndicator = tupleDirection.getArrowIndicator();
        }

        private ProvidedSortOrder(String arrowIndicator) {
            this.tupleDirection = null;
            this.arrowIndicator = arrowIndicator;
        }

        @Override
        @Nonnull
        public String getArrowIndicator() {
            return this.arrowIndicator;
        }

        @Override
        public boolean isDirectional() {
            switch (this) {
                case ASCENDING: 
                case DESCENDING: 
                case ASCENDING_NULLS_LAST: 
                case DESCENDING_NULLS_FIRST: {
                    return true;
                }
            }
            return false;
        }

        @Override
        @Nonnull
        public TupleOrdering.Direction getTupleDirection() {
            Verify.verify(this.isDirectional());
            return Objects.requireNonNull(this.tupleDirection);
        }

        public boolean isCompatibleWithRequestedSortOrder(@Nonnull RequestedSortOrder requestedSortOrder) {
            if (requestedSortOrder == RequestedSortOrder.ANY || this == CHOOSE || this == FIXED) {
                return true;
            }
            if (this.isCounterflowNulls() != requestedSortOrder.isCounterflowNulls()) {
                return false;
            }
            return this.isAnyAscending() == requestedSortOrder.isAnyAscending();
        }

        @Nonnull
        public ProvidedSortOrder flipIfReverse(boolean isReverse) {
            if (isReverse) {
                return SortOrder.mapToReverseSortOrder(this, ProvidedSortOrder.getDirectionToSortOrderMap());
            }
            return this;
        }

        @Nonnull
        public MatchedSortOrder toMatchedSortOrder() {
            return SortOrder.mapToSortOrder(this, MatchedSortOrder.getDirectionToSortOrderMap());
        }

        @Nonnull
        public RequestedSortOrder toRequestedSortOrder() {
            return SortOrder.mapToSortOrder(this, RequestedSortOrder.getDirectionToSortOrderMap());
        }

        @Nonnull
        static EnumMap<TupleOrdering.Direction, ProvidedSortOrder> getDirectionToSortOrderMap() {
            return directionToSortOrderMap;
        }

        @Nonnull
        public static ProvidedSortOrder fromDirection(@Nonnull TupleOrdering.Direction direction) {
            return Objects.requireNonNull(directionToSortOrderMap.get((Object)direction));
        }

        @Nonnull
        public static ProvidedSortOrder fromIsReverse(boolean isReverse) {
            return isReverse ? DESCENDING : ASCENDING;
        }

        static {
            directionToSortOrderMap = SortOrder.computeDirectionToSortOrder(ProvidedSortOrder.class);
        }
    }
}

