/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Compensation;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.IdentityBiMap;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMap;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Equivalence;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PartialMatch {
    @Nonnull
    private final AliasMap boundAliasMap;
    @Nonnull
    private final MatchCandidate matchCandidate;
    @Nonnull
    private final Reference queryRef;
    @Nonnull
    private final RelationalExpression queryExpression;
    @Nonnull
    private final Reference candidateRef;
    @Nonnull
    private final MatchInfo matchInfo;
    @Nonnull
    private final Supplier<Map<CorrelationIdentifier, ComparisonRange>> boundParameterPrefixMapSupplier;
    @Nonnull
    private final Supplier<Set<Placeholder>> boundPlaceholdersSupplier;
    @Nonnull
    private final Supplier<Set<Quantifier>> matchedQuantifiersSupplier;
    @Nonnull
    private final Supplier<Set<Quantifier>> unmatchedQuantifiersSupplier;
    @Nonnull
    private final Supplier<Set<CorrelationIdentifier>> compensatedAliasesSupplier;
    @Nonnull
    private final Supplier<PredicateMap> accumulatedPredicateMapSupplier;
    @Nonnull
    private final Map<QueryPredicate, Optional<PredicateMultiMap.PredicateMapping>> memoizedPulledUpPredicateMap;

    public PartialMatch(@Nonnull AliasMap boundAliasMap, @Nonnull MatchCandidate matchCandidate, @Nonnull Reference queryRef, @Nonnull RelationalExpression queryExpression, @Nonnull Reference candidateRef, @Nonnull MatchInfo matchInfo) {
        this.boundAliasMap = boundAliasMap;
        this.matchCandidate = matchCandidate;
        this.queryRef = queryRef;
        this.queryExpression = queryExpression;
        this.candidateRef = candidateRef;
        this.matchInfo = matchInfo;
        this.boundParameterPrefixMapSupplier = Suppliers.memoize(this::computeBoundParameterPrefixMap);
        this.boundPlaceholdersSupplier = Suppliers.memoize(this::computeBoundPlaceholders);
        this.matchedQuantifiersSupplier = Suppliers.memoize(this::computeMatchedQuantifiers);
        this.unmatchedQuantifiersSupplier = Suppliers.memoize(this::computeUnmatchedQuantifiers);
        this.compensatedAliasesSupplier = Suppliers.memoize(this::computeCompensatedAliases);
        this.accumulatedPredicateMapSupplier = Suppliers.memoize(this::computeAccumulatedPredicateMap);
        this.memoizedPulledUpPredicateMap = new LinkedIdentityMap<QueryPredicate, Optional<PredicateMultiMap.PredicateMapping>>();
    }

    @Nonnull
    public AliasMap getBoundAliasMap() {
        return this.boundAliasMap;
    }

    @Nonnull
    public MatchCandidate getMatchCandidate() {
        return this.matchCandidate;
    }

    @Nonnull
    public Reference getQueryRef() {
        return this.queryRef;
    }

    @Nonnull
    public RelationalExpression getQueryExpression() {
        return this.queryExpression;
    }

    @Nonnull
    public Reference getCandidateRef() {
        return this.candidateRef;
    }

    @Nonnull
    public MatchInfo getMatchInfo() {
        return this.matchInfo;
    }

    @Nonnull
    public MatchInfo.RegularMatchInfo getRegularMatchInfo() {
        return this.matchInfo.getRegularMatchInfo();
    }

    public int getNumBoundParameterPrefix() {
        return this.getBoundParameterPrefixMap().size();
    }

    @Nonnull
    public Map<CorrelationIdentifier, ComparisonRange> getBoundParameterPrefixMap() {
        return this.boundParameterPrefixMapSupplier.get();
    }

    @Nonnull
    private Map<CorrelationIdentifier, ComparisonRange> computeBoundParameterPrefixMap() {
        return this.getMatchCandidate().computeBoundParameterPrefixMap(this.getMatchInfo());
    }

    @Nonnull
    public Set<Quantifier> getMatchedQuantifiers() {
        return this.matchedQuantifiersSupplier.get();
    }

    @Nonnull
    private Set<Quantifier> computeMatchedQuantifiers() {
        return this.queryExpression.getQuantifiers().stream().filter(quantifier -> this.matchInfo.getRegularMatchInfo().getChildPartialMatchMaybe(quantifier.getAlias()).isPresent()).collect(LinkedIdentitySet.toLinkedIdentitySet());
    }

    @Nonnull
    public Set<Quantifier> getUnmatchedQuantifiers() {
        return this.unmatchedQuantifiersSupplier.get();
    }

    @Nonnull
    private Set<Quantifier> computeUnmatchedQuantifiers() {
        return this.queryExpression.getQuantifiers().stream().filter(quantifier -> this.matchInfo.getRegularMatchInfo().getChildPartialMatchMaybe(quantifier.getAlias()).isEmpty()).collect(LinkedIdentitySet.toLinkedIdentitySet());
    }

    @Nonnull
    public final Set<Placeholder> getBoundPlaceholders() {
        return this.boundPlaceholdersSupplier.get();
    }

    @Nonnull
    private Set<Placeholder> computeBoundPlaceholders() {
        Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap = this.getBoundParameterPrefixMap();
        Set<Placeholder> boundPlaceholders = Sets.newIdentityHashSet();
        for (Map.Entry<QueryPredicate, PredicateMultiMap.PredicateMapping> entry : this.getAccumulatedPredicateMap().entries()) {
            Placeholder placeholder;
            QueryPredicate candidatePredicate;
            PredicateMultiMap.PredicateMapping predicateMapping = entry.getValue();
            if (predicateMapping.getMappingKind() != PredicateMultiMap.PredicateMapping.MappingKind.REGULAR_IMPLIES_CANDIDATE || !((candidatePredicate = predicateMapping.getCandidatePredicate()) instanceof Placeholder) || !boundParameterPrefixMap.containsKey((placeholder = (Placeholder)candidatePredicate).getParameterAlias())) continue;
            boundPlaceholders.add(placeholder);
        }
        return boundPlaceholders;
    }

    @Nonnull
    public final Set<CorrelationIdentifier> getCompensatedAliases() {
        return this.compensatedAliasesSupplier.get();
    }

    @Nonnull
    private Set<CorrelationIdentifier> computeCompensatedAliases() {
        ImmutableSet.Builder compensatedAliasesBuilder = ImmutableSet.builder();
        Set<CorrelationIdentifier> ownedAliases = Quantifiers.aliasToQuantifierMap(this.queryExpression.getQuantifiers()).keySet();
        this.queryExpression.getMatchedQuantifiers(this).stream().map(Quantifier::getAlias).forEach(compensatedAliasesBuilder::add);
        PredicateMultiMap predicatesMap = this.matchInfo.getRegularMatchInfo().getPredicateMap();
        for (QueryPredicate queryPredicate : predicatesMap.keySet()) {
            Set<CorrelationIdentifier> predicateCorrelatedTo = queryPredicate.getCorrelatedTo();
            predicateCorrelatedTo.stream().filter(ownedAliases::contains).forEach(compensatedAliasesBuilder::add);
        }
        return compensatedAliasesBuilder.build();
    }

    @Nonnull
    public PredicateMap getAccumulatedPredicateMap() {
        return this.accumulatedPredicateMapSupplier.get();
    }

    @SpotBugsSuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private PredicateMap computeAccumulatedPredicateMap() {
        PredicateMap.Builder targetBuilder = PredicateMap.builder();
        MatchInfo.RegularMatchInfo regularMatchInfo = this.getRegularMatchInfo();
        targetBuilder.putAll(regularMatchInfo.getPredicateMap());
        for (Equivalence.Wrapper partialMatchWrapper : regularMatchInfo.getPartialMatchMap().values()) {
            PartialMatch childPartialMatch = Objects.requireNonNull((PartialMatch)partialMatchWrapper.get());
            targetBuilder.putAll(childPartialMatch.getAccumulatedPredicateMap());
        }
        return targetBuilder.build();
    }

    @Nonnull
    public Map<QueryPredicate, PredicateMultiMap.PredicateMapping> pullUpToParent(@Nonnull CorrelationIdentifier candidateAlias, @Nonnull Predicate<QueryPredicate> predicateFilter) {
        Set<QueryPredicate> interestingPredicates = this.getAccumulatedPredicateMap().getMap().keySet().stream().filter(predicateFilter).collect(LinkedIdentitySet.toLinkedIdentitySet());
        return this.pullUpToParent(candidateAlias, interestingPredicates);
    }

    @Nonnull
    public Map<QueryPredicate, PredicateMultiMap.PredicateMapping> pullUpToParent(@Nonnull CorrelationIdentifier candidateAlias, @Nonnull Set<QueryPredicate> interestingPredicates) {
        Map<QueryPredicate, PredicateMultiMap.PredicateMapping> childPredicateMappings = this.getPulledUpPredicateMappings(interestingPredicates);
        LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateMapping> resultsMap = new LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateMapping>();
        PullUp pullUp = this.pullUp(candidateAlias);
        for (Map.Entry<QueryPredicate, PredicateMultiMap.PredicateMapping> childPredicateMappingEntry : childPredicateMappings.entrySet()) {
            QueryPredicate originalQueryPredicate = childPredicateMappingEntry.getKey();
            PredicateMultiMap.PredicateMapping childPredicateMapping = childPredicateMappingEntry.getValue();
            Optional<QueryPredicate> pulledUpPredicateOptional = childPredicateMapping.getTranslatedQueryPredicate().replaceValuesMaybe(pullUp::pullUpValueMaybe);
            pulledUpPredicateOptional.ifPresent(queryPredicate -> resultsMap.put(originalQueryPredicate, childPredicateMapping.withTranslatedQueryPredicate((QueryPredicate)queryPredicate)));
        }
        return resultsMap;
    }

    @Nonnull
    public Map<QueryPredicate, PredicateMultiMap.PredicateMapping> getPulledUpPredicateMappings(@Nonnull Set<QueryPredicate> interestingPredicates) {
        LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateMapping> resultMap = new LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateMapping>();
        LinkedIdentitySet<QueryPredicate> unmemoizedInterestingPredicates = new LinkedIdentitySet<QueryPredicate>();
        for (QueryPredicate interestingPredicate : interestingPredicates) {
            Optional<PredicateMultiMap.PredicateMapping> memoizedTranslatedPredicateMappingOptional = this.memoizedPulledUpPredicateMap.get(interestingPredicate);
            if (memoizedTranslatedPredicateMappingOptional != null) {
                memoizedTranslatedPredicateMappingOptional.ifPresent(predicateMapping -> resultMap.put(interestingPredicate, (PredicateMultiMap.PredicateMapping)predicateMapping));
                continue;
            }
            unmemoizedInterestingPredicates.add(interestingPredicate);
        }
        RelationalExpression candidateExpression = this.candidateRef.get();
        Map<QueryPredicate, PredicateMultiMap.PredicateMapping> resultMapFromMatchInfo = this.getMatchInfo().collectPulledUpPredicateMappings(candidateExpression, unmemoizedInterestingPredicates);
        for (QueryPredicate interestingPredicate : unmemoizedInterestingPredicates) {
            PredicateMultiMap.PredicateMapping memoizedPulledUpPredicateMapping = resultMapFromMatchInfo.get(interestingPredicate);
            if (memoizedPulledUpPredicateMapping == null) {
                this.memoizedPulledUpPredicateMap.put(interestingPredicate, Optional.empty());
                continue;
            }
            this.memoizedPulledUpPredicateMap.put(interestingPredicate, Optional.of(memoizedPulledUpPredicateMapping));
            resultMap.put(interestingPredicate, memoizedPulledUpPredicateMapping);
        }
        return resultMap;
    }

    @Nonnull
    public Compensation compensateCompleteMatch(@Nullable PullUp unificationPullUp, @Nonnull CorrelationIdentifier candidateTopAlias) {
        return this.queryExpression.compensate(this, this.getBoundParameterPrefixMap(), unificationPullUp, candidateTopAlias);
    }

    @Nonnull
    public Compensation compensate(@Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nonnull PullUp pullUp, @Nonnull CorrelationIdentifier candidateAlias) {
        return this.queryExpression.compensate(this, boundParameterPrefixMap, pullUp, candidateAlias);
    }

    @Nonnull
    public Compensation compensateExistential(@Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap) {
        return this.queryExpression.compensate(this, boundParameterPrefixMap, null, Quantifier.uniqueId());
    }

    @Nullable
    public PullUp.UnificationPullUp prepareForUnification(@Nonnull CorrelationIdentifier topAlias, @Nonnull CorrelationIdentifier topCandidateAlias) {
        return this.getMatchCandidate().prepareForUnification(this, topAlias, topCandidateAlias);
    }

    @Nonnull
    public PullUp pullUp(@Nonnull CorrelationIdentifier candidateAlias) {
        return Objects.requireNonNull(this.nestPullUp(null, candidateAlias).getRight());
    }

    @Nonnull
    public Pair<PullUp, PullUp> nestPullUp(@Nullable PullUp pullUp, @Nonnull CorrelationIdentifier candidateAlias) {
        PullUp rootOfMatchPullUp = null;
        MatchInfo currentMatchInfo = this.getMatchInfo();
        Reference currentCandidateRef = this.candidateRef;
        PullUp currentPullUp = pullUp;
        CorrelationIdentifier currentCandidateAlias = candidateAlias;
        while (true) {
            RelationalExpressionVisitor<PullUp> nestingVisitor = PullUp.visitor(currentPullUp, currentCandidateAlias);
            RelationalExpression currentCandidateExpression = currentCandidateRef.get();
            currentPullUp = nestingVisitor.visit(currentCandidateRef.get());
            if (!(pullUp instanceof PullUp.MatchPullUp) && rootOfMatchPullUp == null) {
                rootOfMatchPullUp = currentPullUp;
            }
            if (!currentMatchInfo.isAdjusted()) break;
            List<? extends Quantifier> currentQuantifiers = currentCandidateExpression.getQuantifiers();
            Verify.verify(currentQuantifiers.size() == 1);
            Quantifier currentQuantifier = currentQuantifiers.get(0);
            currentCandidateAlias = currentQuantifier.getAlias();
            currentCandidateRef = currentQuantifier.getRangesOver();
            currentMatchInfo = ((MatchInfo.AdjustedMatchInfo)currentMatchInfo).getUnderlying();
        }
        return Pair.of(rootOfMatchPullUp, currentPullUp);
    }

    public boolean compensationCanBeDeferred() {
        return this.getUnmatchedQuantifiers().stream().noneMatch(quantifier -> quantifier instanceof Quantifier.ForEach);
    }

    @Nonnull
    public static Collection<MatchInfo> matchInfosFromMap(@Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap) {
        return partialMatchMap.values().stream().map(IdentityBiMap::unwrap).map(Objects::requireNonNull).map(PartialMatch::getMatchInfo).collect(ImmutableList.toImmutableList());
    }

    public String toString() {
        return this.getQueryExpression().getClass().getSimpleName() + "[" + this.getMatchCandidate().getName() + "]";
    }
}

