/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.ExpressionPartition;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Verify;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class PlanPartition
extends ExpressionPartition<RecordQueryPlan> {
    private PlanPartition(@Nonnull Map<ExpressionProperty<?>, ?> propertyValuesMap, @Nonnull Map<RecordQueryPlan, Map<ExpressionProperty<?>, ?>> planPropertyMap) {
        super(propertyValuesMap, planPropertyMap);
    }

    @Nonnull
    public Set<RecordQueryPlan> getPlans() {
        return this.getExpressions();
    }

    @Nonnull
    public PlanPartition filter(@Nonnull Predicate<RecordQueryPlan> expressionPredicate) {
        return this.with((Map)this.getPartitionPropertiesMap(), (Map)this.filterGroupedPropertyMap(expressionPredicate));
    }

    @Nonnull
    protected PlanPartition with(@Nonnull Map<ExpressionProperty<?>, ?> groupingPropertyMap, @Nonnull Map<RecordQueryPlan, Map<ExpressionProperty<?>, ?>> groupedPropertyMap) {
        return new PlanPartition(groupingPropertyMap, groupedPropertyMap);
    }

    @Nonnull
    public static PlanPartition ofPlans(@Nonnull Map<ExpressionProperty<?>, ?> propertyValuesMap, @Nonnull Map<RecordQueryPlan, Map<ExpressionProperty<?>, ?>> planPropertyMap) {
        return new PlanPartition(propertyValuesMap, planPropertyMap);
    }

    @Nonnull
    public static PlanPartition ofExpressions(@Nonnull Map<ExpressionProperty<?>, ?> propertyValuesMap, @Nonnull Map<? extends RelationalExpression, Map<ExpressionProperty<?>, ?>> expressionPropertyMap) {
        Debugger.sanityCheck(() -> Verify.verify(expressionPropertyMap.keySet().stream().allMatch(plan -> plan instanceof RecordQueryPlan)));
        return new PlanPartition(propertyValuesMap, (Map<RecordQueryPlan, Map<ExpressionProperty<?>, ?>>)expressionPropertyMap);
    }
}

