/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.CascadesCostModel;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.PlannerStage;
import com.apple.foundationdb.record.query.plan.cascades.PlanningCostModel;
import com.apple.foundationdb.record.query.plan.cascades.PlanningRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.RewritingCostModel;
import com.apple.foundationdb.record.query.plan.cascades.RewritingRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PPlannerPhase;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum PlannerPhase {
    PLANNING(PlanningRuleSet.getDefault(), PlannerStage.PLANNED, PlanningCostModel::new),
    REWRITING(RewritingRuleSet.getDefault(), PlannerStage.CANONICAL, RewritingCostModel::new, PLANNING);

    @Nonnull
    private final CascadesRuleSet ruleSet;
    @Nonnull
    private final PlannerStage targetStage;
    @Nonnull
    private final Function<RecordQueryPlannerConfiguration, CascadesCostModel> costModelCreator;
    @Nullable
    private final PlannerPhase nextPhase;

    private PlannerPhase(@Nonnull CascadesRuleSet ruleSet, PlannerStage targetStage, Function<RecordQueryPlannerConfiguration, CascadesCostModel> costModelCreator) {
        this(ruleSet, targetStage, costModelCreator, null);
    }

    private PlannerPhase(@Nonnull CascadesRuleSet ruleSet, @Nullable PlannerStage targetStage, Function<RecordQueryPlannerConfiguration, CascadesCostModel> costModelCreator, PlannerPhase nextPhase) {
        this.ruleSet = ruleSet;
        this.targetStage = targetStage;
        this.costModelCreator = costModelCreator;
        this.nextPhase = nextPhase;
    }

    @Nonnull
    public CascadesRuleSet getRuleSet() {
        return this.ruleSet;
    }

    @Nonnull
    public PlannerStage getTargetPlannerStage() {
        return this.targetStage;
    }

    @Nonnull
    public CascadesCostModel createCostModel(@Nonnull RecordQueryPlannerConfiguration configuration) {
        return this.costModelCreator.apply(configuration);
    }

    @Nonnull
    public PlannerPhase getNextPhase() {
        return Objects.requireNonNull(this.nextPhase);
    }

    public boolean hasNextPhase() {
        return this.nextPhase != null;
    }

    @Nonnull
    public PPlannerPhase toProto() {
        switch (this) {
            case REWRITING: {
                return PPlannerPhase.REWRITING;
            }
            case PLANNING: {
                return PPlannerPhase.PLANNING;
            }
        }
        throw new RecordCoreException("no proto mapping for java planner phase", new Object[0]);
    }
}

