/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.ExpressionPropertiesMap;
import com.apple.foundationdb.record.query.plan.cascades.PlanPropertiesMap;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.google.common.base.Verify;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public enum PlannerStage {
    INITIAL(ExpressionPropertiesMap::defaultForRewritePhase),
    CANONICAL(ExpressionPropertiesMap::defaultForRewritePhase),
    PLANNED(PlanPropertiesMap::new);

    @Nonnull
    private final Supplier<ExpressionPropertiesMap<? extends RelationalExpression>> propertiesMapCreator;

    private PlannerStage(Supplier<ExpressionPropertiesMap<? extends RelationalExpression>> propertiesMapCreator) {
        this.propertiesMapCreator = propertiesMapCreator;
    }

    @Nonnull
    public ExpressionPropertiesMap<? extends RelationalExpression> createPropertiesMap() {
        return this.propertiesMapCreator.get();
    }

    public boolean directlyPrecedes(@Nonnull PlannerStage other) {
        return this.precedes(other) && this.ordinal() == other.ordinal() - 1;
    }

    public boolean precedes(@Nonnull PlannerStage other) {
        Verify.verify(this != other);
        return this.ordinal() < other.ordinal();
    }

    public boolean directlySucceeds(@Nonnull PlannerStage other) {
        return this.succeeds(other) && this.ordinal() == other.ordinal() + 1;
    }

    public boolean succeeds(@Nonnull PlannerStage other) {
        Verify.verify(this != other);
        return this.ordinal() > other.ordinal();
    }
}

