/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.CascadesCostModel;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.FindExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.properties.CardinalitiesProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.ComparisonsProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.ExpressionDepthProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.NormalizedResidualPredicateProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.TypeFilterCountProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.UnmatchedFieldsCountProperty;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
@SpotBugsSuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
public class PlanningCostModel
implements CascadesCostModel {
    @Nonnull
    private static final Set<Class<? extends RelationalExpression>> interestingPlanClasses = ImmutableSet.of(RecordQueryScanPlan.class, RecordQueryPlanWithIndex.class, RecordQueryCoveringIndexPlan.class, RecordQueryFetchFromPartialRecordPlan.class, RecordQueryInJoinPlan.class, RecordQueryMapPlan.class, new Class[]{RecordQueryPredicatesFilterPlan.class});
    @Nonnull
    private final RecordQueryPlannerConfiguration configuration;

    public PlanningCostModel(@Nonnull RecordQueryPlannerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    @Nonnull
    public RecordQueryPlannerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int compare(@Nonnull RelationalExpression a, @Nonnull RelationalExpression b) {
        int numSimpleOperationsB;
        int ufpB;
        int distinctFilterPositionCompare;
        int typeFilterCountB;
        int numDataAccessB;
        int unsatisfiedFilterCompare;
        if (a instanceof RecordQueryPlan && !(b instanceof RecordQueryPlan)) {
            return -1;
        }
        if (!(a instanceof RecordQueryPlan) && b instanceof RecordQueryPlan) {
            return 1;
        }
        Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> planOpsMapA = FindExpressionVisitor.evaluate(interestingPlanClasses, a);
        Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> planOpsMapB = FindExpressionVisitor.evaluate(interestingPlanClasses, b);
        CardinalitiesProperty.Cardinalities cardinalitiesA = CardinalitiesProperty.cardinalities().evaluate(a);
        CardinalitiesProperty.Cardinalities cardinalitiesB = CardinalitiesProperty.cardinalities().evaluate(b);
        if (!cardinalitiesA.getMaxCardinality().isUnknown() || !cardinalitiesB.getMaxCardinality().isUnknown()) {
            CardinalitiesProperty.Cardinality maxOfMaxCardinalityOfAllDataAccessesA = this.maxOfMaxCardinalitiesOfAllDataAccesses(planOpsMapA);
            CardinalitiesProperty.Cardinality maxOfMaxCardinalityOfAllDataAccessesB = this.maxOfMaxCardinalitiesOfAllDataAccesses(planOpsMapB);
            if (!maxOfMaxCardinalityOfAllDataAccessesA.isUnknown() || !maxOfMaxCardinalityOfAllDataAccessesB.isUnknown()) {
                if (maxOfMaxCardinalityOfAllDataAccessesA.isUnknown()) {
                    return 1;
                }
                if (maxOfMaxCardinalityOfAllDataAccessesB.isUnknown()) {
                    return -1;
                }
                int maxOfMaxCardinalityCompare = Long.compare(maxOfMaxCardinalityOfAllDataAccessesA.getCardinality(), maxOfMaxCardinalityOfAllDataAccessesB.getCardinality());
                if (maxOfMaxCardinalityCompare != 0) {
                    return maxOfMaxCardinalityCompare;
                }
            }
        }
        if ((unsatisfiedFilterCompare = Long.compare(NormalizedResidualPredicateProperty.countNormalizedConjuncts(a), NormalizedResidualPredicateProperty.countNormalizedConjuncts(b))) != 0) {
            return unsatisfiedFilterCompare;
        }
        int numDataAccessA = PlanningCostModel.count(planOpsMapA, RecordQueryScanPlan.class, RecordQueryPlanWithIndex.class, RecordQueryCoveringIndexPlan.class);
        int countDataAccessesCompare = Integer.compare(numDataAccessA, numDataAccessB = PlanningCostModel.count(planOpsMapB, RecordQueryScanPlan.class, RecordQueryPlanWithIndex.class, RecordQueryCoveringIndexPlan.class));
        if (countDataAccessesCompare != 0) {
            return countDataAccessesCompare;
        }
        OptionalInt inPlanVsOtherOptional = PlanningCostModel.flipFlop(() -> PlanningCostModel.compareInOperator(a, b), () -> PlanningCostModel.compareInOperator(b, a));
        if (inPlanVsOtherOptional.isPresent() && inPlanVsOtherOptional.getAsInt() != 0) {
            return inPlanVsOtherOptional.getAsInt();
        }
        int typeFilterCountA = TypeFilterCountProperty.typeFilterCount().evaluate(a);
        OptionalInt primaryScanVsIndexScanCompareOptional = PlanningCostModel.flipFlop(() -> this.lambda$compare$2(a, b, planOpsMapA, planOpsMapB, typeFilterCountA, typeFilterCountB = TypeFilterCountProperty.typeFilterCount().evaluate(b)), () -> this.comparePrimaryScanToIndexScan(b, a, planOpsMapB, planOpsMapA, typeFilterCountB, typeFilterCountA));
        if (primaryScanVsIndexScanCompareOptional.isPresent() && primaryScanVsIndexScanCompareOptional.getAsInt() != 0) {
            return primaryScanVsIndexScanCompareOptional.getAsInt();
        }
        int typeFilterCountCompare = Integer.compare(typeFilterCountA, typeFilterCountB);
        if (typeFilterCountCompare != 0) {
            return typeFilterCountCompare;
        }
        int typeFilterPositionCompare = Integer.compare(ExpressionDepthProperty.typeFilterDepth().evaluate(b), ExpressionDepthProperty.typeFilterDepth().evaluate(a));
        if (typeFilterPositionCompare != 0) {
            return typeFilterPositionCompare;
        }
        if (PlanningCostModel.count(planOpsMapA, RecordQueryPlanWithIndex.class, RecordQueryCoveringIndexPlan.class) > 0 && PlanningCostModel.count(planOpsMapB, RecordQueryPlanWithIndex.class, RecordQueryCoveringIndexPlan.class) > 0) {
            int numFetchesB;
            int numFetchesA = PlanningCostModel.count(planOpsMapA, RecordQueryPlanWithIndex.class, RecordQueryFetchFromPartialRecordPlan.class);
            int numFetchesCompare = Integer.compare(numFetchesA, numFetchesB = PlanningCostModel.count(planOpsMapB, RecordQueryPlanWithIndex.class, RecordQueryFetchFromPartialRecordPlan.class));
            if (numFetchesCompare != 0) {
                return numFetchesCompare;
            }
            int fetchDepthB = ExpressionDepthProperty.fetchDepth().evaluate(b);
            int fetchDepthA = ExpressionDepthProperty.fetchDepth().evaluate(a);
            int fetchPositionCompare = Integer.compare(fetchDepthA, fetchDepthB);
            if (fetchPositionCompare != 0) {
                return fetchPositionCompare;
            }
            int numFetchOperatorsCompare = Integer.compare(PlanningCostModel.count(planOpsMapA, RecordQueryFetchFromPartialRecordPlan.class), PlanningCostModel.count(planOpsMapB, RecordQueryFetchFromPartialRecordPlan.class));
            if (numFetchOperatorsCompare != 0) {
                return numFetchOperatorsCompare;
            }
        }
        if ((distinctFilterPositionCompare = Integer.compare(ExpressionDepthProperty.distinctDepth().evaluate(b), ExpressionDepthProperty.distinctDepth().evaluate(a))) != 0) {
            return distinctFilterPositionCompare;
        }
        int ufpA = UnmatchedFieldsCountProperty.unmatchedFieldsCount().evaluate(a);
        if (ufpA != (ufpB = UnmatchedFieldsCountProperty.unmatchedFieldsCount().evaluate(b))) {
            return Integer.compare(ufpA, ufpB);
        }
        int numSourcesInJoinA = PlanningCostModel.count(planOpsMapA, RecordQueryInJoinPlan.class);
        int numSourcesInJoinB = PlanningCostModel.count(planOpsMapB, RecordQueryInJoinPlan.class);
        int numSourcesInJoinCompare = Integer.compare(numSourcesInJoinB, numSourcesInJoinA);
        if (numSourcesInJoinCompare != 0) {
            return numSourcesInJoinCompare;
        }
        int numSimpleOperationsA = PlanningCostModel.count(planOpsMapA, RecordQueryMapPlan.class) + PlanningCostModel.count(planOpsMapA, RecordQueryPredicatesFilterPlan.class);
        int numSimpleOperationsCompare = Integer.compare(numSimpleOperationsA, numSimpleOperationsB = PlanningCostModel.count(planOpsMapB, RecordQueryMapPlan.class) + PlanningCostModel.count(planOpsMapB, RecordQueryPredicatesFilterPlan.class));
        if (numSimpleOperationsCompare != 0) {
            return numSimpleOperationsCompare;
        }
        if (a instanceof PlanHashable && b instanceof PlanHashable) {
            int hA = ((PlanHashable)((Object)a)).planHash(PlanHashable.CURRENT_FOR_CONTINUATION);
            int hB = ((PlanHashable)((Object)b)).planHash(PlanHashable.CURRENT_FOR_CONTINUATION);
            return Integer.compare(hA, hB);
        }
        return 0;
    }

    @Nonnull
    private CardinalitiesProperty.Cardinality maxOfMaxCardinalitiesOfAllDataAccesses(@Nonnull Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> planOpsMap) {
        return FindExpressionVisitor.slice(planOpsMap, RecordQueryScanPlan.class, RecordQueryPlanWithIndex.class, RecordQueryCoveringIndexPlan.class).stream().map(plan -> CardinalitiesProperty.cardinalities().evaluate((RelationalExpression)plan).getMaxCardinality()).reduce(CardinalitiesProperty.Cardinality.ofCardinality(0L), (l, r) -> {
            if (l.isUnknown()) {
                return l;
            }
            if (r.isUnknown()) {
                return r;
            }
            return l.getCardinality() > r.getCardinality() ? l : r;
        });
    }

    private OptionalInt comparePrimaryScanToIndexScan(@Nonnull RelationalExpression primaryScan, @Nonnull RelationalExpression indexScan, @Nonnull Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> planOpsMapPrimaryScan, @Nonnull Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> planOpsMapIndexScan, int typeFilterCountPrimaryScan, int typeFilterCountIndexScan) {
        if (PlanningCostModel.count(planOpsMapPrimaryScan, RecordQueryScanPlan.class) == 1 && PlanningCostModel.count(planOpsMapPrimaryScan, RecordQueryPlanWithIndex.class) == 0 && PlanningCostModel.count(planOpsMapIndexScan, RecordQueryScanPlan.class) == 0 && PlanningCostModel.isSingularIndexScanWithFetch(planOpsMapIndexScan)) {
            Sets.SetView<Comparisons.Comparison> indexMinusPrimary;
            Set<Comparisons.Comparison> indexScanComparisons;
            Set<Comparisons.Comparison> primaryScanComparisons;
            Sets.SetView<Comparisons.Comparison> primaryMinusIndex;
            if (typeFilterCountPrimaryScan > 0 && typeFilterCountIndexScan == 0 && (primaryMinusIndex = Sets.difference(primaryScanComparisons = ComparisonsProperty.comparisons().evaluate(primaryScan), indexScanComparisons = ComparisonsProperty.comparisons().evaluate(indexScan))).isEmpty() && !(indexMinusPrimary = Sets.difference(indexScanComparisons, primaryScanComparisons)).isEmpty()) {
                return OptionalInt.of(1);
            }
            if (this.configuration.getIndexScanPreference() == QueryPlanner.IndexScanPreference.PREFER_SCAN) {
                return OptionalInt.of(-1);
            }
            return OptionalInt.of(1);
        }
        return OptionalInt.empty();
    }

    private static OptionalInt compareInOperator(@Nonnull RelationalExpression leftExpression, @Nonnull RelationalExpression rightExpression) {
        RecordQueryInUnionPlan inUnionPlan;
        RecordQueryInJoinPlan inJoinPlan;
        InSource inSource;
        if (!PlanningCostModel.isInPlan(leftExpression)) {
            return OptionalInt.empty();
        }
        Set<Comparisons.Comparison> scanComparisonsSet = ComparisonsProperty.comparisons().evaluate(leftExpression);
        ImmutableSet scanComparisonsCorrelatedTo = scanComparisonsSet.stream().filter(comparison -> comparison instanceof Comparisons.ValueComparison).map(comparison -> (Comparisons.ValueComparison)comparison).filter(comparison -> comparison.getType() == Comparisons.Type.EQUALS).flatMap(comparison -> comparison.getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet());
        if (leftExpression instanceof RecordQueryInJoinPlan ? !scanComparisonsCorrelatedTo.contains(CorrelationIdentifier.of(Bindings.Internal.CORRELATION.identifier((inSource = (inJoinPlan = (RecordQueryInJoinPlan)leftExpression).getInSource()).getBindingName()))) : leftExpression instanceof RecordQueryInUnionPlan && (inUnionPlan = (RecordQueryInUnionPlan)leftExpression).getInSources().stream().noneMatch(inValuesSource -> scanComparisonsCorrelatedTo.contains(CorrelationIdentifier.of(Bindings.Internal.CORRELATION.identifier(inValuesSource.getBindingName()))))) {
            return OptionalInt.of(1);
        }
        return OptionalInt.of(0);
    }

    private static boolean isInPlan(@Nonnull RelationalExpression expression) {
        return expression instanceof RecordQueryInJoinPlan || expression instanceof RecordQueryInUnionPlan;
    }

    private static boolean isSingularIndexScanWithFetch(@Nonnull Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> planOpsMapIndexScan) {
        return PlanningCostModel.count(planOpsMapIndexScan, RecordQueryPlanWithIndex.class) == 1 || PlanningCostModel.count(planOpsMapIndexScan, RecordQueryCoveringIndexPlan.class) == 1 && PlanningCostModel.count(planOpsMapIndexScan, RecordQueryFetchFromPartialRecordPlan.class) == 1;
    }

    private static OptionalInt flipFlop(Supplier<OptionalInt> variantA, Supplier<OptionalInt> variantB) {
        OptionalInt resultA = variantA.get();
        if (resultA.isPresent()) {
            return resultA;
        }
        OptionalInt resultB = variantB.get();
        if (resultB.isPresent()) {
            return OptionalInt.of(-1 * resultB.getAsInt());
        }
        return OptionalInt.empty();
    }

    @SafeVarargs
    private static int count(@Nonnull Map<Class<? extends RelationalExpression>, Set<RelationalExpression>> expressionsMap, Class<? extends RelationalExpression> ... interestingClasses) {
        return FindExpressionVisitor.slice(expressionsMap, interestingClasses).size();
    }

    private /* synthetic */ OptionalInt lambda$compare$2(RelationalExpression a, RelationalExpression b, Map planOpsMapA, Map planOpsMapB, int typeFilterCountA, int typeFilterCountB) {
        return this.comparePrimaryScanToIndexScan(a, b, planOpsMapA, planOpsMapB, typeFilterCountA, typeFilterCountB);
    }
}

