/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.TreeLike;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class PreOrderIterator<T extends TreeLike<T>>
extends AbstractIterator<T> {
    @Nonnull
    private final T root;
    @Nonnull
    private final Deque<Iterator<? extends T>> stack;
    boolean skipNextSubtree;
    @Nullable
    private T lastElement;

    private PreOrderIterator(@Nonnull T root) {
        this.root = root;
        this.stack = new ArrayDeque<Iterator<? extends T>>(root.height());
        this.lastElement = null;
    }

    @Override
    @Nullable
    protected T computeNext() {
        Iterable resultChildren;
        if (this.lastElement == null) {
            if (this.skipNextSubtree) {
                return (T)((TreeLike)this.endOfData());
            }
            this.stack.add(Iterators.singletonIterator(this.root));
        } else if (!this.skipNextSubtree && !Iterables.isEmpty(resultChildren = this.lastElement.getChildren())) {
            this.stack.add(resultChildren.iterator());
        }
        this.skipNextSubtree = false;
        T current = this.advance();
        if (current == null) {
            return (T)((TreeLike)this.endOfData());
        }
        this.lastElement = current;
        return current;
    }

    @Nullable
    private T advance() {
        while (!this.stack.isEmpty()) {
            Iterator<T> top = Verify.verifyNotNull(this.stack.peekLast());
            if (top.hasNext()) {
                return (T)((TreeLike)top.next());
            }
            this.stack.removeLast();
        }
        return null;
    }

    public void skipNextSubtree() {
        this.skipNextSubtree = true;
    }

    @Nonnull
    public Iterator<T> descendOnlyIf(final @Nonnull Predicate<? super T> predicate) {
        return new AbstractIterator<T>(){

            @Override
            @Nullable
            protected T computeNext() {
                if (!PreOrderIterator.this.hasNext()) {
                    return (TreeLike)this.endOfData();
                }
                TreeLike current = (TreeLike)PreOrderIterator.this.next();
                if (!predicate.test(current)) {
                    PreOrderIterator.this.skipNextSubtree();
                }
                return current;
            }
        };
    }

    @Nonnull
    public static <T extends TreeLike<T>> PreOrderIterator<T> over(@Nonnull T treeLike) {
        return new PreOrderIterator<T>(treeLike);
    }
}

