/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;

public class PredicateMap
extends PredicateMultiMap {
    private PredicateMap(@Nonnull SetMultimap<QueryPredicate, PredicateMultiMap.PredicateMapping> map) {
        super(map);
    }

    public Optional<PredicateMultiMap.PredicateMapping> getMappingOptional(@Nonnull QueryPredicate queryPredicate) {
        Collection predicateEntries = this.getMap().get((Object)queryPredicate);
        if (predicateEntries.size() != 1) {
            return Optional.empty();
        }
        return Optional.of((PredicateMultiMap.PredicateMapping)Iterables.getOnlyElement(predicateEntries));
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static PredicateMap empty() {
        return new Builder().build();
    }

    private static Optional<SetMultimap<QueryPredicate, PredicateMultiMap.PredicateMapping>> checkUniqueness(@Nonnull SetMultimap<QueryPredicate, PredicateMultiMap.PredicateMapping> map) {
        for (QueryPredicate queryPredicate : map.keySet()) {
            Collection candidatePredicateMappings = map.get((Object)queryPredicate);
            if (candidatePredicateMappings.size() == 1) continue;
            return Optional.empty();
        }
        return Optional.of(map);
    }

    public static class Builder
    extends PredicateMultiMap.Builder {
        @Override
        public Optional<SetMultimap<QueryPredicate, PredicateMultiMap.PredicateMapping>> checkCorrectness() {
            return super.checkCorrectness().flatMap(x$0 -> PredicateMap.checkUniqueness(x$0));
        }

        @Override
        public PredicateMap build() {
            return new PredicateMap(this.checkCorrectness().orElseThrow(() -> new IllegalArgumentException("conflicts in mapping")));
        }

        public Optional<? extends PredicateMap> buildMaybe() {
            return this.checkCorrectness().map(x$0 -> new PredicateMap((SetMultimap<QueryPredicate, PredicateMultiMap.PredicateMapping>)x$0));
        }
    }
}

