/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.expressions.GroupByExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ExistsPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithComparisons;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValue;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PredicateMultiMap {
    @Nonnull
    private final SetMultimap<QueryPredicate, PredicateMapping> map;

    @Nonnull
    private static Value replaceNewlyMatchedValues(@Nonnull BiMap<CorrelationIdentifier, Value> unmatchedAggregateMap, @Nonnull Map<Value, Value> amendedMatchedAggregateMap, @Nonnull Value rootValue) {
        return Objects.requireNonNull((Value)rootValue.replace(currentValue -> {
            CorrelationIdentifier unmatchedId;
            Value queryValue;
            Value translatedQueryValue;
            if (currentValue instanceof GroupByExpression.UnmatchedAggregateValue && (translatedQueryValue = (Value)amendedMatchedAggregateMap.get(queryValue = Objects.requireNonNull((Value)unmatchedAggregateMap.get(unmatchedId = ((GroupByExpression.UnmatchedAggregateValue)currentValue).getUnmatchedId())))) != null) {
                return translatedQueryValue;
            }
            return currentValue;
        }));
    }

    protected PredicateMultiMap(@Nonnull SetMultimap<QueryPredicate, PredicateMapping> map) {
        SetMultimap copy = Multimaps.newSetMultimap(new LinkedIdentityMap(), LinkedIdentitySet::new);
        map.entries().forEach(entry -> copy.put((QueryPredicate)entry.getKey(), (PredicateMapping)entry.getValue()));
        this.map = Multimaps.unmodifiableSetMultimap(copy);
    }

    @Nonnull
    protected SetMultimap<QueryPredicate, PredicateMapping> getMap() {
        return this.map;
    }

    public Set<PredicateMapping> get(@Nonnull QueryPredicate queryPredicate) {
        return this.map.get((Object)queryPredicate);
    }

    public Set<Map.Entry<QueryPredicate, PredicateMapping>> entries() {
        return this.map.entries();
    }

    public Set<QueryPredicate> keySet() {
        return this.map.keySet();
    }

    public Collection<PredicateMapping> values() {
        return this.map.values();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static Optional<SetMultimap<QueryPredicate, PredicateMapping>> checkConflicts(@Nonnull SetMultimap<QueryPredicate, PredicateMapping> map) {
        Set<QueryPredicate> seenCandidatePredicates = Sets.newIdentityHashSet();
        for (QueryPredicate queryPredicate : map.keySet()) {
            Collection candidatePredicateMappings = map.get((Object)queryPredicate);
            for (PredicateMapping candidatePredicateMapping : candidatePredicateMappings) {
                QueryPredicate candidatePredicate = candidatePredicateMapping.getCandidatePredicate();
                if (seenCandidatePredicates.contains(candidatePredicate)) {
                    return Optional.empty();
                }
                seenCandidatePredicates.add(candidatePredicate);
            }
        }
        return Optional.of(map);
    }

    public static class Builder {
        private final SetMultimap<QueryPredicate, PredicateMapping> map = Multimaps.newSetMultimap(new LinkedIdentityMap(), LinkedIdentitySet::new);

        public boolean put(@Nonnull QueryPredicate queryPredicate, @Nonnull PredicateMapping predicateMapping) {
            return this.map.put(queryPredicate, predicateMapping);
        }

        public boolean putAll(@Nonnull PredicateMultiMap otherMap) {
            boolean isModified = false;
            for (Map.Entry entry : otherMap.getMap().entries()) {
                isModified = this.map.put((QueryPredicate)entry.getKey(), (PredicateMapping)entry.getValue()) || isModified;
            }
            return isModified;
        }

        public boolean putAll(@Nonnull QueryPredicate queryPredicate, @Nonnull Set<PredicateMapping> predicateMappings) {
            boolean isModified = false;
            for (PredicateMapping predicateMapping : predicateMappings) {
                isModified = this.map.put(queryPredicate, predicateMapping) || isModified;
            }
            return isModified;
        }

        public Optional<SetMultimap<QueryPredicate, PredicateMapping>> checkCorrectness() {
            return PredicateMultiMap.checkConflicts(this.map);
        }

        public PredicateMultiMap build() {
            return new PredicateMultiMap(this.checkCorrectness().orElseThrow(() -> new IllegalArgumentException("conflicts in mapping")));
        }

        public Optional<? extends PredicateMultiMap> buildMaybe() {
            return this.checkCorrectness().map(PredicateMultiMap::new);
        }
    }

    public static class PredicateMapping {
        @Nonnull
        private final MappingKey mappingKey;
        @Nonnull
        private final PredicateCompensation predicateCompensation;
        @Nonnull
        private final Optional<CorrelationIdentifier> parameterAliasOptional;
        @Nonnull
        private final Optional<ComparisonRange> comparisonRangeOptional;
        @Nonnull
        private final QueryPlanConstraint constraint;
        @Nonnull
        private final QueryPredicate translatedQueryPredicate;

        private PredicateMapping(@Nonnull QueryPredicate originalQueryPredicate, @Nonnull QueryPredicate candidatePredicate, @Nonnull MappingKind mappingKind, @Nonnull PredicateCompensation predicateCompensation, @Nonnull Optional<CorrelationIdentifier> parameterAlias, @Nonnull Optional<ComparisonRange> comparisonRangeOptional, @Nonnull QueryPlanConstraint constraint, @Nonnull QueryPredicate translatedQueryPredicate) {
            this.mappingKey = new MappingKey(originalQueryPredicate, candidatePredicate, mappingKind);
            this.predicateCompensation = predicateCompensation;
            this.parameterAliasOptional = parameterAlias;
            this.comparisonRangeOptional = comparisonRangeOptional;
            this.constraint = constraint;
            this.translatedQueryPredicate = translatedQueryPredicate;
        }

        @Nonnull
        public QueryPredicate getOriginalQueryPredicate() {
            return this.mappingKey.getOriginalQueryPredicate();
        }

        @Nonnull
        public QueryPredicate getCandidatePredicate() {
            return this.mappingKey.getCandidatePredicate();
        }

        @Nonnull
        public MappingKind getMappingKind() {
            return this.mappingKey.getMappingKind();
        }

        @Nonnull
        public MappingKey getMappingKey() {
            return this.mappingKey;
        }

        @Nonnull
        public PredicateCompensation getPredicateCompensation() {
            return this.predicateCompensation;
        }

        @Nonnull
        public Optional<CorrelationIdentifier> getParameterAliasOptional() {
            return this.parameterAliasOptional;
        }

        public @NonNull Optional<ComparisonRange> getComparisonRangeOptional() {
            return this.comparisonRangeOptional;
        }

        @Nonnull
        public QueryPlanConstraint getConstraint() {
            return this.constraint;
        }

        @Nonnull
        public QueryPredicate getTranslatedQueryPredicate() {
            return this.translatedQueryPredicate;
        }

        @Nonnull
        public PredicateMapping withTranslatedQueryPredicate(@Nonnull QueryPredicate translatedQueryPredicate) {
            return this.toBuilder().setTranslatedQueryPredicate(translatedQueryPredicate).build();
        }

        @Nonnull
        public Builder toBuilder() {
            return new Builder(this.getOriginalQueryPredicate(), this.getTranslatedQueryPredicate(), this.getCandidatePredicate(), this.getMappingKind()).setPredicateCompensation(this.getPredicateCompensation()).setParameterAliasOptional(this.getParameterAliasOptional()).setConstraint(this.getConstraint()).setTranslatedQueryPredicate(this.getTranslatedQueryPredicate());
        }

        @Nonnull
        public static Builder regularMappingBuilder(@Nonnull QueryPredicate originalQueryPredicate, @Nonnull QueryPredicate translatedQueryPredicate, @Nonnull QueryPredicate candidatePredicate) {
            return new Builder(originalQueryPredicate, translatedQueryPredicate, candidatePredicate, MappingKind.REGULAR_IMPLIES_CANDIDATE);
        }

        @Nonnull
        public static Builder orTermMappingBuilder(@Nonnull QueryPredicate originalQueryPredicate, @Nonnull QueryPredicate translatedQueryPredicate, @Nonnull QueryPredicate candidatePredicate) {
            return new Builder(originalQueryPredicate, translatedQueryPredicate, candidatePredicate, MappingKind.OR_TERM_IMPLIES_CANDIDATE);
        }

        public static class MappingKey {
            @Nonnull
            private final QueryPredicate originalQueryPredicate;
            @Nonnull
            private final QueryPredicate candidatePredicate;
            @Nonnull
            private final MappingKind mappingKind;

            public MappingKey(@Nonnull QueryPredicate originalQueryPredicate, @Nonnull QueryPredicate candidatePredicate, @Nonnull MappingKind mappingKind) {
                this.originalQueryPredicate = originalQueryPredicate;
                this.candidatePredicate = candidatePredicate;
                this.mappingKind = mappingKind;
            }

            @Nonnull
            public QueryPredicate getOriginalQueryPredicate() {
                return this.originalQueryPredicate;
            }

            @Nonnull
            public QueryPredicate getCandidatePredicate() {
                return this.candidatePredicate;
            }

            @Nonnull
            public MappingKind getMappingKind() {
                return this.mappingKind;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof MappingKey)) {
                    return false;
                }
                MappingKey that = (MappingKey)o;
                return Objects.equals(this.originalQueryPredicate, that.originalQueryPredicate) && Objects.equals(this.candidatePredicate, that.candidatePredicate) && this.mappingKind == that.mappingKind;
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.originalQueryPredicate, this.candidatePredicate, this.mappingKind});
            }
        }

        public static enum MappingKind {
            REGULAR_IMPLIES_CANDIDATE,
            OR_TERM_IMPLIES_CANDIDATE;

        }

        public static class Builder {
            @Nonnull
            private final QueryPredicate originalQueryPredicate;
            @Nonnull
            private final QueryPredicate candidatePredicate;
            @Nonnull
            private final MappingKind mappingKind;
            @Nonnull
            private PredicateCompensation predicateCompensation;
            @Nonnull
            private Optional<CorrelationIdentifier> parameterAliasOptional;
            @Nonnull
            private Optional<ComparisonRange> comparisonRangeOptional;
            @Nonnull
            private QueryPlanConstraint constraint;
            @Nonnull
            private QueryPredicate translatedQueryPredicate;

            public Builder(@Nonnull QueryPredicate originalQueryPredicate, @Nonnull QueryPredicate translatedQueryPredicate, @Nonnull QueryPredicate candidatePredicate, @Nonnull MappingKind mappingKind) {
                this.originalQueryPredicate = originalQueryPredicate;
                this.translatedQueryPredicate = translatedQueryPredicate;
                this.candidatePredicate = candidatePredicate;
                this.mappingKind = mappingKind;
                this.predicateCompensation = (partialMatch, boundPrefixMap, pullUp) -> PredicateCompensationFunction.noCompensationNeeded();
                this.parameterAliasOptional = Optional.empty();
                this.comparisonRangeOptional = Optional.empty();
                this.constraint = QueryPlanConstraint.noConstraint();
            }

            @Nonnull
            public Builder setPredicateCompensation(@Nonnull PredicateCompensation predicateCompensation) {
                this.predicateCompensation = predicateCompensation;
                return this;
            }

            @Nonnull
            public Builder setParameterAlias(@Nonnull CorrelationIdentifier parameterAlias) {
                return this.setParameterAliasOptional(Optional.of(parameterAlias));
            }

            @Nonnull
            public Builder setParameterAliasOptional(@Nonnull Optional<CorrelationIdentifier> parameterAliasOptional) {
                this.parameterAliasOptional = parameterAliasOptional;
                return this;
            }

            @Nonnull
            public Builder setComparisonRange(@Nonnull ComparisonRange comparisonRange) {
                return this.setComparisonRangeOptional(Optional.of(comparisonRange));
            }

            @Nonnull
            public Builder setComparisonRangeOptional(@Nonnull Optional<ComparisonRange> comparisonRangeOptional) {
                this.comparisonRangeOptional = comparisonRangeOptional;
                return this;
            }

            @Nonnull
            public Builder setSargable(@Nonnull CorrelationIdentifier parameterAlias, @Nonnull ComparisonRange comparisonRange) {
                return this.setParameterAlias(parameterAlias).setComparisonRange(comparisonRange);
            }

            @Nonnull
            public Builder setConstraint(@Nonnull QueryPlanConstraint constraint) {
                this.constraint = constraint;
                return this;
            }

            @Nonnull
            public Builder setTranslatedQueryPredicate(@Nonnull QueryPredicate translatedQueryPredicate) {
                this.translatedQueryPredicate = translatedQueryPredicate;
                return this;
            }

            @Nonnull
            public PredicateMapping build() {
                return new PredicateMapping(this.originalQueryPredicate, this.candidatePredicate, this.mappingKind, this.predicateCompensation, this.parameterAliasOptional, this.comparisonRangeOptional, this.constraint, this.translatedQueryPredicate);
            }
        }
    }

    public static interface ResultCompensationFunction {
        public static final ResultCompensationFunction NO_COMPENSATION_NEEDED = new ResultCompensationFunction(){

            @Override
            public boolean isNeeded() {
                return false;
            }

            @Override
            public boolean isImpossible() {
                return false;
            }

            @Override
            @Nonnull
            public ResultCompensationFunction amend(@Nonnull BiMap<CorrelationIdentifier, Value> unmatchedAggregateMap, @Nonnull Map<Value, Value> amendedMatchedAggregateMap) {
                return this;
            }

            @Override
            @Nonnull
            public Value applyCompensationForResult(@Nonnull TranslationMap translationMap) {
                throw new IllegalArgumentException("this method should not be called");
            }
        };
        public static final ResultCompensationFunction IMPOSSIBLE_COMPENSATION = new ResultCompensationFunction(){

            @Override
            public boolean isNeeded() {
                return true;
            }

            @Override
            public boolean isImpossible() {
                return true;
            }

            @Override
            @Nonnull
            public ResultCompensationFunction amend(@Nonnull BiMap<CorrelationIdentifier, Value> unmatchedAggregateMap, @Nonnull Map<Value, Value> amendedMatchedAggregateMap) {
                return this;
            }

            @Override
            @Nonnull
            public Value applyCompensationForResult(@Nonnull TranslationMap translationMap) {
                throw new IllegalArgumentException("this method should not be called");
            }
        };

        public boolean isNeeded();

        public boolean isImpossible();

        @Nonnull
        public ResultCompensationFunction amend(@Nonnull BiMap<CorrelationIdentifier, Value> var1, @Nonnull Map<Value, Value> var2);

        @Nonnull
        public Value applyCompensationForResult(@Nonnull TranslationMap var1);

        @Nonnull
        public static ResultCompensationFunction ofValue(@Nonnull Value value) {
            return ResultCompensationFunction.ofValue(value, false);
        }

        @Nonnull
        public static ResultCompensationFunction ofValue(final @Nonnull Value value, final boolean shouldSimplifyValue) {
            final boolean isImpossible = ResultCompensationFunction.valueContainsUnmatchedValues(value);
            return new ResultCompensationFunction(){

                @Override
                public boolean isNeeded() {
                    return true;
                }

                @Override
                public boolean isImpossible() {
                    return isImpossible;
                }

                @Override
                @Nonnull
                public ResultCompensationFunction amend(@Nonnull BiMap<CorrelationIdentifier, Value> unmatchedAggregateMap, @Nonnull Map<Value, Value> amendedMatchedAggregateMap) {
                    Value amendedTranslatedQueryValue = PredicateMultiMap.replaceNewlyMatchedValues(unmatchedAggregateMap, amendedMatchedAggregateMap, value);
                    return ResultCompensationFunction.ofValue(amendedTranslatedQueryValue, true);
                }

                @Override
                @Nonnull
                public Value applyCompensationForResult(@Nonnull TranslationMap translationMap) {
                    return value.translateCorrelations(translationMap, shouldSimplifyValue);
                }
            };
        }

        @Nonnull
        public static ResultCompensationFunction noCompensationNeeded() {
            return NO_COMPENSATION_NEEDED;
        }

        @Nonnull
        public static ResultCompensationFunction impossibleCompensation() {
            return IMPOSSIBLE_COMPENSATION;
        }

        private static boolean valueContainsUnmatchedValues(@Nonnull Value pulledUpValue) {
            return pulledUpValue.preOrderStream().anyMatch(v -> v instanceof GroupByExpression.UnmatchedAggregateValue);
        }
    }

    public static interface PredicateCompensationFunction {
        public static final PredicateCompensationFunction NO_COMPENSATION_NEEDED = new PredicateCompensationFunction(){

            @Override
            public boolean isNeeded() {
                return false;
            }

            @Override
            public boolean isImpossible() {
                return false;
            }

            @Override
            @Nonnull
            public PredicateCompensationFunction amend(@Nonnull BiMap<CorrelationIdentifier, Value> unmatchedAggregateMap, @Nonnull Map<Value, Value> amendedMatchedAggregateMap) {
                return this;
            }

            @Override
            @Nonnull
            public Set<QueryPredicate> applyCompensationForPredicate(@Nonnull TranslationMap translationMap) {
                throw new IllegalArgumentException("this method should not be called");
            }
        };
        public static final PredicateCompensationFunction IMPOSSIBLE_COMPENSATION = new PredicateCompensationFunction(){

            @Override
            public boolean isNeeded() {
                return true;
            }

            @Override
            public boolean isImpossible() {
                return true;
            }

            @Override
            @Nonnull
            public PredicateCompensationFunction amend(@Nonnull BiMap<CorrelationIdentifier, Value> unmatchedAggregateMap, @Nonnull Map<Value, Value> amendedMatchedAggregateMap) {
                return this;
            }

            @Override
            @Nonnull
            public Set<QueryPredicate> applyCompensationForPredicate(@Nonnull TranslationMap translationMap) {
                throw new IllegalArgumentException("this method should not be called");
            }
        };

        public boolean isNeeded();

        public boolean isImpossible();

        @Nonnull
        public PredicateCompensationFunction amend(@Nonnull BiMap<CorrelationIdentifier, Value> var1, @Nonnull Map<Value, Value> var2);

        @Nonnull
        public Set<QueryPredicate> applyCompensationForPredicate(@Nonnull TranslationMap var1);

        @Nonnull
        public static PredicateCompensationFunction ofPredicate(@Nonnull QueryPredicate predicate) {
            return PredicateCompensationFunction.ofPredicate(predicate, false);
        }

        @Nonnull
        public static PredicateCompensationFunction ofPredicate(final @Nonnull QueryPredicate predicate, final boolean shouldSimplifyValues) {
            final boolean isImpossible = PredicateCompensationFunction.predicateContainsUnmatchedValues(predicate);
            return new PredicateCompensationFunction(){

                @Override
                public boolean isNeeded() {
                    return true;
                }

                @Override
                public boolean isImpossible() {
                    return isImpossible;
                }

                @Override
                @Nonnull
                public PredicateCompensationFunction amend(@Nonnull BiMap<CorrelationIdentifier, Value> unmatchedAggregateMap, @Nonnull Map<Value, Value> amendedMatchedAggregateMap) {
                    Optional<QueryPredicate> amendedTranslatedPredicateOptional = predicate.replaceValuesMaybe(rootValue -> Optional.of(PredicateMultiMap.replaceNewlyMatchedValues(unmatchedAggregateMap, amendedMatchedAggregateMap, rootValue)));
                    Verify.verify(amendedTranslatedPredicateOptional.isPresent());
                    return PredicateCompensationFunction.ofPredicate(amendedTranslatedPredicateOptional.get(), true);
                }

                @Override
                @Nonnull
                public Set<QueryPredicate> applyCompensationForPredicate(@Nonnull TranslationMap translationMap) {
                    return LinkedIdentitySet.of(new QueryPredicate[]{predicate.translateCorrelations(translationMap, shouldSimplifyValues)});
                }
            };
        }

        private static boolean predicateContainsUnmatchedValues(@Nonnull QueryPredicate pulledUpPredicate) {
            Value value;
            if (pulledUpPredicate instanceof PredicateWithValue && (value = Objects.requireNonNull(((PredicateWithValue)pulledUpPredicate).getValue())).preOrderStream().anyMatch(v -> v instanceof GroupByExpression.UnmatchedAggregateValue)) {
                return true;
            }
            if (pulledUpPredicate instanceof PredicateWithComparisons) {
                List<Comparisons.Comparison> comparisons = ((PredicateWithComparisons)((Object)pulledUpPredicate)).getComparisons();
                for (Comparisons.Comparison comparison : comparisons) {
                    Value comparisonValue;
                    if (!(comparison instanceof Comparisons.ValueComparison) || !(comparisonValue = comparison.getValue()).preOrderStream().anyMatch(v -> v instanceof GroupByExpression.UnmatchedAggregateValue)) continue;
                    return true;
                }
            }
            return false;
        }

        @Nonnull
        public static PredicateCompensationFunction ofExistentialPredicate(@Nonnull ExistsPredicate existsPredicate) {
            final LinkedIdentitySet<QueryPredicate> result = LinkedIdentitySet.of(new QueryPredicate[]{existsPredicate});
            return new PredicateCompensationFunction(){

                @Override
                public boolean isNeeded() {
                    return true;
                }

                @Override
                public boolean isImpossible() {
                    return false;
                }

                @Override
                @Nonnull
                public PredicateCompensationFunction amend(@Nonnull BiMap<CorrelationIdentifier, Value> unmatchedAggregateMap, @Nonnull Map<Value, Value> amendedMatchedAggregateMap) {
                    return this;
                }

                @Override
                @Nonnull
                public Set<QueryPredicate> applyCompensationForPredicate(@Nonnull TranslationMap translationMap) {
                    return result;
                }
            };
        }

        @Nonnull
        public static PredicateCompensationFunction ofChildrenCompensationFunctions(final @Nonnull List<PredicateCompensationFunction> childrenCompensationFunctions, final @Nonnull BiFunction<List<PredicateCompensationFunction>, TranslationMap, Set<QueryPredicate>> compensationFunction) {
            return new PredicateCompensationFunction(){

                @Override
                public boolean isNeeded() {
                    return true;
                }

                @Override
                public boolean isImpossible() {
                    return childrenCompensationFunctions.stream().anyMatch(PredicateCompensationFunction::isImpossible);
                }

                @Override
                @Nonnull
                public PredicateCompensationFunction amend(@Nonnull BiMap<CorrelationIdentifier, Value> unmatchedAggregateMap, @Nonnull Map<Value, Value> amendedMatchedAggregateMap) {
                    ImmutableList<PredicateCompensationFunction> amendedChildrenCompensationFunctions = childrenCompensationFunctions.stream().map(childrenCompensationFunction -> childrenCompensationFunction.amend(unmatchedAggregateMap, amendedMatchedAggregateMap)).collect(ImmutableList.toImmutableList());
                    return PredicateCompensationFunction.ofChildrenCompensationFunctions(amendedChildrenCompensationFunctions, compensationFunction);
                }

                @Override
                @Nonnull
                public Set<QueryPredicate> applyCompensationForPredicate(@Nonnull TranslationMap translationMap) {
                    return (Set)compensationFunction.apply(childrenCompensationFunctions, translationMap);
                }
            };
        }

        @Nonnull
        public static PredicateCompensationFunction noCompensationNeeded() {
            return NO_COMPENSATION_NEEDED;
        }

        @Nonnull
        public static PredicateCompensationFunction impossibleCompensation() {
            return IMPOSSIBLE_COMPENSATION;
        }
    }

    @FunctionalInterface
    public static interface PredicateCompensation {
        @Nonnull
        public PredicateCompensationFunction computeCompensationFunction(@Nonnull PartialMatch var1, @Nonnull Map<CorrelationIdentifier, ComparisonRange> var2, @Nonnull PullUp var3);
    }
}

