/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.PrimaryScanMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.expressions.MatchableSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrimaryAccessExpansionVisitor
extends KeyExpressionExpansionVisitor
implements ExpansionVisitor<KeyExpressionExpansionVisitor.VisitorState> {
    @Nonnull
    private final List<RecordType> availableRecordTypes;
    @Nonnull
    private final List<RecordType> recordTypes;

    public PrimaryAccessExpansionVisitor(@Nonnull Collection<RecordType> availableRecordTypes, @Nonnull Collection<RecordType> recordTypes) {
        this.availableRecordTypes = ImmutableList.copyOf(availableRecordTypes);
        this.recordTypes = ImmutableList.copyOf(recordTypes);
    }

    @Override
    @Nonnull
    @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public PrimaryScanMatchCandidate expand(@Nonnull Supplier<Quantifier.ForEach> baseQuantifierSupplier, @Nullable KeyExpression primaryKey, boolean isReverse) {
        Objects.requireNonNull(primaryKey);
        Debugger.updateIndex(PredicateWithValueAndRanges.class, old -> 0);
        Quantifier.ForEach baseQuantifier = baseQuantifierSupplier.get();
        GraphExpansion graphExpansion = this.pop(primaryKey.expand(this.push(KeyExpressionExpansionVisitor.VisitorState.of(Lists.newArrayList(), Lists.newArrayList(), baseQuantifier, ImmutableList.of(), -1, 0, false, true)))).toBuilder().removeAllResultColumns().build();
        GraphExpansion allExpansions = GraphExpansion.ofOthers(GraphExpansion.ofQuantifier(baseQuantifier), graphExpansion);
        List<CorrelationIdentifier> parameters = allExpansions.getPlaceholderAliases();
        MatchableSortExpression expression = new MatchableSortExpression(parameters, isReverse, allExpansions.buildSelectWithResultValue(baseQuantifier.getFlowedObjectValue()));
        return new PrimaryScanMatchCandidate(Traversal.withRoot(Reference.initialOf((RelationalExpression)expression)), parameters, this.availableRecordTypes, this.recordTypes, primaryKey, baseQuantifier.getFlowedObjectType());
    }
}

