/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PlanContext;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.ValueIndexLikeMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.WithPrimaryKeyMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class PrimaryScanMatchCandidate
implements MatchCandidate,
ValueIndexLikeMatchCandidate,
WithPrimaryKeyMatchCandidate {
    @Nonnull
    private final List<CorrelationIdentifier> parameters;
    @Nonnull
    private final Traversal traversal;
    @Nonnull
    private final List<RecordType> availableRecordTypes;
    @Nonnull
    private final List<RecordType> queriedRecordTypes;
    @Nonnull
    private final KeyExpression primaryKey;
    @Nonnull
    private final Type baseType;
    @Nonnull
    private final Supplier<Optional<List<Value>>> primaryKeyValuesSupplier;

    public PrimaryScanMatchCandidate(@Nonnull Traversal traversal, @Nonnull List<CorrelationIdentifier> parameters, @Nonnull Collection<RecordType> availableRecordTypes, @Nonnull Collection<RecordType> queriedRecordTypes, @Nonnull KeyExpression primaryKey, @Nonnull Type baseType) {
        this.traversal = traversal;
        this.parameters = ImmutableList.copyOf(parameters);
        this.availableRecordTypes = ImmutableList.copyOf(availableRecordTypes);
        this.queriedRecordTypes = ImmutableList.copyOf(queriedRecordTypes);
        this.primaryKey = primaryKey;
        this.baseType = baseType;
        this.primaryKeyValuesSupplier = Suppliers.memoize(() -> MatchCandidate.computePrimaryKeyValuesMaybe(primaryKey, baseType));
    }

    @Override
    @Nonnull
    public String getName() {
        return "primary(" + String.join((CharSequence)",", this.getAvailableRecordTypeNames()) + ")";
    }

    @Override
    @Nonnull
    public Traversal getTraversal() {
        return this.traversal;
    }

    @Override
    @Nonnull
    public List<CorrelationIdentifier> getSargableAliases() {
        return this.parameters;
    }

    @Override
    @Nonnull
    public List<CorrelationIdentifier> getOrderingAliases() {
        return this.getSargableAliases();
    }

    @Override
    @Nonnull
    public Type getBaseType() {
        return this.baseType;
    }

    @Nonnull
    public List<RecordType> getAvailableRecordTypes() {
        return this.availableRecordTypes;
    }

    @Nonnull
    public Set<String> getAvailableRecordTypeNames() {
        return this.getAvailableRecordTypes().stream().map(RecordType::getName).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public List<RecordType> getQueriedRecordTypes() {
        return this.queriedRecordTypes;
    }

    @Override
    @Nonnull
    public Optional<List<Value>> getPrimaryKeyValuesMaybe() {
        return this.primaryKeyValuesSupplier.get();
    }

    @Override
    @Nonnull
    public KeyExpression getFullKeyExpression() {
        return this.primaryKey;
    }

    public String toString() {
        return "primary[" + String.join((CharSequence)",", this.getQueriedRecordTypeNames()) + "]";
    }

    @Override
    public boolean createsDuplicates() {
        return false;
    }

    @Override
    public int getColumnSize() {
        return this.primaryKey.getColumnSize();
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    @Nonnull
    public RecordQueryPlan toEquivalentPlan(@Nonnull PartialMatch partialMatch, @Nonnull PlanContext planContext, @Nonnull Memoizer memoizer, @Nonnull List<ComparisonRange> comparisonRanges, boolean reverseScanOrder) {
        Set<String> availableRecordTypeNames = this.getAvailableRecordTypeNames();
        Set<String> queriedRecordTypeNames = this.getQueriedRecordTypeNames();
        Verify.verify(availableRecordTypeNames.containsAll(queriedRecordTypeNames));
        if (queriedRecordTypeNames.size() == availableRecordTypeNames.size()) {
            RecordQueryScanPlan scanPlan = new RecordQueryScanPlan(availableRecordTypeNames, (Type)Type.Record.fromFieldDescriptorsMap(RecordMetaData.getFieldDescriptorMapFromTypes(this.getAvailableRecordTypes())).narrowMaybe(Type.Record.class).orElseThrow(() -> new RecordCoreException("type is of wrong implementor", new Object[0])), this.primaryKey, PrimaryScanMatchCandidate.toScanComparisons(comparisonRanges), reverseScanOrder, false, this);
            return scanPlan;
        }
        RecordQueryScanPlan scanPlan = new RecordQueryScanPlan(availableRecordTypeNames, (Type)new Type.AnyRecord(false), this.primaryKey, PrimaryScanMatchCandidate.toScanComparisons(comparisonRanges), reverseScanOrder, false, this);
        Type.Record queriedType = Type.Record.fromFieldDescriptorsMap(RecordMetaData.getFieldDescriptorMapFromTypes(this.getQueriedRecordTypes()));
        return new RecordQueryTypeFilterPlan(Quantifier.physical(memoizer.memoizePlan(scanPlan)), queriedRecordTypeNames, queriedType);
    }

    @Nonnull
    private static ScanComparisons toScanComparisons(@Nonnull List<ComparisonRange> comparisonRanges) {
        ScanComparisons.Builder builder = new ScanComparisons.Builder();
        for (ComparisonRange comparisonRange : comparisonRanges) {
            builder.addComparisonRange(comparisonRange);
        }
        return builder.build();
    }
}

