/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PPhysicalQuantifier;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.PlannerStage;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.MaxMatchMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class Quantifier
implements Correlated<Quantifier> {
    @Nonnull
    private static final UUID CURRENT = UUID.randomUUID();
    @Nonnull
    private static final String CONSTANT = "CONSTANT";
    @Nonnull
    private final CorrelationIdentifier alias;
    @Nonnull
    private final Supplier<Set<CorrelationIdentifier>> correlatedToSupplier;
    @Nonnull
    private final Supplier<List<Column<? extends FieldValue>>> flowedColumnsSupplier;
    @Nonnull
    private final Supplier<List<? extends FieldValue>> flowedValuesSupplier;

    @Nonnull
    public static ForEach.ForEachBuilder forEachBuilder() {
        return new ForEach.ForEachBuilder();
    }

    @Nonnull
    public static ForEach forEach(@Nonnull Reference reference) {
        return Quantifier.forEachBuilder().build(reference);
    }

    @Nonnull
    public static ForEach forEach(@Nonnull Reference reference, @Nonnull CorrelationIdentifier alias) {
        return ((ForEach.ForEachBuilder)Quantifier.forEachBuilder().withAlias(alias)).build(reference);
    }

    @Nonnull
    public static ForEach forEachWithNullOnEmpty(@Nonnull Reference reference) {
        return Quantifier.forEachBuilder().setNullOnEmpty(true).build(reference);
    }

    @Nonnull
    public static ForEach forEachWithNullOnEmpty(@Nonnull Reference reference, @Nonnull CorrelationIdentifier alias) {
        return ((ForEach.ForEachBuilder)Quantifier.forEachBuilder().withAlias(alias)).setNullOnEmpty(true).build(reference);
    }

    @Nonnull
    public static Existential.ExistentialBuilder existentialBuilder() {
        return new Existential.ExistentialBuilder();
    }

    @Nonnull
    public static Existential existential(@Nonnull Reference reference) {
        return Quantifier.existentialBuilder().build(reference);
    }

    @Nonnull
    public static Existential existential(@Nonnull Reference reference, @Nonnull CorrelationIdentifier alias) {
        return ((Existential.ExistentialBuilder)Quantifier.existentialBuilder().withAlias(alias)).build(reference);
    }

    public static Physical.PhysicalBuilder physicalBuilder() {
        return new Physical.PhysicalBuilder();
    }

    public static Physical physical(@Nonnull Reference reference) {
        return Quantifier.physicalBuilder().build(reference);
    }

    @Nonnull
    public static Physical physical(@Nonnull Reference reference, @Nonnull CorrelationIdentifier alias) {
        return ((Physical.PhysicalBuilder)Quantifier.physicalBuilder().withAlias(alias)).build(reference);
    }

    protected Quantifier(@Nonnull CorrelationIdentifier alias) {
        this.alias = alias;
        this.correlatedToSupplier = Suppliers.memoize(() -> this.getRangesOver().getCorrelatedTo());
        this.flowedColumnsSupplier = Suppliers.memoize(this::computeFlowedColumns);
        this.flowedValuesSupplier = Suppliers.memoize(this::computeFlowedValues);
        Debugger.registerQuantifier(this);
    }

    @Nonnull
    public CorrelationIdentifier getAlias() {
        return this.alias;
    }

    public abstract Builder<? extends Quantifier, ? extends Builder<?, ?>> toBuilder();

    @Nonnull
    public abstract Reference getRangesOver();

    @Nonnull
    public abstract String getShorthand();

    @Nullable
    public <U> U acceptVisitor(@Nonnull SimpleExpressionVisitor<U> visitor) {
        if (visitor.shouldVisit(this)) {
            return visitor.evaluateAtQuantifier(this, this.getRangesOver().acceptVisitor(visitor));
        }
        return null;
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (!this.semanticEqualsWithoutChildren(other)) {
            return false;
        }
        Quantifier that = (Quantifier)Objects.requireNonNull(other);
        return this.getRangesOver().semanticEquals(that.getRangesOver(), aliasMap);
    }

    public boolean semanticEqualsWithoutChildren(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int semanticHashCode() {
        return Objects.hash(this.getShorthand(), this.getRangesOver().semanticHashCode());
    }

    @Nonnull
    public String toString() {
        return this.getShorthand() + "(" + String.valueOf(this.getAlias()) + ") -> {" + this.getCorrelatedTo().stream().map(CorrelationIdentifier::toString).collect(Collectors.joining(", ")) + "}";
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        return this.correlatedToSupplier.get();
    }

    protected boolean needsRebase(@Nonnull AliasMap translationMap) {
        Set<CorrelationIdentifier> correlatedTo = this.getCorrelatedTo();
        return translationMap.sources().stream().anyMatch(correlatedTo::contains);
    }

    @Nonnull
    public <Q extends Quantifier> Q narrow(@Nonnull Class<Q> narrowedClass) {
        return (Q)((Quantifier)narrowedClass.cast(this));
    }

    @Nonnull
    public <Q extends Quantifier> Optional<Q> narrowMaybe(@Nonnull Class<Q> narrowedClass) {
        if (narrowedClass.isInstance(this)) {
            return Optional.of((Quantifier)narrowedClass.cast(this));
        }
        return Optional.empty();
    }

    @Nonnull
    public List<Column<? extends FieldValue>> getFlowedColumns() {
        return this.flowedColumnsSupplier.get();
    }

    @Nonnull
    protected abstract List<Column<? extends FieldValue>> computeFlowedColumns();

    @Nonnull
    protected static List<Column<? extends FieldValue>> pullUpResultColumns(@Nonnull Type type, @Nonnull CorrelationIdentifier alias) {
        if (!(type instanceof Type.Record)) {
            throw new IllegalStateException("quantifier does not flow records");
        }
        List<Type.Record.Field> fields = Objects.requireNonNull(((Type.Record)type).getFields());
        Type.Record recordType = (Type.Record)type;
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (int i = 0; i < fields.size(); ++i) {
            Type.Record.Field field = fields.get(i);
            resultBuilder.add(Column.of(field, FieldValue.ofOrdinalNumber(QuantifiedObjectValue.of(alias, recordType), Math.toIntExact(i))));
        }
        return resultBuilder.build();
    }

    @Nonnull
    public List<? extends FieldValue> getFlowedValues() {
        return this.flowedValuesSupplier.get();
    }

    @Nonnull
    private List<? extends FieldValue> computeFlowedValues() {
        return this.getFlowedColumns().stream().map(Column::getValue).collect(ImmutableList.toImmutableList());
    }

    public QuantifiedObjectValue getFlowedObjectValue() {
        return QuantifiedObjectValue.of(this.getAlias(), this.getFlowedObjectType());
    }

    @Nonnull
    public Type getFlowedObjectType() {
        Type resolvedTypeAcrossReference = this.getRangesOver().getResultType();
        Verify.verify(resolvedTypeAcrossReference.getTypeCode() == Type.TypeCode.RELATION);
        return Objects.requireNonNull(((Type.Relation)resolvedTypeAcrossReference).getInnerType());
    }

    @Nonnull
    public abstract Optional<RegularTranslationMap> pullUpMaxMatchMapMaybe(@Nonnull MaxMatchMap var1, @Nonnull CorrelationIdentifier var2);

    @Nonnull
    public Quantifier overNewReference(@Nonnull Reference reference) {
        return this.overNewReference(reference, this.getAlias());
    }

    @Nonnull
    public abstract Quantifier overNewReference(@Nonnull Reference var1, @Nonnull CorrelationIdentifier var2);

    @Override
    @Nonnull
    public Quantifier rebase(@Nonnull AliasMap translationMap) {
        throw new UnsupportedOperationException("rebase not supported on quantifier");
    }

    @Nonnull
    public static CorrelationIdentifier uniqueId() {
        return CorrelationIdentifier.uniqueId(Quantifier.class);
    }

    @Nonnull
    public static CorrelationIdentifier current() {
        return CorrelationIdentifier.uniqueSingletonID(CURRENT, "\ud835\udcc6");
    }

    @Nonnull
    public static CorrelationIdentifier constant() {
        return CorrelationIdentifier.of(CONSTANT);
    }

    public static final class ForEach
    extends Quantifier {
        @Nonnull
        private final Reference rangesOver;
        private final boolean isNullOnEmpty;

        private ForEach(@Nonnull CorrelationIdentifier alias, @Nonnull Reference rangesOver, boolean isNullOnEmpty) {
            super(alias);
            this.rangesOver = rangesOver;
            this.isNullOnEmpty = isNullOnEmpty;
        }

        @Override
        @Nonnull
        public Reference getRangesOver() {
            return this.rangesOver;
        }

        public boolean isNullOnEmpty() {
            return this.isNullOnEmpty;
        }

        @Override
        @Nonnull
        public Type getFlowedObjectType() {
            Type baseType = super.getFlowedObjectType();
            return baseType.overrideIfNullable(this.isNullOnEmpty);
        }

        @Override
        @Nonnull
        public Builder<? extends Quantifier, ? extends Builder<?, ?>> toBuilder() {
            return new ForEachBuilder().from(this);
        }

        @Override
        @Nonnull
        public String getShorthand() {
            return "\u0192";
        }

        @Override
        @Nonnull
        public ForEach overNewReference(@Nonnull Reference reference) {
            return this.overNewReference(reference, this.getAlias());
        }

        @Override
        @Nonnull
        public ForEach overNewReference(@Nonnull Reference reference, @Nonnull CorrelationIdentifier newAlias) {
            return ((ForEachBuilder)Quantifier.forEachBuilder().from(this).withAlias(newAlias)).build(reference);
        }

        @Override
        @Nonnull
        public List<Column<? extends FieldValue>> computeFlowedColumns() {
            return ForEach.pullUpResultColumns(this.getFlowedObjectType(), this.getAlias());
        }

        @Override
        @Nonnull
        public Optional<RegularTranslationMap> pullUpMaxMatchMapMaybe(@Nonnull MaxMatchMap maxMatchMap, @Nonnull CorrelationIdentifier candidateAlias) {
            return maxMatchMap.pullUpMaybe(this.getAlias(), candidateAlias);
        }

        @Override
        public boolean semanticEqualsWithoutChildren(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForEach other = (ForEach)o;
            return this.isNullOnEmpty == other.isNullOnEmpty;
        }

        @Override
        public int semanticHashCode() {
            return Objects.hash(this.getShorthand(), this.getRangesOver().semanticHashCode(), this.isNullOnEmpty());
        }

        @Override
        @Nonnull
        public String toString() {
            String isNullOnEmpty = this.isNullOnEmpty() ? "nOE" : "";
            return this.getShorthand() + "(" + String.valueOf(this.getAlias()) + ")" + isNullOnEmpty + " -> {" + this.getCorrelatedTo().stream().map(CorrelationIdentifier::toString).collect(Collectors.joining(", ")) + "}";
        }

        public static class ForEachBuilder
        extends Builder<ForEach, ForEachBuilder> {
            private boolean isNullOnEmpty;

            @Nonnull
            public ForEachBuilder setNullOnEmpty(boolean isNullOnEmpty) {
                this.isNullOnEmpty = isNullOnEmpty;
                return this;
            }

            @Override
            @Nonnull
            public ForEachBuilder from(ForEach quantifier) {
                return ((ForEachBuilder)this.withAlias(quantifier.getAlias())).setNullOnEmpty(quantifier.isNullOnEmpty());
            }

            @Override
            @Nonnull
            public ForEach build(@Nonnull Reference rangesOver) {
                return new ForEach(this.alias == null ? Quantifier.uniqueId() : this.alias, rangesOver, this.isNullOnEmpty);
            }
        }
    }

    public static abstract class Builder<Q extends Quantifier, B extends Builder<Q, B>> {
        @Nullable
        protected CorrelationIdentifier alias;

        @Nonnull
        public B from(Q quantifier) {
            return this.withAlias(((Quantifier)quantifier).getAlias());
        }

        @Nonnull
        public B withAlias(CorrelationIdentifier alias) {
            this.alias = alias;
            return (B)this;
        }

        @Nonnull
        public abstract Quantifier build(@Nonnull Reference var1);
    }

    public static final class Existential
    extends Quantifier {
        @Nonnull
        private final Reference rangesOver;

        private Existential(@Nonnull CorrelationIdentifier alias, @Nonnull Reference rangesOver) {
            super(alias);
            this.rangesOver = rangesOver;
        }

        @Override
        @Nonnull
        public Reference getRangesOver() {
            return this.rangesOver;
        }

        @Override
        @Nonnull
        public Builder<? extends Quantifier, ? extends Builder<?, ?>> toBuilder() {
            return new ExistentialBuilder().from(this);
        }

        @Override
        @Nonnull
        public String getShorthand() {
            return "\u2203";
        }

        @Override
        @Nonnull
        public Existential overNewReference(@Nonnull Reference reference) {
            return this.overNewReference(reference, this.getAlias());
        }

        @Override
        @Nonnull
        public Existential overNewReference(@Nonnull Reference reference, @Nonnull CorrelationIdentifier newAlias) {
            return ((ExistentialBuilder)((ExistentialBuilder)Quantifier.existentialBuilder().from(this)).withAlias(newAlias)).build(reference);
        }

        @Override
        @Nonnull
        public List<Column<? extends FieldValue>> computeFlowedColumns() {
            throw new IllegalStateException("should not be called");
        }

        @Override
        @Nonnull
        public Optional<RegularTranslationMap> pullUpMaxMatchMapMaybe(@Nonnull MaxMatchMap maxMatchMap, @Nonnull CorrelationIdentifier candidateAlias) {
            return Optional.of(TranslationMap.ofAliases(this.getAlias(), candidateAlias));
        }

        public static class ExistentialBuilder
        extends Builder<Existential, ExistentialBuilder> {
            @Override
            @Nonnull
            public Existential build(@Nonnull Reference rangesOver) {
                return new Existential(this.alias == null ? Quantifier.uniqueId() : this.alias, rangesOver);
            }
        }
    }

    public static final class Physical
    extends Quantifier
    implements PlanSerializable {
        @Nonnull
        private final Reference rangesOver;

        private Physical(@Nonnull CorrelationIdentifier alias, @Nonnull Reference rangesOver) {
            super(alias);
            this.rangesOver = rangesOver;
        }

        @Override
        @Nonnull
        public Reference getRangesOver() {
            return this.rangesOver;
        }

        @Nonnull
        public RecordQueryPlan getRangesOverPlan() {
            return (RecordQueryPlan)this.getRangesOver().get();
        }

        @Override
        @Nonnull
        public String getShorthand() {
            return "\ud835\udcc5";
        }

        @Override
        @Nonnull
        public Builder<? extends Quantifier, ? extends Builder<?, ?>> toBuilder() {
            return new PhysicalBuilder().from(this);
        }

        @Override
        public boolean equals(Object other) {
            return this.structuralEquals(other);
        }

        @Override
        public int hashCode() {
            return this.structuralHashCode();
        }

        public boolean structuralEquals(@Nullable Object other) {
            return this.structuralEquals(other, AliasMap.emptyMap());
        }

        public boolean structuralEquals(@Nullable Object other, @Nonnull AliasMap equivalenceMap) {
            if (!(other instanceof Physical)) {
                return false;
            }
            return this.getRangesOverPlan().structuralEquals(((Physical)other).getRangesOverPlan(), equivalenceMap);
        }

        public int structuralHashCode() {
            return this.getRangesOverPlan().structuralHashCode();
        }

        @Override
        @Nonnull
        public Physical overNewReference(@Nonnull Reference reference) {
            return this.overNewReference(reference, this.getAlias());
        }

        @Override
        @Nonnull
        public Physical overNewReference(@Nonnull Reference reference, @Nonnull CorrelationIdentifier newAlias) {
            return ((PhysicalBuilder)((PhysicalBuilder)Quantifier.physicalBuilder().from(this)).withAlias(newAlias)).build(reference);
        }

        @Override
        @Nonnull
        public List<Column<? extends FieldValue>> computeFlowedColumns() {
            return Physical.pullUpResultColumns(this.getFlowedObjectType(), this.getAlias());
        }

        @Override
        @Nonnull
        public Optional<RegularTranslationMap> pullUpMaxMatchMapMaybe(@Nonnull MaxMatchMap maxMatchMap, @Nonnull CorrelationIdentifier candidateAlias) {
            throw new UnsupportedOperationException("this method should not be called");
        }

        @Override
        @Nonnull
        public PPhysicalQuantifier toProto(@Nonnull PlanSerializationContext serializationContext) {
            PPhysicalQuantifier.Builder builder = PPhysicalQuantifier.newBuilder().setAlias(this.getAlias().getId());
            Set<RelationalExpression> finalExpressions = this.getRangesOver().getFinalExpressions();
            for (RelationalExpression finalExpression : finalExpressions) {
                Verify.verify(finalExpression instanceof RecordQueryPlan);
                builder.addPlanReferences(serializationContext.toPlanReferenceProto((RecordQueryPlan)finalExpression));
            }
            return builder.build();
        }

        @Nonnull
        public static Physical fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPhysicalQuantifier physicalQuantifierProto) {
            ImmutableList.Builder membersBuilder = ImmutableList.builder();
            for (int i = 0; i < physicalQuantifierProto.getPlanReferencesCount(); ++i) {
                membersBuilder.add(serializationContext.fromPlanReferenceProto(physicalQuantifierProto.getPlanReferences(i)));
            }
            Reference reference = Reference.ofFinalExpressions(PlannerStage.PLANNED, membersBuilder.build());
            return ((PhysicalBuilder)Physical.physicalBuilder().withAlias(CorrelationIdentifier.of(Objects.requireNonNull(physicalQuantifierProto.getAlias())))).build(reference);
        }

        public static class PhysicalBuilder
        extends Builder<Physical, PhysicalBuilder> {
            @Override
            @Nonnull
            public Physical build(@Nonnull Reference rangesOver) {
                return new Physical(this.alias == null ? Quantifier.uniqueId() : this.alias, rangesOver);
            }

            @Nonnull
            public PhysicalBuilder morphFrom(@Nonnull ForEach quantifier) {
                return (PhysicalBuilder)this.withAlias(quantifier.getAlias());
            }
        }
    }
}

