/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.combinatorics.CrossProduct;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterator;
import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.References;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.BoundMatch;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.ComputingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.DependencyUtils;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.FindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.GenericMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.MatchFunction;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.MatchPredicate;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.PredicatedMatcher;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class Quantifiers {
    private Quantifiers() {
    }

    @Nonnull
    public static Set<CorrelationIdentifier> aliases(@Nonnull Iterable<? extends Quantifier> quantifiers) {
        return DependencyUtils.computeAliases(quantifiers, Quantifier::getAlias);
    }

    @Nonnull
    public static List<? extends Reference> rangesOver(@Nonnull Iterable<? extends Quantifier> quantifiers) {
        return StreamSupport.stream(quantifiers.spliterator(), false).map(Quantifier::getRangesOver).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public static Map<CorrelationIdentifier, Quantifier> aliasToQuantifierMap(@Nonnull Iterable<? extends Quantifier> quantifiers) {
        return DependencyUtils.computeAliasToElementMap(quantifiers, Quantifier::getAlias);
    }

    @Nonnull
    public static List<Quantifier.ForEach> forEachQuantifiers(@Nonnull Iterable<Reference> rangesOverExpressions) {
        return Quantifiers.fromExpressions(rangesOverExpressions, Quantifier::forEach);
    }

    @Nonnull
    public static List<Quantifier.Existential> existentialQuantifiers(@Nonnull Iterable<Reference> rangesOverPlans) {
        return Quantifiers.fromExpressions(rangesOverPlans, Quantifier::existential);
    }

    @Nonnull
    public static List<Quantifier.Physical> fromPlans(@Nonnull Iterable<? extends Reference> rangesOverPlans) {
        return Quantifiers.fromExpressions(rangesOverPlans, Quantifier::physical);
    }

    @Nonnull
    public static <Q extends Quantifier> List<Q> fromExpressions(@Nonnull Iterable<? extends Reference> rangesOverExpressions, @Nonnull Function<Reference, Q> creator) {
        return StreamSupport.stream(rangesOverExpressions.spliterator(), false).map(creator).collect(Collectors.toList());
    }

    @Nonnull
    public static AliasMap translate(@Nonnull Quantifier from, @Nonnull Quantifier to) {
        return AliasMap.ofAliases(from.getAlias(), to.getAlias());
    }

    @Nonnull
    public static AliasMap toAliasMap(@Nonnull BiMap<Quantifier, Quantifier> map) {
        return AliasMap.copyOf((Map<CorrelationIdentifier, CorrelationIdentifier>)map.entrySet().stream().collect(ImmutableBiMap.toImmutableBiMap(entry -> ((Quantifier)entry.getKey()).getAlias(), entry -> ((Quantifier)entry.getValue()).getAlias())));
    }

    @Nonnull
    public static BiMap<CorrelationIdentifier, Quantifier> toBiMap(@Nonnull Collection<? extends Quantifier> quantifiers) {
        return quantifiers.stream().collect(ImmutableBiMap.toImmutableBiMap(Quantifier::getAlias, Function.identity()));
    }

    @Nonnull
    public static <Q extends Quantifier> List<Q> narrow(@Nonnull Class<Q> narrowedClass, @Nonnull List<? extends Quantifier> quantifiers) {
        return quantifiers.stream().map(narrowedClass::cast).collect(Collectors.toList());
    }

    @Nonnull
    public static <Q extends Quantifier> Set<Q> narrow(@Nonnull Class<Q> narrowedClass, @Nonnull Set<? extends Quantifier> quantifiers) {
        return quantifiers.stream().map(narrowedClass::cast).collect(Collectors.toSet());
    }

    @Nonnull
    public static SetMultimap<CorrelationIdentifier, CorrelationIdentifier> computeDependsOnMap(@Nonnull Iterable<? extends Quantifier> quantifiers) {
        return Quantifiers.computeDependsOnMap(quantifiers, Quantifiers.aliasToQuantifierMap(quantifiers));
    }

    @Nonnull
    public static SetMultimap<CorrelationIdentifier, CorrelationIdentifier> computeDependsOnMap(@Nonnull Iterable<? extends Quantifier> quantifiers, @Nonnull Map<CorrelationIdentifier, Quantifier> aliasToQuantifierMap) {
        return DependencyUtils.computeDependsOnMapWithAliases(aliasToQuantifierMap.keySet(), aliasToQuantifierMap, Quantifier::getCorrelatedTo);
    }

    @Nonnull
    public static Iterable<AliasMap> findMatches(@Nonnull AliasMap boundAliasesMap, @Nonnull Collection<? extends Quantifier> quantifiers, @Nonnull Collection<? extends Quantifier> otherQuantifiers, @Nonnull MatchPredicate<Quantifier> matchPredicate) {
        MatchPredicate<Quantifier> quantifierMatchPredicate = (quantifier, otherQuantifier, eM) -> quantifier.semanticEqualsWithoutChildren(otherQuantifier);
        return Quantifiers.predicatedMatcher(boundAliasesMap, quantifiers, otherQuantifiers, quantifierMatchPredicate.and(matchPredicate)).findCompleteMatches();
    }

    @Nonnull
    private static PredicatedMatcher predicatedMatcher(@Nonnull AliasMap boundAliasesMap, @Nonnull Collection<? extends Quantifier> quantifiers, @Nonnull Collection<? extends Quantifier> otherQuantifiers, @Nonnull MatchPredicate<Quantifier> matchPredicate) {
        return FindingMatcher.onAliasDependencies(boundAliasesMap, quantifiers, Quantifier::getAlias, Quantifier::getCorrelatedTo, otherQuantifiers, Quantifier::getAlias, Quantifier::getCorrelatedTo, matchPredicate);
    }

    @Nonnull
    public static <M> Iterable<BoundMatch<EnumeratingIterable<M>>> match(@Nonnull AliasMap boundAliasesMap, @Nonnull Collection<? extends Quantifier> quantifiers, @Nonnull Collection<? extends Quantifier> otherQuantifiers, @Nonnull MatchFunction<Quantifier, M> matchFunction) {
        return Quantifiers.genericMatcher(boundAliasesMap, quantifiers, otherQuantifiers, matchFunction).match();
    }

    @Nonnull
    public static <M> GenericMatcher<BoundMatch<EnumeratingIterable<M>>> genericMatcher(@Nonnull AliasMap boundAliasesMap, @Nonnull Collection<? extends Quantifier> quantifiers, @Nonnull Collection<? extends Quantifier> otherQuantifiers, @Nonnull MatchFunction<Quantifier, M> matchFunction) {
        return ComputingMatcher.onAliasDependencies(boundAliasesMap, quantifiers, Quantifier::getAlias, Quantifier::getCorrelatedTo, otherQuantifiers, Quantifier::getAlias, Quantifier::getCorrelatedTo, matchFunction, ComputingMatcher::productAccumulator);
    }

    @Nonnull
    public static Iterable<AliasMap> enumerateConstraintAliases(@Nonnull AliasMap aliasMap, @Nonnull List<? extends Quantifier> quantifiers, @Nonnull Function<Quantifier, Collection<AliasMap>> constraintsFunction, @Nonnull Set<CorrelationIdentifier> eligibleAliases, @Nonnull Set<CorrelationIdentifier> otherEligibleAliases) {
        if (quantifiers.isEmpty()) {
            return ImmutableList.of(aliasMap);
        }
        EnumeratingIterable enumeratingIterable = CrossProduct.crossProduct(quantifiers.stream().map(constraintsFunction).collect(ImmutableList.toImmutableList()));
        return () -> {
            Iterator iterator = enumeratingIterable.iterator();
            return new AbstractIterator<AliasMap>((EnumeratingIterator)iterator, aliasMap, eligibleAliases, otherEligibleAliases){
                final /* synthetic */ EnumeratingIterator val$iterator;
                final /* synthetic */ AliasMap val$aliasMap;
                final /* synthetic */ Set val$eligibleAliases;
                final /* synthetic */ Set val$otherEligibleAliases;
                {
                    this.val$iterator = enumeratingIterator;
                    this.val$aliasMap = aliasMap;
                    this.val$eligibleAliases = set;
                    this.val$otherEligibleAliases = set2;
                }

                @Override
                protected AliasMap computeNext() {
                    while (this.val$iterator.hasNext()) {
                        AliasMap currentAliasMap;
                        Optional<AliasMap> aliasMapOptional;
                        int i;
                        List next = (List)this.val$iterator.next();
                        AliasMap nestedAliasMap = this.val$aliasMap.toBuilder(next.size()).build();
                        for (i = 0; i < next.size() && (aliasMapOptional = nestedAliasMap.combineMaybe(currentAliasMap = ((AliasMap)next.get(i)).filterMappings((source, target) -> this.val$eligibleAliases.contains(source) && this.val$otherEligibleAliases.contains(target)))).isPresent(); ++i) {
                            nestedAliasMap = aliasMapOptional.get();
                        }
                        if (i == next.size()) {
                            return nestedAliasMap;
                        }
                        this.val$iterator.skip(i);
                    }
                    return (AliasMap)this.endOfData();
                }
            };
        };
    }

    public static boolean isReversed(@Nonnull List<Quantifier.Physical> quantifiers) {
        return quantifiers.stream().map(Quantifier.Physical::getRangesOver).flatMap(reference -> reference.getFinalExpressions().stream()).map(expression -> {
            Verify.verify(expression instanceof RecordQueryPlan);
            return (RecordQueryPlan)expression;
        }).map(QueryPlan::isReverse).findAny().orElseThrow(() -> new RecordCoreException("unable to determine reversed-ness", new Object[0]));
    }

    @Nonnull
    public static List<? extends Quantifier> anyTopologicalOrderPermutation(@Nonnull List<? extends Quantifier> quantifiers) {
        ImmutableMap aliasToQuantifierMap = quantifiers.stream().collect(ImmutableMap.toImmutableMap(Quantifier::getAlias, Function.identity()));
        ImmutableSet aliases = quantifiers.stream().map(Quantifier::getAlias).collect(ImmutableSet.toImmutableSet());
        Optional<List<CorrelationIdentifier>> aliasesPermutationOptional = TopologicalSort.anyTopologicalOrderPermutation(aliases, alias -> Objects.requireNonNull((Quantifier)aliasToQuantifierMap.get(alias)).getCorrelatedTo());
        Verify.verify(aliasesPermutationOptional.isPresent());
        return aliasesPermutationOptional.get().stream().map(alias -> Objects.requireNonNull((Quantifier)aliasToQuantifierMap.get(alias))).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public static List<? extends Quantifier> rebaseGraphs(@Nonnull List<? extends Quantifier> quantifiers, @Nonnull Memoizer memoizer, @Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        List<? extends Reference> oldReferences = Quantifiers.rangesOver(quantifiers);
        List<? extends Reference> newReferences = References.rebaseGraphs(oldReferences, memoizer, translationMap, shouldSimplifyValues);
        return Streams.zip(quantifiers.stream(), newReferences.stream(), (oldQun, newRef) -> {
            CorrelationIdentifier newAlias = translationMap.getTargetOrDefault(oldQun.getAlias(), oldQun.getAlias());
            if (newAlias.equals(oldQun.getAlias()) && oldQun.getRangesOver() == newRef) {
                return oldQun;
            }
            return oldQun.overNewReference((Reference)newRef, newAlias);
        }).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public static Type getFlowedTypeForSetOperation(@Nonnull Iterable<? extends Quantifier> quantifiers) {
        return Streams.stream(quantifiers).findFirst().map(Quantifier::getFlowedObjectType).orElseThrow(() -> new RecordCoreException("unable to resolve object type from quantifiers", new Object[0]));
    }

    public static class AliasResolver {
        @Nonnull
        private final Traversal traversal;

        public AliasResolver(@Nonnull Traversal traversal) {
            this.traversal = traversal;
        }

        public Set<Quantifier> resolveCorrelationAlias(@Nonnull RelationalExpression expression, @Nonnull CorrelationIdentifier alias) {
            Set<Reference> refsContaining = this.traversal.getRefsContaining(expression);
            Set<Quantifier> resolvedQuantifiers = Sets.newIdentityHashSet();
            for (Reference reference : refsContaining) {
                this.resolveCorrelationAlias(reference, alias, resolvedQuantifiers);
            }
            return resolvedQuantifiers;
        }

        public Set<Quantifier> resolveCorrelationAlias(@Nonnull Reference reference, @Nonnull CorrelationIdentifier alias) {
            Set<Quantifier> resolvedQuantifiers = Sets.newIdentityHashSet();
            this.resolveCorrelationAlias(reference, alias, resolvedQuantifiers);
            return resolvedQuantifiers;
        }

        private void resolveCorrelationAlias(@Nonnull Reference reference, @Nonnull CorrelationIdentifier alias, @Nonnull Set<Quantifier> resolvedQuantifiers) {
            Set<Traversal.ReferencePath> referencePaths = this.traversal.getParentRefPaths(reference);
            for (Traversal.ReferencePath referencePath : referencePaths) {
                RelationalExpression expression = referencePath.getExpression();
                for (Quantifier quantifier : expression.getQuantifiers()) {
                    if (!quantifier.getAlias().equals(alias)) continue;
                    Verify.verify(expression.canCorrelate());
                    resolvedQuantifiers.add(quantifier);
                }
                this.resolveCorrelationAlias(referencePath.getReference(), alias, resolvedQuantifiers);
            }
        }

        public static AliasResolver withRoot(@Nonnull Reference rootRef) {
            return new AliasResolver(Traversal.withRoot(rootRef));
        }
    }
}

