/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.query.plan.cascades.UserDefinedFunction;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class RawSqlFunction
extends UserDefinedFunction {
    @Nonnull
    private final String definition;

    public RawSqlFunction(@Nonnull String functionName, @Nonnull String description) {
        super(functionName, ImmutableList.of());
        this.definition = description;
    }

    @Override
    @Nonnull
    public RecordMetaDataProto.PUserDefinedFunction toProto(@Nonnull PlanSerializationContext serializationContext) {
        RecordMetaDataProto.PRawSqlFunction.Builder builder = RecordMetaDataProto.PRawSqlFunction.newBuilder();
        builder.setName(this.functionName).setDefinition(this.definition);
        return RecordMetaDataProto.PUserDefinedFunction.newBuilder().setSqlFunction(builder.build()).build();
    }

    @Override
    @Nonnull
    public Typed encapsulate(@Nonnull List<? extends Typed> arguments) {
        throw new RecordCoreException("attempt to encapsulate raw sql function", new Object[0]);
    }

    @Override
    @Nonnull
    public Typed encapsulate(@Nonnull Map<String, ? extends Typed> namedArguments) {
        throw new RecordCoreException("attempt to encapsulate raw sql function", new Object[0]);
    }

    @Nonnull
    public String getDefinition() {
        return this.definition;
    }

    public static class Deserializer
    implements PlanDeserializer<RecordMetaDataProto.PRawSqlFunction, RawSqlFunction> {
        @Override
        @Nonnull
        public Class<RecordMetaDataProto.PRawSqlFunction> getProtoMessageClass() {
            return RecordMetaDataProto.PRawSqlFunction.class;
        }

        @Override
        @Nonnull
        public RawSqlFunction fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull RecordMetaDataProto.PRawSqlFunction sqlFunction) {
            return new RawSqlFunction(sqlFunction.getName(), sqlFunction.getDefinition());
        }
    }
}

